/*
 * Decompiled with CFR 0.152.
 */
package org.alov.data;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import org.alov.map.FloatRectangle;
import org.alov.map.Layer;
import org.alov.map.MapUtils;
import org.alov.map.StreamCounter;
import org.alov.util.AlovMapException;
import org.alov.util.Const;
import org.alov.util.Strings;

public abstract class DataProvider
implements Const,
Serializable {
    public Layer layer = null;
    private String sAuthorization = null;

    public DataProvider() {
    }

    public DataProvider(Layer lyr) {
        this.layer = lyr;
        String sPass = this.layer.connectionData.getProperty("pass");
        String sUser = this.layer.connectionData.getProperty("user");
        if (!Strings.isNullOrBlank(sPass) && !Strings.isNullOrBlank(sUser)) {
            try {
                this.sAuthorization = "Basic " + Strings.encodeBASE64((sUser + ":" + sPass).getBytes());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    public StreamCounter openURL(String baseUrl) throws IOException {
        return MapUtils.openURL(baseUrl, this.sAuthorization, this.layer);
    }

    public abstract String loadComplete() throws AlovMapException;

    public void writeGeoStream(Object objUser, FloatRectangle rect, String sParams, DataOutputStream oss) throws AlovMapException {
    }

    public void writeAttribData(PrintWriter out, String sParams, String sQuery, String sReq) throws AlovMapException {
    }
}

