/*
 * Decompiled with CFR 0.152.
 */
package org.alov.addon;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Vector;
import org.alov.map.Carte;
import org.alov.map.CarteHost;
import org.alov.map.CarteHostListener;
import org.alov.map.CarteListener;
import org.alov.map.FloatPoint;
import org.alov.map.FloatRectangle;
import org.alov.map.MapUtils;
import org.alov.map.Shape;
import org.alov.map.StatusListener;
import org.alov.util.Strings;
import org.alov.util.XmlElement;
import org.alov.util.XmlUtils;
import org.alov.viewer.ImageButton;

public class DistanceTool
extends Panel
implements CarteHostListener,
CarteListener,
ActionListener,
StatusListener {
    private static final String NAME_BTN_ADD = "distance_add";
    private static final String NAME_BTN_CLEAR = "distance_clear";
    private static final String NAME_LBL_INFO = "distance_info";
    private static byte TOOL_ADD_WAYPOINT = (byte)51;
    private Carte map = null;
    private CarteHost host = null;
    private Label lblInfo;
    private boolean drawingPath;
    private boolean isDrawAngle = false;
    private Vector waypoints = new Vector();
    private double pathLength = 0.0;
    private Point lastMousePosition = null;
    private String lastLabel = null;
    private int distUnits;
    private int unitsFormat = 1;
    private static final Font font = new Font("SansSerif", 1, 14);
    private static final int PATH_OVAL_RADIUS = 4;

    private void addWaypoint(float x, float y) {
        this.addWaypoint(new FloatPoint(x, y));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addWaypoint(FloatPoint point) {
        this.waypoints.addElement(point);
        this.recalculatePathLength();
        Graphics g = this.map.getGraphics();
        if (g != null) {
            try {
                this.drawWholePath(g);
            }
            finally {
                g.dispose();
            }
        }
    }

    private void clearPath() {
        this.waypoints.removeAllElements();
        this.map.repaint();
        this.recalculatePathLength();
    }

    public void setParameters(CarteHost host, XmlElement layout) {
        this.host = host;
        this.map = host.getMapByName(layout);
        this.map.statusListeners.addElement(this);
        this.map.mapListeners.addElement(this);
        Container cont = (Container)((Object)host);
        MapUtils.addActionListener(this, cont, NAME_BTN_CLEAR);
        String unitsS = XmlUtils.getString("precision", layout, null);
        try {
            int rnd = Integer.parseInt(unitsS);
            int n = this.unitsFormat = Math.abs(rnd) > 5 ? 1 : (int)Math.pow(10.0, Math.abs(rnd));
            if (rnd < 0) {
                this.unitsFormat = -this.unitsFormat;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        unitsS = XmlUtils.getString("units", layout, null);
        this.distUnits = MapUtils.setUnits(unitsS, -1);
        this.isDrawAngle = XmlUtils.getBoolean("angle", layout, false);
    }

    public void stop() {
    }

    private void drawWholePath(Graphics g) {
        int waypointCount = this.waypoints.size();
        if (waypointCount <= 0) {
            return;
        }
        Point previousPoint = null;
        g.setColor(Color.black);
        for (int i = 0; i < waypointCount; ++i) {
            Point currentPoint = this.map.mapToScreen((FloatPoint)this.waypoints.elementAt(i));
            g.drawOval(currentPoint.x - 4, currentPoint.y - 4, 8, 8);
            if (previousPoint != null) {
                Shape.drawBoldLine(g, previousPoint.x, previousPoint.y, currentPoint.x, currentPoint.y);
            }
            previousPoint = currentPoint;
        }
    }

    private void drawPathSegment(Graphics g, Point pointFrom, Point pointTo, boolean drawBoundingCircle) {
        g.drawLine(pointFrom.x, pointFrom.y, pointTo.x, pointTo.y);
        double dx = pointTo.x - pointFrom.x;
        double dy = pointTo.y - pointFrom.y;
        int radius = (int)Math.sqrt(dx * dx + dy * dy);
        g.drawOval(pointFrom.x - radius, pointFrom.y - radius, radius * 2, radius * 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mouseAt(Point point, boolean clearOnly) {
        int waypointCount = this.waypoints.size();
        if (waypointCount > 0) {
            FloatPoint lastWaypointMap = (FloatPoint)this.waypoints.elementAt(waypointCount - 1);
            Point lastWaypoint = this.map.mapToScreen(lastWaypointMap);
            Graphics g = this.map.getGraphics();
            if (g != null) {
                try {
                    g.setFont(font);
                    g.setColor(Color.black);
                    g.setXORMode(Color.white);
                    if (this.lastMousePosition != null) {
                        this.drawPathSegment(g, lastWaypoint, this.lastMousePosition, true);
                        g.drawString(this.lastLabel, this.lastMousePosition.x, this.lastMousePosition.y);
                    }
                    if (!clearOnly) {
                        if (this.isDrawAngle) {
                            double angle = Math.atan2(point.y - lastWaypoint.y, point.x - lastWaypoint.x);
                            if ((angle = Math.toDegrees(angle)) < 0.0) {
                                angle = 360.0 + angle;
                            }
                            angle = angle > 270.0 ? angle - 270.0 : angle + 90.0;
                            this.lastLabel = Strings.doubleToStr(angle, 100) + " x ";
                        } else {
                            this.lastLabel = "";
                        }
                        FloatPoint newPoint = this.map.screenToMap(point);
                        this.lastLabel = this.lastLabel + this.formatLength(this.getPathLength() + this.distance(lastWaypointMap, newPoint));
                        this.drawPathSegment(g, lastWaypoint, point, true);
                        g.drawString(this.lastLabel, point.x, point.y);
                        g.setXORMode(Color.black);
                        this.lastMousePosition = point;
                    }
                }
                finally {
                    g.dispose();
                }
            }
        }
    }

    public void mouseMapPressed(MouseEvent e) {
        if (this.map.getTool() == TOOL_ADD_WAYPOINT && (e.getModifiers() & 0x10) != 0) {
            if (this.waypoints.size() <= 0 || this.drawingPath) {
                this.drawingPath = e.getClickCount() <= 1;
            } else {
                this.clearPath();
                this.drawingPath = true;
            }
            Point screenPoint = e.getPoint();
            FloatPoint mapPoint = this.map.screenToMap(screenPoint);
            this.mouseAt(screenPoint, true);
            this.addWaypoint(mapPoint);
            this.lastMousePosition = null;
        }
    }

    public void mouseMapReleased(FloatRectangle selRect, MouseEvent e) {
    }

    public void mouseMapMoved(MouseEvent e) {
        if (this.map.getTool() == TOOL_ADD_WAYPOINT && this.drawingPath) {
            Point screenPoint = e.getPoint();
            this.mouseAt(screenPoint, false);
        }
    }

    public void afterMapDraw(Graphics g) {
        this.lastMousePosition = null;
        this.lastLabel = null;
        this.drawWholePath(g);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object o = actionEvent.getSource();
        if (o instanceof Component) {
            String sName = ((Component)o).getName();
            if (sName.equalsIgnoreCase(NAME_BTN_ADD)) {
                this.map.setTool(TOOL_ADD_WAYPOINT);
                if (o instanceof ImageButton) {
                    ((ImageButton)o).setDown(true);
                }
            } else if (sName.equalsIgnoreCase(NAME_BTN_CLEAR)) {
                this.clearPath();
            }
        }
    }

    public void afterProjectLoaded(boolean bSuccess) {
        Container cont = (Container)((Object)this.host);
        MapUtils.addActionListener(this, cont, NAME_BTN_ADD);
        MapUtils.addActionListener(this, cont, NAME_LBL_INFO);
        this.lblInfo = (Label)this.host.findComponent(NAME_LBL_INFO);
        if (bSuccess && this.distUnits == -1) {
            this.distUnits = this.map.getProject().ZoomUnits;
        }
    }

    public void notifyStatus(int code, Object obj) {
        Component c;
        if (code == 11 && obj != null) {
            this.clearPath();
        } else if (this.map.getTool() == TOOL_ADD_WAYPOINT && (c = this.host.findComponent(NAME_BTN_ADD)) instanceof ImageButton) {
            ((ImageButton)c).setDown(true);
        }
    }

    private void recalculatePathLength() {
        this.pathLength = this.getPathLength();
        if (this.lblInfo != null) {
            this.lblInfo.setText(this.formatLength(this.pathLength));
        }
    }

    private double getPathLength() {
        int waypointCount = this.waypoints.size();
        FloatPoint prevPoint = null;
        double length = 0.0;
        for (int i = 0; i < waypointCount; ++i) {
            FloatPoint currentPoint = (FloatPoint)this.waypoints.elementAt(i);
            if (prevPoint != null) {
                length += this.distance(prevPoint, currentPoint);
            }
            prevPoint = currentPoint;
        }
        return length;
    }

    private String formatLength(double val) {
        String strUnitsLength;
        switch (this.distUnits) {
            case 1: {
                strUnitsLength = this.map.getResource("m");
                break;
            }
            case 0: 
            case 2: {
                strUnitsLength = this.map.getResource("km");
                break;
            }
            case 4: {
                strUnitsLength = this.map.getResource("ft");
                break;
            }
            case 5: {
                strUnitsLength = this.map.getResource("mi");
                break;
            }
            case 6: {
                strUnitsLength = this.map.getResource("nmi");
                break;
            }
            default: {
                strUnitsLength = "";
            }
        }
        return MapUtils.formatDistance(val, this.map.getProject().MapUnits, this.distUnits, this.unitsFormat, strUnitsLength);
    }

    private double distance(FloatPoint a, FloatPoint b) {
        int units = this.map.getProject().MapUnits;
        return MapUtils.getDistance(a, b, units);
    }
}

