/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.wavelet.synthesis;

import jj2000.j2k.decoder.DecoderSpecs;
import jj2000.j2k.image.Coord;
import jj2000.j2k.image.DataBlk;
import jj2000.j2k.image.DataBlkFloat;
import jj2000.j2k.image.DataBlkInt;
import jj2000.j2k.wavelet.synthesis.CBlkWTDataSrcDec;
import jj2000.j2k.wavelet.synthesis.InvWTHelper;
import jj2000.j2k.wavelet.synthesis.InverseWT;
import jj2000.j2k.wavelet.synthesis.SubbandSyn;

public class InvWTFull
extends InverseWT {
    private CBlkWTDataSrcDec src;
    private int dtype;
    private DataBlk[] reconstructedComps;
    private InvWTHelper iwtHelper;

    public InvWTFull(CBlkWTDataSrcDec cBlkWTDataSrcDec, DecoderSpecs decoderSpecs) {
        super(cBlkWTDataSrcDec, decoderSpecs);
        this.src = cBlkWTDataSrcDec;
        this.iwtHelper = new InvWTHelper(cBlkWTDataSrcDec);
        this.reconstructedComps = new DataBlk[cBlkWTDataSrcDec.getNumComps()];
    }

    public DataBlk getCompData(DataBlk dataBlk, int n) {
        Object[] objectArray = null;
        switch (dataBlk.getDataType()) {
            case 3: {
                int[] nArray = (int[])dataBlk.getData();
                if (nArray == null || nArray.length < dataBlk.w * dataBlk.h) {
                    nArray = new int[dataBlk.w * dataBlk.h];
                }
                objectArray = nArray;
                break;
            }
            case 4: {
                float[] fArray = (float[])dataBlk.getData();
                if (fArray == null || fArray.length < dataBlk.w * dataBlk.h) {
                    fArray = new float[dataBlk.w * dataBlk.h];
                }
                objectArray = fArray;
                break;
            }
        }
        dataBlk = this.getInternCompData(dataBlk, n);
        dataBlk.setData(objectArray);
        dataBlk.offset = 0;
        dataBlk.scanw = dataBlk.w;
        return dataBlk;
    }

    public int getFixedPoint(int n) {
        return this.src.getFixedPoint(n);
    }

    public int getImplementationType(int n) {
        return 2;
    }

    public final DataBlk getInternCompData(DataBlk dataBlk, int n) {
        this.dtype = this.src.getSubbandTree((int)this.getTileIdx(), (int)n).hFilter == null ? 3 : this.src.getSubbandTree((int)this.getTileIdx(), (int)n).hFilter.getDataType();
        if (this.reconstructedComps[n] == null) {
            switch (this.dtype) {
                case 4: {
                    this.reconstructedComps[n] = new DataBlkFloat(0, 0, this.getCompWidth(n), this.getCompHeight(n));
                    break;
                }
                case 3: {
                    this.reconstructedComps[n] = new DataBlkInt(0, 0, this.getCompWidth(n), this.getCompHeight(n));
                    break;
                }
            }
            this.waveletTreeReconstruction(this.reconstructedComps[n], this.src.getSubbandTree(this.getTileIdx(), n), n);
        }
        if (dataBlk.getDataType() != this.dtype) {
            dataBlk = this.dtype == 3 ? new DataBlkInt(dataBlk.ulx, dataBlk.uly, dataBlk.w, dataBlk.h) : new DataBlkFloat(dataBlk.ulx, dataBlk.uly, dataBlk.w, dataBlk.h);
        }
        dataBlk.setData(this.reconstructedComps[n].getData());
        dataBlk.offset = this.reconstructedComps[n].w * dataBlk.uly + dataBlk.ulx;
        dataBlk.scanw = this.reconstructedComps[n].w;
        dataBlk.progressive = false;
        return dataBlk;
    }

    public int getNomRangeBits(int n) {
        return this.src.getNomRangeBits(n);
    }

    public boolean isReversible(int n, int n2) {
        return this.iwtHelper.isReversible(n, n2);
    }

    public void nextTile() {
        super.nextTile();
        if (this.reconstructedComps != null) {
            int n = this.reconstructedComps.length - 1;
            while (n >= 0) {
                this.reconstructedComps[n] = null;
                --n;
            }
        }
    }

    public void setTile(int n, int n2) {
        super.setTile(n, n2);
        if (this.reconstructedComps != null) {
            int n3 = this.reconstructedComps.length - 1;
            while (n3 >= 0) {
                this.reconstructedComps[n3] = null;
                --n3;
            }
        }
    }

    private void wavelet2DReconstruction(DataBlk dataBlk, SubbandSyn subbandSyn, int n) {
        int n2;
        if (subbandSyn.w == 0 || subbandSyn.h == 0) {
            return;
        }
        Object object = dataBlk.getData();
        int n3 = subbandSyn.ulx;
        int n4 = subbandSyn.uly;
        int n5 = subbandSyn.w;
        int n6 = subbandSyn.h;
        Object[] objectArray = null;
        switch (subbandSyn.hFilter.getDataType()) {
            case 3: {
                objectArray = new int[n5 >= n6 ? n5 : n6];
                break;
            }
            case 4: {
                objectArray = new float[n5 >= n6 ? n5 : n6];
                break;
            }
        }
        int n7 = (n4 - dataBlk.uly) * dataBlk.w + n3 - dataBlk.ulx;
        if (subbandSyn.ulcx % 2 == 0) {
            n2 = 0;
            while (n2 < n6) {
                System.arraycopy(object, n7, objectArray, 0, n5);
                subbandSyn.hFilter.synthetize_lpf(objectArray, 0, (n5 + 1) / 2, 1, objectArray, (n5 + 1) / 2, n5 / 2, 1, object, n7, 1);
                ++n2;
                n7 += dataBlk.w;
            }
        } else {
            n2 = 0;
            while (n2 < n6) {
                System.arraycopy(object, n7, objectArray, 0, n5);
                subbandSyn.hFilter.synthetize_hpf(objectArray, 0, n5 / 2, 1, objectArray, n5 / 2, (n5 + 1) / 2, 1, object, n7, 1);
                ++n2;
                n7 += dataBlk.w;
            }
        }
        n7 = (n4 - dataBlk.uly) * dataBlk.w + n3 - dataBlk.ulx;
        switch (subbandSyn.hFilter.getDataType()) {
            case 3: {
                int[] nArray = (int[])object;
                Object[] objectArray2 = objectArray;
                if (subbandSyn.ulcy % 2 == 0) {
                    int n8 = 0;
                    while (n8 < n5) {
                        n2 = n6 - 1;
                        int n9 = n7 + n2 * dataBlk.w;
                        while (n2 >= 0) {
                            objectArray2[n2] = nArray[n9];
                            --n2;
                            n9 -= dataBlk.w;
                        }
                        subbandSyn.vFilter.synthetize_lpf(objectArray, 0, (n6 + 1) / 2, 1, objectArray, (n6 + 1) / 2, n6 / 2, 1, object, n7, dataBlk.w);
                        ++n8;
                        ++n7;
                    }
                } else {
                    int n10 = 0;
                    while (n10 < n5) {
                        n2 = n6 - 1;
                        int n11 = n7 + n2 * dataBlk.w;
                        while (n2 >= 0) {
                            objectArray2[n2] = nArray[n11];
                            --n2;
                            n11 -= dataBlk.w;
                        }
                        subbandSyn.vFilter.synthetize_hpf(objectArray, 0, n6 / 2, 1, objectArray, n6 / 2, (n6 + 1) / 2, 1, object, n7, dataBlk.w);
                        ++n10;
                        ++n7;
                    }
                }
                break;
            }
            case 4: {
                float[] fArray = (float[])object;
                float[] fArray2 = objectArray;
                if (subbandSyn.ulcy % 2 == 0) {
                    int n12 = 0;
                    while (n12 < n5) {
                        n2 = n6 - 1;
                        int n13 = n7 + n2 * dataBlk.w;
                        while (n2 >= 0) {
                            fArray2[n2] = fArray[n13];
                            --n2;
                            n13 -= dataBlk.w;
                        }
                        subbandSyn.vFilter.synthetize_lpf(objectArray, 0, (n6 + 1) / 2, 1, objectArray, (n6 + 1) / 2, n6 / 2, 1, object, n7, dataBlk.w);
                        ++n12;
                        ++n7;
                    }
                } else {
                    int n14 = 0;
                    while (n14 < n5) {
                        n2 = n6 - 1;
                        int n15 = n7 + n2 * dataBlk.w;
                        while (n2 >= 0) {
                            fArray2[n2] = fArray[n15];
                            --n2;
                            n15 -= dataBlk.w;
                        }
                        subbandSyn.vFilter.synthetize_hpf(objectArray, 0, n6 / 2, 1, objectArray, n6 / 2, (n6 + 1) / 2, 1, object, n7, dataBlk.w);
                        ++n14;
                        ++n7;
                    }
                }
                break;
            }
        }
    }

    private void waveletTreeReconstruction(DataBlk dataBlk, SubbandSyn subbandSyn, int n) {
        if (!subbandSyn.isNode) {
            if (subbandSyn.w == 0 || subbandSyn.h == 0) {
                return;
            }
            DataBlk dataBlk2 = this.dtype == 3 ? new DataBlkInt() : new DataBlkFloat();
            Coord coord = this.src.getNumCodeBlocks(subbandSyn, n, null);
            Object object = dataBlk.getData();
            int n2 = 0;
            while (n2 < coord.y) {
                int n3 = 0;
                while (n3 < coord.x) {
                    dataBlk2 = this.src.getInternCodeBlock(n, n2, n3, subbandSyn, dataBlk2);
                    Object object2 = dataBlk2.getData();
                    int n4 = dataBlk2.h - 1;
                    while (n4 >= 0) {
                        System.arraycopy(object2, dataBlk2.offset + n4 * dataBlk2.scanw, object, (dataBlk2.uly + n4) * dataBlk.w + dataBlk2.ulx, dataBlk2.w);
                        --n4;
                    }
                    ++n3;
                }
                ++n2;
            }
        } else if (subbandSyn.isNode) {
            this.waveletTreeReconstruction(dataBlk, (SubbandSyn)subbandSyn.getLL(), n);
            if (subbandSyn.level >= this.decSpec.dls.getMin() - this.reslvl) {
                this.waveletTreeReconstruction(dataBlk, (SubbandSyn)subbandSyn.getHL(), n);
                this.waveletTreeReconstruction(dataBlk, (SubbandSyn)subbandSyn.getLH(), n);
                this.waveletTreeReconstruction(dataBlk, (SubbandSyn)subbandSyn.getHH(), n);
                this.wavelet2DReconstruction(dataBlk, subbandSyn, n);
            }
        }
    }
}

