/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.wavelet.synthesis;

import jj2000.j2k.decoder.DecoderSpecs;
import jj2000.j2k.image.Coord;
import jj2000.j2k.wavelet.synthesis.InvWT;
import jj2000.j2k.wavelet.synthesis.MultiResImgData;

public abstract class InvWTAdapter
implements InvWT {
    protected DecoderSpecs decSpec;
    protected MultiResImgData mressrc;
    int reslvl;

    protected InvWTAdapter(MultiResImgData multiResImgData, DecoderSpecs decoderSpecs) {
        this.mressrc = multiResImgData;
        this.decSpec = decoderSpecs;
    }

    public int getCompHeight(int n) {
        int n2 = this.getTileIdx();
        int n3 = (Integer)this.decSpec.dls.getTileCompVal(n2, n) - this.decSpec.dls.getMin() + this.reslvl;
        return this.mressrc.getCompHeight(n, n3);
    }

    public int getCompImgHeight(int n) {
        int n2 = this.decSpec.dls.getMinInComp(n) - this.decSpec.dls.getMin() + this.reslvl;
        return this.mressrc.getCompImgHeight(n, n2);
    }

    public int getCompImgWidth(int n) {
        int n2 = this.decSpec.dls.getMinInComp(n) - this.decSpec.dls.getMin() + this.reslvl;
        return this.mressrc.getCompImgWidth(n, n2);
    }

    public int getCompSubsX(int n) {
        return this.mressrc.getCompSubsX(n);
    }

    public int getCompSubsY(int n) {
        return this.mressrc.getCompSubsY(n);
    }

    public int getCompWidth(int n) {
        int n2 = this.getTileIdx();
        int n3 = (Integer)this.decSpec.dls.getTileCompVal(n2, n) - this.decSpec.dls.getMin() + this.reslvl;
        return this.mressrc.getCompWidth(n, n3);
    }

    public int getHeight() {
        int n = this.getTileIdx();
        int n2 = this.decSpec.dls.getMinInTile(n) - this.decSpec.dls.getMin() + this.reslvl;
        return this.mressrc.getHeight(n2);
    }

    public int getImgHeight() {
        return this.mressrc.getImgHeight(this.reslvl);
    }

    public int getImgULX() {
        return this.mressrc.getImgULX(this.reslvl);
    }

    public int getImgULY() {
        return this.mressrc.getImgULY(this.reslvl);
    }

    public int getImgWidth() {
        return this.mressrc.getImgWidth(this.reslvl);
    }

    public abstract int getImplementationType(int var1);

    public abstract int getNomRangeBits(int var1);

    public int getNumComps() {
        return this.mressrc.getNumComps();
    }

    public int getNumTiles() {
        return this.mressrc.getNumTiles();
    }

    public Coord getNumTiles(Coord coord) {
        return this.mressrc.getNumTiles(coord);
    }

    public Coord getTile(Coord coord) {
        return this.mressrc.getTile(coord);
    }

    public int getTileIdx() {
        return this.mressrc.getTileIdx();
    }

    public Coord getTileOff(Coord coord, int n) {
        return this.mressrc.getTileOff(coord, n, this.reslvl);
    }

    public int getULX(int n) {
        int n2 = this.getTileIdx();
        int n3 = (Integer)this.decSpec.dls.getTileCompVal(n2, n) - this.decSpec.dls.getMin() + this.reslvl;
        return this.mressrc.getULX(n, n3);
    }

    public int getULY(int n) {
        int n2 = this.getTileIdx();
        int n3 = (Integer)this.decSpec.dls.getTileCompVal(n2, n) - this.decSpec.dls.getMin() + this.reslvl;
        return this.mressrc.getULY(n, n3);
    }

    public int getWidth() {
        int n = this.getTileIdx();
        int n2 = this.decSpec.dls.getMinInTile(n) - this.decSpec.dls.getMin() + this.reslvl;
        return this.mressrc.getWidth(n2);
    }

    public abstract boolean isReversible(int var1, int var2);

    public void nextTile() {
        this.mressrc.nextTile();
    }

    public void setImgResLevel(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.reslvl = n;
    }

    public void setTile(int n, int n2) {
        this.mressrc.setTile(n, n2);
    }
}

