/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.wavelet.analysis;

import jj2000.j2k.encoder.EncoderSpecs;
import jj2000.j2k.image.BlkImgDataSrc;
import jj2000.j2k.image.Coord;
import jj2000.j2k.image.ImgData;
import jj2000.j2k.image.ImgDataAdapter;
import jj2000.j2k.util.ParameterList;
import jj2000.j2k.wavelet.analysis.AnWTFilter;
import jj2000.j2k.wavelet.analysis.CBlkWTData;
import jj2000.j2k.wavelet.analysis.CBlkWTDataSrc;
import jj2000.j2k.wavelet.analysis.ForwWT;
import jj2000.j2k.wavelet.analysis.ForwWTFull;
import jj2000.j2k.wavelet.analysis.SubbandAn;

public abstract class ForwardWT
extends ImgDataAdapter
implements ForwWT,
CBlkWTDataSrc {
    public static final int WT_DECOMP_DYADIC = 0;
    public static final char OPT_PREFIX = 'W';
    private static final String[][] pinfo = new String[][]{{"Wlev", "<number of decomposition levels>", "Specifies the number of wavelet decomposition levels to apply to the image. If 0 no wavelet transform is performed. All components and all tiles have the same number of decomposition levels.", "5"}, {"Wwt", "[full]", "Specifies the wavelet transform to be used. Possible value is: 'full' (full page). The value 'full' performs a normal DWT.", "full"}};

    protected ForwardWT(ImgData imgData) {
        super(imgData);
    }

    public static ForwardWT createInstance(BlkImgDataSrc blkImgDataSrc, ParameterList parameterList, EncoderSpecs encoderSpecs) {
        parameterList.checkList('W', ParameterList.toNameArray(pinfo));
        int n = (Integer)encoderSpecs.dls.getDefault();
        int n2 = 0;
        int n3 = 0;
        return new ForwWTFull(blkImgDataSrc, encoderSpecs, n2, n3);
    }

    public abstract int getDataType(int var1, int var2);

    public abstract int getDecomp(int var1, int var2);

    public abstract int getDecompLevels(int var1, int var2);

    public abstract int getFixedPoint(int var1);

    public abstract AnWTFilter[] getHorAnWaveletFilters(int var1, int var2);

    public abstract int getImplementationType(int var1);

    public abstract CBlkWTData getNextCodeBlock(int var1, CBlkWTData var2);

    public abstract CBlkWTData getNextInternCodeBlock(int var1, CBlkWTData var2);

    public abstract Coord getNumCodeBlocks(SubbandAn var1, Coord var2);

    public static String[][] getParameterInfo() {
        return pinfo;
    }

    public abstract int getPartitionULX();

    public abstract int getPartitionULY();

    public abstract SubbandAn getSubbandTree(int var1, int var2);

    public abstract AnWTFilter[] getVertAnWaveletFilters(int var1, int var2);

    public abstract boolean isReversible(int var1, int var2);
}

