/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.wavelet.analysis;

import jj2000.j2k.IntegerSpec;
import jj2000.j2k.encoder.EncoderSpecs;
import jj2000.j2k.image.BlkImgDataSrc;
import jj2000.j2k.image.Coord;
import jj2000.j2k.image.DataBlk;
import jj2000.j2k.image.DataBlkFloat;
import jj2000.j2k.image.DataBlkInt;
import jj2000.j2k.wavelet.Subband;
import jj2000.j2k.wavelet.analysis.AnWTFilter;
import jj2000.j2k.wavelet.analysis.AnWTFilterSpec;
import jj2000.j2k.wavelet.analysis.CBlkWTData;
import jj2000.j2k.wavelet.analysis.CBlkWTDataFloat;
import jj2000.j2k.wavelet.analysis.CBlkWTDataInt;
import jj2000.j2k.wavelet.analysis.ForwardWT;
import jj2000.j2k.wavelet.analysis.SubbandAn;

public class ForwWTFull
extends ForwardWT {
    private boolean intData;
    private SubbandAn[][] subbTrees;
    private BlkImgDataSrc src;
    private int pox;
    private int poy;
    private IntegerSpec dls;
    private AnWTFilterSpec filters;
    private DataBlk[] decomposedComps;
    private int[] lastn;
    private int[] lastm;
    SubbandAn[] currentSubband;
    Coord ncblks;

    public ForwWTFull(BlkImgDataSrc blkImgDataSrc, EncoderSpecs encoderSpecs, int n, int n2) {
        super(blkImgDataSrc);
        this.src = blkImgDataSrc;
        this.pox = n;
        this.poy = n2;
        this.dls = encoderSpecs.dls;
        this.filters = encoderSpecs.wfs;
        int n3 = blkImgDataSrc.getNumComps();
        int n4 = blkImgDataSrc.getNumTiles();
        this.currentSubband = new SubbandAn[n3];
        this.decomposedComps = new DataBlk[n3];
        this.subbTrees = new SubbandAn[n4][n3];
        this.lastn = new int[n3];
        this.lastm = new int[n3];
    }

    public int getDataType(int n, int n2) {
        return this.filters.getWTDataType(n, n2);
    }

    public int getDecomp(int n, int n2) {
        return 0;
    }

    public int getDecompLevels(int n, int n2) {
        return (Integer)this.dls.getTileCompVal(n, n2);
    }

    public int getFixedPoint(int n) {
        return this.src.getFixedPoint(n);
    }

    public AnWTFilter[] getHorAnWaveletFilters(int n, int n2) {
        return this.filters.getHFilters(n, n2);
    }

    public int getImplementationType(int n) {
        return 2;
    }

    public CBlkWTData getNextCodeBlock(int n, CBlkWTData cBlkWTData) {
        this.intData = this.filters.getWTDataType(this.tIdx, n) == 3;
        Object object = null;
        if (cBlkWTData != null) {
            object = cBlkWTData.getData();
        }
        if ((cBlkWTData = this.getNextInternCodeBlock(n, cBlkWTData)) == null) {
            return null;
        }
        if (this.intData) {
            int[] nArray = (int[])object;
            if (nArray == null || nArray.length < cBlkWTData.w * cBlkWTData.h) {
                object = new int[cBlkWTData.w * cBlkWTData.h];
            }
        } else {
            float[] fArray = (float[])object;
            if (fArray == null || fArray.length < cBlkWTData.w * cBlkWTData.h) {
                object = new float[cBlkWTData.w * cBlkWTData.h];
            }
        }
        Object object2 = cBlkWTData.getData();
        int n2 = cBlkWTData.w;
        int n3 = n2 * (cBlkWTData.h - 1);
        int n4 = cBlkWTData.offset + (cBlkWTData.h - 1) * cBlkWTData.scanw;
        while (n3 >= 0) {
            System.arraycopy(object2, n4, object, n3, n2);
            n3 -= n2;
            n4 -= cBlkWTData.scanw;
        }
        cBlkWTData.setData(object);
        cBlkWTData.offset = 0;
        cBlkWTData.scanw = n2;
        return cBlkWTData;
    }

    public CBlkWTData getNextInternCodeBlock(int n, CBlkWTData cBlkWTData) {
        block15: {
            boolean bl = this.intData = this.filters.getWTDataType(this.tIdx, n) == 3;
            if (this.decomposedComps[n] == null) {
                DataBlk dataBlk;
                int n2 = this.getCompWidth(n);
                int n3 = this.getCompHeight(n);
                if (this.intData) {
                    this.decomposedComps[n] = new DataBlkInt(0, 0, n2, n3);
                    dataBlk = new DataBlkInt();
                } else {
                    this.decomposedComps[n] = new DataBlkFloat(0, 0, n2, n3);
                    dataBlk = new DataBlkFloat();
                }
                Object object = this.decomposedComps[n].getData();
                dataBlk.ulx = 0;
                dataBlk.w = n2;
                dataBlk.h = 1;
                int n4 = 0;
                while (n4 < n3) {
                    dataBlk.uly = n4;
                    dataBlk.ulx = 0;
                    dataBlk = this.src.getInternCompData(dataBlk, n);
                    System.arraycopy(dataBlk.getData(), dataBlk.offset, object, n4 * n2, n2);
                    ++n4;
                }
                this.waveletTreeDecomposition(this.decomposedComps[n], this.getSubbandTree(this.tIdx, n), n);
                this.currentSubband[n] = this.getNextSubband(n);
                this.lastn[n] = -1;
                this.lastm[n] = 0;
            }
            do {
                this.ncblks = this.getNumCodeBlocks(this.currentSubband[n], this.ncblks);
                int n5 = n;
                this.lastn[n5] = this.lastn[n5] + 1;
                if (this.lastn[n] == this.ncblks.x) {
                    this.lastn[n] = 0;
                    int n6 = n;
                    this.lastm[n6] = this.lastm[n6] + 1;
                }
                if (this.lastm[n] < this.ncblks.y) break block15;
                this.currentSubband[n] = this.getNextSubband(n);
                this.lastn[n] = -1;
                this.lastm[n] = 0;
            } while (this.currentSubband[n] != null);
            this.decomposedComps[n] = null;
            return null;
        }
        int n7 = this.pox;
        int n8 = this.poy;
        block0 : switch (this.currentSubband[n].gOrient) {
            case 1: {
                n7 = 0;
                Subband subband = this.currentSubband[n];
                do {
                    if (subband.orientation != 3 && subband.orientation != 2) continue;
                    n8 = 0;
                    break block0;
                } while (subband.gOrient != 0 && (subband = ((Subband)subband).getParent()) != null);
                break;
            }
            case 2: {
                Subband subband = this.currentSubband[n];
                do {
                    if (subband.orientation != 3 && subband.orientation != 1) continue;
                    n7 = 0;
                    break;
                } while (subband.gOrient != 0 && (subband = ((Subband)subband).getParent()) != null);
                n8 = 0;
                break;
            }
            case 3: {
                n7 = 0;
                n8 = 0;
                break;
            }
            default: {
                throw new Error("Internal JJ2000 error");
            }
            case 0: 
        }
        if (cBlkWTData == null) {
            cBlkWTData = this.intData ? new CBlkWTDataInt() : new CBlkWTDataFloat();
        }
        int n9 = this.lastn[n];
        int n10 = this.lastm[n];
        SubbandAn subbandAn = this.currentSubband[n];
        cBlkWTData.n = n9;
        cBlkWTData.m = n10;
        cBlkWTData.sb = subbandAn;
        int n11 = (subbandAn.ulcx - n7 + subbandAn.nomCBlkW) / subbandAn.nomCBlkW - 1;
        int n12 = (subbandAn.ulcy - n8 + subbandAn.nomCBlkH) / subbandAn.nomCBlkH - 1;
        cBlkWTData.ulx = n9 == 0 ? subbandAn.ulx : (n11 + n9) * subbandAn.nomCBlkW - (subbandAn.ulcx - n7) + subbandAn.ulx;
        cBlkWTData.uly = n10 == 0 ? subbandAn.uly : (n12 + n10) * subbandAn.nomCBlkH - (subbandAn.ulcy - n8) + subbandAn.uly;
        cBlkWTData.w = n9 < this.ncblks.x - 1 ? (n11 + n9 + 1) * subbandAn.nomCBlkW - (subbandAn.ulcx - n7) + subbandAn.ulx - cBlkWTData.ulx : subbandAn.ulx + subbandAn.w - cBlkWTData.ulx;
        cBlkWTData.h = n10 < this.ncblks.y - 1 ? (n12 + n10 + 1) * subbandAn.nomCBlkH - (subbandAn.ulcy - n8) + subbandAn.uly - cBlkWTData.uly : subbandAn.uly + subbandAn.h - cBlkWTData.uly;
        cBlkWTData.wmseScaling = 1.0f;
        cBlkWTData.offset = cBlkWTData.uly * this.decomposedComps[n].w + cBlkWTData.ulx;
        cBlkWTData.scanw = this.decomposedComps[n].w;
        cBlkWTData.setData(this.decomposedComps[n].getData());
        return cBlkWTData;
    }

    /*
     * Unable to fully structure code
     */
    private SubbandAn getNextSubband(int var1_1) {
        var2_2 = true;
        var3_3 = false;
        var4_4 = var2_2;
        var5_5 = this.currentSubband[var1_1];
        if (var5_5 == null) {
            var5_5 = this.getSubbandTree(this.tIdx, var1_1);
            if (!var5_5.isNode) {
                return var5_5;
            }
        }
        while (var5_5 != null) {
            block19: {
                block20: {
                    block18: {
                        if (var5_5.isNode) break block18;
                        switch (var5_5.orientation) {
                            case 3: {
                                var5_5 = (SubbandAn)var5_5.getParent().getLH();
                                var4_4 = var2_2;
                                ** GOTO lbl53
                            }
                            case 2: {
                                var5_5 = (SubbandAn)var5_5.getParent().getHL();
                                var4_4 = var2_2;
                                ** GOTO lbl53
                            }
                            case 1: {
                                var5_5 = (SubbandAn)var5_5.getParent().getLL();
                                var4_4 = var2_2;
                                ** GOTO lbl53
                            }
                            case 0: {
                                var5_5 = (SubbandAn)var5_5.getParent();
                                var4_4 = var3_3;
                                ** GOTO lbl53
                            }
                            default: {
                                if (var5_5 != null) break block19;
                            }
                        }
                    }
                    if (!var5_5.isNode) ** GOTO lbl53
                    if (var4_4 != var2_2) break block20;
                    var5_5 = (SubbandAn)var5_5.getHH();
                    ** GOTO lbl53
                }
                if (var4_4 != var3_3) ** GOTO lbl53
                switch (var5_5.orientation) {
                    case 3: {
                        var5_5 = (SubbandAn)var5_5.getParent().getLH();
                        var4_4 = var2_2;
                        break;
                    }
                    case 2: {
                        var5_5 = (SubbandAn)var5_5.getParent().getHL();
                        var4_4 = var2_2;
                        break;
                    }
                    case 1: {
                        var5_5 = (SubbandAn)var5_5.getParent().getLL();
                        var4_4 = var2_2;
                        break;
                    }
                    case 0: {
                        var5_5 = (SubbandAn)var5_5.getParent();
                        var4_4 = var3_3;
                    }
                }
lbl53:
                // 12 sources

                if (var5_5 != null) break block19;
                break;
            }
            if (var5_5.isNode) continue;
        }
        return var5_5;
    }

    public Coord getNumCodeBlocks(SubbandAn subbandAn, Coord coord) {
        if (coord == null) {
            coord = new Coord();
        }
        if (subbandAn.w != 0 && subbandAn.h != 0) {
            int n = this.pox;
            int n2 = this.poy;
            block0 : switch (subbandAn.gOrient) {
                case 1: {
                    n = 0;
                    Subband subband = subbandAn;
                    do {
                        if (subband.orientation != 3 && subband.orientation != 2) continue;
                        n2 = 0;
                        break block0;
                    } while (subband.gOrient != 0 && (subband = ((Subband)subband).getParent()) != null);
                    break;
                }
                case 2: {
                    Subband subband = subbandAn;
                    do {
                        if (subband.orientation != 3 && subband.orientation != 1) continue;
                        n = 0;
                        break;
                    } while (subband.gOrient != 0 && (subband = ((Subband)subband).getParent()) != null);
                    n2 = 0;
                    break;
                }
                case 3: {
                    n = 0;
                    n2 = 0;
                    break;
                }
                default: {
                    throw new Error("Internal JJ2000 error");
                }
                case 0: 
            }
            coord.x = (subbandAn.ulcx + subbandAn.w - n + subbandAn.nomCBlkW - 1) / subbandAn.nomCBlkW - ((subbandAn.ulcx - n + subbandAn.nomCBlkW) / subbandAn.nomCBlkW - 1);
            coord.y = (subbandAn.ulcy + subbandAn.h - n2 + subbandAn.nomCBlkH - 1) / subbandAn.nomCBlkH - ((subbandAn.ulcy - n2 + subbandAn.nomCBlkH) / subbandAn.nomCBlkH - 1);
        } else {
            coord.x = 0;
            coord.y = 0;
        }
        return coord;
    }

    public int getPartitionULX() {
        return this.pox;
    }

    public int getPartitionULY() {
        return this.poy;
    }

    public SubbandAn getSubbandTree(int n, int n2) {
        if (this.subbTrees[n][n2] == null) {
            this.subbTrees[n][n2] = new SubbandAn(this.getCompWidth(n2), this.getCompHeight(n2), this.getULX(n2), this.getULY(n2), this.getDecompLevels(n, n2), this.getHorAnWaveletFilters(n, n2), this.getVertAnWaveletFilters(n, n2));
        }
        return this.subbTrees[n][n2];
    }

    public AnWTFilter[] getVertAnWaveletFilters(int n, int n2) {
        return this.filters.getVFilters(n, n2);
    }

    public boolean isReversible(int n, int n2) {
        return this.filters.isReversible(n, n2);
    }

    public void nextTile() {
        super.nextTile();
        if (this.decomposedComps != null) {
            int n = this.decomposedComps.length - 1;
            while (n >= 0) {
                this.decomposedComps[n] = null;
                this.currentSubband[n] = null;
                --n;
            }
        }
    }

    public void setTile(int n, int n2) {
        super.setTile(n, n2);
        if (this.decomposedComps != null) {
            int n3 = this.decomposedComps.length - 1;
            while (n3 >= 0) {
                this.decomposedComps[n3] = null;
                this.currentSubband[n3] = null;
                --n3;
            }
        }
    }

    private void wavelet2DDecomposition(DataBlk dataBlk, SubbandAn subbandAn, int n) {
        if (subbandAn.w == 0 || subbandAn.h == 0) {
            return;
        }
        int n2 = subbandAn.ulx;
        int n3 = subbandAn.uly;
        int n4 = subbandAn.w;
        int n5 = subbandAn.h;
        int n6 = this.getCompWidth(n);
        int n7 = this.getCompHeight(n);
        if (this.intData) {
            int n8;
            int n9;
            int n10;
            int[] nArray = new int[Math.max(n4, n5)];
            int[] nArray2 = ((DataBlkInt)dataBlk).getDataInt();
            if (subbandAn.ulcy % 2 == 0) {
                n10 = 0;
                while (n10 < n4) {
                    n9 = n3 * n6 + n2 + n10;
                    n8 = 0;
                    while (n8 < n5) {
                        nArray[n8] = nArray2[n9 + n8 * n6];
                        ++n8;
                    }
                    subbandAn.vFilter.analyze_lpf(nArray, 0, n5, 1, nArray2, n9, n6, nArray2, n9 + (n5 + 1) / 2 * n6, n6);
                    ++n10;
                }
            } else {
                n10 = 0;
                while (n10 < n4) {
                    n9 = n3 * n6 + n2 + n10;
                    n8 = 0;
                    while (n8 < n5) {
                        nArray[n8] = nArray2[n9 + n8 * n6];
                        ++n8;
                    }
                    subbandAn.vFilter.analyze_hpf(nArray, 0, n5, 1, nArray2, n9, n6, nArray2, n9 + n5 / 2 * n6, n6);
                    ++n10;
                }
            }
            if (subbandAn.ulcx % 2 == 0) {
                n8 = 0;
                while (n8 < n5) {
                    n9 = (n3 + n8) * n6 + n2;
                    n10 = 0;
                    while (n10 < n4) {
                        nArray[n10] = nArray2[n9 + n10];
                        ++n10;
                    }
                    subbandAn.hFilter.analyze_lpf(nArray, 0, n4, 1, nArray2, n9, 1, nArray2, n9 + (n4 + 1) / 2, 1);
                    ++n8;
                }
            } else {
                n8 = 0;
                while (n8 < n5) {
                    n9 = (n3 + n8) * n6 + n2;
                    n10 = 0;
                    while (n10 < n4) {
                        nArray[n10] = nArray2[n9 + n10];
                        ++n10;
                    }
                    subbandAn.hFilter.analyze_hpf(nArray, 0, n4, 1, nArray2, n9, 1, nArray2, n9 + n4 / 2, 1);
                    ++n8;
                }
            }
        } else {
            int n11;
            int n12;
            int n13;
            float[] fArray = new float[Math.max(n4, n5)];
            float[] fArray2 = ((DataBlkFloat)dataBlk).getDataFloat();
            if (subbandAn.ulcy % 2 == 0) {
                n13 = 0;
                while (n13 < n4) {
                    n12 = n3 * n6 + n2 + n13;
                    n11 = 0;
                    while (n11 < n5) {
                        fArray[n11] = fArray2[n12 + n11 * n6];
                        ++n11;
                    }
                    subbandAn.vFilter.analyze_lpf(fArray, 0, n5, 1, fArray2, n12, n6, fArray2, n12 + (n5 + 1) / 2 * n6, n6);
                    ++n13;
                }
            } else {
                n13 = 0;
                while (n13 < n4) {
                    n12 = n3 * n6 + n2 + n13;
                    n11 = 0;
                    while (n11 < n5) {
                        fArray[n11] = fArray2[n12 + n11 * n6];
                        ++n11;
                    }
                    subbandAn.vFilter.analyze_hpf(fArray, 0, n5, 1, fArray2, n12, n6, fArray2, n12 + n5 / 2 * n6, n6);
                    ++n13;
                }
            }
            if (subbandAn.ulcx % 2 == 0) {
                n11 = 0;
                while (n11 < n5) {
                    n12 = (n3 + n11) * n6 + n2;
                    n13 = 0;
                    while (n13 < n4) {
                        fArray[n13] = fArray2[n12 + n13];
                        ++n13;
                    }
                    subbandAn.hFilter.analyze_lpf(fArray, 0, n4, 1, fArray2, n12, 1, fArray2, n12 + (n4 + 1) / 2, 1);
                    ++n11;
                }
            } else {
                n11 = 0;
                while (n11 < n5) {
                    n12 = (n3 + n11) * n6 + n2;
                    n13 = 0;
                    while (n13 < n4) {
                        fArray[n13] = fArray2[n12 + n13];
                        ++n13;
                    }
                    subbandAn.hFilter.analyze_hpf(fArray, 0, n4, 1, fArray2, n12, 1, fArray2, n12 + n4 / 2, 1);
                    ++n11;
                }
            }
        }
    }

    private void waveletTreeDecomposition(DataBlk dataBlk, SubbandAn subbandAn, int n) {
        if (!subbandAn.isNode) {
            return;
        }
        this.wavelet2DDecomposition(dataBlk, subbandAn, n);
        this.waveletTreeDecomposition(dataBlk, (SubbandAn)subbandAn.getHH(), n);
        this.waveletTreeDecomposition(dataBlk, (SubbandAn)subbandAn.getLH(), n);
        this.waveletTreeDecomposition(dataBlk, (SubbandAn)subbandAn.getHL(), n);
        this.waveletTreeDecomposition(dataBlk, (SubbandAn)subbandAn.getLL(), n);
    }
}

