/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.wavelet.analysis;

import jj2000.j2k.wavelet.WaveletFilter;

public abstract class AnWTFilter
implements WaveletFilter {
    public static final char OPT_PREFIX = 'F';
    private static final String[][] pinfo = new String[][]{{"Ffilters", "[<tile-component idx>] <id> [ [<tile-component idx>] <id> ...]", "Specifies which filters to use for specified tile-component.\n<tile-component idx>: see general note\n<id>: ',' separates horizontal and vertical filters, ':' separates decomposition levels filters. JPEG 2000 part I only supports w5x3 and w9x7 filters.", null}};

    public abstract void analyze_hpf(Object var1, int var2, int var3, int var4, Object var5, int var6, int var7, Object var8, int var9, int var10);

    public abstract void analyze_lpf(Object var1, int var2, int var3, int var4, Object var5, int var6, int var7, Object var8, int var9, int var10);

    public abstract int getAnHighNegSupport();

    public abstract int getAnHighPosSupport();

    public abstract int getAnLowNegSupport();

    public abstract int getAnLowPosSupport();

    public abstract int getDataType();

    public abstract int getFilterType();

    public float[] getHPSynWaveForm(float[] fArray, float[] fArray2) {
        return AnWTFilter.upsampleAndConvolve(fArray, this.getHPSynthesisFilter(), fArray2);
    }

    public abstract float[] getHPSynthesisFilter();

    public abstract int getImplType();

    public float[] getLPSynWaveForm(float[] fArray, float[] fArray2) {
        return AnWTFilter.upsampleAndConvolve(fArray, this.getLPSynthesisFilter(), fArray2);
    }

    public abstract float[] getLPSynthesisFilter();

    public static String[][] getParameterInfo() {
        return pinfo;
    }

    public abstract int getSynHighNegSupport();

    public abstract int getSynHighPosSupport();

    public abstract int getSynLowNegSupport();

    public abstract int getSynLowPosSupport();

    public abstract boolean isReversible();

    public abstract boolean isSameAsFullWT(int var1, int var2, int var3);

    private static float[] upsampleAndConvolve(float[] fArray, float[] fArray2, float[] fArray3) {
        if (fArray == null) {
            fArray = new float[]{1.0f};
        }
        if (fArray3 == null) {
            fArray3 = new float[fArray.length * 2 + fArray2.length - 2];
        }
        int n = 0;
        int n2 = fArray.length * 2 + fArray2.length - 2;
        while (n < n2) {
            int n3;
            float f = 0.0f;
            int n4 = (n - fArray2.length + 2) / 2;
            if (n4 < 0) {
                n4 = 0;
            }
            if ((n3 = n / 2 + 1) > fArray.length) {
                n3 = fArray.length;
            }
            int n5 = 2 * n4 - n + fArray2.length - 1;
            while (n4 < n3) {
                f += fArray[n4] * fArray2[n5];
                ++n4;
                n5 += 2;
            }
            fArray3[n] = f;
            ++n;
        }
        return fArray3;
    }
}

