/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.util;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import jj2000.j2k.util.StringFormatException;

public class ParameterList
extends Properties {
    public ParameterList() {
    }

    public ParameterList(ParameterList parameterList) {
        super(parameterList);
    }

    public void checkList(char c, String[] stringArray) {
        Enumeration<?> enumeration = this.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.length() <= 0 || string.charAt(0) != c) continue;
            boolean bl = false;
            if (stringArray != null) {
                int n = stringArray.length - 1;
                while (n >= 0) {
                    if (string.equals(stringArray[n])) {
                        bl = true;
                        break;
                    }
                    --n;
                }
            }
            if (bl) continue;
            throw new IllegalArgumentException("Option '" + string + "' is " + "not a valid one.");
        }
    }

    public void checkList(char[] cArray, String[] stringArray) {
        Enumeration<?> enumeration = this.propertyNames();
        String string = new String(cArray);
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string2.length() <= 0 || string.indexOf(string2.charAt(0)) != -1) continue;
            boolean bl = false;
            if (stringArray != null) {
                int n = stringArray.length - 1;
                while (n >= 0) {
                    if (string2.equals(stringArray[n])) {
                        bl = true;
                        break;
                    }
                    --n;
                }
            }
            if (bl) continue;
            throw new IllegalArgumentException("Option '" + string2 + "' is " + "not a valid one.");
        }
    }

    public boolean getBooleanParameter(String string) {
        String string2 = this.getParameter(string);
        if (string2 == null) {
            throw new IllegalArgumentException("No parameter with name " + string);
        }
        if (string2.equals("on")) {
            return true;
        }
        if (string2.equals("off")) {
            return false;
        }
        throw new StringFormatException("Parameter \"" + string + "\" is not boolean: " + string2);
    }

    public ParameterList getDefaultParameterList() {
        return (ParameterList)this.defaults;
    }

    public float getFloatParameter(String string) {
        String string2 = this.getParameter(string);
        if (string2 == null) {
            throw new IllegalArgumentException("No parameter with name " + string);
        }
        try {
            return new Float(string2).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException("Parameter \"" + string + "\" is not floating-point: " + numberFormatException.getMessage());
        }
    }

    public int getIntParameter(String string) {
        String string2 = this.getParameter(string);
        if (string2 == null) {
            throw new IllegalArgumentException("No parameter with name " + string);
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException("Parameter \"" + string + "\" is not integer: " + numberFormatException.getMessage());
        }
    }

    public String getParameter(String string) {
        String string2 = (String)((Hashtable)this).get(string);
        if (string2 == null && this.defaults != null) {
            string2 = this.defaults.getProperty(string);
        }
        return string2;
    }

    public void parseArgs(String[] stringArray) {
        int n = -1;
        do {
            if (++n < stringArray.length) continue;
            return;
        } while (stringArray[n].length() <= 0);
        char c = stringArray[n].charAt(0);
        if (c != '-' && c != '+') {
            throw new StringFormatException("Argument list does not start with an option: " + stringArray[n]);
        }
        if (stringArray[n].length() >= 2 && Character.isDigit(stringArray[n].charAt(1))) {
            throw new StringFormatException("Numeric option name: " + stringArray[n]);
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (n < stringArray.length) {
            if (stringArray[n].length() <= 1) {
                throw new StringFormatException("Option \"" + stringArray[n] + "\" is too short.");
            }
            c = stringArray[n].charAt(0);
            String string = stringArray[n++];
            stringBuffer.setLength(0);
            if (n >= stringArray.length) {
                stringBuffer.append(c == '-' ? "on" : "off");
            } else {
                char c2 = stringArray[n].charAt(0);
                if (c2 == '-' || c2 == '+') {
                    if (stringArray[n].length() <= 1) {
                        throw new StringFormatException("Option or argument \"" + stringArray[n] + "\" too short");
                    }
                    if (!Character.isDigit(stringArray[n].charAt(1))) {
                        stringBuffer.append(c == '-' ? "on" : "off");
                    }
                }
                if (stringBuffer.length() == 0) {
                    if (c == '+') {
                        throw new StringFormatException("Boolean option \"" + string + "\" has a value");
                    }
                    stringBuffer.append(stringArray[n++]);
                    while (n < stringArray.length) {
                        if (stringArray[n].length() == 0) {
                            ++n;
                            continue;
                        }
                        c = stringArray[n].charAt(0);
                        if (c == '-' || c == '+') {
                            if (stringArray[n].length() <= 1) {
                                throw new StringFormatException("Option or argument \"" + stringArray[n] + "\" too short");
                            }
                            if (!Character.isDigit(stringArray[n].charAt(1))) break;
                        }
                        stringBuffer.append(' ');
                        stringBuffer.append(stringArray[n++]);
                    }
                }
            }
            if (((Hashtable)this).get(string.substring(1)) != null) {
                throw new StringFormatException("Option \"" + string + "\" appears more than once");
            }
            ((Hashtable)this).put(string.substring(1), stringBuffer.toString());
        }
    }

    public static String[] toNameArray(String[][] stringArray) {
        if (stringArray == null) {
            return null;
        }
        String[] stringArray2 = new String[stringArray.length];
        int n = stringArray.length - 1;
        while (n >= 0) {
            stringArray2[n] = stringArray[n][0];
            --n;
        }
        return stringArray2;
    }
}

