/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.util;

public final class NativeServices {
    public static final String SHLIB_NAME = "jj2000";
    private static int libState;
    private static final int LIB_STATE_NOT_LOADED = 0;
    private static final int LIB_STATE_LOADED = 1;
    private static final int LIB_STATE_NOT_FOUND = 2;

    private NativeServices() {
        throw new IllegalArgumentException("Class can not be instantiated");
    }

    private static void checkLibrary() {
        switch (libState) {
            case 1: {
                return;
            }
            case 0: {
                if (NativeServices.loadLibrary()) break;
            }
            case 2: {
                throw new UnsatisfiedLinkError("NativeServices: native shared library could not be loaded");
            }
        }
    }

    public static int getThreadConcurrency() {
        NativeServices.checkLibrary();
        return NativeServices.getThreadConcurrencyN();
    }

    private static native int getThreadConcurrencyN();

    public static boolean loadLibrary() {
        if (libState == 1) {
            return true;
        }
        try {
            System.loadLibrary(SHLIB_NAME);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            libState = 2;
            return false;
        }
        libState = 1;
        return true;
    }

    public static void setThreadConcurrency(int n) {
        NativeServices.checkLibrary();
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        NativeServices.setThreadConcurrencyN(n);
    }

    private static native void setThreadConcurrencyN(int var0);
}

