/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import jj2000.j2k.io.RandomAccessIO;

public class ISRandomAccessIO
implements RandomAccessIO {
    private InputStream is;
    private int maxsize;
    private int inc;
    private byte[] buf;
    private int len;
    private int pos;
    private boolean complete;

    public ISRandomAccessIO(InputStream inputStream) {
        this(inputStream, 262144, 262144, Integer.MAX_VALUE);
    }

    public ISRandomAccessIO(InputStream inputStream, int n, int n2, int n3) {
        if (n < 0 || n2 <= 0 || n3 <= 0 || inputStream == null) {
            throw new IllegalArgumentException();
        }
        this.is = inputStream;
        if (n < Integer.MAX_VALUE) {
            ++n;
        }
        this.buf = new byte[n];
        this.inc = n2;
        if (n3 < Integer.MAX_VALUE) {
            ++n3;
        }
        this.maxsize = n3;
        this.pos = 0;
        this.len = 0;
        this.complete = false;
    }

    public void close() throws IOException {
        this.buf = null;
        if (!this.complete) {
            this.is.close();
            this.is = null;
        }
    }

    public void flush() {
    }

    public int getByteOrdering() {
        return 0;
    }

    public int getPos() throws IOException {
        return this.pos;
    }

    private void growBuffer() throws IOException {
        byte[] byArray;
        int n = this.inc;
        if (this.buf.length + n > this.maxsize) {
            n = this.maxsize - this.buf.length;
        }
        if (n <= 0) {
            throw new IOException("Reached maximum cache size (" + this.maxsize + ")");
        }
        try {
            byArray = new byte[this.buf.length + this.inc];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new IOException("Out of memory to cache input data");
        }
        System.arraycopy(this.buf, 0, byArray, 0, this.len);
        this.buf = byArray;
    }

    public int length() throws IOException {
        while (!this.complete) {
            this.readInput();
        }
        return this.len;
    }

    /*
     * Unable to fully structure code
     */
    public int read() throws IOException {
        if (this.pos >= this.len) ** GOTO lbl4
        return 255 & this.buf[this.pos++];
lbl-1000:
        // 1 sources

        {
            this.readInput();
lbl4:
            // 2 sources

            ** while (!this.complete && this.pos >= this.len)
        }
lbl5:
        // 1 sources

        if (this.pos == this.len) {
            throw new EOFException();
        }
        if (this.pos > this.len) {
            throw new IOException("Position beyond EOF");
        }
        return 255 & this.buf[this.pos++];
    }

    public byte readByte() throws IOException {
        if (this.pos < this.len) {
            return this.buf[this.pos++];
        }
        return (byte)this.read();
    }

    public double readDouble() throws IOException {
        if (this.pos + 7 < this.len) {
            return Double.longBitsToDouble((long)this.buf[this.pos++] << 56 | (long)(0xFF & this.buf[this.pos++]) << 48 | (long)(0xFF & this.buf[this.pos++]) << 40 | (long)(0xFF & this.buf[this.pos++]) << 32 | (long)(0xFF & this.buf[this.pos++]) << 24 | (long)(0xFF & this.buf[this.pos++]) << 16 | (long)(0xFF & this.buf[this.pos++]) << 8 | (long)(0xFF & this.buf[this.pos++]));
        }
        return Double.longBitsToDouble((long)this.read() << 56 | (long)this.read() << 48 | (long)this.read() << 40 | (long)this.read() << 32 | (long)this.read() << 24 | (long)this.read() << 16 | (long)this.read() << 8 | (long)this.read());
    }

    public float readFloat() throws IOException {
        if (this.pos + 3 < this.len) {
            return Float.intBitsToFloat(this.buf[this.pos++] << 24 | (0xFF & this.buf[this.pos++]) << 16 | (0xFF & this.buf[this.pos++]) << 8 | 0xFF & this.buf[this.pos++]);
        }
        return Float.intBitsToFloat(this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read());
    }

    /*
     * Unable to fully structure code
     */
    public void readFully(byte[] var1_1, int var2_2, int var3_3) throws IOException {
        if (this.pos + var3_3 > this.len) ** GOTO lbl6
        System.arraycopy(this.buf, this.pos, var1_1, var2_2, var3_3);
        this.pos += var3_3;
        return;
lbl-1000:
        // 1 sources

        {
            this.readInput();
lbl6:
            // 2 sources

            ** while (!this.complete && this.pos + var3_3 > this.len)
        }
lbl7:
        // 1 sources

        if (this.pos + var3_3 > this.len) {
            throw new EOFException();
        }
        System.arraycopy(this.buf, this.pos, var1_1, var2_2, var3_3);
        this.pos += var3_3;
    }

    private void readInput() throws IOException {
        int n;
        if (this.complete) {
            throw new IllegalArgumentException("Already reached EOF");
        }
        int n2 = this.is.available();
        if (n2 == 0) {
            n2 = 1;
        }
        while (this.len + n2 > this.buf.length) {
            this.growBuffer();
        }
        do {
            if ((n = this.is.read(this.buf, this.len, n2)) <= 0) continue;
            this.len += n;
            n2 -= n;
        } while (n2 > 0 && n > 0);
        if (n <= 0) {
            this.complete = true;
            this.is.close();
            this.is = null;
        }
    }

    public int readInt() throws IOException {
        if (this.pos + 3 < this.len) {
            return this.buf[this.pos++] << 24 | (0xFF & this.buf[this.pos++]) << 16 | (0xFF & this.buf[this.pos++]) << 8 | 0xFF & this.buf[this.pos++];
        }
        return this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read();
    }

    public long readLong() throws IOException {
        if (this.pos + 7 < this.len) {
            return (long)this.buf[this.pos++] << 56 | (long)(0xFF & this.buf[this.pos++]) << 48 | (long)(0xFF & this.buf[this.pos++]) << 40 | (long)(0xFF & this.buf[this.pos++]) << 32 | (long)(0xFF & this.buf[this.pos++]) << 24 | (long)(0xFF & this.buf[this.pos++]) << 16 | (long)(0xFF & this.buf[this.pos++]) << 8 | (long)(0xFF & this.buf[this.pos++]);
        }
        return (long)this.read() << 56 | (long)this.read() << 48 | (long)this.read() << 40 | (long)this.read() << 32 | (long)this.read() << 24 | (long)this.read() << 16 | (long)this.read() << 8 | (long)this.read();
    }

    public short readShort() throws IOException {
        if (this.pos + 1 < this.len) {
            return (short)(this.buf[this.pos++] << 8 | 0xFF & this.buf[this.pos++]);
        }
        return (short)(this.read() << 8 | this.read());
    }

    public int readUnsignedByte() throws IOException {
        if (this.pos < this.len) {
            return 0xFF & this.buf[this.pos++];
        }
        return this.read();
    }

    public long readUnsignedInt() throws IOException {
        if (this.pos + 3 < this.len) {
            return 0xFFFFFFFFL & (long)(this.buf[this.pos++] << 24 | (0xFF & this.buf[this.pos++]) << 16 | (0xFF & this.buf[this.pos++]) << 8 | 0xFF & this.buf[this.pos++]);
        }
        return 0xFFFFFFFFL & (long)(this.read() << 24 | this.read() << 16 | this.read() << 8 | this.read());
    }

    public int readUnsignedShort() throws IOException {
        if (this.pos + 1 < this.len) {
            return (0xFF & this.buf[this.pos++]) << 8 | 0xFF & this.buf[this.pos++];
        }
        return this.read() << 8 | this.read();
    }

    public void seek(int n) throws IOException {
        if (this.complete && n > this.len) {
            throw new EOFException();
        }
        this.pos = n;
    }

    public int skipBytes(int n) throws IOException {
        if (this.complete && this.pos + n > this.len) {
            throw new EOFException();
        }
        this.pos += n;
        return n;
    }

    public void write(int n) throws IOException {
        throw new IOException("read-only");
    }

    public void writeByte(int n) throws IOException {
        throw new IOException("read-only");
    }

    public void writeDouble(double d) throws IOException {
        throw new IOException("read-only");
    }

    public void writeFloat(float f) throws IOException {
        throw new IOException("read-only");
    }

    public void writeInt(int n) throws IOException {
        throw new IOException("read-only");
    }

    public void writeLong(long l) throws IOException {
        throw new IOException("read-only");
    }

    public void writeShort(int n) throws IOException {
        throw new IOException("read-only");
    }
}

