/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Vector;
import jj2000.j2k.io.BEBufferedRandomAccessFile;
import jj2000.j2k.io.BufferedRandomAccessFile;

public class CodestreamManipulator {
    private boolean ppmUsed;
    private boolean pptUsed;
    private boolean tempSop;
    private boolean tempEph;
    private int nt;
    private int pptp;
    private String outname;
    private static int TP_HEAD_LEN = 14;
    private static int MAX_TPSOT = 16;
    private int maxtp;
    private int[] ppt;
    private Integer[] positions;
    private byte[] mainHeader;
    private byte[][][] tileParts;
    private byte[][] tileHeaders;
    private byte[][][] packetHeaders;
    private byte[][][] packetData;
    private byte[][][] sopMarkSeg;

    public CodestreamManipulator(String string, int n, int n2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.ppt = new int[this.nt];
        this.outname = string;
        this.nt = n;
        this.pptp = n2;
        this.ppmUsed = bl;
        this.pptUsed = bl2;
        this.tempSop = bl3;
        this.tempEph = bl4;
    }

    private void createTileParts() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.tileParts = new byte[this.nt][][];
        this.maxtp = 0;
        int n = 0;
        while (n < this.nt) {
            if (this.pptp == 0) {
                this.pptp = this.ppt[n];
            }
            int n2 = this.ppt[n];
            int n3 = (int)Math.ceil((double)n2 / (double)this.pptp);
            int n4 = this.packetHeaders[n].length;
            this.maxtp = n3 > this.maxtp ? n3 : this.maxtp;
            this.tileParts[n] = new byte[n3][];
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            boolean bl = false;
            int n8 = 0;
            while (n8 < n3) {
                int n9;
                int n10 = n9 = this.pptp > n2 ? n2 : this.pptp;
                if (n8 == 0) {
                    byteArrayOutputStream.write(this.tileHeaders[n], 0, this.tileHeaders[n].length - 2);
                } else {
                    byteArrayOutputStream.write(new byte[TP_HEAD_LEN - 2], 0, TP_HEAD_LEN - 2);
                }
                if (this.pptUsed) {
                    int n11;
                    int n12 = 3;
                    int n13 = 0;
                    n7 = n6;
                    while (n7 < n6 + n9) {
                        int n14 = this.packetHeaders[n][n7].length;
                        if (n12 + n14 > 65535) {
                            byteArrayOutputStream.write(0xFFFFFF);
                            byteArrayOutputStream.write(-159);
                            byteArrayOutputStream.write(n12 >>> 8);
                            byteArrayOutputStream.write(n12);
                            byteArrayOutputStream.write(n13++);
                            n11 = n6;
                            while (n11 < n7) {
                                byteArrayOutputStream.write(this.packetHeaders[n][n11], 0, this.packetHeaders[n][n11].length);
                                ++n11;
                            }
                            n12 = 3;
                            n6 = n7;
                        }
                        n12 += n14;
                        ++n7;
                    }
                    byteArrayOutputStream.write(0xFFFFFF);
                    byteArrayOutputStream.write(-159);
                    byteArrayOutputStream.write(n12 >>> 8);
                    byteArrayOutputStream.write(n12);
                    byteArrayOutputStream.write(n13);
                    n11 = n6;
                    while (n11 < n7) {
                        byteArrayOutputStream.write(this.packetHeaders[n][n11], 0, this.packetHeaders[n][n11].length);
                        ++n11;
                    }
                }
                n6 = n7;
                byteArrayOutputStream.write(0xFFFFFF);
                byteArrayOutputStream.write(-109);
                n7 = n5;
                while (n7 < n5 + n9) {
                    if (!this.tempSop) {
                        byteArrayOutputStream.write(this.sopMarkSeg[n][n7], 0, 6);
                    }
                    if (!this.ppmUsed && !this.pptUsed) {
                        byteArrayOutputStream.write(this.packetHeaders[n][n7], 0, this.packetHeaders[n][n7].length);
                    }
                    byteArrayOutputStream.write(this.packetData[n][n7], 0, this.packetData[n][n7].length);
                    ++n7;
                }
                n5 += n9;
                byte[] byArray = byteArrayOutputStream.toByteArray();
                this.tileParts[n][n8] = byArray;
                int n15 = byteArrayOutputStream.size();
                if (n8 == 0) {
                    byArray[6] = (byte)(n15 >>> 24);
                    byArray[7] = (byte)(n15 >>> 16);
                    byArray[8] = (byte)(n15 >>> 8);
                    byArray[9] = (byte)n15;
                    byArray[10] = 0;
                    byArray[11] = (byte)n3;
                } else {
                    byArray[0] = -1;
                    byArray[1] = -112;
                    byArray[2] = 0;
                    byArray[3] = 10;
                    byArray[4] = 0;
                    byArray[5] = (byte)n;
                    byArray[6] = (byte)(n15 >>> 24);
                    byArray[7] = (byte)(n15 >>> 16);
                    byArray[8] = (byte)(n15 >>> 8);
                    byArray[9] = (byte)n15;
                    byArray[10] = (byte)n8;
                    byArray[11] = (byte)n3;
                }
                byteArrayOutputStream.reset();
                n2 -= n9;
                ++n8;
            }
            ++n;
        }
        byteArrayOutputStream.close();
    }

    public int doCodestreamManipulation() throws IOException {
        int n = 0;
        this.ppt = new int[this.nt];
        this.tileParts = new byte[this.nt][][];
        this.tileHeaders = new byte[this.nt][];
        this.packetHeaders = new byte[this.nt][][];
        this.packetData = new byte[this.nt][][];
        this.sopMarkSeg = new byte[this.nt][][];
        if (!this.ppmUsed && !this.pptUsed && this.pptp == 0) {
            return 0;
        }
        BEBufferedRandomAccessFile bEBufferedRandomAccessFile = new BEBufferedRandomAccessFile(this.outname, "rw+");
        n -= bEBufferedRandomAccessFile.length();
        this.parseAndFind(bEBufferedRandomAccessFile);
        this.readAndBuffer(bEBufferedRandomAccessFile);
        bEBufferedRandomAccessFile.close();
        bEBufferedRandomAccessFile = new BEBufferedRandomAccessFile(this.outname, "rw");
        this.createTileParts();
        this.writeNewCodestream(bEBufferedRandomAccessFile);
        bEBufferedRandomAccessFile.flush();
        bEBufferedRandomAccessFile.close();
        return n += bEBufferedRandomAccessFile.length();
    }

    private void parseAndFind(BufferedRandomAccessFile bufferedRandomAccessFile) throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = 0;
        int n5 = 0;
        Vector<Integer> vector = new Vector<Integer>();
        short s = (short)bufferedRandomAccessFile.readUnsignedShort();
        s = (short)bufferedRandomAccessFile.readUnsignedShort();
        while (s != -112) {
            n3 = bufferedRandomAccessFile.getPos();
            n2 = bufferedRandomAccessFile.readUnsignedShort();
            if (s == -174) {
                n = bufferedRandomAccessFile.readUnsignedByte();
                if (this.tempSop) {
                    n &= 0xFD;
                }
                if (this.tempEph) {
                    n &= 0xFB;
                }
                bufferedRandomAccessFile.seek(n3 + 2);
                bufferedRandomAccessFile.write(n);
            }
            bufferedRandomAccessFile.seek(n3 + n2);
            s = (short)bufferedRandomAccessFile.readUnsignedShort();
        }
        n3 = bufferedRandomAccessFile.getPos();
        bufferedRandomAccessFile.seek(n3 - 2);
        int n6 = 0;
        while (n6 < this.nt) {
            bufferedRandomAccessFile.readUnsignedShort();
            n3 = bufferedRandomAccessFile.getPos();
            vector.addElement(new Integer(bufferedRandomAccessFile.getPos()));
            bufferedRandomAccessFile.readInt();
            n2 = bufferedRandomAccessFile.readInt();
            bufferedRandomAccessFile.readUnsignedShort();
            int n7 = n3 + n2 - 2;
            s = (short)bufferedRandomAccessFile.readUnsignedShort();
            while (s != -109) {
                n3 = bufferedRandomAccessFile.getPos();
                n2 = bufferedRandomAccessFile.readUnsignedShort();
                if (s == -174) {
                    n = bufferedRandomAccessFile.readUnsignedByte();
                    if (this.tempSop) {
                        n &= 0xFD;
                    }
                    if (this.tempEph) {
                        n &= 0xFB;
                    }
                    bufferedRandomAccessFile.seek(n3 + 2);
                    bufferedRandomAccessFile.write(n);
                }
                bufferedRandomAccessFile.seek(n3 + n2);
                s = (short)bufferedRandomAccessFile.readUnsignedShort();
            }
            n4 = 0;
            n5 = 0;
            int n8 = bufferedRandomAccessFile.getPos();
            while (n8 < n7) {
                short s2 = (short)bufferedRandomAccessFile.readUnsignedByte();
                if (s2 == 255) {
                    s = (short)((s2 << 8) + bufferedRandomAccessFile.readUnsignedByte());
                    ++n8;
                    if (s == -111) {
                        vector.addElement(new Integer(bufferedRandomAccessFile.getPos()));
                        int n9 = n6;
                        this.ppt[n9] = this.ppt[n9] + 1;
                        ++n4;
                    }
                    if (s == -110) {
                        vector.addElement(new Integer(bufferedRandomAccessFile.getPos()));
                        ++n5;
                    }
                }
                ++n8;
            }
            ++n6;
        }
        vector.addElement(new Integer(bufferedRandomAccessFile.getPos() + 2));
        this.positions = new Integer[vector.size()];
        vector.copyInto(this.positions);
    }

    private void readAndBuffer(BufferedRandomAccessFile bufferedRandomAccessFile) throws IOException {
        bufferedRandomAccessFile.seek(0);
        int n = this.positions[0] - 2;
        this.mainHeader = new byte[n];
        bufferedRandomAccessFile.readFully(this.mainHeader, 0, n);
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.nt) {
            int n4 = this.ppt[n3];
            this.packetHeaders[n3] = new byte[n4][];
            this.packetData[n3] = new byte[n4][];
            this.sopMarkSeg[n3] = new byte[n4][];
            n = this.positions[n2 + 1] - this.positions[n2];
            this.tileHeaders[n3] = new byte[n];
            bufferedRandomAccessFile.readFully(this.tileHeaders[n3], 0, n);
            ++n2;
            int n5 = 0;
            while (n5 < n4) {
                n = this.positions[n2 + 1] - this.positions[n2];
                if (this.tempSop) {
                    n -= 6;
                    bufferedRandomAccessFile.skipBytes(6);
                } else {
                    n -= 6;
                    this.sopMarkSeg[n3][n5] = new byte[6];
                    bufferedRandomAccessFile.readFully(this.sopMarkSeg[n3][n5], 0, 6);
                }
                if (!this.tempEph) {
                    n += 2;
                }
                this.packetHeaders[n3][n5] = new byte[n];
                bufferedRandomAccessFile.readFully(this.packetHeaders[n3][n5], 0, n);
                n = this.positions[++n2 + 1] - this.positions[n2];
                n -= 2;
                if (this.tempEph) {
                    bufferedRandomAccessFile.skipBytes(2);
                }
                this.packetData[n3][n5] = new byte[n];
                bufferedRandomAccessFile.readFully(this.packetData[n3][n5], 0, n);
                ++n2;
                ++n5;
            }
            ++n3;
        }
    }

    private void writeNewCodestream(BufferedRandomAccessFile bufferedRandomAccessFile) throws IOException {
        int n;
        byte[] byArray;
        int n2;
        int n3;
        int n4 = this.tileParts.length;
        int[][] nArray = new int[n4][this.maxtp];
        bufferedRandomAccessFile.write(this.mainHeader, 0, this.mainHeader.length);
        if (this.ppmUsed) {
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n10 = 0;
            int[] nArray2 = new int[n4];
            n3 = 0;
            while (n3 < n4) {
                nArray2[n3] = this.packetHeaders[n3].length;
                ++n3;
            }
            n2 = 0;
            while (n2 < this.maxtp) {
                n3 = 0;
                while (n3 < n4) {
                    if (this.tileParts[n3].length > n2) {
                        n9 = this.packetHeaders[n3].length;
                        n8 = n2 == this.tileParts[n3].length - 1 ? nArray2[n3] : this.pptp;
                        n7 = n9 - nArray2[n3];
                        n6 = n7 + n8;
                        n5 = n7;
                        while (n5 < n6) {
                            int[] nArray3 = nArray[n3];
                            int n11 = n2;
                            nArray3[n11] = nArray3[n11] + this.packetHeaders[n3][n5].length;
                            ++n5;
                        }
                        int n12 = n3;
                        nArray2[n12] = nArray2[n12] - n8;
                    }
                    ++n3;
                }
                ++n2;
            }
            byteArrayOutputStream.write(0xFFFFFF);
            byteArrayOutputStream.write(-160);
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(0);
            byteArrayOutputStream.write(0);
            int n13 = 3;
            ++n10;
            n3 = 0;
            while (n3 < n4) {
                nArray2[n3] = this.packetHeaders[n3].length;
                ++n3;
            }
            n2 = 0;
            while (n2 < this.maxtp) {
                n3 = 0;
                while (n3 < n4) {
                    if (this.tileParts[n3].length > n2) {
                        n9 = this.packetHeaders[n3].length;
                        n8 = n2 == this.tileParts[n3].length - 1 ? nArray2[n3] : this.pptp;
                        n7 = n9 - nArray2[n3];
                        n6 = n7 + n8;
                        if (n13 + 4 > 65535) {
                            byArray = byteArrayOutputStream.toByteArray();
                            n = byArray.length - 2;
                            byArray[2] = (byte)(n >>> 8);
                            byArray[3] = (byte)n;
                            bufferedRandomAccessFile.write(byArray, 0, n + 2);
                            byteArrayOutputStream.reset();
                            byteArrayOutputStream.write(0xFFFFFF);
                            byteArrayOutputStream.write(-160);
                            byteArrayOutputStream.write(0);
                            byteArrayOutputStream.write(0);
                            byteArrayOutputStream.write(n10++);
                            n13 = 3;
                        }
                        n = nArray[n3][n2];
                        byteArrayOutputStream.write(n >>> 24);
                        byteArrayOutputStream.write(n >>> 16);
                        byteArrayOutputStream.write(n >>> 8);
                        byteArrayOutputStream.write(n);
                        n13 += 4;
                        n5 = n7;
                        while (n5 < n6) {
                            n = this.packetHeaders[n3][n5].length;
                            if (n13 + n > 65535) {
                                byArray = byteArrayOutputStream.toByteArray();
                                n = byArray.length - 2;
                                byArray[2] = (byte)(n >>> 8);
                                byArray[3] = (byte)n;
                                bufferedRandomAccessFile.write(byArray, 0, n + 2);
                                byteArrayOutputStream.reset();
                                byteArrayOutputStream.write(0xFFFFFF);
                                byteArrayOutputStream.write(-160);
                                byteArrayOutputStream.write(0);
                                byteArrayOutputStream.write(0);
                                byteArrayOutputStream.write(n10++);
                                n13 = 3;
                            }
                            byteArrayOutputStream.write(this.packetHeaders[n3][n5], 0, this.packetHeaders[n3][n5].length);
                            n13 += this.packetHeaders[n3][n5].length;
                            ++n5;
                        }
                        int n14 = n3;
                        nArray2[n14] = nArray2[n14] - n8;
                    }
                    ++n3;
                }
                ++n2;
            }
            byArray = byteArrayOutputStream.toByteArray();
            n = byArray.length - 2;
            byArray[2] = (byte)(n >>> 8);
            byArray[3] = (byte)n;
            bufferedRandomAccessFile.write(byArray, 0, n + 2);
        }
        n2 = 0;
        while (n2 < this.maxtp) {
            n3 = 0;
            while (n3 < this.nt) {
                if (this.tileParts[n3].length >= n2) {
                    byArray = this.tileParts[n3][n2];
                    n = byArray.length;
                    bufferedRandomAccessFile.write(byArray, 0, n);
                }
                ++n3;
            }
            ++n2;
        }
        bufferedRandomAccessFile.writeShort(-39);
    }
}

