/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.quantization.quantizer;

import jj2000.j2k.encoder.EncoderSpecs;
import jj2000.j2k.image.Coord;
import jj2000.j2k.quantization.GuardBitsSpec;
import jj2000.j2k.quantization.QuantStepSizeSpec;
import jj2000.j2k.quantization.QuantTypeSpec;
import jj2000.j2k.quantization.quantizer.Quantizer;
import jj2000.j2k.wavelet.Subband;
import jj2000.j2k.wavelet.analysis.CBlkWTData;
import jj2000.j2k.wavelet.analysis.CBlkWTDataFloat;
import jj2000.j2k.wavelet.analysis.CBlkWTDataSrc;
import jj2000.j2k.wavelet.analysis.SubbandAn;

public class StdQuantizer
extends Quantizer {
    public static final int QSTEP_MANTISSA_BITS = 11;
    public static final int QSTEP_EXPONENT_BITS = 5;
    public static final int QSTEP_MAX_MANTISSA = 2047;
    public static final int QSTEP_MAX_EXPONENT = 31;
    private static double log2 = Math.log(2.0);
    private QuantTypeSpec qts;
    private QuantStepSizeSpec qsss;
    private GuardBitsSpec gbs;
    private CBlkWTDataFloat infblk;

    public StdQuantizer(CBlkWTDataSrc cBlkWTDataSrc, EncoderSpecs encoderSpecs) {
        super(cBlkWTDataSrc);
        this.qts = encoderSpecs.qts;
        this.qsss = encoderSpecs.qsss;
        this.gbs = encoderSpecs.gbs;
    }

    protected void calcSbParams(SubbandAn subbandAn, int n) {
        if (subbandAn.stepWMSE > 0.0f) {
            return;
        }
        if (!subbandAn.isNode) {
            if (this.isReversible(this.tIdx, n)) {
                subbandAn.stepWMSE = (float)Math.pow(2.0, -(this.src.getNomRangeBits(n) << 1)) * subbandAn.l2Norm * subbandAn.l2Norm;
            } else {
                float f = ((Float)this.qsss.getTileCompVal(this.tIdx, n)).floatValue();
                subbandAn.stepWMSE = this.isDerived(this.tIdx, n) ? f * f * (float)Math.pow(2.0, subbandAn.anGainExp - subbandAn.level << 1) * subbandAn.l2Norm * subbandAn.l2Norm : f * f;
            }
        } else {
            this.calcSbParams((SubbandAn)subbandAn.getLL(), n);
            this.calcSbParams((SubbandAn)subbandAn.getHL(), n);
            this.calcSbParams((SubbandAn)subbandAn.getLH(), n);
            this.calcSbParams((SubbandAn)subbandAn.getHH(), n);
            subbandAn.stepWMSE = 1.0f;
        }
    }

    private static float convertFromExpMantissa(int n) {
        return (-1.0f - (float)(n & 0x7FF) / 2048.0f) / (float)(-1 << (n >> 11 & 0x1F));
    }

    public static int convertToExpMantissa(float f) {
        int n = (int)Math.ceil(-Math.log(f) / log2);
        if (n > 31) {
            return 63488;
        }
        return n << 11 | (int)((-f * (float)(-1 << n) - 1.0f) * 2048.0f + 0.5f);
    }

    public int getMaxMagBits(int n) {
        SubbandAn subbandAn = this.getSubbandTree(this.tIdx, n);
        if (this.isReversible(this.tIdx, n)) {
            return this.getMaxMagBitsRev(subbandAn, n);
        }
        if (this.isDerived(this.tIdx, n)) {
            return this.getMaxMagBitsDerived(subbandAn, this.tIdx, n);
        }
        return this.getMaxMagBitsExpounded(subbandAn, this.tIdx, n);
    }

    private int getMaxMagBitsDerived(Subband subband, int n, int n2) {
        int n3 = 0;
        int n4 = (Integer)this.gbs.getTileCompVal(n, n2);
        if (!subband.isNode) {
            float f = ((Float)this.qsss.getTileCompVal(n, n2)).floatValue();
            return n4 - 1 + subband.level - (int)Math.floor(Math.log(f) / log2);
        }
        n3 = this.getMaxMagBitsDerived(subband.getLL(), n, n2);
        int n5 = this.getMaxMagBitsDerived(subband.getLH(), n, n2);
        if (n5 > n3) {
            n3 = n5;
        }
        if ((n5 = this.getMaxMagBitsDerived(subband.getHL(), n, n2)) > n3) {
            n3 = n5;
        }
        if ((n5 = this.getMaxMagBitsDerived(subband.getHH(), n, n2)) > n3) {
            n3 = n5;
        }
        return n3;
    }

    private int getMaxMagBitsExpounded(Subband subband, int n, int n2) {
        int n3 = 0;
        int n4 = (Integer)this.gbs.getTileCompVal(n, n2);
        if (!subband.isNode) {
            float f = ((Float)this.qsss.getTileCompVal(n, n2)).floatValue();
            return n4 - 1 - (int)Math.floor(Math.log(f / (((SubbandAn)subband).l2Norm * (float)(1 << subband.anGainExp))) / log2);
        }
        n3 = this.getMaxMagBitsExpounded(subband.getLL(), n, n2);
        int n5 = this.getMaxMagBitsExpounded(subband.getLH(), n, n2);
        if (n5 > n3) {
            n3 = n5;
        }
        if ((n5 = this.getMaxMagBitsExpounded(subband.getHL(), n, n2)) > n3) {
            n3 = n5;
        }
        if ((n5 = this.getMaxMagBitsExpounded(subband.getHH(), n, n2)) > n3) {
            n3 = n5;
        }
        return n3;
    }

    private int getMaxMagBitsRev(Subband subband, int n) {
        int n2 = 0;
        int n3 = (Integer)this.gbs.getTileCompVal(this.tIdx, n);
        if (!subband.isNode) {
            return n3 - 1 + this.src.getNomRangeBits(n) + subband.anGainExp;
        }
        n2 = this.getMaxMagBitsRev(subband.getLL(), n);
        int n4 = this.getMaxMagBitsRev(subband.getLH(), n);
        if (n4 > n2) {
            n2 = n4;
        }
        if ((n4 = this.getMaxMagBitsRev(subband.getHL(), n)) > n2) {
            n2 = n4;
        }
        if ((n4 = this.getMaxMagBitsRev(subband.getHH(), n)) > n2) {
            n2 = n4;
        }
        return n2;
    }

    public CBlkWTData getNextCodeBlock(int n, CBlkWTData cBlkWTData) {
        return this.getNextInternCodeBlock(n, cBlkWTData);
    }

    /*
     * Exception decompiling
     */
    public final CBlkWTData getNextInternCodeBlock(int var1_1, CBlkWTData var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: CONTINUE without a while class org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.GotoStatement.getTargetStartBlock(GotoStatement.java:102)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.IfStatement.getStructuredStatement(IfStatement.java:110)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.getStructuredStatementPlaceHolder(Op03SimpleStatement.java:550)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:727)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Coord getNumCodeBlocks(SubbandAn subbandAn, Coord coord) {
        return this.src.getNumCodeBlocks(subbandAn, coord);
    }

    public int getNumGuardBits(int n, int n2) {
        return (Integer)this.gbs.getTileCompVal(n, n2);
    }

    public QuantTypeSpec getQuantTypeSpec() {
        return this.qts;
    }

    public boolean isDerived(int n, int n2) {
        return this.qts.isDerived(n, n2);
    }

    public boolean isReversible(int n, int n2) {
        return this.qts.isReversible(n, n2);
    }
}

