/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.quantization.quantizer;

import jj2000.j2k.encoder.EncoderSpecs;
import jj2000.j2k.image.Coord;
import jj2000.j2k.image.ImgDataAdapter;
import jj2000.j2k.quantization.quantizer.CBlkQuantDataSrcEnc;
import jj2000.j2k.quantization.quantizer.StdQuantizer;
import jj2000.j2k.wavelet.analysis.CBlkWTData;
import jj2000.j2k.wavelet.analysis.CBlkWTDataSrc;
import jj2000.j2k.wavelet.analysis.SubbandAn;

public abstract class Quantizer
extends ImgDataAdapter
implements CBlkQuantDataSrcEnc {
    public static final char OPT_PREFIX = 'Q';
    private static final String[][] pinfo = new String[][]{{"Qtype", "[<tile-component idx>] <id> [ [<tile-component idx>] <id> ...]", "Specifies which quantization type to use for specified tile-component. By default (if '-lossless is not specified'), the quantization step size is 'expounded'.\n<tile-component idx> : see general note.\n<id>: Supported quantization types specification are : 'reversible' (no quantization), 'derived' (derived quantization step size) and 'expounded'.\nExample: -Qtype reversible or -Qtype t2,4-8 c2 reversible t9 derived.", null}, {"Qstep", "[<tile-component idx>] <bnss> [ [<tile-component idx>] <bnss> ...]", "This option specifies the base normalized quantization step size (bnss) for tile-components. It is normalized to a dynamic range of 1 in the image domain. This parameter is ignored in reversible coding.", "0.0078125"}, {"Qguard_bits", "[<tile-component idx>] <gb> [ [<tile-component idx>] <gb> ...]", "The number of bits used for each tile-component in the quantizer to avoid overflow (gb).", "2"}};
    protected CBlkWTDataSrc src;

    public Quantizer(CBlkWTDataSrc cBlkWTDataSrc) {
        super(cBlkWTDataSrc);
        this.src = cBlkWTDataSrc;
    }

    protected abstract void calcSbParams(SubbandAn var1, int var2);

    public static Quantizer createInstance(CBlkWTDataSrc cBlkWTDataSrc, EncoderSpecs encoderSpecs) {
        return new StdQuantizer(cBlkWTDataSrc, encoderSpecs);
    }

    public abstract int getMaxMagBits(int var1);

    public abstract CBlkWTData getNextCodeBlock(int var1, CBlkWTData var2);

    public abstract CBlkWTData getNextInternCodeBlock(int var1, CBlkWTData var2);

    public abstract Coord getNumCodeBlocks(SubbandAn var1, Coord var2);

    public abstract int getNumGuardBits(int var1, int var2);

    public static String[][] getParameterInfo() {
        return pinfo;
    }

    public int getPartitionULX() {
        return this.src.getPartitionULX();
    }

    public int getPartitionULY() {
        return this.src.getPartitionULY();
    }

    public SubbandAn getSubbandTree(int n, int n2) {
        SubbandAn subbandAn = this.src.getSubbandTree(n, n2);
        this.calcSbParams(subbandAn, n2);
        return subbandAn;
    }

    public abstract boolean isDerived(int var1, int var2);

    public abstract boolean isReversible(int var1, int var2);
}

