/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.quantization.dequantizer;

import jj2000.j2k.decoder.DecoderSpecs;
import jj2000.j2k.image.CompTransfSpec;
import jj2000.j2k.image.Coord;
import jj2000.j2k.image.DataBlk;
import jj2000.j2k.image.invcomptransf.InvCompTransf;
import jj2000.j2k.quantization.dequantizer.CBlkQuantDataSrcDec;
import jj2000.j2k.wavelet.synthesis.CBlkWTDataSrcDec;
import jj2000.j2k.wavelet.synthesis.MultiResImgDataAdapter;
import jj2000.j2k.wavelet.synthesis.SubbandSyn;
import jj2000.j2k.wavelet.synthesis.SynWTFilterSpec;

public abstract class Dequantizer
extends MultiResImgDataAdapter
implements CBlkWTDataSrcDec {
    public static final char OPT_PREFIX = 'Q';
    private static final String[][] pinfo = null;
    protected CBlkQuantDataSrcDec src;
    protected int[] rb = null;
    protected int[] utrb = null;
    private CompTransfSpec cts;
    private SynWTFilterSpec wfs;

    public Dequantizer(CBlkQuantDataSrcDec cBlkQuantDataSrcDec, int[] nArray, DecoderSpecs decoderSpecs) {
        super(cBlkQuantDataSrcDec);
        if (nArray.length != cBlkQuantDataSrcDec.getNumComps()) {
            throw new IllegalArgumentException();
        }
        this.src = cBlkQuantDataSrcDec;
        this.utrb = nArray;
        this.cts = decoderSpecs.cts;
        this.wfs = decoderSpecs.wfs;
    }

    public abstract DataBlk getCodeBlock(int var1, int var2, int var3, SubbandSyn var4, DataBlk var5);

    public abstract int getFixedPoint(int var1);

    public abstract DataBlk getInternCodeBlock(int var1, int var2, int var3, SubbandSyn var4, DataBlk var5);

    public int getNomRangeBits(int n) {
        return this.rb[n];
    }

    public Coord getNumCodeBlocks(SubbandSyn subbandSyn, int n, Coord coord) {
        return this.src.getNumCodeBlocks(subbandSyn, n, coord);
    }

    public static String[][] getParameterInfo() {
        return null;
    }

    public int getPartitionULX() {
        return this.src.getPartitionULX();
    }

    public int getPartitionULY() {
        return this.src.getPartitionULY();
    }

    public SubbandSyn getSubbandTree(int n, int n2) {
        return this.src.getSubbandTree(n, n2);
    }

    public void nextTile() {
        this.src.nextTile();
        this.tIdx = this.getTileIdx();
        int n = (Integer)this.cts.getTileDef(this.tIdx);
        switch (n) {
            case 0: {
                this.rb = this.utrb;
                break;
            }
            case 1: {
                this.rb = InvCompTransf.calcMixedBitDepths(this.utrb, 1, null);
                break;
            }
            case 2: {
                this.rb = InvCompTransf.calcMixedBitDepths(this.utrb, 2, null);
                break;
            }
            default: {
                throw new IllegalArgumentException("Non JPEG 2000 part I component transformation for tile: " + this.tIdx);
            }
        }
    }

    public void setTile(int n, int n2) {
        this.src.setTile(n, n2);
        this.tIdx = this.getTileIdx();
        int n3 = 0;
        if ((Integer)this.cts.getTileDef(this.tIdx) == 0) {
            n3 = 0;
        } else {
            int n4 = this.src.getNumComps();
            int n5 = 0;
            int n6 = 0;
            while (n6 < n4) {
                n5 += this.wfs.isReversible(this.tIdx, n6) ? 1 : 0;
                ++n6;
            }
            if (n5 == 3) {
                n3 = 1;
            } else if (n5 == 0) {
                n3 = 2;
            } else {
                throw new IllegalArgumentException("Wavelet transformation and component transformation not coherent in tile" + this.tIdx);
            }
        }
        switch (n3) {
            case 0: {
                this.rb = this.utrb;
                break;
            }
            case 1: {
                this.rb = InvCompTransf.calcMixedBitDepths(this.utrb, 1, null);
                break;
            }
            case 2: {
                this.rb = InvCompTransf.calcMixedBitDepths(this.utrb, 2, null);
                break;
            }
            default: {
                throw new IllegalArgumentException("Non JPEG 2000 part I component transformation for tile: " + this.tIdx);
            }
        }
    }
}

