/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.io;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import jj2000.j2k.io.EndianType;
import jj2000.j2k.io.RandomAccessIO;

public abstract class BufferedRandomAccessFile
implements RandomAccessIO,
EndianType {
    private String fileName;
    private boolean isReadOnly = true;
    private RandomAccessFile theFile;
    protected byte[] byteBuffer;
    protected boolean byteBufferChanged;
    protected int offset;
    protected int pos;
    protected int maxByte;
    protected boolean isEOFInBuffer;
    protected int byteOrdering;

    protected BufferedRandomAccessFile(File file, String string) throws IOException {
        this(file, string, 512);
    }

    protected BufferedRandomAccessFile(File file, String string, int n) throws IOException {
        this.fileName = file.getName();
        if (string.equals("rw") || string.equals("rw+")) {
            this.isReadOnly = false;
            if (string.equals("rw") && file.exists()) {
                file.delete();
            }
            string = "rw";
        }
        this.theFile = new RandomAccessFile(file, string);
        this.byteBuffer = new byte[n];
        this.readNewBuffer(0);
    }

    protected BufferedRandomAccessFile(String string, String string2) throws IOException {
        this(string, string2, 512);
    }

    protected BufferedRandomAccessFile(String string, String string2, int n) throws IOException {
        this(new File(string), string2, n);
    }

    public void close() throws IOException {
        this.flush();
        this.byteBuffer = null;
        this.theFile.close();
    }

    public final void flush() throws IOException {
        if (this.byteBufferChanged) {
            this.theFile.seek(this.offset);
            this.theFile.write(this.byteBuffer, 0, this.maxByte);
            this.byteBufferChanged = false;
        }
    }

    public int getByteOrdering() {
        return this.byteOrdering;
    }

    public int getPos() {
        return this.offset + this.pos;
    }

    public int length() throws IOException {
        int n = (int)this.theFile.length();
        if (this.offset + this.maxByte <= n) {
            return n;
        }
        return this.offset + this.maxByte;
    }

    public final int read() throws IOException, EOFException {
        if (this.pos < this.maxByte) {
            return this.byteBuffer[this.pos++] & 0xFF;
        }
        if (this.isEOFInBuffer) {
            this.pos = this.maxByte + 1;
            throw new EOFException();
        }
        this.readNewBuffer(this.offset + this.pos);
        return this.read();
    }

    public final byte readByte() throws EOFException, IOException {
        if (this.pos < this.maxByte) {
            return this.byteBuffer[this.pos++];
        }
        if (this.isEOFInBuffer) {
            this.pos = this.maxByte + 1;
            throw new EOFException();
        }
        this.readNewBuffer(this.offset + this.pos);
        return this.readByte();
    }

    public abstract double readDouble() throws EOFException, IOException;

    public abstract float readFloat() throws EOFException, IOException;

    public final void readFully(byte[] byArray, int n, int n2) throws IOException {
        while (n2 > 0) {
            if (this.pos < this.maxByte) {
                int n3 = this.maxByte - this.pos;
                if (n3 > n2) {
                    n3 = n2;
                }
                System.arraycopy(this.byteBuffer, this.pos, byArray, n, n3);
                this.pos += n3;
                n += n3;
                n2 -= n3;
                continue;
            }
            if (this.isEOFInBuffer) {
                this.pos = this.maxByte + 1;
                throw new EOFException();
            }
            this.readNewBuffer(this.offset + this.pos);
        }
    }

    public abstract int readInt() throws EOFException, IOException;

    public abstract long readLong() throws EOFException, IOException;

    protected final void readNewBuffer(int n) throws IOException {
        if (this.byteBufferChanged) {
            this.flush();
        }
        if (this.isReadOnly && (long)n >= this.theFile.length()) {
            throw new EOFException();
        }
        this.offset = n;
        this.theFile.seek(this.offset);
        this.maxByte = this.theFile.read(this.byteBuffer, 0, this.byteBuffer.length);
        this.pos = 0;
        if (this.maxByte < this.byteBuffer.length) {
            this.isEOFInBuffer = true;
            if (this.maxByte == -1) {
                ++this.maxByte;
            }
        } else {
            this.isEOFInBuffer = false;
        }
    }

    public abstract short readShort() throws EOFException, IOException;

    public final int readUnsignedByte() throws EOFException, IOException {
        return this.read();
    }

    public abstract long readUnsignedInt() throws EOFException, IOException;

    public abstract int readUnsignedShort() throws EOFException, IOException;

    public void seek(int n) throws IOException {
        if (n >= this.offset && n < this.offset + this.byteBuffer.length) {
            if (this.isReadOnly && this.isEOFInBuffer && n > this.offset + this.maxByte) {
                throw new EOFException();
            }
            this.pos = n - this.offset;
        } else {
            this.readNewBuffer(n);
        }
    }

    public int skipBytes(int n) throws EOFException, IOException {
        if (n < 0) {
            throw new IllegalArgumentException("Can not skip negative number of bytes");
        }
        if (n <= this.maxByte - this.pos) {
            this.pos += n;
            return n;
        }
        this.seek(this.offset + this.pos + n);
        return n;
    }

    public String toString() {
        return "BufferedRandomAccessFile: " + this.fileName + " (" + (this.isReadOnly ? "read only" : "read/write") + ")";
    }

    public final void write(byte by) throws IOException {
        if (this.pos < this.byteBuffer.length) {
            if (this.isReadOnly) {
                throw new IOException("File is read only");
            }
            this.byteBuffer[this.pos] = by;
            if (this.pos >= this.maxByte) {
                this.maxByte = this.pos + 1;
            }
            ++this.pos;
            this.byteBufferChanged = true;
        } else {
            this.readNewBuffer(this.offset + this.pos);
            this.write(by);
        }
    }

    public final void write(int n) throws IOException {
        if (this.pos < this.byteBuffer.length) {
            if (this.isReadOnly) {
                throw new IOException("File is read only");
            }
            this.byteBuffer[this.pos] = (byte)n;
            if (this.pos >= this.maxByte) {
                this.maxByte = this.pos + 1;
            }
            ++this.pos;
            this.byteBufferChanged = true;
        } else {
            this.readNewBuffer(this.offset + this.pos);
            this.write(n);
        }
    }

    public final void write(byte[] byArray, int n, int n2) throws IOException {
        int n3 = n + n2;
        if (n3 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException(byArray.length);
        }
        int n4 = n;
        while (n4 < n3) {
            this.write(byArray[n4]);
            ++n4;
        }
    }

    public final void writeByte(int n) throws IOException {
        this.write(n);
    }

    public abstract void writeDouble(double var1) throws IOException;

    public abstract void writeFloat(float var1) throws IOException;

    public abstract void writeInt(int var1) throws IOException;

    public abstract void writeLong(long var1) throws IOException;

    public abstract void writeShort(int var1) throws IOException;
}

