/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.image.output;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import jj2000.j2k.image.BlkImgDataSrc;
import jj2000.j2k.image.DataBlkInt;
import jj2000.j2k.image.output.ImgWriter;

public class ImgWriterPPM
extends ImgWriter {
    private int[] levShift = new int[3];
    private RandomAccessFile out;
    private int[] cps = new int[3];
    private int[] fb = new int[3];
    private DataBlkInt db = new DataBlkInt();
    private int offset;
    private byte[] buf;

    public ImgWriterPPM(File file, BlkImgDataSrc blkImgDataSrc, int n, int n2, int n3) throws IOException {
        if (n < 0 || n >= blkImgDataSrc.getNumComps() || n2 < 0 || n2 >= blkImgDataSrc.getNumComps() || n3 < 0 || n3 >= blkImgDataSrc.getNumComps() || blkImgDataSrc.getNomRangeBits(n) > 8 || blkImgDataSrc.getNomRangeBits(n2) > 8 || blkImgDataSrc.getNomRangeBits(n3) > 8) {
            throw new IllegalArgumentException();
        }
        this.w = blkImgDataSrc.getCompImgWidth(n);
        this.h = blkImgDataSrc.getCompImgHeight(n);
        if (this.w != blkImgDataSrc.getCompImgWidth(n2) || this.w != blkImgDataSrc.getCompImgWidth(n3) || this.h != blkImgDataSrc.getCompImgHeight(n2) || this.h != blkImgDataSrc.getCompImgHeight(n3)) {
            throw new IllegalArgumentException();
        }
        if (file.exists() && !file.delete()) {
            throw new IOException("Could not reset file");
        }
        this.out = new RandomAccessFile(file, "rw");
        this.src = blkImgDataSrc;
        this.cps[0] = n;
        this.cps[1] = n2;
        this.cps[2] = n3;
        this.fb[0] = blkImgDataSrc.getFixedPoint(n);
        this.fb[1] = blkImgDataSrc.getFixedPoint(n2);
        this.fb[2] = blkImgDataSrc.getFixedPoint(n3);
        this.levShift[0] = 1 << blkImgDataSrc.getNomRangeBits(n) - 1;
        this.levShift[1] = 1 << blkImgDataSrc.getNomRangeBits(n2) - 1;
        this.levShift[2] = 1 << blkImgDataSrc.getNomRangeBits(n3) - 1;
        this.writeHeaderInfo();
    }

    public ImgWriterPPM(String string, BlkImgDataSrc blkImgDataSrc, int n, int n2, int n3) throws IOException {
        this(new File(string), blkImgDataSrc, n, n2, n3);
    }

    public void close() throws IOException {
        if (this.out.length() != (long)(3 * this.w * this.h + this.offset)) {
            this.out.seek(this.out.length());
            int n = 3 * this.w * this.h + this.offset - (int)this.out.length();
            while (n > 0) {
                this.out.writeByte(0);
                --n;
            }
        }
        this.out.close();
        this.src = null;
        this.out = null;
        this.db = null;
    }

    public void flush() throws IOException {
        this.buf = null;
    }

    public String toString() {
        return "ImgWriterPPM: WxH = " + this.w + "x" + this.h + ", Components = " + this.cps[0] + "," + this.cps[1] + "," + this.cps[2] + "\nUnderlying RandomAccessFile:\n" + this.out.toString();
    }

    public void write() throws IOException {
        int n = this.src.getWidth();
        int n2 = this.src.getHeight();
        int n3 = 0;
        while (n3 < n2) {
            this.write(0, n3, n, n2 - n3 < 64 ? n2 - n3 : 64);
            n3 += 64;
        }
    }

    public void write(int n, int n2, int n3, int n4) throws IOException {
        int n5 = this.src.getULX(this.cps[0]) - (this.src.getImgULX() + this.src.getCompSubsX(this.cps[0]) - 1) / this.src.getCompSubsX(this.cps[0]);
        int n6 = this.src.getULY(this.cps[0]) - (this.src.getImgULY() + this.src.getCompSubsY(this.cps[0]) - 1) / this.src.getCompSubsY(this.cps[0]);
        if (this.db.data != null && this.db.data.length < n3) {
            this.db.data = null;
        }
        if (this.buf == null || this.buf.length < 3 * n3) {
            this.buf = new byte[3 * n3];
        }
        int n7 = 0;
        while (n7 < n4) {
            int n8 = 0;
            while (n8 < 3) {
                int n9;
                int n10;
                int n11;
                int n12 = (1 << this.src.getNomRangeBits(this.cps[n8])) - 1;
                int n13 = this.levShift[n8];
                this.db.ulx = n;
                this.db.uly = n2 + n7;
                this.db.w = n3;
                this.db.h = 1;
                do {
                    this.db = (DataBlkInt)this.src.getInternCompData(this.db, this.cps[n8]);
                } while (this.db.progressive);
                int n14 = this.fb[n8];
                if (n14 == 0) {
                    n11 = this.db.offset + n3 - 1;
                    n10 = 3 * n3 - 1 + n8 - 2;
                    while (n10 >= 0) {
                        n9 = this.db.data[n11] + n13;
                        this.buf[n10] = (byte)(n9 < 0 ? 0 : (n9 > n12 ? n12 : n9));
                        n10 -= 3;
                        --n11;
                    }
                } else {
                    n11 = this.db.offset + n3 - 1;
                    n10 = 3 * n3 - 1 + n8 - 2;
                    while (n10 >= 0) {
                        n9 = (this.db.data[n11] >>> n14) + n13;
                        this.buf[n10] = (byte)(n9 < 0 ? 0 : (n9 > n12 ? n12 : n9));
                        n10 -= 3;
                        --n11;
                    }
                }
                ++n8;
            }
            this.out.seek(this.offset + 3 * (this.w * (n2 + n6 + n7) + n + n5));
            this.out.write(this.buf, 0, 3 * n3);
            ++n7;
        }
    }

    private void writeHeaderInfo() throws IOException {
        this.out.seek(0L);
        this.out.write(80);
        this.out.write(54);
        this.out.write(10);
        this.offset = 3;
        String string = String.valueOf(this.w);
        byte[] byArray = string.getBytes();
        int n = 0;
        while (n < byArray.length) {
            this.out.write(byArray[n]);
            ++this.offset;
            ++n;
        }
        this.out.write(32);
        ++this.offset;
        string = String.valueOf(this.h);
        byArray = string.getBytes();
        n = 0;
        while (n < byArray.length) {
            this.out.write(byArray[n]);
            ++this.offset;
            ++n;
        }
        this.out.write(10);
        this.out.write(50);
        this.out.write(53);
        this.out.write(53);
        this.out.write(10);
        this.offset += 5;
    }
}

