/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.image.output;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import jj2000.j2k.image.BlkImgDataSrc;
import jj2000.j2k.image.DataBlkInt;
import jj2000.j2k.image.output.ImgWriter;

public class ImgWriterPGX
extends ImgWriter {
    int maxVal;
    int minVal;
    int levShift;
    boolean isSigned;
    private int bitDepth;
    private RandomAccessFile out;
    private int offset;
    private DataBlkInt db = new DataBlkInt();
    private int fb;
    private int c;
    private int packBytes;
    private byte[] buf;

    public ImgWriterPGX(File file, BlkImgDataSrc blkImgDataSrc, int n, boolean bl) throws IOException {
        this.c = n;
        if (file.exists() && !file.delete()) {
            throw new IOException("Could not reset file");
        }
        this.out = new RandomAccessFile(file, "rw");
        this.isSigned = bl;
        this.src = blkImgDataSrc;
        this.w = this.src.getCompImgWidth(n);
        this.h = this.src.getCompImgHeight(n);
        this.fb = blkImgDataSrc.getFixedPoint(n);
        this.bitDepth = this.src.getNomRangeBits(this.c);
        if (this.bitDepth <= 0 || this.bitDepth > 31) {
            throw new IOException("PGX supports only bit-depth between 1 and 31");
        }
        this.packBytes = this.bitDepth <= 8 ? 1 : (this.bitDepth <= 16 ? 2 : 4);
        String string = "PG ML " + (this.isSigned ? "- " : "+ ") + this.bitDepth + " " + this.w + " " + this.h + "\n";
        byte[] byArray = string.getBytes();
        int n2 = 0;
        while (n2 < byArray.length) {
            this.out.write(byArray[n2]);
            ++n2;
        }
        this.offset = byArray.length;
        this.maxVal = this.isSigned ? (1 << this.src.getNomRangeBits(n) - 1) - 1 : (1 << this.src.getNomRangeBits(n)) - 1;
        this.minVal = this.isSigned ? -1 * (1 << this.src.getNomRangeBits(n) - 1) : 0;
        this.levShift = this.isSigned ? 0 : 1 << this.src.getNomRangeBits(n) - 1;
    }

    public ImgWriterPGX(String string, BlkImgDataSrc blkImgDataSrc, int n, boolean bl) throws IOException {
        this(new File(string), blkImgDataSrc, n, bl);
    }

    public void close() throws IOException {
        if (this.out.length() != (long)(this.w * this.h * this.packBytes + this.offset)) {
            this.out.seek(this.out.length());
            int n = this.offset + this.w * this.h * this.packBytes - (int)this.out.length();
            while (n > 0) {
                this.out.writeByte(0);
                --n;
            }
        }
        this.out.close();
        this.src = null;
        this.out = null;
        this.db = null;
    }

    public void flush() throws IOException {
        this.buf = null;
    }

    public String toString() {
        return "ImgWriterPGX: WxH = " + this.w + "x" + this.h + ", Component = " + this.c + ", Bit-depth = " + this.bitDepth + ", signed = " + this.isSigned + "\nUnderlying RandomAccessFile:\n" + this.out.toString();
    }

    public void write() throws IOException {
        int n = this.src.getCompWidth(this.c);
        int n2 = this.src.getCompHeight(this.c);
        int n3 = 0;
        while (n3 < n2) {
            this.write(0, n3, n, n2 - n3 < 64 ? n2 - n3 : 64);
            n3 += 64;
        }
    }

    public void write(int n, int n2, int n3, int n4) throws IOException {
        int n5 = this.fb;
        this.db.ulx = n;
        this.db.uly = n2;
        this.db.w = n3;
        this.db.h = n4;
        int n6 = this.src.getULX(this.c) - (this.src.getImgULX() + this.src.getCompSubsX(this.c) - 1) / this.src.getCompSubsX(this.c);
        int n7 = this.src.getULY(this.c) - (this.src.getImgULY() + this.src.getCompSubsY(this.c) - 1) / this.src.getCompSubsY(this.c);
        if (this.db.data != null && this.db.data.length < n3 * n4) {
            this.db.data = null;
        }
        do {
            this.src.getInternCompData(this.db, this.c);
        } while (this.db.progressive);
        if (this.buf == null || this.buf.length < this.packBytes * n3) {
            this.buf = new byte[this.packBytes * n3];
        }
        switch (this.packBytes) {
            case 1: {
                int n8 = 0;
                while (n8 < n4) {
                    int n9;
                    int n10;
                    int n11;
                    this.out.seek(this.offset + this.w * (n2 + n7 + n8) + n + n6);
                    if (n5 == 0) {
                        n11 = this.db.offset + n8 * this.db.scanw + n3 - 1;
                        n10 = n3 - 1;
                        while (n10 >= 0) {
                            n9 = this.db.data[n11] + this.levShift;
                            this.buf[n10--] = (byte)(n9 < this.minVal ? this.minVal : (n9 > this.maxVal ? this.maxVal : n9));
                            --n11;
                        }
                    } else {
                        n11 = this.db.offset + n8 * this.db.scanw + n3 - 1;
                        n10 = n3 - 1;
                        while (n10 >= 0) {
                            n9 = (this.db.data[n11] >>> n5) + this.levShift;
                            this.buf[n10--] = (byte)(n9 < this.minVal ? this.minVal : (n9 > this.maxVal ? this.maxVal : n9));
                            --n11;
                        }
                    }
                    this.out.write(this.buf, 0, n3);
                    ++n8;
                }
                break;
            }
            case 2: {
                int n12 = 0;
                while (n12 < n4) {
                    int n13;
                    int n14;
                    int n15;
                    this.out.seek(this.offset + 2 * (this.w * (n2 + n7 + n12) + n + n6));
                    if (n5 == 0) {
                        n15 = this.db.offset + n12 * this.db.scanw + n3 - 1;
                        n14 = (n3 << 1) - 1;
                        while (n14 >= 0) {
                            n13 = this.db.data[n15] + this.levShift;
                            n13 = n13 < this.minVal ? this.minVal : (n13 > this.maxVal ? this.maxVal : n13);
                            this.buf[n14--] = (byte)n13;
                            this.buf[n14--] = (byte)(n13 >>> 8);
                            --n15;
                        }
                    } else {
                        n15 = this.db.offset + n12 * this.db.scanw + n3 - 1;
                        n14 = (n3 << 1) - 1;
                        while (n14 >= 0) {
                            n13 = (this.db.data[n15] >>> n5) + this.levShift;
                            n13 = n13 < this.minVal ? this.minVal : (n13 > this.maxVal ? this.maxVal : n13);
                            this.buf[n14--] = (byte)n13;
                            this.buf[n14--] = (byte)(n13 >>> 8);
                            --n15;
                        }
                    }
                    this.out.write(this.buf, 0, n3 << 1);
                    ++n12;
                }
                break;
            }
            case 4: {
                int n16 = 0;
                while (n16 < n4) {
                    int n17;
                    int n18;
                    int n19;
                    this.out.seek(this.offset + 4 * (this.w * (n2 + n7 + n16) + n + n6));
                    if (n5 == 0) {
                        n19 = this.db.offset + n16 * this.db.scanw + n3 - 1;
                        n18 = (n3 << 2) - 1;
                        while (n18 >= 0) {
                            n17 = this.db.data[n19] + this.levShift;
                            n17 = n17 < this.minVal ? this.minVal : (n17 > this.maxVal ? this.maxVal : n17);
                            this.buf[n18--] = (byte)n17;
                            this.buf[n18--] = (byte)(n17 >>> 8);
                            this.buf[n18--] = (byte)(n17 >>> 16);
                            this.buf[n18--] = (byte)(n17 >>> 24);
                            --n19;
                        }
                    } else {
                        n19 = this.db.offset + n16 * this.db.scanw + n3 - 1;
                        n18 = (n3 << 2) - 1;
                        while (n18 >= 0) {
                            n17 = (this.db.data[n19] >>> n5) + this.levShift;
                            n17 = n17 < this.minVal ? this.minVal : (n17 > this.maxVal ? this.maxVal : n17);
                            this.buf[n18--] = (byte)n17;
                            this.buf[n18--] = (byte)(n17 >>> 8);
                            this.buf[n18--] = (byte)(n17 >>> 16);
                            this.buf[n18--] = (byte)(n17 >>> 24);
                            --n19;
                        }
                    }
                    this.out.write(this.buf, 0, n3 << 2);
                    ++n16;
                }
                break;
            }
            default: {
                throw new IOException("PGX supports only bit-depth between 1 and 31");
            }
        }
    }
}

