/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.image.output;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import jj2000.j2k.image.BlkImgDataSrc;
import jj2000.j2k.image.DataBlkInt;
import jj2000.j2k.image.output.ImgWriter;

public class ImgWriterPGM
extends ImgWriter {
    private int levShift;
    private RandomAccessFile out;
    private int c;
    private int fb;
    private DataBlkInt db = new DataBlkInt();
    private int offset;
    private byte[] buf;

    public ImgWriterPGM(File file, BlkImgDataSrc blkImgDataSrc, int n) throws IOException {
        if (n < 0 || n >= blkImgDataSrc.getNumComps() || blkImgDataSrc.getNomRangeBits(n) > 8) {
            throw new IllegalArgumentException();
        }
        if (file.exists() && !file.delete()) {
            throw new IOException("Could not reset file");
        }
        this.out = new RandomAccessFile(file, "rw");
        this.src = blkImgDataSrc;
        this.c = n;
        this.w = blkImgDataSrc.getCompImgWidth(n);
        this.h = blkImgDataSrc.getCompImgHeight(n);
        this.fb = blkImgDataSrc.getFixedPoint(n);
        this.levShift = 1 << blkImgDataSrc.getNomRangeBits(n) - 1;
        this.writeHeaderInfo();
    }

    public ImgWriterPGM(String string, BlkImgDataSrc blkImgDataSrc, int n) throws IOException {
        this(new File(string), blkImgDataSrc, n);
    }

    public void close() throws IOException {
        if (this.out.length() != (long)(this.w * this.h + this.offset)) {
            this.out.seek(this.out.length());
            int n = this.offset + this.w * this.h - (int)this.out.length();
            while (n > 0) {
                this.out.writeByte(0);
                --n;
            }
        }
        this.out.close();
        this.src = null;
        this.out = null;
        this.db = null;
    }

    public void flush() throws IOException {
        this.buf = null;
    }

    public String toString() {
        return "ImgWriterPGM: WxH = " + this.w + "x" + this.h + ", Component = " + this.c + "\nUnderlying RandomAccessFile:\n" + this.out.toString();
    }

    public void write() throws IOException {
        int n = this.src.getCompWidth(this.c);
        int n2 = this.src.getCompHeight(this.c);
        int n3 = 0;
        while (n3 < n2) {
            this.write(0, n3, n, n2 - n3 < 64 ? n2 - n3 : 64);
            n3 += 64;
        }
    }

    public void write(int n, int n2, int n3, int n4) throws IOException {
        int n5 = this.fb;
        this.db.ulx = n;
        this.db.uly = n2;
        this.db.w = n3;
        this.db.h = n4;
        int n6 = this.src.getULX(this.c) - (this.src.getImgULX() + this.src.getCompSubsX(this.c) - 1) / this.src.getCompSubsX(this.c);
        int n7 = this.src.getULY(this.c) - (this.src.getImgULY() + this.src.getCompSubsY(this.c) - 1) / this.src.getCompSubsY(this.c);
        if (this.db.data != null && this.db.data.length < n3 * n4) {
            this.db.data = null;
        }
        do {
            this.db = (DataBlkInt)this.src.getInternCompData(this.db, this.c);
        } while (this.db.progressive);
        int n8 = (1 << this.src.getNomRangeBits(this.c)) - 1;
        if (this.buf == null || this.buf.length < n3) {
            this.buf = new byte[n3];
        }
        int n9 = 0;
        while (n9 < n4) {
            int n10;
            int n11;
            int n12;
            this.out.seek(this.offset + this.w * (n2 + n7 + n9) + n + n6);
            if (n5 == 0) {
                n12 = this.db.offset + n9 * this.db.scanw + n3 - 1;
                n11 = n3 - 1;
                while (n11 >= 0) {
                    n10 = this.db.data[n12] + this.levShift;
                    this.buf[n11] = (byte)(n10 < 0 ? 0 : (n10 > n8 ? n8 : n10));
                    --n11;
                    --n12;
                }
            } else {
                n12 = this.db.offset + n9 * this.db.scanw + n3 - 1;
                n11 = n3 - 1;
                while (n11 >= 0) {
                    n10 = (this.db.data[n12] >> n5) + this.levShift;
                    this.buf[n11] = (byte)(n10 < 0 ? 0 : (n10 > n8 ? n8 : n10));
                    --n11;
                    --n12;
                }
            }
            this.out.write(this.buf, 0, n3);
            ++n9;
        }
    }

    private void writeHeaderInfo() throws IOException {
        this.out.writeByte(80);
        this.out.write(53);
        this.out.write(10);
        this.offset = 3;
        String string = String.valueOf(this.w);
        byte[] byArray = string.getBytes();
        int n = 0;
        while (n < byArray.length) {
            this.out.writeByte(byArray[n]);
            ++this.offset;
            ++n;
        }
        this.out.write(32);
        ++this.offset;
        string = String.valueOf(this.h);
        byArray = string.getBytes();
        n = 0;
        while (n < byArray.length) {
            this.out.writeByte(byArray[n]);
            ++this.offset;
            ++n;
        }
        this.out.write(10);
        this.out.write(50);
        this.out.write(53);
        this.out.write(53);
        this.out.write(10);
        this.offset += 5;
    }
}

