/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.image.invcomptransf;

import jj2000.j2k.decoder.DecoderSpecs;
import jj2000.j2k.image.BlkImgDataSrc;
import jj2000.j2k.image.CompTransfSpec;
import jj2000.j2k.image.DataBlk;
import jj2000.j2k.image.DataBlkFloat;
import jj2000.j2k.image.DataBlkInt;
import jj2000.j2k.image.ImgDataAdapter;
import jj2000.j2k.util.MathUtil;
import jj2000.j2k.wavelet.synthesis.SynWTFilterSpec;

public class InvCompTransf
extends ImgDataAdapter
implements BlkImgDataSrc {
    public static final int NONE = 0;
    public static final char OPT_PREFIX = 'M';
    private static final String[][] pinfo = null;
    public static final int INV_RCT = 1;
    public static final int INV_ICT = 2;
    private BlkImgDataSrc src;
    private CompTransfSpec cts;
    private SynWTFilterSpec wfs;
    private int transfType = 0;
    private int[][] outdata = new int[3][];
    private DataBlk block0;
    private DataBlk block1;
    private DataBlk block2;
    private DataBlkInt dbi = new DataBlkInt();
    private int[] utdepth;

    public InvCompTransf(BlkImgDataSrc blkImgDataSrc, DecoderSpecs decoderSpecs, int[] nArray) {
        super(blkImgDataSrc);
        this.cts = decoderSpecs.cts;
        this.wfs = decoderSpecs.wfs;
        this.src = blkImgDataSrc;
        this.utdepth = nArray;
    }

    public static int[] calcMixedBitDepths(int[] nArray, int n, int[] nArray2) {
        if (nArray.length < 3 && n != 0) {
            throw new IllegalArgumentException();
        }
        if (nArray2 == null) {
            nArray2 = new int[nArray.length];
        }
        switch (n) {
            case 0: {
                System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                break;
            }
            case 1: {
                if (nArray.length > 3) {
                    System.arraycopy(nArray, 3, nArray2, 3, nArray.length - 3);
                }
                nArray2[0] = MathUtil.log2((1 << nArray[0]) + (2 << nArray[1]) + (1 << nArray[2]) - 1) - 2 + 1;
                nArray2[1] = MathUtil.log2((1 << nArray[2]) + (1 << nArray[1]) - 1) + 1;
                nArray2[2] = MathUtil.log2((1 << nArray[0]) + (1 << nArray[1]) - 1) + 1;
                break;
            }
            case 2: {
                if (nArray.length > 3) {
                    System.arraycopy(nArray, 3, nArray2, 3, nArray.length - 3);
                }
                nArray2[0] = MathUtil.log2((int)Math.floor((double)(1 << nArray[0]) * 0.299072 + (double)(1 << nArray[1]) * 0.586914 + (double)(1 << nArray[2]) * 0.114014) - 1) + 1;
                nArray2[1] = MathUtil.log2((int)Math.floor((double)(1 << nArray[0]) * 0.168701 + (double)(1 << nArray[1]) * 0.331299 + (double)(1 << nArray[2]) * 0.5) - 1) + 1;
                nArray2[2] = MathUtil.log2((int)Math.floor((double)(1 << nArray[0]) * 0.5 + (double)(1 << nArray[1]) * 0.418701 + (double)(1 << nArray[2]) * 0.081299) - 1) + 1;
                break;
            }
        }
        return nArray2;
    }

    public DataBlk getCompData(DataBlk dataBlk, int n) {
        if (n >= 3 || this.transfType == 0) {
            return this.src.getCompData(dataBlk, n);
        }
        return this.getInternCompData(dataBlk, n);
    }

    public int getFixedPoint(int n) {
        return this.src.getFixedPoint(n);
    }

    public DataBlk getInternCompData(DataBlk dataBlk, int n) {
        switch (this.transfType) {
            case 0: {
                return this.src.getInternCompData(dataBlk, n);
            }
            case 1: {
                return this.invRCT(dataBlk, n);
            }
            case 2: {
                return this.invICT(dataBlk, n);
            }
        }
        throw new IllegalArgumentException("Non JPEG 2000 part I component transformation");
    }

    public int getNomRangeBits(int n) {
        return this.utdepth[n];
    }

    public static String[][] getParameterInfo() {
        return null;
    }

    private DataBlk invICT(DataBlk dataBlk, int n) {
        if (this.outdata[n] == null || this.dbi.ulx > dataBlk.ulx || this.dbi.uly > dataBlk.uly || this.dbi.ulx + this.dbi.w < dataBlk.ulx + dataBlk.w || this.dbi.uly + this.dbi.h < dataBlk.uly + dataBlk.h) {
            int n2 = dataBlk.w;
            int n3 = dataBlk.h;
            this.outdata[n] = (int[])dataBlk.getData();
            if (this.outdata[n] == null || this.outdata[n].length != n2 * n3) {
                this.outdata[n] = new int[n3 * n2];
                dataBlk.setData(this.outdata[n]);
            }
            this.outdata[(n + 1) % 3] = new int[this.outdata[n].length];
            this.outdata[(n + 2) % 3] = new int[this.outdata[n].length];
            if (this.block0 == null || this.block0.getDataType() != 4) {
                this.block0 = new DataBlkFloat();
            }
            if (this.block2 == null || this.block2.getDataType() != 4) {
                this.block2 = new DataBlkFloat();
            }
            if (this.block1 == null || this.block1.getDataType() != 4) {
                this.block1 = new DataBlkFloat();
            }
            this.block2.w = this.block1.w = dataBlk.w;
            this.block0.w = this.block1.w;
            this.block2.h = this.block1.h = dataBlk.h;
            this.block0.h = this.block1.h;
            this.block2.ulx = this.block1.ulx = dataBlk.ulx;
            this.block0.ulx = this.block1.ulx;
            this.block2.uly = this.block1.uly = dataBlk.uly;
            this.block0.uly = this.block1.uly;
            this.block0 = (DataBlkFloat)this.src.getInternCompData(this.block0, 0);
            float[] fArray = (float[])this.block0.getData();
            this.block2 = (DataBlkFloat)this.src.getInternCompData(this.block2, 1);
            float[] fArray2 = (float[])this.block2.getData();
            this.block1 = (DataBlkFloat)this.src.getInternCompData(this.block1, 2);
            float[] fArray3 = (float[])this.block1.getData();
            dataBlk.progressive = this.block0.progressive || this.block1.progressive || this.block2.progressive;
            dataBlk.offset = 0;
            dataBlk.scanw = n2;
            this.dbi.progressive = dataBlk.progressive;
            this.dbi.ulx = dataBlk.ulx;
            this.dbi.uly = dataBlk.uly;
            this.dbi.w = dataBlk.w;
            this.dbi.h = dataBlk.h;
            int n4 = n2 * n3 - 1;
            int n5 = this.block0.offset + (n3 - 1) * this.block0.scanw + n2 - 1;
            int n6 = this.block2.offset + (n3 - 1) * this.block2.scanw + n2 - 1;
            int n7 = this.block1.offset + (n3 - 1) * this.block1.scanw + n2 - 1;
            int n8 = n3 - 1;
            while (n8 >= 0) {
                int n9 = n4 - n2;
                while (n4 > n9) {
                    this.outdata[0][n4] = (int)(fArray[n5] + 1.402f * fArray3[n7] + 0.5f);
                    this.outdata[1][n4] = (int)(fArray[n5] - 0.34413f * fArray2[n6] - 0.71414f * fArray3[n7] + 0.5f);
                    this.outdata[2][n4] = (int)(fArray[n5] + 1.772f * fArray2[n6] + 0.5f);
                    --n4;
                    --n5;
                    --n6;
                    --n7;
                }
                n5 -= this.block0.scanw - n2;
                n6 -= this.block2.scanw - n2;
                n7 -= this.block1.scanw - n2;
                --n8;
            }
            this.outdata[n] = null;
        } else if (n >= 0 && n <= 3) {
            dataBlk.setData(this.outdata[n]);
            dataBlk.progressive = this.dbi.progressive;
            dataBlk.offset = (dataBlk.uly - this.dbi.uly) * this.dbi.w + dataBlk.ulx - this.dbi.ulx;
            dataBlk.scanw = this.dbi.w;
            this.outdata[n] = null;
        } else if (n >= 3) {
            int n10 = dataBlk.w;
            int n11 = dataBlk.h;
            int[] nArray = (int[])dataBlk.getData();
            if (nArray == null) {
                nArray = new int[n11 * n10];
                dataBlk.setData(nArray);
            }
            DataBlkFloat dataBlkFloat = new DataBlkFloat(dataBlk.ulx, dataBlk.uly, n10, n11);
            this.src.getInternCompData(dataBlkFloat, n);
            float[] fArray = (float[])dataBlkFloat.getData();
            int n12 = n10 * n11 - 1;
            int n13 = dataBlkFloat.offset + (n11 - 1) * dataBlkFloat.scanw + n10 - 1;
            int n14 = n11 - 1;
            while (n14 >= 0) {
                int n15 = n12 - n10;
                while (n12 > n15) {
                    nArray[n12] = (int)fArray[n13];
                    --n12;
                    --n13;
                }
                n13 -= dataBlkFloat.scanw - n10;
                --n14;
            }
            dataBlk.progressive = dataBlkFloat.progressive;
            dataBlk.offset = 0;
            dataBlk.scanw = n10;
        } else {
            throw new IllegalArgumentException();
        }
        return dataBlk;
    }

    private DataBlk invRCT(DataBlk dataBlk, int n) {
        if (this.outdata[n] == null || this.dbi.ulx > dataBlk.ulx || this.dbi.uly > dataBlk.uly || this.dbi.ulx + this.dbi.w < dataBlk.ulx + dataBlk.w || this.dbi.uly + this.dbi.h < dataBlk.uly + dataBlk.h) {
            int n2 = dataBlk.w;
            int n3 = dataBlk.h;
            this.outdata[n] = (int[])dataBlk.getData();
            if (this.outdata[n] == null || this.outdata[n].length != n3 * n2) {
                this.outdata[n] = new int[n3 * n2];
                dataBlk.setData(this.outdata[n]);
            }
            this.outdata[(n + 1) % 3] = new int[this.outdata[n].length];
            this.outdata[(n + 2) % 3] = new int[this.outdata[n].length];
            if (this.block0 == null || this.block0.getDataType() != 3) {
                this.block0 = new DataBlkInt();
            }
            if (this.block1 == null || this.block1.getDataType() != 3) {
                this.block1 = new DataBlkInt();
            }
            if (this.block2 == null || this.block2.getDataType() != 3) {
                this.block2 = new DataBlkInt();
            }
            this.block1.w = this.block2.w = dataBlk.w;
            this.block0.w = this.block2.w;
            this.block1.h = this.block2.h = dataBlk.h;
            this.block0.h = this.block2.h;
            this.block1.ulx = this.block2.ulx = dataBlk.ulx;
            this.block0.ulx = this.block2.ulx;
            this.block1.uly = this.block2.uly = dataBlk.uly;
            this.block0.uly = this.block2.uly;
            this.block0 = (DataBlkInt)this.src.getInternCompData(this.block0, 0);
            int[] nArray = (int[])this.block0.getData();
            this.block1 = (DataBlkInt)this.src.getInternCompData(this.block1, 1);
            int[] nArray2 = (int[])this.block1.getData();
            this.block2 = (DataBlkInt)this.src.getInternCompData(this.block2, 2);
            int[] nArray3 = (int[])this.block2.getData();
            dataBlk.progressive = this.block0.progressive || this.block1.progressive || this.block2.progressive;
            dataBlk.offset = 0;
            dataBlk.scanw = n2;
            this.dbi.progressive = dataBlk.progressive;
            this.dbi.ulx = dataBlk.ulx;
            this.dbi.uly = dataBlk.uly;
            this.dbi.w = dataBlk.w;
            this.dbi.h = dataBlk.h;
            int n4 = n2 * n3 - 1;
            int n5 = this.block0.offset + (n3 - 1) * this.block0.scanw + n2 - 1;
            int n6 = this.block1.offset + (n3 - 1) * this.block1.scanw + n2 - 1;
            int n7 = this.block2.offset + (n3 - 1) * this.block2.scanw + n2 - 1;
            int n8 = n3 - 1;
            while (n8 >= 0) {
                int n9 = n4 - n2;
                while (n4 > n9) {
                    this.outdata[1][n4] = nArray[n5] - (nArray2[n6] + nArray3[n7] >> 2);
                    this.outdata[0][n4] = nArray3[n7] + this.outdata[1][n4];
                    this.outdata[2][n4] = nArray2[n6] + this.outdata[1][n4];
                    --n4;
                    --n5;
                    --n6;
                    --n7;
                }
                n5 -= this.block0.scanw - n2;
                n6 -= this.block1.scanw - n2;
                n7 -= this.block2.scanw - n2;
                --n8;
            }
            this.outdata[n] = null;
        } else if (n >= 0 && n <= 3) {
            dataBlk.setData(this.outdata[n]);
            dataBlk.progressive = this.dbi.progressive;
            dataBlk.offset = (dataBlk.uly - this.dbi.uly) * this.dbi.w + dataBlk.ulx - this.dbi.ulx;
            dataBlk.scanw = this.dbi.w;
            this.outdata[n] = null;
        } else {
            if (n >= 3) {
                return this.src.getInternCompData(dataBlk, n);
            }
            throw new IllegalArgumentException();
        }
        return dataBlk;
    }

    public boolean isReversible() {
        switch (this.transfType) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new IllegalArgumentException("Non JPEG 2000 part I component transformation");
    }

    public void nextTile() {
        this.src.nextTile();
        this.tIdx = this.getTileIdx();
        if ((Integer)this.cts.getTileDef(this.tIdx) == 0) {
            this.transfType = 0;
        } else {
            int n = this.src.getNumComps();
            int n2 = 0;
            int n3 = 0;
            while (n3 < n) {
                n2 += this.wfs.isReversible(this.tIdx, n3) ? 1 : 0;
                ++n3;
            }
            if (n2 == 3) {
                this.transfType = 1;
            } else if (n2 == 0) {
                this.transfType = 2;
            } else {
                throw new IllegalArgumentException("Wavelet transformation and component transformation not coherent in tile" + this.tIdx);
            }
        }
    }

    public void setTile(int n, int n2) {
        this.src.setTile(n, n2);
        this.tIdx = this.getTileIdx();
        if ((Integer)this.cts.getTileDef(this.tIdx) == 0) {
            this.transfType = 0;
        } else {
            int n3 = this.src.getNumComps();
            int n4 = 0;
            int n5 = 0;
            while (n5 < n3) {
                n4 += this.wfs.isReversible(this.tIdx, n5) ? 1 : 0;
                ++n5;
            }
            if (n4 == 3) {
                this.transfType = 1;
            } else if (n4 == 0) {
                this.transfType = 2;
            } else {
                throw new IllegalArgumentException("Wavelet transformation and component transformation not coherent in tile" + this.tIdx);
            }
        }
    }

    public String toString() {
        switch (this.transfType) {
            case 1: {
                return "Inverse RCT";
            }
            case 2: {
                return "Inverse ICT";
            }
            case 0: {
                return "No component transformation";
            }
        }
        throw new IllegalArgumentException("Non JPEG 2000 part I component transformation");
    }
}

