/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.image.input;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import jj2000.j2k.JJ2KExceptionHandler;
import jj2000.j2k.image.DataBlk;
import jj2000.j2k.image.DataBlkInt;
import jj2000.j2k.image.input.ImgReader;
import jj2000.j2k.io.EndianType;

public class ImgReaderPGX
extends ImgReader
implements EndianType {
    private int offset;
    private RandomAccessFile in;
    private int bitDepth;
    private boolean isSigned;
    private int packBytes;
    private int byteOrder;
    private byte[] buf;
    private DataBlkInt intBlk;

    public ImgReaderPGX(File file) throws IOException {
        String string;
        if (!file.exists()) {
            throw new IllegalArgumentException("PGX file " + file.getName() + " does not exist");
        }
        this.in = new RandomAccessFile(file, "r");
        try {
            string = this.in.readLine();
        }
        catch (IOException iOException) {
            throw new IOException(String.valueOf(file.getName()) + " is not a PGX file");
        }
        if (string == null) {
            throw new IOException(String.valueOf(file.getName()) + " is an empty file");
        }
        this.offset = string.length() + 1;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        try {
            int n = stringTokenizer.countTokens();
            if (!stringTokenizer.nextToken().equals("PG")) {
                throw new IOException(String.valueOf(file.getName()) + " is not a PGX file");
            }
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("LM")) {
                this.byteOrder = 1;
            } else if (string2.equals("ML")) {
                this.byteOrder = 0;
            } else {
                throw new IOException(String.valueOf(file.getName()) + " is not a PGX file");
            }
            if (n == 6) {
                string2 = stringTokenizer.nextToken();
                if (string2.equals("+")) {
                    this.isSigned = false;
                } else if (string2.equals("-")) {
                    this.isSigned = true;
                } else {
                    throw new IOException(String.valueOf(file.getName()) + " is not a PGX file");
                }
            }
            try {
                this.bitDepth = new Integer(stringTokenizer.nextToken());
                if (this.bitDepth <= 0 || this.bitDepth > 31) {
                    throw new IOException(String.valueOf(file.getName()) + " is not a valid PGX file");
                }
                this.w = new Integer(stringTokenizer.nextToken());
                this.h = new Integer(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                throw new IOException(String.valueOf(file.getName()) + " is not a PGX file");
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IOException(String.valueOf(file.getName()) + " is not a PGX file");
        }
        this.nc = 1;
        this.packBytes = this.bitDepth <= 8 ? 1 : (this.bitDepth <= 16 ? 2 : 4);
    }

    public ImgReaderPGX(String string) throws IOException {
        this(new File(string));
    }

    public void close() throws IOException {
        this.in.close();
        this.in = null;
        this.buf = null;
    }

    public DataBlk getCompData(DataBlk dataBlk, int n) {
        return this.getInternCompData(dataBlk, n);
    }

    public int getFixedPoint(int n) {
        if (n != 0) {
            throw new IllegalArgumentException();
        }
        return 0;
    }

    public DataBlk getInternCompData(DataBlk dataBlk, int n) {
        int[] nArray;
        int n2 = 1 << this.bitDepth - 1;
        if (n != 0) {
            throw new IllegalArgumentException();
        }
        if (dataBlk.getDataType() != 3) {
            if (this.intBlk == null) {
                this.intBlk = new DataBlkInt(dataBlk.ulx, dataBlk.uly, dataBlk.w, dataBlk.h);
            } else {
                this.intBlk.ulx = dataBlk.ulx;
                this.intBlk.uly = dataBlk.uly;
                this.intBlk.w = dataBlk.w;
                this.intBlk.h = dataBlk.h;
            }
            dataBlk = this.intBlk;
        }
        if ((nArray = (int[])dataBlk.getData()) == null || nArray.length < dataBlk.w * dataBlk.h * this.packBytes) {
            nArray = new int[dataBlk.w * dataBlk.h];
            dataBlk.setData(nArray);
        }
        int n3 = 32 - this.bitDepth;
        if (this.buf == null || this.buf.length < this.packBytes * dataBlk.w) {
            this.buf = new byte[this.packBytes * dataBlk.w];
        }
        try {
            switch (this.packBytes) {
                case 1: {
                    int n4 = dataBlk.uly + dataBlk.h;
                    if (this.isSigned) {
                        int n5 = dataBlk.uly;
                        while (n5 < n4) {
                            this.in.seek(this.offset + n5 * this.w + dataBlk.ulx);
                            this.in.read(this.buf, 0, dataBlk.w);
                            int n6 = (n5 - dataBlk.uly) * dataBlk.w + dataBlk.w - 1;
                            int n7 = dataBlk.w - 1;
                            while (n7 >= 0) {
                                nArray[n6] = (this.buf[n7--] & 0xFF) << n3 >> n3;
                                --n6;
                            }
                            ++n5;
                        }
                    } else {
                        int n8 = dataBlk.uly;
                        while (n8 < n4) {
                            this.in.seek(this.offset + n8 * this.w + dataBlk.ulx);
                            this.in.read(this.buf, 0, dataBlk.w);
                            int n9 = (n8 - dataBlk.uly) * dataBlk.w + dataBlk.w - 1;
                            int n10 = dataBlk.w - 1;
                            while (n10 >= 0) {
                                nArray[n9] = ((this.buf[n10--] & 0xFF) << n3 >>> n3) - n2;
                                --n9;
                            }
                            ++n8;
                        }
                    }
                    break;
                }
                case 2: {
                    int n11 = dataBlk.uly + dataBlk.h;
                    if (this.isSigned) {
                        int n12 = dataBlk.uly;
                        while (n12 < n11) {
                            this.in.seek(this.offset + 2 * (n12 * this.w + dataBlk.ulx));
                            this.in.read(this.buf, 0, dataBlk.w << 1);
                            switch (this.byteOrder) {
                                case 1: {
                                    int n13 = (n12 - dataBlk.uly) * dataBlk.w + dataBlk.w - 1;
                                    int n14 = (this.w << 1) - 1;
                                    while (n14 >= 0) {
                                        nArray[n13] = ((this.buf[n14--] & 0xFF) << 8 | this.buf[n14--] & 0xFF) << n3 >> n3;
                                        --n13;
                                    }
                                    break;
                                }
                                case 0: {
                                    int n13 = (n12 - dataBlk.uly) * dataBlk.w + dataBlk.w - 1;
                                    int n14 = (this.w << 1) - 1;
                                    while (n14 >= 0) {
                                        nArray[n13] = (this.buf[n14--] & 0xFF | (this.buf[n14--] & 0xFF) << 8) << n3 >> n3;
                                        --n13;
                                    }
                                    break;
                                }
                                default: {
                                    throw new Error("Internal JJ2000 bug");
                                }
                            }
                            ++n12;
                        }
                    } else {
                        int n15 = dataBlk.uly;
                        while (n15 < n11) {
                            this.in.seek(this.offset + 2 * (n15 * this.w + dataBlk.ulx));
                            this.in.read(this.buf, 0, dataBlk.w << 1);
                            switch (this.byteOrder) {
                                case 1: {
                                    int n16 = (n15 - dataBlk.uly) * dataBlk.w + dataBlk.w - 1;
                                    int n17 = (this.w << 1) - 1;
                                    while (n17 >= 0) {
                                        nArray[n16] = (((this.buf[n17--] & 0xFF) << 8 | this.buf[n17--] & 0xFF) << n3 >>> n3) - n2;
                                        --n16;
                                    }
                                    break;
                                }
                                case 0: {
                                    int n16 = (n15 - dataBlk.uly) * dataBlk.w + dataBlk.w - 1;
                                    int n17 = (this.w << 1) - 1;
                                    while (n17 >= 0) {
                                        nArray[n16] = ((this.buf[n17--] & 0xFF | (this.buf[n17--] & 0xFF) << 8) << n3 >>> n3) - n2;
                                        --n16;
                                    }
                                    break;
                                }
                                default: {
                                    throw new Error("Internal JJ2000 bug");
                                }
                            }
                            ++n15;
                        }
                    }
                    break;
                }
                case 4: {
                    int n18 = dataBlk.uly + dataBlk.h;
                    if (this.isSigned) {
                        int n19 = dataBlk.uly;
                        while (n19 < n18) {
                            this.in.seek(this.offset + 4 * (n19 * this.w + dataBlk.ulx));
                            this.in.read(this.buf, 0, dataBlk.w << 2);
                            switch (this.byteOrder) {
                                case 1: {
                                    int n20 = (n19 - dataBlk.uly) * dataBlk.w + dataBlk.w - 1;
                                    int n21 = (this.w << 2) - 1;
                                    while (n21 >= 0) {
                                        nArray[n20] = ((this.buf[n21--] & 0xFF) << 24 | (this.buf[n21--] & 0xFF) << 16 | (this.buf[n21--] & 0xFF) << 8 | this.buf[n21--] & 0xFF) << n3 >> n3;
                                        --n20;
                                    }
                                    break;
                                }
                                case 0: {
                                    int n20 = (n19 - dataBlk.uly) * dataBlk.w + dataBlk.w - 1;
                                    int n21 = (this.w << 2) - 1;
                                    while (n21 >= 0) {
                                        nArray[n20] = (this.buf[n21--] & 0xFF | (this.buf[n21--] & 0xFF) << 8 | (this.buf[n21--] & 0xFF) << 16 | (this.buf[n21--] & 0xFF) << 24) << n3 >> n3;
                                        --n20;
                                    }
                                    break;
                                }
                                default: {
                                    throw new Error("Internal JJ2000 bug");
                                }
                            }
                            ++n19;
                        }
                    } else {
                        int n22 = dataBlk.uly;
                        while (n22 < n18) {
                            this.in.seek(this.offset + 4 * (n22 * this.w + dataBlk.ulx));
                            this.in.read(this.buf, 0, dataBlk.w << 2);
                            switch (this.byteOrder) {
                                case 1: {
                                    int n23 = (n22 - dataBlk.uly) * dataBlk.w + dataBlk.w - 1;
                                    int n24 = (this.w << 2) - 1;
                                    while (n24 >= 0) {
                                        nArray[n23] = (((this.buf[n24--] & 0xFF) << 24 | (this.buf[n24--] & 0xFF) << 16 | (this.buf[n24--] & 0xFF) << 8 | this.buf[n24--] & 0xFF) << n3 >>> n3) - n2;
                                        --n23;
                                    }
                                    break;
                                }
                                case 0: {
                                    int n23 = (n22 - dataBlk.uly) * dataBlk.w + dataBlk.w - 1;
                                    int n24 = (this.w << 2) - 1;
                                    while (n24 >= 0) {
                                        nArray[n23] = ((this.buf[n24--] & 0xFF | (this.buf[n24--] & 0xFF) << 8 | (this.buf[n24--] & 0xFF) << 16 | (this.buf[n24--] & 0xFF) << 24) << n3 >>> n3) - n2;
                                        --n23;
                                    }
                                    break;
                                }
                                default: {
                                    throw new Error("Internal JJ2000 bug");
                                }
                            }
                            ++n22;
                        }
                    }
                    break;
                }
                default: {
                    throw new IOException("PGX supports only bit-depth between 1 and 31");
                }
            }
        }
        catch (IOException iOException) {
            JJ2KExceptionHandler.handleException(iOException);
        }
        dataBlk.progressive = false;
        dataBlk.offset = 0;
        dataBlk.scanw = dataBlk.w;
        return dataBlk;
    }

    public int getNomRangeBits(int n) {
        if (n != 0) {
            throw new IllegalArgumentException();
        }
        return this.bitDepth;
    }

    public boolean isOrigSigned(int n) {
        if (n != 0) {
            throw new IllegalArgumentException();
        }
        return this.isSigned;
    }

    public String toString() {
        return "ImgReaderPGX: WxH = " + this.w + "x" + this.h + ", Component = 0" + ", Bit-depth = " + this.bitDepth + ", signed = " + this.isSigned + "\nUnderlying RandomAccessIO:\n" + this.in.toString();
    }
}

