/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.image;

import jj2000.j2k.NoNextElementException;
import jj2000.j2k.image.BlkImgDataSrc;
import jj2000.j2k.image.Coord;
import jj2000.j2k.image.DataBlk;
import jj2000.j2k.image.ImgDataAdapter;
import jj2000.j2k.util.FacilityManager;

public class Tiler
extends ImgDataAdapter
implements BlkImgDataSrc {
    private final BlkImgDataSrc src;
    private final int ax;
    private final int ay;
    private final int px;
    private final int py;
    private final int nw;
    private final int nh;
    private final int nht;
    private final int nvt;
    private final int[] bw;
    private final int[] bh;
    private final int[] offX;
    private final int[] offY;
    private final int[] iulx;
    private final int[] iuly;
    private int tx;
    private int ty;
    private int cw;
    private int ch;

    public Tiler(BlkImgDataSrc blkImgDataSrc, int n, int n2, int n3, int n4, int n5, int n6) {
        super(blkImgDataSrc);
        if (blkImgDataSrc.getNumTiles() != 1) {
            throw new IllegalArgumentException("Source is tiled");
        }
        if (blkImgDataSrc.getImgULX() != 0 || blkImgDataSrc.getImgULY() != 0) {
            throw new IllegalArgumentException("Source is \"canvased\"");
        }
        if (n < 0 || n2 < 0 || n3 < 0 || n4 < 0 || n5 < 0 || n6 < 0 || n3 > n || n4 > n2) {
            throw new IllegalArgumentException("Invalid image origin, tiling origin or nominal tile size");
        }
        int n7 = 0;
        while (n7 < blkImgDataSrc.getNumComps()) {
            int n8 = (n + blkImgDataSrc.getImgWidth() + blkImgDataSrc.getCompSubsX(n7) - 1) / blkImgDataSrc.getCompSubsX(n7) - (n + blkImgDataSrc.getCompSubsX(n7) - 1) / blkImgDataSrc.getCompSubsX(n7);
            int n9 = (n2 + blkImgDataSrc.getImgHeight() + blkImgDataSrc.getCompSubsY(n7) - 1) / blkImgDataSrc.getCompSubsY(n7) - (n2 + blkImgDataSrc.getCompSubsY(n7) - 1) / blkImgDataSrc.getCompSubsY(n7);
            if (n8 != blkImgDataSrc.getCompImgWidth(n7) || n9 != blkImgDataSrc.getCompImgHeight(n7)) {
                throw new IllegalArgumentException("Image origin (ax,ay) = (" + n + "," + n2 + ") yields invalid " + "component dimensions");
            }
            ++n7;
        }
        if (n5 == 0) {
            n5 = n + blkImgDataSrc.getImgWidth() - n3;
        }
        if (n6 == 0) {
            n6 = n2 + blkImgDataSrc.getImgHeight() - n4;
        }
        if (n - n3 >= n5 || n2 - n4 >= n6) {
            n3 += (n - n3) / n5 * n5;
            n4 += (n2 - n4) / n6 * n6;
            FacilityManager.getMsgLogger().printmsg(1, "Automatically adjusted tiling origin to equivalent one (" + n3 + "," + n4 + ") so that " + "first tile overlaps the image");
        }
        this.src = blkImgDataSrc;
        this.ax = n;
        this.ay = n2;
        this.px = n3;
        this.py = n4;
        this.nw = n5;
        this.nh = n6;
        this.nht = (n + blkImgDataSrc.getImgWidth() - n3 + n5 - 1) / n5;
        this.nvt = (n2 + blkImgDataSrc.getImgHeight() - n4 + n6 - 1) / n6;
        this.bw = new int[blkImgDataSrc.getNumComps()];
        this.bh = new int[blkImgDataSrc.getNumComps()];
        this.offX = new int[blkImgDataSrc.getNumComps()];
        this.offY = new int[blkImgDataSrc.getNumComps()];
        this.iulx = new int[blkImgDataSrc.getNumComps()];
        this.iuly = new int[blkImgDataSrc.getNumComps()];
        this.setTile(0, 0);
    }

    public final DataBlk getCompData(DataBlk dataBlk, int n) {
        if (dataBlk.ulx < 0 || dataBlk.uly < 0 || dataBlk.ulx + dataBlk.w > this.bw[n] || dataBlk.uly + dataBlk.h > this.bh[n]) {
            throw new IllegalArgumentException("Block is outside the tile");
        }
        dataBlk.ulx += this.iulx[n];
        dataBlk.uly += this.iuly[n];
        dataBlk = this.src.getCompData(dataBlk, n);
        dataBlk.ulx -= this.iulx[n];
        dataBlk.uly -= this.iuly[n];
        return dataBlk;
    }

    public final int getCompHeight(int n) {
        return this.bh[n];
    }

    public final int getCompWidth(int n) {
        return this.bw[n];
    }

    public int getFixedPoint(int n) {
        return this.src.getFixedPoint(n);
    }

    public final int getHeight() {
        return this.ch;
    }

    public final int getImgULX() {
        return this.ax;
    }

    public final int getImgULY() {
        return this.ay;
    }

    public final DataBlk getInternCompData(DataBlk dataBlk, int n) {
        if (dataBlk.ulx < 0 || dataBlk.uly < 0 || dataBlk.ulx + dataBlk.w > this.bw[n] || dataBlk.uly + dataBlk.h > this.bh[n]) {
            throw new IllegalArgumentException("Block is outside the tile");
        }
        dataBlk.ulx += this.iulx[n];
        dataBlk.uly += this.iuly[n];
        dataBlk = this.src.getInternCompData(dataBlk, n);
        dataBlk.ulx -= this.iulx[n];
        dataBlk.uly -= this.iuly[n];
        return dataBlk;
    }

    public final int getNomTileHeight() {
        return this.nh;
    }

    public final int getNomTileWidth() {
        return this.nw;
    }

    public final int getNumTiles() {
        return this.nht * this.nvt;
    }

    public final Coord getNumTiles(Coord coord) {
        if (coord != null) {
            coord.x = this.nht;
            coord.y = this.nvt;
            return coord;
        }
        return new Coord(this.nht, this.nvt);
    }

    public final Coord getTile(Coord coord) {
        if (coord != null) {
            coord.x = this.tx;
            coord.y = this.ty;
            return coord;
        }
        return new Coord(this.tx, this.ty);
    }

    public final int getTileIdx() {
        return this.ty * this.nht + this.tx;
    }

    public final Coord getTileOff(Coord coord, int n) {
        if (coord != null) {
            coord.x = this.offX[n];
            coord.y = this.offY[n];
            return coord;
        }
        return new Coord(this.offX[n], this.offY[n]);
    }

    public final Coord getTilingOrigin(Coord coord) {
        if (coord != null) {
            coord.x = this.px;
            coord.y = this.py;
            return coord;
        }
        return new Coord(this.px, this.py);
    }

    public final int getULX(int n) {
        return this.iulx[n] + (this.ax + this.src.getCompSubsX(n) - 1) / this.src.getCompSubsX(n);
    }

    public final int getULY(int n) {
        return this.iuly[n] + (this.ay + this.src.getCompSubsY(n) - 1) / this.src.getCompSubsY(n);
    }

    public final int getWidth() {
        return this.cw;
    }

    public final void nextTile() {
        if (this.tx == this.nht - 1 && this.ty == this.nvt - 1) {
            throw new NoNextElementException();
        }
        if (this.tx < this.nht - 1) {
            this.setTile(this.tx + 1, this.ty);
        } else {
            this.setTile(0, this.ty + 1);
        }
    }

    public final void setTile(int n, int n2) {
        if (n < 0 || n2 < 0 || n >= this.nht || n2 >= this.nvt) {
            throw new IllegalArgumentException("Tile's indexes out of bounds");
        }
        this.tx = n;
        this.ty = n2;
        int n3 = n != 0 ? this.px + n * this.nw : this.ax;
        int n4 = n2 != 0 ? this.py + n2 * this.nh : this.ay;
        int n5 = n != this.nht - 1 ? this.px + (n + 1) * this.nw : this.ax + this.src.getImgWidth();
        int n6 = n2 != this.nvt - 1 ? this.py + (n2 + 1) * this.nh : this.ay + this.src.getImgHeight();
        this.cw = n5 - n3;
        this.ch = n6 - n4;
        int n7 = this.src.getNumComps() - 1;
        while (n7 >= 0) {
            this.bw[n7] = (n5 + this.src.getCompSubsX(n7) - 1) / this.src.getCompSubsX(n7) - (n3 + this.src.getCompSubsX(n7) - 1) / this.src.getCompSubsX(n7);
            this.bh[n7] = (n6 + this.src.getCompSubsY(n7) - 1) / this.src.getCompSubsY(n7) - (n4 + this.src.getCompSubsY(n7) - 1) / this.src.getCompSubsY(n7);
            this.offX[n7] = (this.px + n * this.nw + this.src.getCompSubsX(n7) - 1) / this.src.getCompSubsX(n7);
            this.offY[n7] = (this.py + n2 * this.nh + this.src.getCompSubsY(n7) - 1) / this.src.getCompSubsY(n7);
            this.iulx[n7] = (n3 + this.src.getCompSubsX(n7) - 1) / this.src.getCompSubsX(n7) - (this.ax + this.src.getCompSubsX(n7) - 1) / this.src.getCompSubsX(n7);
            this.iuly[n7] = (n4 + this.src.getCompSubsY(n7) - 1) / this.src.getCompSubsY(n7) - (this.ay + this.src.getCompSubsY(n7) - 1) / this.src.getCompSubsY(n7);
            --n7;
        }
    }

    public String toString() {
        return "Tiler: source= " + this.src + "\n" + this.getNumTiles() + " tile(s), nominal width= " + this.nw + ", nominal height= " + this.nh;
    }
}

