/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.image;

import jj2000.j2k.NoNextElementException;
import jj2000.j2k.image.BlkImgDataSrc;
import jj2000.j2k.image.Coord;
import jj2000.j2k.image.DataBlk;

public class ImgDataJoiner
implements BlkImgDataSrc {
    private int w;
    private int h;
    private int nc;
    private BlkImgDataSrc[] imageData;
    private int[] compIdx;
    private int[] subsX;
    private int[] subsY;

    public ImgDataJoiner(BlkImgDataSrc[] blkImgDataSrcArray, int[] nArray) {
        this.imageData = blkImgDataSrcArray;
        this.compIdx = nArray;
        if (this.imageData.length != this.compIdx.length) {
            throw new IllegalArgumentException("imD and cIdx must have the same length");
        }
        this.nc = blkImgDataSrcArray.length;
        this.subsX = new int[this.nc];
        this.subsY = new int[this.nc];
        int n = 0;
        while (n < this.nc) {
            if (blkImgDataSrcArray[n].getNumTiles() != 1 || blkImgDataSrcArray[n].getULX(nArray[n]) != 0 || blkImgDataSrcArray[n].getULY(nArray[n]) != 0) {
                throw new IllegalArgumentException("All input components must, not use tiles and must have the origin at the canvas origin");
            }
            ++n;
        }
        int n2 = 0;
        int n3 = 0;
        n = 0;
        while (n < this.nc) {
            if (blkImgDataSrcArray[n].getCompImgWidth(nArray[n]) > n2) {
                n2 = blkImgDataSrcArray[n].getCompImgWidth(nArray[n]);
            }
            if (blkImgDataSrcArray[n].getCompImgHeight(nArray[n]) > n3) {
                n3 = blkImgDataSrcArray[n].getCompImgHeight(nArray[n]);
            }
            ++n;
        }
        this.w = n2;
        this.h = n3;
        n = 0;
        while (n < this.nc) {
            this.subsX[n] = (n2 + blkImgDataSrcArray[n].getCompImgWidth(nArray[n]) - 1) / blkImgDataSrcArray[n].getCompImgWidth(nArray[n]);
            this.subsY[n] = (n3 + blkImgDataSrcArray[n].getCompImgHeight(nArray[n]) - 1) / blkImgDataSrcArray[n].getCompImgHeight(nArray[n]);
            if ((n2 + this.subsX[n] - 1) / this.subsX[n] != blkImgDataSrcArray[n].getCompImgWidth(nArray[n]) || (n3 + this.subsY[n] - 1) / this.subsY[n] != blkImgDataSrcArray[n].getCompImgHeight(nArray[n])) {
                throw new Error("Can not compute component subsampling factors: strange subsampling.");
            }
            ++n;
        }
    }

    public DataBlk getCompData(DataBlk dataBlk, int n) {
        return this.imageData[n].getCompData(dataBlk, this.compIdx[n]);
    }

    public int getCompHeight(int n) {
        return this.imageData[n].getCompHeight(this.compIdx[n]);
    }

    public int getCompImgHeight(int n) {
        return this.imageData[n].getCompImgHeight(this.compIdx[n]);
    }

    public int getCompImgWidth(int n) {
        return this.imageData[n].getCompImgWidth(this.compIdx[n]);
    }

    public int getCompSubsX(int n) {
        return this.subsX[n];
    }

    public int getCompSubsY(int n) {
        return this.subsY[n];
    }

    public int getCompWidth(int n) {
        return this.imageData[n].getCompWidth(this.compIdx[n]);
    }

    public int getFixedPoint(int n) {
        return this.imageData[n].getFixedPoint(this.compIdx[n]);
    }

    public int getHeight() {
        return this.h;
    }

    public int getImgHeight() {
        return this.h;
    }

    public int getImgULX() {
        return 0;
    }

    public int getImgULY() {
        return 0;
    }

    public int getImgWidth() {
        return this.w;
    }

    public DataBlk getInternCompData(DataBlk dataBlk, int n) {
        return this.imageData[n].getInternCompData(dataBlk, this.compIdx[n]);
    }

    public int getNomRangeBits(int n) {
        return this.imageData[n].getNomRangeBits(this.compIdx[n]);
    }

    public int getNumComps() {
        return this.nc;
    }

    public int getNumTiles() {
        return 1;
    }

    public Coord getNumTiles(Coord coord) {
        if (coord != null) {
            coord.x = 1;
            coord.y = 1;
            return coord;
        }
        return new Coord(1, 1);
    }

    public Coord getTile(Coord coord) {
        if (coord != null) {
            coord.x = 0;
            coord.y = 0;
            return coord;
        }
        return new Coord(0, 0);
    }

    public int getTileIdx() {
        return 0;
    }

    public Coord getTileOff(Coord coord, int n) {
        if (coord != null) {
            coord.x = 0;
            coord.y = 0;
            return coord;
        }
        return new Coord(0, 0);
    }

    public int getULX(int n) {
        return 0;
    }

    public int getULY(int n) {
        return 0;
    }

    public int getWidth() {
        return this.w;
    }

    public void nextTile() {
        throw new NoNextElementException();
    }

    public void setTile(int n, int n2) {
        if (n != 0 || n2 != 0) {
            throw new IllegalArgumentException();
        }
    }

    public String toString() {
        String string = "ImgDataJoiner: WxH = " + this.w + "x" + this.h;
        int n = 0;
        while (n < this.nc) {
            string = String.valueOf(string) + "\n- Component " + n + " " + this.imageData[n];
            ++n;
        }
        return string;
    }
}

