/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.fileformat.writer;

import java.io.IOException;
import jj2000.j2k.fileformat.FileFormatBoxes;
import jj2000.j2k.io.BEBufferedRandomAccessFile;

public class FileFormatWriter
implements FileFormatBoxes {
    private BEBufferedRandomAccessFile fi;
    private String filename;
    private int height;
    private int width;
    private int nc;
    private int[] bpc;
    private boolean bpcVaries;
    private int clength;
    private static final int CSB_LENGTH = 15;
    private static final int FTB_LENGTH = 20;
    private static final int IHB_LENGTH = 22;
    private static final int BPC_LENGTH = 8;

    public FileFormatWriter(String string, int n, int n2, int n3, int[] nArray, int n4) {
        this.height = n;
        this.width = n2;
        this.nc = n3;
        this.bpc = nArray;
        this.filename = string;
        this.clength = n4;
        this.bpcVaries = false;
        int n5 = nArray[0];
        int n6 = n3 - 1;
        while (n6 > 0) {
            if (nArray[n6] != n5) {
                this.bpcVaries = true;
            }
            --n6;
        }
    }

    public void writeBitsPerComponentBox() throws IOException {
        this.fi.writeInt(8 + this.nc);
        this.fi.writeInt(1651532643);
        int n = 0;
        while (n < this.nc) {
            this.fi.writeByte(this.bpc[n] - 1);
            ++n;
        }
    }

    public void writeColourSpecificationBox() throws IOException {
        this.fi.writeInt(15);
        this.fi.writeInt(1668246642);
        this.fi.writeByte(1);
        this.fi.writeByte(0);
        this.fi.writeByte(0);
        if (this.nc > 1) {
            this.fi.writeInt(16);
        } else {
            this.fi.writeInt(17);
        }
    }

    public void writeContiguousCodeStreamBox(byte[] byArray) throws IOException {
        this.fi.writeInt(this.clength + 8);
        this.fi.writeInt(1785737827);
        int n = 0;
        while (n < this.clength) {
            this.fi.writeByte(byArray[n]);
            ++n;
        }
    }

    public int writeFileFormat() throws IOException {
        try {
            this.fi = new BEBufferedRandomAccessFile(this.filename, "rw+");
            byte[] byArray = new byte[this.clength];
            this.fi.readFully(byArray, 0, this.clength);
            this.fi.seek(0);
            this.fi.writeInt(12);
            this.fi.writeInt(1783636000);
            this.fi.writeInt(218793738);
            this.writeFileTypeBox();
            this.writeJP2HeaderBox();
            this.writeContiguousCodeStreamBox(byArray);
            this.fi.close();
        }
        catch (Exception exception) {
            throw new Error("Error while writing JP2 file format");
        }
        if (this.bpcVaries) {
            return 85 + this.nc + 8;
        }
        return 85;
    }

    public void writeFileTypeBox() throws IOException {
        this.fi.writeInt(20);
        this.fi.writeInt(1718909296);
        this.fi.writeInt(1785737760);
        this.fi.writeInt(0);
        this.fi.writeInt(1785737760);
    }

    public void writeImageHeaderBox() throws IOException {
        this.fi.writeInt(22);
        this.fi.writeInt(1768449138);
        this.fi.writeInt(this.height);
        this.fi.writeInt(this.width);
        this.fi.writeShort(this.nc);
        if (this.bpcVaries) {
            this.fi.writeByte(255);
        } else {
            this.fi.writeByte(this.bpc[0] - 1);
        }
        this.fi.writeByte(7);
        this.fi.writeByte(1);
        this.fi.writeByte(0);
    }

    public void writeJP2HeaderBox() throws IOException {
        if (this.bpcVaries) {
            this.fi.writeInt(53 + this.nc);
        } else {
            this.fi.writeInt(45);
        }
        this.fi.writeInt(1785737832);
        this.writeImageHeaderBox();
        this.writeColourSpecificationBox();
        if (this.bpcVaries) {
            this.writeBitsPerComponentBox();
        }
    }
}

