/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.entropy.encoder;

import java.util.Stack;
import jj2000.j2k.encoder.EncoderSpecs;
import jj2000.j2k.entropy.StdEntropyCoderOptions;
import jj2000.j2k.entropy.encoder.BitToByteOutput;
import jj2000.j2k.entropy.encoder.ByteOutputBuffer;
import jj2000.j2k.entropy.encoder.CBlkRateDistStats;
import jj2000.j2k.entropy.encoder.EntropyCoder;
import jj2000.j2k.entropy.encoder.MQCoder;
import jj2000.j2k.image.Coord;
import jj2000.j2k.quantization.quantizer.CBlkQuantDataSrcEnc;
import jj2000.j2k.util.ArrayUtil;
import jj2000.j2k.util.FacilityManager;
import jj2000.j2k.util.MathUtil;
import jj2000.j2k.util.ThreadPool;
import jj2000.j2k.wavelet.Subband;
import jj2000.j2k.wavelet.analysis.CBlkWTData;
import jj2000.j2k.wavelet.analysis.SubbandAn;

public class StdEntropyCoder
extends EntropyCoder
implements StdEntropyCoderOptions {
    private static final boolean DO_TIMING = false;
    private long[] time;
    public static final String THREADS_PROP_NAME = "jj2000.j2k.entropy.encoder.StdEntropyCoder.nthreads";
    public static final String DEF_THREADS_NUM = "0";
    public static final int THREADS_PRIORITY_INC = 0;
    private ThreadPool tPool;
    private Stack idleComps;
    private Stack[] completedComps;
    private int[] nBusyComps;
    private boolean[] finishedTileComponent;
    private MQCoder[] mqT;
    private BitToByteOutput[] boutT;
    private ByteOutputBuffer[] outT;
    private EncoderSpecs encSpec;
    private int[][] opts = null;
    private int[][] lenCalc = null;
    private int[][] tType = null;
    private static final int ZC_LUT_BITS = 8;
    private static final int[] ZC_LUT_LH;
    private static final int[] ZC_LUT_HL;
    private static final int[] ZC_LUT_HH;
    private static final int SC_LUT_BITS = 9;
    private static final int[] SC_LUT;
    private static final int SC_LUT_MASK = 15;
    private static final int SC_SPRED_SHIFT = 31;
    private static final int INT_SIGN_BIT = Integer.MIN_VALUE;
    private static final int MR_LUT_BITS = 9;
    private static final int[] MR_LUT;
    private static final int NUM_CTXTS = 19;
    private static final int RLC_CTXT = 1;
    private static final int UNIF_CTXT = 0;
    private static final int[] MQ_INIT;
    private static final int[] SEG_MARKERS;
    private static final int[] SEG_MARK_CTXTS;
    private int[][] stateT;
    private static final int STATE_SEP = 16;
    private static final int STATE_SIG_R1 = 32768;
    private static final int STATE_VISITED_R1 = 16384;
    private static final int STATE_NZ_CTXT_R1 = 8192;
    private static final int STATE_H_L_SIGN_R1 = 4096;
    private static final int STATE_H_R_SIGN_R1 = 2048;
    private static final int STATE_V_U_SIGN_R1 = 1024;
    private static final int STATE_V_D_SIGN_R1 = 512;
    private static final int STATE_PREV_MR_R1 = 256;
    private static final int STATE_H_L_R1 = 128;
    private static final int STATE_H_R_R1 = 64;
    private static final int STATE_V_U_R1 = 32;
    private static final int STATE_V_D_R1 = 16;
    private static final int STATE_D_UL_R1 = 8;
    private static final int STATE_D_UR_R1 = 4;
    private static final int STATE_D_DL_R1 = 2;
    private static final int STATE_D_DR_R1 = 1;
    private static final int STATE_SIG_R2 = Integer.MIN_VALUE;
    private static final int STATE_VISITED_R2 = 0x40000000;
    private static final int STATE_NZ_CTXT_R2 = 0x20000000;
    private static final int STATE_H_L_SIGN_R2 = 0x10000000;
    private static final int STATE_H_R_SIGN_R2 = 0x8000000;
    private static final int STATE_V_U_SIGN_R2 = 0x4000000;
    private static final int STATE_V_D_SIGN_R2 = 0x2000000;
    private static final int STATE_PREV_MR_R2 = 0x1000000;
    private static final int STATE_H_L_R2 = 0x800000;
    private static final int STATE_H_R_R2 = 0x400000;
    private static final int STATE_V_U_R2 = 0x200000;
    private static final int STATE_V_D_R2 = 0x100000;
    private static final int STATE_D_UL_R2 = 524288;
    private static final int STATE_D_UR_R2 = 262144;
    private static final int STATE_D_DL_R2 = 131072;
    private static final int STATE_D_DR_R2 = 65536;
    private static final int SIG_MASK_R1R2 = -2147450880;
    private static final int VSTD_MASK_R1R2 = 0x40004000;
    private static final int RLC_MASK_R1R2 = -536813568;
    private static final int ZC_MASK = 255;
    private static final int SC_SHIFT_R1 = 4;
    private static final int SC_SHIFT_R2 = 20;
    private static final int SC_MASK = 511;
    private static final int MR_MASK = 511;
    private static final int MSE_LKP_BITS = 7;
    private static final int MSE_LKP_FRAC_BITS = 13;
    private static final int[] FS_LOSSY;
    private static final int[] FM_LOSSY;
    private static final int[] FS_LOSSLESS;
    private static final int[] FM_LOSSLESS;
    private double[][] distbufT;
    private int[][] ratebufT;
    private boolean[][] istermbufT;
    private CBlkWTData[] srcblkT;
    private int[][] symbufT;
    private int[][] ctxtbufT;
    private boolean[][] precinctPartition;

    static {
        double d;
        double d2;
        int n;
        ZC_LUT_LH = new int[256];
        ZC_LUT_HL = new int[256];
        ZC_LUT_HH = new int[256];
        SC_LUT = new int[512];
        MR_LUT = new int[512];
        int[] nArray = new int[19];
        nArray[0] = 46;
        nArray[1] = 3;
        nArray[2] = 4;
        MQ_INIT = nArray;
        int[] nArray2 = new int[4];
        nArray2[0] = 1;
        nArray2[2] = 1;
        SEG_MARKERS = nArray2;
        SEG_MARK_CTXTS = new int[4];
        FS_LOSSY = new int[64];
        FM_LOSSY = new int[128];
        FS_LOSSLESS = new int[64];
        FM_LOSSLESS = new int[128];
        StdEntropyCoder.ZC_LUT_LH[0] = 2;
        int n2 = 1;
        while (n2 < 16) {
            StdEntropyCoder.ZC_LUT_LH[n2] = 4;
            ++n2;
        }
        n2 = 0;
        while (n2 < 4) {
            StdEntropyCoder.ZC_LUT_LH[1 << n2] = 3;
            ++n2;
        }
        n2 = 0;
        while (n2 < 16) {
            StdEntropyCoder.ZC_LUT_LH[0x20 | n2] = 5;
            StdEntropyCoder.ZC_LUT_LH[0x10 | n2] = 5;
            StdEntropyCoder.ZC_LUT_LH[0x30 | n2] = 6;
            ++n2;
        }
        StdEntropyCoder.ZC_LUT_LH[128] = 7;
        StdEntropyCoder.ZC_LUT_LH[64] = 7;
        n2 = 1;
        while (n2 < 16) {
            StdEntropyCoder.ZC_LUT_LH[0x80 | n2] = 8;
            StdEntropyCoder.ZC_LUT_LH[0x40 | n2] = 8;
            ++n2;
        }
        n2 = 1;
        while (n2 < 4) {
            n = 0;
            while (n < 16) {
                StdEntropyCoder.ZC_LUT_LH[0x80 | n2 << 4 | n] = 9;
                StdEntropyCoder.ZC_LUT_LH[0x40 | n2 << 4 | n] = 9;
                ++n;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < 64) {
            StdEntropyCoder.ZC_LUT_LH[0xC0 | n2] = 10;
            ++n2;
        }
        StdEntropyCoder.ZC_LUT_HL[0] = 2;
        n2 = 1;
        while (n2 < 16) {
            StdEntropyCoder.ZC_LUT_HL[n2] = 4;
            ++n2;
        }
        n2 = 0;
        while (n2 < 4) {
            StdEntropyCoder.ZC_LUT_HL[1 << n2] = 3;
            ++n2;
        }
        n2 = 0;
        while (n2 < 16) {
            StdEntropyCoder.ZC_LUT_HL[0x80 | n2] = 5;
            StdEntropyCoder.ZC_LUT_HL[0x40 | n2] = 5;
            StdEntropyCoder.ZC_LUT_HL[0xC0 | n2] = 6;
            ++n2;
        }
        StdEntropyCoder.ZC_LUT_HL[32] = 7;
        StdEntropyCoder.ZC_LUT_HL[16] = 7;
        n2 = 1;
        while (n2 < 16) {
            StdEntropyCoder.ZC_LUT_HL[0x20 | n2] = 8;
            StdEntropyCoder.ZC_LUT_HL[0x10 | n2] = 8;
            ++n2;
        }
        n2 = 1;
        while (n2 < 4) {
            n = 0;
            while (n < 16) {
                StdEntropyCoder.ZC_LUT_HL[n2 << 6 | 0x20 | n] = 9;
                StdEntropyCoder.ZC_LUT_HL[n2 << 6 | 0x10 | n] = 9;
                ++n;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < 4) {
            n = 0;
            while (n < 16) {
                StdEntropyCoder.ZC_LUT_HL[n2 << 6 | 0x20 | 0x10 | n] = 10;
                ++n;
            }
            ++n2;
        }
        int[] nArray3 = new int[]{3, 5, 6, 9, 10, 12};
        int[] nArray4 = new int[]{1, 2, 4, 8};
        int[] nArray5 = new int[]{3, 5, 6, 7, 9, 10, 11, 12, 13, 14, 15};
        int[] nArray6 = new int[]{7, 11, 13, 14, 15};
        StdEntropyCoder.ZC_LUT_HH[0] = 2;
        n2 = 0;
        while (n2 < nArray4.length) {
            StdEntropyCoder.ZC_LUT_HH[nArray4[n2] << 4] = 3;
            ++n2;
        }
        n2 = 0;
        while (n2 < nArray5.length) {
            StdEntropyCoder.ZC_LUT_HH[nArray5[n2] << 4] = 4;
            ++n2;
        }
        n2 = 0;
        while (n2 < nArray4.length) {
            StdEntropyCoder.ZC_LUT_HH[nArray4[n2]] = 5;
            ++n2;
        }
        n2 = 0;
        while (n2 < nArray4.length) {
            n = 0;
            while (n < nArray4.length) {
                StdEntropyCoder.ZC_LUT_HH[nArray4[n2] << 4 | nArray4[n]] = 6;
                ++n;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < nArray5.length) {
            n = 0;
            while (n < nArray4.length) {
                StdEntropyCoder.ZC_LUT_HH[nArray5[n2] << 4 | nArray4[n]] = 7;
                ++n;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < nArray3.length) {
            StdEntropyCoder.ZC_LUT_HH[nArray3[n2]] = 8;
            ++n2;
        }
        n = 0;
        while (n < nArray3.length) {
            n2 = 1;
            while (n2 < 16) {
                StdEntropyCoder.ZC_LUT_HH[n2 << 4 | nArray3[n]] = 9;
                ++n2;
            }
            ++n;
        }
        n2 = 0;
        while (n2 < 16) {
            n = 0;
            while (n < nArray6.length) {
                StdEntropyCoder.ZC_LUT_HH[n2 << 4 | nArray6[n]] = 10;
                ++n;
            }
            ++n2;
        }
        int[] nArray7 = new int[36];
        nArray7[18] = 15;
        nArray7[17] = 14;
        nArray7[16] = 13;
        nArray7[10] = 12;
        nArray7[9] = 11;
        nArray7[8] = -2147483636;
        nArray7[2] = -2147483635;
        nArray7[1] = -2147483634;
        nArray7[0] = -2147483633;
        n2 = 0;
        while (n2 < 511) {
            int n3 = n2 & 1;
            int n4 = n2 >> 1 & 1;
            int n5 = n2 >> 2 & 1;
            int n6 = n2 >> 3 & 1;
            int n7 = n2 >> 5 & 1;
            int n8 = n2 >> 6 & 1;
            int n9 = n2 >> 8 & 1;
            int n10 = n2 >> 7 & 1;
            int n11 = n6 * (1 - 2 * n9) + n5 * (1 - 2 * n10);
            n11 = n11 >= -1 ? n11 : -1;
            n11 = n11 <= 1 ? n11 : 1;
            int n12 = n4 * (1 - 2 * n8) + n3 * (1 - 2 * n7);
            n12 = n12 >= -1 ? n12 : -1;
            n12 = n12 <= 1 ? n12 : 1;
            StdEntropyCoder.SC_LUT[n2] = nArray7[n11 + 1 << 3 | n12 + 1];
            ++n2;
        }
        nArray7 = null;
        StdEntropyCoder.MR_LUT[0] = 16;
        n2 = 1;
        while (n2 < 256) {
            StdEntropyCoder.MR_LUT[n2] = 17;
            ++n2;
        }
        while (n2 < 512) {
            StdEntropyCoder.MR_LUT[n2] = 18;
            ++n2;
        }
        n2 = 0;
        while (n2 < 64) {
            d2 = (double)n2 / 64.0 + 1.0;
            d = d2 * d2;
            StdEntropyCoder.FS_LOSSLESS[n2] = (int)Math.floor(d * 8192.0 + 0.5);
            StdEntropyCoder.FS_LOSSY[n2] = (int)Math.floor((d -= (d2 -= 1.5) * d2) * 8192.0 + 0.5);
            ++n2;
        }
        n2 = 0;
        while (n2 < 128) {
            d2 = (double)n2 / 64.0;
            d = (d2 - 1.0) * (d2 - 1.0);
            StdEntropyCoder.FM_LOSSLESS[n2] = (int)Math.floor(d * 8192.0 + 0.5);
            StdEntropyCoder.FM_LOSSY[n2] = (int)Math.floor((d -= (d2 -= n2 < 64 ? 0.5 : 1.5) * d2) * 8192.0 + 0.5);
            ++n2;
        }
    }

    public StdEntropyCoder(CBlkQuantDataSrcEnc cBlkQuantDataSrcEnc, EncoderSpecs encoderSpecs) {
        super(cBlkQuantDataSrcEnc);
        int n;
        int n2;
        int n3;
        this.encSpec = encoderSpecs;
        int n4 = encoderSpecs.cblks.getMaxCBlkWidth();
        int n5 = encoderSpecs.cblks.getMaxCBlkHeight();
        try {
            n3 = Integer.parseInt(System.getProperty(THREADS_PROP_NAME, DEF_THREADS_NUM));
            if (n3 < 0) {
                throw new NumberFormatException();
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Invalid number of threads for entropy coding in property jj2000.j2k.entropy.encoder.StdEntropyCoder.nthreads");
        }
        if (n3 > 0) {
            FacilityManager.getMsgLogger().printmsg(1, "Using multithreaded entropy coder with " + n3 + " compressor threads.");
            n2 = n3;
            this.tPool = new ThreadPool(n3, Thread.currentThread().getPriority(), "StdEntropyCoder");
            this.idleComps = new Stack();
            this.completedComps = new Stack[cBlkQuantDataSrcEnc.getNumComps()];
            this.nBusyComps = new int[cBlkQuantDataSrcEnc.getNumComps()];
            this.finishedTileComponent = new boolean[cBlkQuantDataSrcEnc.getNumComps()];
            n = cBlkQuantDataSrcEnc.getNumComps() - 1;
            while (n >= 0) {
                this.completedComps[n] = new Stack();
                --n;
            }
            n = 0;
            while (n < n3) {
                this.idleComps.push(new Compressor(n));
                ++n;
            }
        } else {
            n2 = 1;
            this.tPool = null;
            this.idleComps = null;
            this.completedComps = null;
            this.nBusyComps = null;
            this.finishedTileComponent = null;
        }
        this.outT = new ByteOutputBuffer[n2];
        this.mqT = new MQCoder[n2];
        this.boutT = new BitToByteOutput[n2];
        this.stateT = new int[n2][(n4 + 2) * ((n5 + 1) / 2 + 2)];
        this.symbufT = new int[n2][n4 * 10];
        this.ctxtbufT = new int[n2][n4 * 10];
        this.distbufT = new double[n2][96];
        this.ratebufT = new int[n2][96];
        this.istermbufT = new boolean[n2][96];
        this.srcblkT = new CBlkWTData[n2];
        n = 0;
        while (n < n2) {
            this.outT[n] = new ByteOutputBuffer();
            this.mqT[n] = new MQCoder(this.outT[n], 19, MQ_INIT);
            ++n;
        }
        this.precinctPartition = new boolean[cBlkQuantDataSrcEnc.getNumComps()][cBlkQuantDataSrcEnc.getNumTiles()];
        SubbandAn subbandAn = null;
        Coord coord = null;
        coord = cBlkQuantDataSrcEnc.getNumTiles(coord);
        this.initTileComp(encoderSpecs.nTiles, encoderSpecs.nComp);
        int n6 = 0;
        while (n6 < cBlkQuantDataSrcEnc.getNumComps()) {
            int n7 = 0;
            while (n7 < coord.y) {
                int n8 = 0;
                while (n8 < coord.x) {
                    this.setTile(n8, n7);
                    subbandAn = this.getSubbandTree(this.tIdx, n6);
                    this.precinctPartition[n6][this.tIdx] = false;
                    this.initCBlkDim(n6, subbandAn);
                    ++n8;
                }
                ++n7;
            }
            ++n6;
        }
        this.setTile(0, 0);
    }

    private static int calcSkipMSBP(CBlkWTData cBlkWTData, int n) {
        int[] nArray = (int[])cBlkWTData.getData();
        int n2 = cBlkWTData.w;
        int n3 = cBlkWTData.h;
        int n4 = 0;
        int n5 = Integer.MAX_VALUE & ~((1 << n) - 1);
        int n6 = n3 - 1;
        int n7 = cBlkWTData.offset;
        while (n6 >= 0) {
            int n8 = n7 + n2;
            while (n7 < n8) {
                int n9 = nArray[n7] & n5;
                if (n9 > n4) {
                    n4 = n9;
                }
                ++n7;
            }
            n7 += cBlkWTData.scanw - n2;
            --n6;
        }
        int n10 = 30;
        while ((1 << n10 & n4) == 0 && --n10 >= n) {
        }
        return 30 - n10;
    }

    private static void checkEndOfPassFF(byte[] byArray, int[] nArray, boolean[] blArray, int n) {
        if (blArray == null) {
            --n;
            while (n >= 0) {
                int n2 = nArray[n] - 1;
                if (n2 >= 0 && byArray[n2] == -1) {
                    int n3 = n;
                    nArray[n3] = nArray[n3] - 1;
                }
                --n;
            }
        } else {
            --n;
            while (n >= 0) {
                int n4;
                if (!blArray[n] && (n4 = nArray[n] - 1) >= 0 && byArray[n4] == -1) {
                    int n5 = n;
                    nArray[n5] = nArray[n5] - 1;
                }
                --n;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private static int cleanuppass(CBlkWTData var0, MQCoder var1_1, boolean var2_2, int var3_3, int[] var4_4, int[] var5_5, int[] var6_6, int[] var7_7, int[] var8_8, int[] var9_9, int var10_10, int var11_11, int var12_12) {
        var18_13 = var0.scanw;
        var19_14 = var0.w + 2;
        var20_15 = var19_14 * 4 / 2 - var0.w;
        var21_16 = var18_13 * 4 - var0.w;
        var24_17 = 1 << var3_3;
        var28_18 = (int[])var0.getData();
        var36_19 = (var0.h + 4 - 1) / 4;
        var29_20 = 0;
        var30_21 = var3_3 - 6;
        var31_22 = var30_21 >= 0 ? 0 : -var30_21;
        var32_23 = var30_21 <= 0 ? 0 : var30_21;
        var35_24 = (var12_12 & 8) != 0;
        var38_25 = -var19_14 - 1;
        var39_26 = -var19_14 + 1;
        var40_27 = var19_14 + 1;
        var41_28 = var19_14 - 1;
        var16_29 = var0.offset;
        var14_30 = var19_14 + 1;
        var34_31 = var36_19 - 1;
        while (var34_31 >= 0) {
            var37_41 = var34_31 != 0 ? 4 : var0.h - (var36_19 - 1) * 4;
            var22_35 = var16_29 + var0.w;
            var17_34 = 0;
            while (var16_29 < var22_35) {
                block41: {
                    block43: {
                        block44: {
                            block45: {
                                block35: {
                                    block42: {
                                        block37: {
                                            block40: {
                                                block39: {
                                                    block38: {
                                                        block36: {
                                                            var13_32 = var14_30;
                                                            var23_36 = var4_4[var13_32];
                                                            if (var23_36 != 0 || var4_4[var13_32 + var19_14] != 0 || var37_41 != 4) break block35;
                                                            var15_33 = var16_29;
                                                            if ((var28_18[var15_33] & var24_17) == 0) break block36;
                                                            var26_38 = 0;
                                                            break block37;
                                                        }
                                                        if ((var28_18[var15_33 += var18_13] & var24_17) == 0) break block38;
                                                        var26_38 = 1;
                                                        break block37;
                                                    }
                                                    if ((var28_18[var15_33 += var18_13] & var24_17) == 0) break block39;
                                                    var26_38 = 2;
                                                    var23_36 = var4_4[var13_32 += var19_14];
                                                    break block37;
                                                }
                                                if ((var28_18[var15_33 += var18_13] & var24_17) != 0) break block40;
                                                var7_7[var17_34] = 0;
                                                var8_8[var17_34++] = 1;
                                                break block41;
                                            }
                                            var26_38 = 3;
                                            var23_36 = var4_4[var13_32 += var19_14];
                                        }
                                        var7_7[var17_34] = 1;
                                        var8_8[var17_34++] = 1;
                                        var7_7[var17_34] = var26_38 >> 1;
                                        var8_8[var17_34++] = 0;
                                        var7_7[var17_34] = var26_38 & 1;
                                        var8_8[var17_34++] = 0;
                                        var33_40 = var28_18[var15_33] >> var32_23 << var31_22;
                                        var29_20 += var5_5[var33_40 & 63];
                                        var25_37 = var28_18[var15_33] >>> 31;
                                        if ((var26_38 & 1) != 0) break block42;
                                        var27_39 = StdEntropyCoder.SC_LUT[var23_36 >>> 4 & 511];
                                        var7_7[var17_34] = var25_37 ^ var27_39 >>> 31;
                                        var8_8[var17_34++] = var27_39 & 15;
                                        if (var26_38 != 0 || !var35_24) {
                                            v0 = var13_32 + var38_25;
                                            var4_4[v0] = var4_4[v0] | 0x20010000;
                                            v1 = var13_32 + var39_26;
                                            var4_4[v1] = var4_4[v1] | 0x20020000;
                                        }
                                        if (var25_37 != 0) {
                                            var23_36 |= 606126080;
                                            if (var26_38 != 0 || !var35_24) {
                                                v2 = var13_32 - var19_14;
                                                var4_4[v2] = var4_4[v2] | 0x22100000;
                                            }
                                            v3 = var13_32 + 1;
                                            var4_4[v3] = var4_4[v3] | 537407616;
                                            v4 = var13_32 - 1;
                                            var4_4[v4] = var4_4[v4] | 537143360;
                                        } else {
                                            var23_36 |= 0x2020C000;
                                            if (var26_38 != 0 || !var35_24) {
                                                v5 = var13_32 - var19_14;
                                                var4_4[v5] = var4_4[v5] | 0x20100000;
                                            }
                                            v6 = var13_32 + 1;
                                            var4_4[v6] = var4_4[v6] | 0x20082080;
                                            v7 = var13_32 - 1;
                                            var4_4[v7] = var4_4[v7] | 0x20042040;
                                        }
                                        if (var26_38 >> 1 == 0) break block35;
                                        break block43;
                                    }
                                    var27_39 = StdEntropyCoder.SC_LUT[var23_36 >>> 20 & 511];
                                    var7_7[var17_34] = var25_37 ^ var27_39 >>> 31;
                                    var8_8[var17_34++] = var27_39 & 15;
                                    v8 = var13_32 + var41_28;
                                    var4_4[v8] = var4_4[v8] | 8196;
                                    v9 = var13_32 + var40_27;
                                    var4_4[v9] = var4_4[v9] | 8200;
                                    if (var25_37 != 0) {
                                        var23_36 |= -2147474928;
                                        v10 = var13_32 + var19_14;
                                        var4_4[v10] = var4_4[v10] | 9248;
                                        v11 = var13_32 + 1;
                                        var4_4[v11] = var4_4[v11] | 813703170;
                                        v12 = var13_32 - 1;
                                        var4_4[v12] = var4_4[v12] | 675291137;
                                    } else {
                                        var23_36 |= -2147475440;
                                        v13 = var13_32 + var19_14;
                                        var4_4[v13] = var4_4[v13] | 8224;
                                        v14 = var13_32 + 1;
                                        var4_4[v14] = var4_4[v14] | 0x20802002;
                                        v15 = var13_32 - 1;
                                        var4_4[v15] = var4_4[v15] | 541073409;
                                    }
                                    var4_4[var13_32] = var23_36;
                                    if (var26_38 >> 1 != 0) break block41;
                                    var23_36 = var4_4[var13_32 += var19_14];
                                    break block43;
                                }
                                if (((var23_36 >> 1 | var23_36) & 0x40004000) == 0x40004000) break block44;
                                var15_33 = var16_29;
                                if ((var23_36 & 49152) == 0) {
                                    var8_8[var17_34] = var6_6[var23_36 & 255];
                                    var7_7[var17_34++] = (var28_18[var15_33] & var24_17) >>> var3_3;
                                    if (var7_7[var17_34++] != 0) {
                                        var25_37 = var28_18[var15_33] >>> 31;
                                        var27_39 = StdEntropyCoder.SC_LUT[var23_36 >>> 4 & 511];
                                        var7_7[var17_34] = var25_37 ^ var27_39 >>> 31;
                                        var8_8[var17_34++] = var27_39 & 15;
                                        if (!var35_24) {
                                            v16 = var13_32 + var38_25;
                                            var4_4[v16] = var4_4[v16] | 0x20010000;
                                            v17 = var13_32 + var39_26;
                                            var4_4[v17] = var4_4[v17] | 0x20020000;
                                        }
                                        if (var25_37 != 0) {
                                            var23_36 |= 606126080;
                                            if (!var35_24) {
                                                v18 = var13_32 - var19_14;
                                                var4_4[v18] = var4_4[v18] | 0x22100000;
                                            }
                                            v19 = var13_32 + 1;
                                            var4_4[v19] = var4_4[v19] | 537407616;
                                            v20 = var13_32 - 1;
                                            var4_4[v20] = var4_4[v20] | 537143360;
                                        } else {
                                            var23_36 |= 0x2020C000;
                                            if (!var35_24) {
                                                v21 = var13_32 - var19_14;
                                                var4_4[v21] = var4_4[v21] | 0x20100000;
                                            }
                                            v22 = var13_32 + 1;
                                            var4_4[v22] = var4_4[v22] | 0x20082080;
                                            v23 = var13_32 - 1;
                                            var4_4[v23] = var4_4[v23] | 0x20042040;
                                        }
                                        var33_40 = var28_18[var15_33] >> var32_23 << var31_22;
                                        var29_20 += var5_5[var33_40 & 63];
                                    }
                                }
                                if (var37_41 >= 2) break block45;
                                var4_4[var13_32] = var23_36 &= -1073758209;
                                break block41;
                            }
                            if ((var23_36 & -1073741824) == 0) {
                                var8_8[var17_34] = var6_6[var23_36 >>> 16 & 255];
                                var7_7[var17_34++] = (var28_18[var15_33 += var18_13] & var24_17) >>> var3_3;
                                if (var7_7[var17_34++] != 0) {
                                    var25_37 = var28_18[var15_33] >>> 31;
                                    var27_39 = StdEntropyCoder.SC_LUT[var23_36 >>> 20 & 511];
                                    var7_7[var17_34] = var25_37 ^ var27_39 >>> 31;
                                    var8_8[var17_34++] = var27_39 & 15;
                                    v24 = var13_32 + var41_28;
                                    var4_4[v24] = var4_4[v24] | 8196;
                                    v25 = var13_32 + var40_27;
                                    var4_4[v25] = var4_4[v25] | 8200;
                                    if (var25_37 != 0) {
                                        var23_36 |= -1073733104;
                                        v26 = var13_32 + var19_14;
                                        var4_4[v26] = var4_4[v26] | 9248;
                                        v27 = var13_32 + 1;
                                        var4_4[v27] = var4_4[v27] | 813703170;
                                        v28 = var13_32 - 1;
                                        var4_4[v28] = var4_4[v28] | 675291137;
                                    } else {
                                        var23_36 |= -1073733616;
                                        v29 = var13_32 + var19_14;
                                        var4_4[v29] = var4_4[v29] | 8224;
                                        v30 = var13_32 + 1;
                                        var4_4[v30] = var4_4[v30] | 0x20802002;
                                        v31 = var13_32 - 1;
                                        var4_4[v31] = var4_4[v31] | 541073409;
                                    }
                                    var33_40 = var28_18[var15_33] >> var32_23 << var31_22;
                                    var29_20 += var5_5[var33_40 & 63];
                                }
                            }
                        }
                        var4_4[var13_32] = var23_36 &= -1073758209;
                        if (var37_41 < 3) break block41;
                        var23_36 = var4_4[var13_32 += var19_14];
                    }
                    if (((var23_36 >> 1 | var23_36) & 0x40004000) == 0x40004000) ** GOTO lbl256
                    var15_33 = var16_29 + (var18_13 << 1);
                    if ((var23_36 & 49152) == 0) {
                        var8_8[var17_34] = var6_6[var23_36 & 255];
                        var7_7[var17_34++] = (var28_18[var15_33] & var24_17) >>> var3_3;
                        if (var7_7[var17_34++] != 0) {
                            var25_37 = var28_18[var15_33] >>> 31;
                            var27_39 = StdEntropyCoder.SC_LUT[var23_36 >>> 4 & 511];
                            var7_7[var17_34] = var25_37 ^ var27_39 >>> 31;
                            var8_8[var17_34++] = var27_39 & 15;
                            v32 = var13_32 + var38_25;
                            var4_4[v32] = var4_4[v32] | 0x20010000;
                            v33 = var13_32 + var39_26;
                            var4_4[v33] = var4_4[v33] | 0x20020000;
                            if (var25_37 != 0) {
                                var23_36 |= 606126080;
                                v34 = var13_32 - var19_14;
                                var4_4[v34] = var4_4[v34] | 0x22100000;
                                v35 = var13_32 + 1;
                                var4_4[v35] = var4_4[v35] | 537407616;
                                v36 = var13_32 - 1;
                                var4_4[v36] = var4_4[v36] | 537143360;
                            } else {
                                var23_36 |= 0x2020C000;
                                v37 = var13_32 - var19_14;
                                var4_4[v37] = var4_4[v37] | 0x20100000;
                                v38 = var13_32 + 1;
                                var4_4[v38] = var4_4[v38] | 0x20082080;
                                v39 = var13_32 - 1;
                                var4_4[v39] = var4_4[v39] | 0x20042040;
                            }
                            var33_40 = var28_18[var15_33] >> var32_23 << var31_22;
                            var29_20 += var5_5[var33_40 & 63];
                        }
                    }
                    if (var37_41 < 4) {
                        var4_4[var13_32] = var23_36 &= -1073758209;
                    } else {
                        if ((var23_36 & -1073741824) == 0) {
                            var8_8[var17_34] = var6_6[var23_36 >>> 16 & 255];
                            var7_7[var17_34++] = (var28_18[var15_33 += var18_13] & var24_17) >>> var3_3;
                            if (var7_7[var17_34++] != 0) {
                                var25_37 = var28_18[var15_33] >>> 31;
                                var27_39 = StdEntropyCoder.SC_LUT[var23_36 >>> 20 & 511];
                                var7_7[var17_34] = var25_37 ^ var27_39 >>> 31;
                                var8_8[var17_34++] = var27_39 & 15;
                                v40 = var13_32 + var41_28;
                                var4_4[v40] = var4_4[v40] | 8196;
                                v41 = var13_32 + var40_27;
                                var4_4[v41] = var4_4[v41] | 8200;
                                if (var25_37 != 0) {
                                    var23_36 |= -1073733104;
                                    v42 = var13_32 + var19_14;
                                    var4_4[v42] = var4_4[v42] | 9248;
                                    v43 = var13_32 + 1;
                                    var4_4[v43] = var4_4[v43] | 813703170;
                                    v44 = var13_32 - 1;
                                    var4_4[v44] = var4_4[v44] | 675291137;
                                } else {
                                    var23_36 |= -1073733616;
                                    v45 = var13_32 + var19_14;
                                    var4_4[v45] = var4_4[v45] | 8224;
                                    v46 = var13_32 + 1;
                                    var4_4[v46] = var4_4[v46] | 0x20802002;
                                    v47 = var13_32 - 1;
                                    var4_4[v47] = var4_4[v47] | 541073409;
                                }
                                var33_40 = var28_18[var15_33] >> var32_23 << var31_22;
                                var29_20 += var5_5[var33_40 & 63];
                            }
                        }
lbl256:
                        // 6 sources

                        var4_4[var13_32] = var23_36 &= -1073758209;
                    }
                }
                ++var16_29;
                ++var14_30;
            }
            if (var17_34 > 0) {
                var1_1.codeSymbols(var7_7, var8_8, var17_34);
            }
            --var34_31;
            var16_29 += var21_16;
            var14_30 += var20_15;
        }
        if ((var12_12 & 32) != 0) {
            var1_1.codeSymbols(StdEntropyCoder.SEG_MARKERS, StdEntropyCoder.SEG_MARK_CTXTS, StdEntropyCoder.SEG_MARKERS.length);
        }
        if ((var12_12 & 2) != 0) {
            var1_1.resetCtxts();
        }
        var9_9[var10_10] = var2_2 != false ? var1_1.terminate() : var1_1.getNumCodedBytes();
        if (var11_11 >= 0) {
            v48 = var10_10;
            var9_9[v48] = var9_9[v48] + var9_9[var11_11];
        }
        if (var2_2) {
            var1_1.finishLengthCalculation(var9_9, var10_10);
        }
        return var29_20;
    }

    private static void compressCodeBlock(int n, CBlkRateDistStats cBlkRateDistStats, CBlkWTData cBlkWTData, MQCoder mQCoder, BitToByteOutput bitToByteOutput, ByteOutputBuffer byteOutputBuffer, int[] nArray, double[] dArray, int[] nArray2, boolean[] blArray, int[] nArray3, int[] nArray4, int n2, boolean bl, int n3, int n4) {
        int[] nArray5;
        if ((n2 & 0x10) != 0 && n4 != 3) {
            throw new IllegalArgumentException("Embedded error-resilient info in MQ termination option specified but incorrect MQ termination policy specified");
        }
        mQCoder.setLenCalcType(n3);
        mQCoder.setTermType(n4);
        int n5 = 30 - cBlkWTData.magbits + 1;
        n5 = n5 < 0 ? 0 : n5;
        ArrayUtil.intArraySet(nArray, 0);
        int n6 = StdEntropyCoder.calcSkipMSBP(cBlkWTData, n5);
        cBlkRateDistStats.m = cBlkWTData.m;
        cBlkRateDistStats.n = cBlkWTData.n;
        cBlkRateDistStats.sb = cBlkWTData.sb;
        cBlkRateDistStats.nROIcoeff = cBlkWTData.nROIcoeff;
        cBlkRateDistStats.skipMSBP = n6;
        cBlkRateDistStats.nROIcp = cBlkRateDistStats.nROIcoeff != 0 ? 3 * (cBlkWTData.nROIbp - n6 - 1) + 1 : 0;
        switch (cBlkWTData.sb.gOrient) {
            case 1: {
                nArray5 = ZC_LUT_HL;
                break;
            }
            case 0: 
            case 2: {
                nArray5 = ZC_LUT_LH;
                break;
            }
            case 3: {
                nArray5 = ZC_LUT_HH;
                break;
            }
            default: {
                throw new Error("JJ2000 internal error");
            }
        }
        int n7 = 30 - n6;
        int[] nArray6 = FS_LOSSY;
        int[] nArray7 = FM_LOSSY;
        double d = Math.pow(2.0, (n7 - n5 << 1) - 13) * (double)cBlkWTData.sb.stepWMSE * (double)cBlkWTData.wmseScaling;
        double d2 = 0.0;
        int n8 = 0;
        int n9 = -1;
        if (n7 >= n5) {
            if (bl && n7 == n5) {
                nArray6 = FM_LOSSLESS;
            }
            blArray[n8] = (n2 & 4) != 0 || n7 == n5 || (n2 & 1) != 0 && 27 - n6 >= n7;
            dArray[n8] = d2 += (double)StdEntropyCoder.cleanuppass(cBlkWTData, mQCoder, blArray[n8], n7, nArray, nArray6, nArray5, nArray3, nArray4, nArray2, n8, n9, n2) * d;
            if (blArray[n8]) {
                n9 = n8;
            }
            ++n8;
            d *= 0.25;
            --n7;
        }
        while (n7 >= n5) {
            if (bl && n7 == n5) {
                nArray6 = FS_LOSSLESS;
                nArray7 = FM_LOSSLESS;
            }
            boolean bl2 = blArray[n8] = (n2 & 4) != 0;
            d2 = (n2 & 1) == 0 || 27 - n6 <= n7 ? (d2 += (double)StdEntropyCoder.sigProgPass(cBlkWTData, mQCoder, blArray[n8], n7, nArray, nArray6, nArray5, nArray3, nArray4, nArray2, n8, n9, n2) * d) : (d2 += (double)StdEntropyCoder.rawSigProgPass(cBlkWTData, bitToByteOutput, blArray[n8], n7, nArray, nArray6, nArray2, n8, n9, n2) * d);
            dArray[n8] = d2;
            if (blArray[n8]) {
                n9 = n8;
            }
            boolean bl3 = blArray[++n8] = (n2 & 4) != 0 || (n2 & 1) != 0 && 27 - n6 > n7;
            d2 = (n2 & 1) == 0 || 27 - n6 <= n7 ? (d2 += (double)StdEntropyCoder.magRefPass(cBlkWTData, mQCoder, blArray[n8], n7, nArray, nArray7, nArray3, nArray4, nArray2, n8, n9, n2) * d) : (d2 += (double)StdEntropyCoder.rawMagRefPass(cBlkWTData, bitToByteOutput, blArray[n8], n7, nArray, nArray7, nArray2, n8, n9, n2) * d);
            dArray[n8] = d2;
            if (blArray[n8]) {
                n9 = n8;
            }
            blArray[++n8] = (n2 & 4) != 0 || n7 == n5 || (n2 & 1) != 0 && 27 - n6 >= n7;
            dArray[n8] = d2 += (double)StdEntropyCoder.cleanuppass(cBlkWTData, mQCoder, blArray[n8], n7, nArray, nArray6, nArray5, nArray3, nArray4, nArray2, n8, n9, n2) * d;
            if (blArray[n8]) {
                n9 = n8;
            }
            ++n8;
            d *= 0.25;
            --n7;
        }
        cBlkRateDistStats.data = new byte[byteOutputBuffer.size()];
        byteOutputBuffer.toByteArray(0, byteOutputBuffer.size(), cBlkRateDistStats.data, 0);
        StdEntropyCoder.checkEndOfPassFF(cBlkRateDistStats.data, nArray2, blArray, n8);
        cBlkRateDistStats.selectConvexHull(nArray2, dArray, (boolean[])((n2 & 5) != 0 ? blArray : null), n8, bl);
        mQCoder.reset();
        if (bitToByteOutput != null) {
            bitToByteOutput.reset();
        }
    }

    public void finalize() throws Throwable {
        super.finalize();
    }

    public int getCBlkHeight(int n, int n2) {
        return this.encSpec.cblks.getCBlkHeight((byte)3, n, n2);
    }

    public int getCBlkWidth(int n, int n2) {
        return this.encSpec.cblks.getCBlkWidth((byte)3, n, n2);
    }

    /*
     * Unable to fully structure code
     */
    public CBlkRateDistStats getNextCodeBlock(int var1_1, CBlkRateDistStats var2_2) {
        var3_3 = 0L;
        if (this.tPool != null) ** GOTO lbl35
        this.srcblkT[0] = this.src.getNextInternCodeBlock(var1_1, this.srcblkT[0]);
        if (this.srcblkT[0] == null) {
            return null;
        }
        if ((this.opts[this.tIdx][var1_1] & 1) != 0 && this.boutT[0] == null) {
            this.boutT[0] = new BitToByteOutput(this.outT[0]);
        }
        if (var2_2 == null) {
            var2_2 = new CBlkRateDistStats();
        }
        StdEntropyCoder.compressCodeBlock(var1_1, var2_2, this.srcblkT[0], this.mqT[0], this.boutT[0], this.outT[0], this.stateT[0], this.distbufT[0], this.ratebufT[0], this.istermbufT[0], this.symbufT[0], this.ctxtbufT[0], this.opts[this.tIdx][var1_1], this.isReversible(this.tIdx, var1_1), this.lenCalc[this.tIdx][var1_1], this.tType[this.tIdx][var1_1]);
        return var2_2;
lbl-1000:
        // 1 sources

        {
            var6_5 = (Compressor)this.idleComps.pop();
            var5_4 = var6_5.getIdx();
            this.srcblkT[var5_4] = this.src.getNextInternCodeBlock(var1_1, this.srcblkT[var5_4]);
            if (this.srcblkT[var5_4] != null) {
                if ((this.opts[this.tIdx][var1_1] & 1) != 0 && this.boutT[var5_4] == null) {
                    this.boutT[var5_4] = new BitToByteOutput(this.outT[var5_4]);
                }
                if (var2_2 == null) {
                    var2_2 = new CBlkRateDistStats();
                }
                var6_5.ccb = var2_2;
                var6_5.c = var1_1;
                var6_5.options = this.opts[this.tIdx][var1_1];
                var6_5.rev = this.isReversible(this.tIdx, var1_1);
                var6_5.lcType = this.lenCalc[this.tIdx][var1_1];
                var6_5.tType = this.tType[this.tIdx][var1_1];
                v0 = var1_1;
                this.nBusyComps[v0] = this.nBusyComps[v0] + 1;
                var2_2 = null;
                this.tPool.runTarget(var6_5, this.completedComps[var1_1]);
                continue;
            }
            this.idleComps.push(var6_5);
            this.finishedTileComponent[var1_1] = true;
lbl35:
            // 3 sources

            ** while (!this.finishedTileComponent[var1_1] && !this.idleComps.empty())
        }
lbl36:
        // 1 sources

        if (this.nBusyComps[var1_1] > 0) {
            var8_6 = this.completedComps[var1_1];
            synchronized (var8_6) {
                if (this.completedComps[var1_1].empty()) {
                    try {
                        this.completedComps[var1_1].wait();
                    }
                    catch (InterruptedException v1) {}
                }
                var6_5 = (Compressor)this.completedComps[var1_1].pop();
                var5_4 = var6_5.getIdx();
                v2 = var1_1;
                this.nBusyComps[v2] = this.nBusyComps[v2] - 1;
                this.idleComps.push(var6_5);
                this.tPool.checkTargetErrors();
                var7_7 = var6_5.ccb;
                var9_8 = null;
                return var7_7;
            }
        }
        this.tPool.checkTargetErrors();
        return null;
    }

    public Coord getNumCodeBlocks(SubbandAn subbandAn, Coord coord) {
        return this.src.getNumCodeBlocks(subbandAn, coord);
    }

    public int getPPX(int n, int n2, int n3) {
        return this.encSpec.pss.getPPX(n, n2, n3);
    }

    public int getPPY(int n, int n2, int n3) {
        return this.encSpec.pss.getPPY(n, n2, n3);
    }

    private void initCBlkDim(int n, Subband subband) {
        int n2 = subband.level - 1;
        int n3 = this.getCBlkWidth(this.tIdx, n);
        int n4 = this.getCBlkHeight(this.tIdx, n);
        if (!subband.isNode) {
            int n5 = this.encSpec.pss.getPPX(this.tIdx, n, subband.resLvl);
            int n6 = this.encSpec.pss.getPPY(this.tIdx, n, subband.resLvl);
            if (n5 != 65535 || n6 != 65535) {
                this.precinctPartition[n][this.tIdx] = true;
                int n7 = MathUtil.log2(n5);
                int n8 = MathUtil.log2(n6);
                int n9 = MathUtil.log2(n3);
                int n10 = MathUtil.log2(n4);
                switch (subband.resLvl) {
                    case 0: {
                        subband.nomCBlkW = n9 < n7 ? 1 << n9 : 1 << n7;
                        subband.nomCBlkH = n10 < n8 ? 1 << n10 : 1 << n8;
                        break;
                    }
                    default: {
                        subband.nomCBlkW = n9 < n7 - 1 ? 1 << n9 : 1 << n7 - 1;
                        subband.nomCBlkH = n10 < n8 - 1 ? 1 << n10 : 1 << n8 - 1;
                        break;
                    }
                }
            } else {
                subband.nomCBlkW = n3;
                subband.nomCBlkH = n4;
            }
        } else {
            this.initCBlkDim(n, subband.getLL());
            this.initCBlkDim(n, subband.getHL());
            this.initCBlkDim(n, subband.getLH());
            this.initCBlkDim(n, subband.getHH());
        }
    }

    public void initTileComp(int n, int n2) {
        this.opts = new int[n][n2];
        this.lenCalc = new int[n][n2];
        this.tType = new int[n][n2];
        int n3 = 0;
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                String string;
                this.opts[n3][n4] = 0;
                if (((String)this.encSpec.bms.getTileCompVal(n3, n4)).equalsIgnoreCase("on")) {
                    int[] nArray = this.opts[n3];
                    int n5 = n4;
                    nArray[n5] = nArray[n5] | 1;
                }
                if (((String)this.encSpec.mqrs.getTileCompVal(n3, n4)).equalsIgnoreCase("on")) {
                    int[] nArray = this.opts[n3];
                    int n6 = n4;
                    nArray[n6] = nArray[n6] | 2;
                }
                if (((String)this.encSpec.rts.getTileCompVal(n3, n4)).equalsIgnoreCase("on")) {
                    int[] nArray = this.opts[n3];
                    int n7 = n4;
                    nArray[n7] = nArray[n7] | 4;
                }
                if (((String)this.encSpec.css.getTileCompVal(n3, n4)).equalsIgnoreCase("on")) {
                    int[] nArray = this.opts[n3];
                    int n8 = n4;
                    nArray[n8] = nArray[n8] | 8;
                }
                if (((String)this.encSpec.sss.getTileCompVal(n3, n4)).equalsIgnoreCase("on")) {
                    int[] nArray = this.opts[n3];
                    int n9 = n4;
                    nArray[n9] = nArray[n9] | 0x20;
                }
                if ((string = (String)this.encSpec.lcs.getTileCompVal(n3, n4)).equals("near_opt")) {
                    this.lenCalc[n3][n4] = 2;
                } else if (string.equals("lazy_good")) {
                    this.lenCalc[n3][n4] = 1;
                } else if (string.equals("lazy")) {
                    this.lenCalc[n3][n4] = 0;
                } else {
                    throw new IllegalArgumentException("Unrecognized or unsupported MQ length calculation.");
                }
                String string2 = (String)this.encSpec.tts.getTileCompVal(n3, n4);
                if (string2.equalsIgnoreCase("easy")) {
                    this.tType[n3][n4] = 2;
                } else if (string2.equalsIgnoreCase("full")) {
                    this.tType[n3][n4] = 0;
                } else if (string2.equalsIgnoreCase("near_opt")) {
                    this.tType[n3][n4] = 1;
                } else if (string2.equalsIgnoreCase("predict")) {
                    this.tType[n3][n4] = 3;
                    int[] nArray = this.opts[n3];
                    int n10 = n4;
                    nArray[n10] = nArray[n10] | 0x10;
                    if ((this.opts[n3][n4] & 5) == 0) {
                        FacilityManager.getMsgLogger().printmsg(1, "Using error resilient MQ termination, but terminating only at the end of code-blocks. The error protection offered by this option will be very weak. Specify the 'Creg_term' and/or 'Cbypass' option for increased error resilience.");
                    }
                } else {
                    throw new IllegalArgumentException("Unrecognized or unsupported MQ coder termination.");
                }
                ++n4;
            }
            ++n3;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static int magRefPass(CBlkWTData var0, MQCoder var1_1, boolean var2_2, int var3_3, int[] var4_4, int[] var5_5, int[] var6_6, int[] var7_7, int[] var8_8, int var9_9, int var10_10, int var11_11) {
        var17_12 = var0.scanw;
        var18_13 = var0.w + 2;
        var19_14 = var18_13 * 4 / 2 - var0.w;
        var20_15 = var17_12 * 4 - var0.w;
        var23_16 = 1 << var3_3;
        var24_17 = (int[])var0.getData();
        var31_18 = (var0.h + 4 - 1) / 4;
        var25_19 = 0;
        var26_20 = var3_3 - 6;
        var27_21 = var26_20 >= 0 ? 0 : -var26_20;
        var28_22 = var26_20 <= 0 ? 0 : var26_20;
        var15_23 = var0.offset;
        var13_24 = var18_13 + 1;
        var30_25 = var31_18 - 1;
        while (var30_25 >= 0) {
            var32_32 = var30_25 != 0 ? 4 : var0.h - (var31_18 - 1) * 4;
            var21_29 = var15_23 + var0.w;
            var16_28 = 0;
            while (var15_23 < var21_29) {
                var12_26 = var13_24;
                var22_30 = var4_4[var12_26];
                if ((var22_30 >>> 1 & ~var22_30 & 0x40004000) == 0) ** GOTO lbl40
                var14_27 = var15_23;
                if ((var22_30 & 49152) == 32768) {
                    var6_6[var16_28] = (var24_17[var14_27] & var23_16) >>> var3_3;
                    var7_7[var16_28++] = StdEntropyCoder.MR_LUT[var22_30 & 511];
                    var22_30 |= 256;
                    var29_31 = var24_17[var14_27] >> var28_22 << var27_21;
                    var25_19 += var5_5[var29_31 & 127];
                }
                if (var32_32 < 2) {
                    var4_4[var12_26] = var22_30;
                } else {
                    if ((var22_30 & -1073741824) == -2147483648) {
                        var6_6[var16_28] = (var24_17[var14_27 += var17_12] & var23_16) >>> var3_3;
                        var7_7[var16_28++] = StdEntropyCoder.MR_LUT[var22_30 >>> 16 & 511];
                        var22_30 |= 0x1000000;
                        var29_31 = var24_17[var14_27] >> var28_22 << var27_21;
                        var25_19 += var5_5[var29_31 & 127];
                    }
                    var4_4[var12_26] = var22_30;
lbl40:
                    // 2 sources

                    if (var32_32 >= 3 && ((var22_30 = var4_4[var12_26 += var18_13]) >>> 1 & ~var22_30 & 0x40004000) != 0) {
                        var14_27 = var15_23 + (var17_12 << 1);
                        if ((var22_30 & 49152) == 32768) {
                            var6_6[var16_28] = (var24_17[var14_27] & var23_16) >>> var3_3;
                            var7_7[var16_28++] = StdEntropyCoder.MR_LUT[var22_30 & 511];
                            var22_30 |= 256;
                            var29_31 = var24_17[var14_27] >> var28_22 << var27_21;
                            var25_19 += var5_5[var29_31 & 127];
                        }
                        if (var32_32 < 4) {
                            var4_4[var12_26] = var22_30;
                        } else {
                            if ((var4_4[var12_26] & -1073741824) == -2147483648) {
                                var6_6[var16_28] = (var24_17[var14_27 += var17_12] & var23_16) >>> var3_3;
                                var7_7[var16_28++] = StdEntropyCoder.MR_LUT[var22_30 >>> 16 & 511];
                                var22_30 |= 0x1000000;
                                var29_31 = var24_17[var14_27] >> var28_22 << var27_21;
                                var25_19 += var5_5[var29_31 & 127];
                            }
                            var4_4[var12_26] = var22_30;
                        }
                    }
                }
                ++var15_23;
                ++var13_24;
            }
            if (var16_28 > 0) {
                var1_1.codeSymbols(var6_6, var7_7, var16_28);
            }
            --var30_25;
            var15_23 += var20_15;
            var13_24 += var19_14;
        }
        if ((var11_11 & 2) != 0) {
            var1_1.resetCtxts();
        }
        var8_8[var9_9] = var2_2 != false ? var1_1.terminate() : var1_1.getNumCodedBytes();
        if (var10_10 >= 0) {
            v0 = var9_9;
            var8_8[v0] = var8_8[v0] + var8_8[var10_10];
        }
        if (var2_2) {
            var1_1.finishLengthCalculation(var8_8, var9_9);
        }
        return var25_19;
    }

    public void nextTile() {
        if (this.finishedTileComponent != null) {
            int n = this.src.getNumComps() - 1;
            while (n >= 0) {
                this.finishedTileComponent[n] = false;
                --n;
            }
        }
        super.nextTile();
    }

    public boolean precinctPartitionUsed(int n, int n2) {
        return this.precinctPartition[n][n2];
    }

    private static int rawMagRefPass(CBlkWTData cBlkWTData, BitToByteOutput bitToByteOutput, boolean bl, int n, int[] nArray, int[] nArray2, int[] nArray3, int n2, int n3, int n4) {
        int n5 = cBlkWTData.scanw;
        int n6 = cBlkWTData.w + 2;
        int n7 = n6 * 4 / 2 - cBlkWTData.w;
        int n8 = n5 * 4 - cBlkWTData.w;
        int n9 = 1 << n;
        int[] nArray4 = (int[])cBlkWTData.getData();
        int n10 = (cBlkWTData.h + 4 - 1) / 4;
        int n11 = 0;
        int n12 = n - 6;
        int n13 = n12 >= 0 ? 0 : -n12;
        int n14 = n12 <= 0 ? 0 : n12;
        int n15 = cBlkWTData.offset;
        int n16 = n6 + 1;
        int n17 = n10 - 1;
        while (n17 >= 0) {
            int n18 = n17 != 0 ? 4 : cBlkWTData.h - (n10 - 1) * 4;
            int n19 = n15 + cBlkWTData.w;
            while (n15 < n19) {
                block13: {
                    int n20;
                    int n21;
                    int n22;
                    int n23;
                    block12: {
                        n23 = n16;
                        n22 = nArray[n23];
                        if ((n22 >>> 1 & ~n22 & 0x40004000) == 0) break block12;
                        n21 = n15;
                        if ((n22 & 0xC000) == 32768) {
                            bitToByteOutput.writeBit((nArray4[n21] & n9) >>> n);
                            n20 = nArray4[n21] >> n14 << n13;
                            n11 += nArray2[n20 & 0x7F];
                        }
                        if (n18 < 2) break block13;
                        if ((n22 & 0xC0000000) == Integer.MIN_VALUE) {
                            bitToByteOutput.writeBit((nArray4[n21 += n5] & n9) >>> n);
                            n20 = nArray4[n21] >> n14 << n13;
                            n11 += nArray2[n20 & 0x7F];
                        }
                    }
                    if (n18 >= 3 && ((n22 = nArray[n23 += n6]) >>> 1 & ~n22 & 0x40004000) != 0) {
                        n21 = n15 + (n5 << 1);
                        if ((n22 & 0xC000) == 32768) {
                            bitToByteOutput.writeBit((nArray4[n21] & n9) >>> n);
                            n20 = nArray4[n21] >> n14 << n13;
                            n11 += nArray2[n20 & 0x7F];
                        }
                        if (n18 >= 4 && (nArray[n23] & 0xC0000000) == Integer.MIN_VALUE) {
                            bitToByteOutput.writeBit((nArray4[n21 += n5] & n9) >>> n);
                            n20 = nArray4[n21] >> n14 << n13;
                            n11 += nArray2[n20 & 0x7F];
                        }
                    }
                }
                ++n15;
                ++n16;
            }
            --n17;
            n15 += n8;
            n16 += n7;
        }
        nArray3[n2] = bitToByteOutput.length();
        if (bl) {
            bitToByteOutput.terminate();
        }
        if (n3 >= 0) {
            int n24 = n2;
            nArray3[n24] = nArray3[n24] + nArray3[n3];
        }
        return n11;
    }

    /*
     * Unable to fully structure code
     */
    private static int rawSigProgPass(CBlkWTData var0, BitToByteOutput var1_1, boolean var2_2, int var3_3, int[] var4_4, int[] var5_5, int[] var6_6, int var7_7, int var8_8, int var9_9) {
        var14_10 = var0.scanw;
        var15_11 = var0.w + 2;
        var16_12 = var15_11 * 4 / 2 - var0.w;
        var17_13 = var14_10 * 4 - var0.w;
        var20_14 = 1 << var3_3;
        var22_15 = (int[])var0.getData();
        var30_16 = (var0.h + 4 - 1) / 4;
        var23_17 = 0;
        var24_18 = var3_3 - 6;
        var25_19 = var24_18 >= 0 ? 0 : -var24_18;
        var26_20 = var24_18 <= 0 ? 0 : var24_18;
        var29_21 = (var9_9 & 8) != 0;
        var32_22 = -var15_11 - 1;
        var33_23 = -var15_11 + 1;
        var34_24 = var15_11 + 1;
        var35_25 = var15_11 - 1;
        var13_26 = var0.offset;
        var11_27 = var15_11 + 1;
        var28_28 = var30_16 - 1;
        while (var28_28 >= 0) {
            var31_35 = var28_28 != 0 ? 4 : var0.h - (var30_16 - 1) * 4;
            var18_31 = var13_26 + var0.w;
            while (var13_26 < var18_31) {
                var10_29 = var11_27;
                var19_32 = var4_4[var10_29];
                if ((~var19_32 & var19_32 << 2 & -2147450880) == 0) ** GOTO lbl95
                var12_30 = var13_26;
                if ((var19_32 & 40960) == 8192) {
                    var21_33 = (var22_15[var12_30] & var20_14) >>> var3_3;
                    var1_1.writeBit(var21_33);
                    if (var21_33 != 0) {
                        var21_33 = var22_15[var12_30] >>> 31;
                        var1_1.writeBit(var21_33);
                        if (!var29_21) {
                            v0 = var10_29 + var32_22;
                            var4_4[v0] = var4_4[v0] | 0x20010000;
                            v1 = var10_29 + var33_23;
                            var4_4[v1] = var4_4[v1] | 0x20020000;
                        }
                        if (var21_33 != 0) {
                            var19_32 |= 606126080;
                            if (!var29_21) {
                                v2 = var10_29 - var15_11;
                                var4_4[v2] = var4_4[v2] | 0x22100000;
                            }
                            v3 = var10_29 + 1;
                            var4_4[v3] = var4_4[v3] | 537407616;
                            v4 = var10_29 - 1;
                            var4_4[v4] = var4_4[v4] | 537143360;
                        } else {
                            var19_32 |= 0x2020C000;
                            if (!var29_21) {
                                v5 = var10_29 - var15_11;
                                var4_4[v5] = var4_4[v5] | 0x20100000;
                            }
                            v6 = var10_29 + 1;
                            var4_4[v6] = var4_4[v6] | 0x20082080;
                            v7 = var10_29 - 1;
                            var4_4[v7] = var4_4[v7] | 0x20042040;
                        }
                        var27_34 = var22_15[var12_30] >> var26_20 << var25_19;
                        var23_17 += var5_5[var27_34 & 63];
                    } else {
                        var19_32 |= 16384;
                    }
                }
                if (var31_35 < 2) {
                    var4_4[var10_29] = var19_32;
                } else {
                    if ((var19_32 & -1610612736) == 0x20000000) {
                        var21_33 = (var22_15[var12_30 += var14_10] & var20_14) >>> var3_3;
                        var1_1.writeBit(var21_33);
                        if (var21_33 != 0) {
                            var21_33 = var22_15[var12_30] >>> 31;
                            var1_1.writeBit(var21_33);
                            v8 = var10_29 + var35_25;
                            var4_4[v8] = var4_4[v8] | 8196;
                            v9 = var10_29 + var34_24;
                            var4_4[v9] = var4_4[v9] | 8200;
                            if (var21_33 != 0) {
                                var19_32 |= -1073733104;
                                v10 = var10_29 + var15_11;
                                var4_4[v10] = var4_4[v10] | 9248;
                                v11 = var10_29 + 1;
                                var4_4[v11] = var4_4[v11] | 813703170;
                                v12 = var10_29 - 1;
                                var4_4[v12] = var4_4[v12] | 675291137;
                            } else {
                                var19_32 |= -1073733616;
                                v13 = var10_29 + var15_11;
                                var4_4[v13] = var4_4[v13] | 8224;
                                v14 = var10_29 + 1;
                                var4_4[v14] = var4_4[v14] | 0x20802002;
                                v15 = var10_29 - 1;
                                var4_4[v15] = var4_4[v15] | 541073409;
                            }
                            var27_34 = var22_15[var12_30] >> var26_20 << var25_19;
                            var23_17 += var5_5[var27_34 & 63];
                        } else {
                            var19_32 |= 0x40000000;
                        }
                    }
                    var4_4[var10_29] = var19_32;
lbl95:
                    // 2 sources

                    if (var31_35 >= 3 && (~(var19_32 = var4_4[var10_29 += var15_11]) & var19_32 << 2 & -2147450880) != 0) {
                        var12_30 = var13_26 + (var14_10 << 1);
                        if ((var19_32 & 40960) == 8192) {
                            var21_33 = (var22_15[var12_30] & var20_14) >>> var3_3;
                            var1_1.writeBit(var21_33);
                            if (var21_33 != 0) {
                                var21_33 = var22_15[var12_30] >>> 31;
                                var1_1.writeBit(var21_33);
                                v16 = var10_29 + var32_22;
                                var4_4[v16] = var4_4[v16] | 0x20010000;
                                v17 = var10_29 + var33_23;
                                var4_4[v17] = var4_4[v17] | 0x20020000;
                                if (var21_33 != 0) {
                                    var19_32 |= 606126080;
                                    v18 = var10_29 - var15_11;
                                    var4_4[v18] = var4_4[v18] | 0x22100000;
                                    v19 = var10_29 + 1;
                                    var4_4[v19] = var4_4[v19] | 537407616;
                                    v20 = var10_29 - 1;
                                    var4_4[v20] = var4_4[v20] | 537143360;
                                } else {
                                    var19_32 |= 0x2020C000;
                                    v21 = var10_29 - var15_11;
                                    var4_4[v21] = var4_4[v21] | 0x20100000;
                                    v22 = var10_29 + 1;
                                    var4_4[v22] = var4_4[v22] | 0x20082080;
                                    v23 = var10_29 - 1;
                                    var4_4[v23] = var4_4[v23] | 0x20042040;
                                }
                                var27_34 = var22_15[var12_30] >> var26_20 << var25_19;
                                var23_17 += var5_5[var27_34 & 63];
                            } else {
                                var19_32 |= 16384;
                            }
                        }
                        if (var31_35 < 4) {
                            var4_4[var10_29] = var19_32;
                        } else {
                            if ((var19_32 & -1610612736) == 0x20000000) {
                                var21_33 = (var22_15[var12_30 += var14_10] & var20_14) >>> var3_3;
                                var1_1.writeBit(var21_33);
                                if (var21_33 != 0) {
                                    var21_33 = var22_15[var12_30] >>> 31;
                                    var1_1.writeBit(var21_33);
                                    v24 = var10_29 + var35_25;
                                    var4_4[v24] = var4_4[v24] | 8196;
                                    v25 = var10_29 + var34_24;
                                    var4_4[v25] = var4_4[v25] | 8200;
                                    if (var21_33 != 0) {
                                        var19_32 |= -1073733104;
                                        v26 = var10_29 + var15_11;
                                        var4_4[v26] = var4_4[v26] | 9248;
                                        v27 = var10_29 + 1;
                                        var4_4[v27] = var4_4[v27] | 813703170;
                                        v28 = var10_29 - 1;
                                        var4_4[v28] = var4_4[v28] | 675291137;
                                    } else {
                                        var19_32 |= -1073733616;
                                        v29 = var10_29 + var15_11;
                                        var4_4[v29] = var4_4[v29] | 8224;
                                        v30 = var10_29 + 1;
                                        var4_4[v30] = var4_4[v30] | 0x20802002;
                                        v31 = var10_29 - 1;
                                        var4_4[v31] = var4_4[v31] | 541073409;
                                    }
                                    var27_34 = var22_15[var12_30] >> var26_20 << var25_19;
                                    var23_17 += var5_5[var27_34 & 63];
                                } else {
                                    var19_32 |= 0x40000000;
                                }
                            }
                            var4_4[var10_29] = var19_32;
                        }
                    }
                }
                ++var13_26;
                ++var11_27;
            }
            --var28_28;
            var13_26 += var17_13;
            var11_27 += var16_12;
        }
        var6_6[var7_7] = var1_1.length();
        if (var2_2) {
            var1_1.terminate();
        }
        if (var8_8 >= 0) {
            v32 = var7_7;
            var6_6[v32] = var6_6[v32] + var6_6[var8_8];
        }
        return var23_17;
    }

    public void setTile(int n, int n2) {
        if (this.finishedTileComponent != null) {
            int n3 = this.src.getNumComps() - 1;
            while (n3 >= 0) {
                this.finishedTileComponent[n3] = false;
                --n3;
            }
        }
        super.setTile(n, n2);
    }

    /*
     * Unable to fully structure code
     */
    private static int sigProgPass(CBlkWTData var0, MQCoder var1_1, boolean var2_2, int var3_3, int[] var4_4, int[] var5_5, int[] var6_6, int[] var7_7, int[] var8_8, int[] var9_9, int var10_10, int var11_11, int var12_12) {
        var18_13 = var0.scanw;
        var19_14 = var0.w + 2;
        var20_15 = var19_14 * 4 / 2 - var0.w;
        var21_16 = var18_13 * 4 - var0.w;
        var24_17 = 1 << var3_3;
        var27_18 = (int[])var0.getData();
        var35_19 = (var0.h + 4 - 1) / 4;
        var28_20 = 0;
        var29_21 = var3_3 - 6;
        var30_22 = var29_21 >= 0 ? 0 : -var29_21;
        var31_23 = var29_21 <= 0 ? 0 : var29_21;
        var34_24 = (var12_12 & 8) != 0;
        var37_25 = -var19_14 - 1;
        var38_26 = -var19_14 + 1;
        var39_27 = var19_14 + 1;
        var40_28 = var19_14 - 1;
        var16_29 = var0.offset;
        var14_30 = var19_14 + 1;
        var33_31 = var35_19 - 1;
        while (var33_31 >= 0) {
            var36_40 = var33_31 != 0 ? 4 : var0.h - (var35_19 - 1) * 4;
            var22_35 = var16_29 + var0.w;
            var17_34 = 0;
            while (var16_29 < var22_35) {
                var13_32 = var14_30;
                var23_36 = var4_4[var13_32];
                if ((~var23_36 & var23_36 << 2 & -2147450880) == 0) ** GOTO lbl100
                var15_33 = var16_29;
                if ((var23_36 & 40960) == 8192) {
                    var8_8[var17_34] = var6_6[var23_36 & 255];
                    var7_7[var17_34++] = (var27_18[var15_33] & var24_17) >>> var3_3;
                    if (var7_7[var17_34++] != 0) {
                        var25_37 = var27_18[var15_33] >>> 31;
                        var26_38 = StdEntropyCoder.SC_LUT[var23_36 >>> 4 & 511];
                        var7_7[var17_34] = var25_37 ^ var26_38 >>> 31;
                        var8_8[var17_34++] = var26_38 & 15;
                        if (!var34_24) {
                            v0 = var13_32 + var37_25;
                            var4_4[v0] = var4_4[v0] | 0x20010000;
                            v1 = var13_32 + var38_26;
                            var4_4[v1] = var4_4[v1] | 0x20020000;
                        }
                        if (var25_37 != 0) {
                            var23_36 |= 606126080;
                            if (!var34_24) {
                                v2 = var13_32 - var19_14;
                                var4_4[v2] = var4_4[v2] | 0x22100000;
                            }
                            v3 = var13_32 + 1;
                            var4_4[v3] = var4_4[v3] | 537407616;
                            v4 = var13_32 - 1;
                            var4_4[v4] = var4_4[v4] | 537143360;
                        } else {
                            var23_36 |= 0x2020C000;
                            if (!var34_24) {
                                v5 = var13_32 - var19_14;
                                var4_4[v5] = var4_4[v5] | 0x20100000;
                            }
                            v6 = var13_32 + 1;
                            var4_4[v6] = var4_4[v6] | 0x20082080;
                            v7 = var13_32 - 1;
                            var4_4[v7] = var4_4[v7] | 0x20042040;
                        }
                        var32_39 = var27_18[var15_33] >> var31_23 << var30_22;
                        var28_20 += var5_5[var32_39 & 63];
                    } else {
                        var23_36 |= 16384;
                    }
                }
                if (var36_40 < 2) {
                    var4_4[var13_32] = var23_36;
                } else {
                    if ((var23_36 & -1610612736) == 0x20000000) {
                        var8_8[var17_34] = var6_6[var23_36 >>> 16 & 255];
                        var7_7[var17_34++] = (var27_18[var15_33 += var18_13] & var24_17) >>> var3_3;
                        if (var7_7[var17_34++] != 0) {
                            var25_37 = var27_18[var15_33] >>> 31;
                            var26_38 = StdEntropyCoder.SC_LUT[var23_36 >>> 20 & 511];
                            var7_7[var17_34] = var25_37 ^ var26_38 >>> 31;
                            var8_8[var17_34++] = var26_38 & 15;
                            v8 = var13_32 + var40_28;
                            var4_4[v8] = var4_4[v8] | 8196;
                            v9 = var13_32 + var39_27;
                            var4_4[v9] = var4_4[v9] | 8200;
                            if (var25_37 != 0) {
                                var23_36 |= -1073733104;
                                v10 = var13_32 + var19_14;
                                var4_4[v10] = var4_4[v10] | 9248;
                                v11 = var13_32 + 1;
                                var4_4[v11] = var4_4[v11] | 813703170;
                                v12 = var13_32 - 1;
                                var4_4[v12] = var4_4[v12] | 675291137;
                            } else {
                                var23_36 |= -1073733616;
                                v13 = var13_32 + var19_14;
                                var4_4[v13] = var4_4[v13] | 8224;
                                v14 = var13_32 + 1;
                                var4_4[v14] = var4_4[v14] | 0x20802002;
                                v15 = var13_32 - 1;
                                var4_4[v15] = var4_4[v15] | 541073409;
                            }
                            var32_39 = var27_18[var15_33] >> var31_23 << var30_22;
                            var28_20 += var5_5[var32_39 & 63];
                        } else {
                            var23_36 |= 0x40000000;
                        }
                    }
                    var4_4[var13_32] = var23_36;
lbl100:
                    // 2 sources

                    if (var36_40 >= 3 && (~(var23_36 = var4_4[var13_32 += var19_14]) & var23_36 << 2 & -2147450880) != 0) {
                        var15_33 = var16_29 + (var18_13 << 1);
                        if ((var23_36 & 40960) == 8192) {
                            var8_8[var17_34] = var6_6[var23_36 & 255];
                            var7_7[var17_34++] = (var27_18[var15_33] & var24_17) >>> var3_3;
                            if (var7_7[var17_34++] != 0) {
                                var25_37 = var27_18[var15_33] >>> 31;
                                var26_38 = StdEntropyCoder.SC_LUT[var23_36 >>> 4 & 511];
                                var7_7[var17_34] = var25_37 ^ var26_38 >>> 31;
                                var8_8[var17_34++] = var26_38 & 15;
                                v16 = var13_32 + var37_25;
                                var4_4[v16] = var4_4[v16] | 0x20010000;
                                v17 = var13_32 + var38_26;
                                var4_4[v17] = var4_4[v17] | 0x20020000;
                                if (var25_37 != 0) {
                                    var23_36 |= 606126080;
                                    v18 = var13_32 - var19_14;
                                    var4_4[v18] = var4_4[v18] | 0x22100000;
                                    v19 = var13_32 + 1;
                                    var4_4[v19] = var4_4[v19] | 537407616;
                                    v20 = var13_32 - 1;
                                    var4_4[v20] = var4_4[v20] | 537143360;
                                } else {
                                    var23_36 |= 0x2020C000;
                                    v21 = var13_32 - var19_14;
                                    var4_4[v21] = var4_4[v21] | 0x20100000;
                                    v22 = var13_32 + 1;
                                    var4_4[v22] = var4_4[v22] | 0x20082080;
                                    v23 = var13_32 - 1;
                                    var4_4[v23] = var4_4[v23] | 0x20042040;
                                }
                                var32_39 = var27_18[var15_33] >> var31_23 << var30_22;
                                var28_20 += var5_5[var32_39 & 63];
                            } else {
                                var23_36 |= 16384;
                            }
                        }
                        if (var36_40 < 4) {
                            var4_4[var13_32] = var23_36;
                        } else {
                            if ((var23_36 & -1610612736) == 0x20000000) {
                                var8_8[var17_34] = var6_6[var23_36 >>> 16 & 255];
                                var7_7[var17_34++] = (var27_18[var15_33 += var18_13] & var24_17) >>> var3_3;
                                if (var7_7[var17_34++] != 0) {
                                    var25_37 = var27_18[var15_33] >>> 31;
                                    var26_38 = StdEntropyCoder.SC_LUT[var23_36 >>> 20 & 511];
                                    var7_7[var17_34] = var25_37 ^ var26_38 >>> 31;
                                    var8_8[var17_34++] = var26_38 & 15;
                                    v24 = var13_32 + var40_28;
                                    var4_4[v24] = var4_4[v24] | 8196;
                                    v25 = var13_32 + var39_27;
                                    var4_4[v25] = var4_4[v25] | 8200;
                                    if (var25_37 != 0) {
                                        var23_36 |= -1073733104;
                                        v26 = var13_32 + var19_14;
                                        var4_4[v26] = var4_4[v26] | 9248;
                                        v27 = var13_32 + 1;
                                        var4_4[v27] = var4_4[v27] | 813703170;
                                        v28 = var13_32 - 1;
                                        var4_4[v28] = var4_4[v28] | 675291137;
                                    } else {
                                        var23_36 |= -1073733616;
                                        v29 = var13_32 + var19_14;
                                        var4_4[v29] = var4_4[v29] | 8224;
                                        v30 = var13_32 + 1;
                                        var4_4[v30] = var4_4[v30] | 0x20802002;
                                        v31 = var13_32 - 1;
                                        var4_4[v31] = var4_4[v31] | 541073409;
                                    }
                                    var32_39 = var27_18[var15_33] >> var31_23 << var30_22;
                                    var28_20 += var5_5[var32_39 & 63];
                                } else {
                                    var23_36 |= 0x40000000;
                                }
                            }
                            var4_4[var13_32] = var23_36;
                        }
                    }
                }
                ++var16_29;
                ++var14_30;
            }
            var1_1.codeSymbols(var7_7, var8_8, var17_34);
            --var33_31;
            var16_29 += var21_16;
            var14_30 += var20_15;
        }
        if ((var12_12 & 2) != 0) {
            var1_1.resetCtxts();
        }
        var9_9[var10_10] = var2_2 != false ? var1_1.terminate() : var1_1.getNumCodedBytes();
        if (var11_11 >= 0) {
            v32 = var10_10;
            var9_9[v32] = var9_9[v32] + var9_9[var11_11];
        }
        if (var2_2) {
            var1_1.finishLengthCalculation(var9_9, var10_10);
        }
        return var28_20;
    }

    private class Compressor
    implements Runnable {
        private final int idx;
        CBlkRateDistStats ccb;
        int c;
        int options;
        boolean rev;
        int lcType;
        int tType;
        private long[] time;

        Compressor(int n) {
            this.idx = n;
        }

        public int getIdx() {
            return this.idx;
        }

        synchronized long getTiming(int n) {
            return 0L;
        }

        public void run() {
            try {
                long l = 0L;
                StdEntropyCoder.compressCodeBlock(this.c, this.ccb, StdEntropyCoder.this.srcblkT[this.idx], StdEntropyCoder.this.mqT[this.idx], StdEntropyCoder.this.boutT[this.idx], StdEntropyCoder.this.outT[this.idx], StdEntropyCoder.this.stateT[this.idx], StdEntropyCoder.this.distbufT[this.idx], StdEntropyCoder.this.ratebufT[this.idx], StdEntropyCoder.this.istermbufT[this.idx], StdEntropyCoder.this.symbufT[this.idx], StdEntropyCoder.this.ctxtbufT[this.idx], this.options, this.rev, this.lcType, this.tType);
            }
            finally {
                Object var2_2 = null;
                StdEntropyCoder.this.completedComps[this.c].push(this);
            }
        }
    }
}

