/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.entropy.encoder;

import jj2000.j2k.entropy.encoder.ByteOutputBuffer;
import jj2000.j2k.util.ArrayUtil;

public class MQCoder {
    public static final int LENGTH_LAZY = 0;
    public static final int LENGTH_LAZY_GOOD = 1;
    public static final int LENGTH_NEAR_OPT = 2;
    public static final int TERM_FULL = 0;
    public static final int TERM_NEAR_OPT = 1;
    public static final int TERM_EASY = 2;
    public static final int TERM_PRED_ER = 3;
    static final int[] qe = new int[]{22017, 13313, 6145, 2753, 1313, 545, 22017, 21505, 18433, 14337, 12289, 9217, 7169, 5633, 22017, 21505, 20737, 18433, 14337, 13313, 12289, 10241, 9217, 8705, 7169, 6145, 5633, 5121, 4609, 4353, 2753, 2497, 2209, 1313, 1089, 673, 545, 321, 273, 133, 73, 37, 21, 9, 5, 1, 22017};
    static final int[] nMPS = new int[]{1, 2, 3, 4, 5, 38, 7, 8, 9, 10, 11, 12, 13, 29, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 45, 46};
    static final int[] nLPS = new int[]{1, 6, 9, 12, 29, 33, 6, 14, 14, 14, 17, 18, 20, 21, 14, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 46};
    static final int[] switchLM;
    ByteOutputBuffer out;
    int[] mPS;
    int[] I;
    int c;
    int cT;
    int a;
    int b;
    boolean delFF;
    int nrOfWrittenBytes = -1;
    int[] initStates;
    int ttype;
    int ltype;
    int[] savedC;
    int[] savedCT;
    int[] savedA;
    int[] savedB;
    boolean[] savedDelFF;
    int nSaved;
    static final int SAVED_LEN = 96;
    static final int SAVED_INC = 12;

    static {
        int[] nArray = new int[47];
        nArray[0] = 1;
        nArray[6] = 1;
        nArray[14] = 1;
        switchLM = nArray;
    }

    public MQCoder(ByteOutputBuffer byteOutputBuffer, int n, int[] nArray) {
        this.out = byteOutputBuffer;
        this.I = new int[n];
        this.mPS = new int[n];
        this.initStates = nArray;
        this.a = 32768;
        this.c = 0;
        this.cT = this.b == 255 ? 13 : 12;
        this.resetCtxts();
        this.b = 0;
    }

    private void byteOut() {
        if (this.nrOfWrittenBytes >= 0) {
            if (this.b == 255) {
                this.delFF = true;
                this.b = this.c >>> 20;
                this.c &= 0xFFFFF;
                this.cT = 7;
            } else if (this.c < 0x8000000) {
                if (this.delFF) {
                    this.out.write(255);
                    this.delFF = false;
                    ++this.nrOfWrittenBytes;
                }
                this.out.write(this.b);
                ++this.nrOfWrittenBytes;
                this.b = this.c >>> 19;
                this.c &= 0x7FFFF;
                this.cT = 8;
            } else {
                ++this.b;
                if (this.b == 255) {
                    this.delFF = true;
                    this.c &= 0x7FFFFFF;
                    this.b = this.c >>> 20;
                    this.c &= 0xFFFFF;
                    this.cT = 7;
                } else {
                    if (this.delFF) {
                        this.out.write(255);
                        this.delFF = false;
                        ++this.nrOfWrittenBytes;
                    }
                    this.out.write(this.b);
                    ++this.nrOfWrittenBytes;
                    this.b = this.c >>> 19 & 0xFF;
                    this.c &= 0x7FFFF;
                    this.cT = 8;
                }
            }
        } else {
            this.b = this.c >>> 19;
            this.c &= 0x7FFFF;
            this.cT = 8;
            ++this.nrOfWrittenBytes;
        }
    }

    public final void codeSymbol(int n, int n2) {
        int n3 = this.I[n2];
        int n4 = qe[n3];
        if (n == this.mPS[n2]) {
            this.a -= n4;
            if (this.a >= 32768) {
                this.c += n4;
            } else {
                if (this.a < n4) {
                    this.a = n4;
                } else {
                    this.c += n4;
                }
                this.I[n2] = nMPS[n3];
                this.a <<= 1;
                this.c <<= 1;
                --this.cT;
                if (this.cT == 0) {
                    this.byteOut();
                }
            }
        } else {
            int n5 = this.a;
            if ((n5 -= n4) < n4) {
                this.c += n4;
            } else {
                n5 = n4;
            }
            if (switchLM[n3] != 0) {
                this.mPS[n2] = 1 - this.mPS[n2];
            }
            this.I[n2] = nLPS[n3];
            int n6 = 0;
            do {
                ++n6;
            } while ((n5 <<= 1) < 32768);
            if (this.cT > n6) {
                this.c <<= n6;
                this.cT -= n6;
            } else {
                do {
                    this.c <<= this.cT;
                    this.byteOut();
                } while (this.cT <= (n6 -= this.cT));
                this.c <<= n6;
                this.cT -= n6;
            }
            this.a = n5;
        }
    }

    public final void codeSymbols(int[] nArray, int[] nArray2, int n) {
        int n2 = this.a;
        int n3 = 0;
        while (n3 < n) {
            int n4 = nArray2[n3];
            int n5 = this.I[n4];
            int n6 = qe[n5];
            if (nArray[n3] == this.mPS[n4]) {
                if ((n2 -= n6) >= 32768) {
                    this.c += n6;
                } else {
                    if (n2 < n6) {
                        n2 = n6;
                    } else {
                        this.c += n6;
                    }
                    this.I[n4] = nMPS[n5];
                    n2 <<= 1;
                    this.c <<= 1;
                    --this.cT;
                    if (this.cT == 0) {
                        this.byteOut();
                    }
                }
            } else {
                if ((n2 -= n6) < n6) {
                    this.c += n6;
                } else {
                    n2 = n6;
                }
                if (switchLM[n5] != 0) {
                    this.mPS[n4] = 1 - this.mPS[n4];
                }
                this.I[n4] = nLPS[n5];
                int n7 = 0;
                do {
                    ++n7;
                } while ((n2 <<= 1) < 32768);
                if (this.cT > n7) {
                    this.c <<= n7;
                    this.cT -= n7;
                } else {
                    do {
                        this.c <<= this.cT;
                        this.byteOut();
                    } while (this.cT <= (n7 -= this.cT));
                    this.c <<= n7;
                    this.cT -= n7;
                }
            }
            ++n3;
        }
        this.a = n2;
    }

    public final void fastCodeSymbols(int n, int n2, int n3) {
        int n4;
        int n5 = this.I[n2];
        int n6 = qe[n5];
        if (n6 <= 16384 && n == this.mPS[n2] && (n4 = (this.a - 32768) / n6 + 1) > 1) {
            do {
                int n7;
                if (n3 <= n4) {
                    n7 = n3 * n6;
                    this.a -= n7;
                    this.c += n7;
                    if (this.a >= 32768) {
                        this.I[n2] = n5;
                        return;
                    }
                    this.I[n2] = nMPS[n5];
                    this.a <<= 1;
                    this.c <<= 1;
                    --this.cT;
                    if (this.cT == 0) {
                        this.byteOut();
                    }
                    return;
                }
                n7 = n4 * n6;
                this.c += n7;
                this.a -= n7;
                n5 = nMPS[n5];
                n6 = qe[n5];
                this.a <<= 1;
                this.c <<= 1;
                --this.cT;
                if (this.cT != 0) continue;
                this.byteOut();
            } while ((n3 -= (n4 = (this.a - 32768) / n6 + 1)) > 0);
        } else {
            int n8 = this.a;
            do {
                if (n == this.mPS[n2]) {
                    if ((n8 -= n6) >= 32768) {
                        this.c += n6;
                        continue;
                    }
                    if (n8 < n6) {
                        n8 = n6;
                    } else {
                        this.c += n6;
                    }
                    n5 = nMPS[n5];
                    n6 = qe[n5];
                    n8 <<= 1;
                    this.c <<= 1;
                    --this.cT;
                    if (this.cT != 0) continue;
                    this.byteOut();
                    continue;
                }
                if ((n8 -= n6) < n6) {
                    this.c += n6;
                } else {
                    n8 = n6;
                }
                if (switchLM[n5] != 0) {
                    this.mPS[n2] = 1 - this.mPS[n2];
                }
                n5 = nLPS[n5];
                n6 = qe[n5];
                int n9 = 0;
                do {
                    ++n9;
                } while ((n8 <<= 1) < 32768);
                if (this.cT > n9) {
                    this.c <<= n9;
                    this.cT -= n9;
                    continue;
                }
                do {
                    this.c <<= this.cT;
                    this.byteOut();
                } while (this.cT <= (n9 -= this.cT));
                this.c <<= n9;
                this.cT -= n9;
            } while (--n3 > 0);
            this.I[n2] = n5;
            this.a = n8;
        }
    }

    public void finishLengthCalculation(int[] nArray, int n) {
        if (this.ltype != 2) {
            if (n > 0 && nArray[n - 1] > nArray[n]) {
                int n2 = nArray[n];
                do {
                    int n3 = --n;
                    nArray[n3] = n2;
                } while (--n >= 0 && nArray[n] > n2);
            }
        } else {
            int n4 = n - this.nSaved;
            int n5 = n4 - 1 >= 0 ? nArray[n4 - 1] : 0;
            int n6 = nArray[n];
            int n7 = 0;
            while (n4 < n) {
                int n8 = this.savedC[n7];
                int n9 = this.savedC[n7] + this.savedA[n7];
                int n10 = this.savedB[n7];
                int n11 = this.savedB[n7];
                if (((n8 <<= this.savedCT[n7]) & 0x8000000) != 0) {
                    ++n10;
                    n8 &= 0x7FFFFFF;
                }
                if (((n9 <<= this.savedCT[n7]) & 0x8000000) != 0) {
                    ++n11;
                    n9 &= 0x7FFFFFF;
                }
                boolean bl = this.savedDelFF[n7];
                int n12 = nArray[n4] + (bl ? 1 : 0);
                while (true) {
                    if (n12 >= n6) {
                        n12 = n6;
                        break;
                    }
                    if (bl) {
                        if (n10 < 128 && n11 >= 128) {
                            --n12;
                            break;
                        }
                    } else if (n10 < 256 && n11 >= 256) break;
                    int n13 = n12 >= n5 ? this.out.getByte(n12) : 0;
                    n10 -= n13;
                    n11 -= n13;
                    ++n12;
                    if (n13 == 255) {
                        n10 <<= 7;
                        n10 |= n8 >> 20 & 0x7F;
                        n8 &= 0xFFFFF;
                        n8 <<= 7;
                        n11 <<= 7;
                        n11 |= n9 >> 20 & 0x7F;
                        n9 &= 0xFFFFF;
                        n9 <<= 7;
                        bl = true;
                        continue;
                    }
                    n10 <<= 8;
                    n10 |= n8 >> 19 & 0xFF;
                    n8 &= 0x7FFFF;
                    n8 <<= 8;
                    n11 <<= 8;
                    n11 |= n9 >> 19 & 0xFF;
                    n9 &= 0x7FFFF;
                    n9 <<= 8;
                    bl = false;
                }
                nArray[n4] = n12 >= n5 ? n12 : n5;
                ++n4;
                ++n7;
            }
            this.nSaved = 0;
        }
    }

    public final int getNumCodedBytes() {
        switch (this.ltype) {
            case 1: {
                int n = this.b >= 254 ? 22 : 23;
                if (11 - this.cT + 16 <= n) {
                    return this.nrOfWrittenBytes + (this.delFF ? 1 : 0) + 1 + 3;
                }
                return this.nrOfWrittenBytes + (this.delFF ? 1 : 0) + 1 + 4;
            }
            case 0: {
                if (27 - this.cT <= 22) {
                    return this.nrOfWrittenBytes + (this.delFF ? 1 : 0) + 1 + 3;
                }
                return this.nrOfWrittenBytes + (this.delFF ? 1 : 0) + 1 + 4;
            }
            case 2: {
                this.saveState();
                return this.nrOfWrittenBytes;
            }
        }
        throw new Error("Illegal length calculation type code");
    }

    public final int getNumCtxts() {
        return this.I.length;
    }

    public final void reset() {
        this.out.reset();
        this.a = 32768;
        this.c = 0;
        this.b = 0;
        this.cT = this.b == 255 ? 13 : 12;
        this.resetCtxts();
        this.nrOfWrittenBytes = -1;
        this.delFF = false;
        this.nSaved = 0;
    }

    public final void resetCtxt(int n) {
        this.I[n] = this.initStates[n];
        this.mPS[n] = 0;
    }

    public final void resetCtxts() {
        System.arraycopy(this.initStates, 0, this.I, 0, this.I.length);
        ArrayUtil.intArraySet(this.mPS, 0);
    }

    private void saveState() {
        if (this.nSaved == this.savedC.length) {
            Object[] objectArray = this.savedC;
            this.savedC = new int[this.nSaved + 12];
            System.arraycopy(objectArray, 0, this.savedC, 0, this.nSaved);
            objectArray = this.savedCT;
            this.savedCT = new int[this.nSaved + 12];
            System.arraycopy(objectArray, 0, this.savedCT, 0, this.nSaved);
            objectArray = this.savedA;
            this.savedA = new int[this.nSaved + 12];
            System.arraycopy(objectArray, 0, this.savedA, 0, this.nSaved);
            objectArray = this.savedB;
            this.savedB = new int[this.nSaved + 12];
            System.arraycopy(objectArray, 0, this.savedB, 0, this.nSaved);
            objectArray = this.savedDelFF;
            this.savedDelFF = new boolean[this.nSaved + 12];
            System.arraycopy(objectArray, 0, this.savedDelFF, 0, this.nSaved);
        }
        this.savedC[this.nSaved] = this.c;
        this.savedCT[this.nSaved] = this.cT;
        this.savedA[this.nSaved] = this.a;
        this.savedB[this.nSaved] = this.b;
        this.savedDelFF[this.nSaved] = this.delFF;
        ++this.nSaved;
    }

    public void setLenCalcType(int n) {
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException("Unrecognized length calculation type code: " + n);
        }
        if (n == 2) {
            if (this.savedC == null) {
                this.savedC = new int[96];
            }
            if (this.savedCT == null) {
                this.savedCT = new int[96];
            }
            if (this.savedA == null) {
                this.savedA = new int[96];
            }
            if (this.savedB == null) {
                this.savedB = new int[96];
            }
            if (this.savedDelFF == null) {
                this.savedDelFF = new boolean[96];
            }
        }
        this.ltype = n;
    }

    public void setTermType(int n) {
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            throw new IllegalArgumentException("Unrecognized termination type code: " + n);
        }
        this.ttype = n;
    }

    public int terminate() {
        int n;
        block0 : switch (this.ttype) {
            case 0: {
                n = this.c + this.a;
                this.c |= 0xFFFF;
                if (this.c >= n) {
                    this.c -= 32768;
                }
                int n2 = 27 - this.cT;
                do {
                    this.c <<= this.cT;
                    n2 = this.b != 255 ? (n2 -= 8) : (n2 -= 7);
                    this.byteOut();
                } while (n2 > 0);
                this.b |= (1 << -n2) - 1;
                if (this.b == 255) {
                    this.delFF = true;
                    break;
                }
                if (this.delFF) {
                    this.out.write(255);
                    this.delFF = false;
                    ++this.nrOfWrittenBytes;
                }
                this.out.write(this.b);
                ++this.nrOfWrittenBytes;
                break;
            }
            case 2: 
            case 3: {
                int n3 = 11 - this.cT + 1;
                this.c <<= this.cT;
                while (n3 > 0) {
                    this.byteOut();
                    n3 -= this.cT;
                    this.c <<= this.cT;
                }
                if (n3 < 0 && this.ttype == 2) {
                    this.b |= (1 << -n3) - 1;
                }
                this.byteOut();
                break;
            }
            case 1: {
                int n4;
                int n5 = this.c;
                int n6 = this.c + this.a;
                int n7 = n4 = this.b;
                n6 <<= this.cT;
                if (((n5 <<= this.cT) & 0x8000000) != 0) {
                    if (n7 == 255) {
                        this.delFF = true;
                        n7 = n5 >>> 20;
                        n4 = n6 >>> 20;
                        n5 &= 0xFFFFF;
                        n6 &= 0xFFFFF;
                        n5 <<= 7;
                        n6 <<= 7;
                    } else {
                        ++n7;
                        n5 &= 0xF7FFFFFF;
                    }
                }
                if ((n6 & 0x8000000) != 0) {
                    ++n4;
                    n6 &= 0xF7FFFFFF;
                }
                while (true) {
                    if (this.delFF) {
                        if (n7 <= 127 && n4 > 127) break block0;
                        this.out.write(255);
                        ++this.nrOfWrittenBytes;
                        this.delFF = false;
                    } else if (n7 <= 255 && n4 > 255) break block0;
                    if (n7 < 255) {
                        if (this.nrOfWrittenBytes >= 0) {
                            this.out.write(n7);
                        }
                        ++this.nrOfWrittenBytes;
                        n4 -= n7;
                        n4 <<= 8;
                        n4 |= n6 >>> 19 & 0xFF;
                        n7 = n5 >>> 19 & 0xFF;
                        n5 &= 0x7FFFF;
                        n6 &= 0x7FFFF;
                        n5 <<= 8;
                        n6 <<= 8;
                        continue;
                    }
                    this.delFF = true;
                    n4 -= n7;
                    n4 <<= 7;
                    n4 |= n6 >> 20 & 0x7F;
                    n7 = n5 >> 20 & 0x7F;
                    n5 &= 0xFFFFF;
                    n6 &= 0xFFFFF;
                    n5 <<= 7;
                    n6 <<= 7;
                }
            }
            default: {
                throw new Error("Illegal termination type code");
            }
        }
        n = this.nrOfWrittenBytes;
        this.a = 32768;
        this.c = 0;
        this.b = 0;
        this.cT = 12;
        this.delFF = false;
        this.nrOfWrittenBytes = -1;
        return n;
    }
}

