/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.entropy.encoder;

import java.io.IOException;
import java.util.Vector;
import jj2000.j2k.codestream.writer.BitOutputBuffer;
import jj2000.j2k.codestream.writer.CodestreamWriter;
import jj2000.j2k.codestream.writer.PktEncoder;
import jj2000.j2k.encoder.EncoderSpecs;
import jj2000.j2k.entropy.Progression;
import jj2000.j2k.entropy.encoder.CBlkRateDistStats;
import jj2000.j2k.entropy.encoder.CodedCBlkDataSrcEnc;
import jj2000.j2k.entropy.encoder.EBCOTLayer;
import jj2000.j2k.entropy.encoder.LayersInfo;
import jj2000.j2k.entropy.encoder.PostCompRateAllocator;
import jj2000.j2k.image.Coord;
import jj2000.j2k.util.ParameterList;
import jj2000.j2k.wavelet.analysis.SubbandAn;

public class EBCOTRateAllocator
extends PostCompRateAllocator {
    private static final boolean DO_TIMING = false;
    private long initTime;
    private long buildTime;
    private long writeTime;
    private CBlkRateDistStats[][][][][] cblks;
    private int[][][][][][] truncIdxs;
    private Coord[][][] maxNumPrec;
    private EBCOTLayer[] layers;
    private static final double LOG2 = Math.log(2.0);
    private static final int RD_SUMMARY_OFF = 24;
    private static final int RD_SUMMARY_SIZE = 64;
    private static final float FLOAT_REL_PRECISION = 1.0E-4f;
    private static final float FLOAT_ABS_PRECISION = 1.0E-10f;
    private static final int MIN_AVG_PACKET_SZ = 32;
    private int[] RDSlopesRates;
    private PktEncoder packetEnc;
    private LayersInfo lyrSpec;
    private float maxSlope;
    private float minSlope;

    public EBCOTRateAllocator(CodedCBlkDataSrcEnc codedCBlkDataSrcEnc, LayersInfo layersInfo, CodestreamWriter codestreamWriter, EncoderSpecs encoderSpecs, ParameterList parameterList) {
        super(codedCBlkDataSrcEnc, layersInfo.getTotNumLayers(), codestreamWriter, encoderSpecs);
        Coord coord = null;
        this.lyrSpec = layersInfo;
        this.RDSlopesRates = new int[64];
        int n = codedCBlkDataSrcEnc.getNumTiles();
        int n2 = this.getNumComps();
        this.cblks = new CBlkRateDistStats[n][n2][][][];
        this.truncIdxs = new int[n][this.numLayers][n2][][][];
        int n3 = 0;
        codedCBlkDataSrcEnc.setTile(0, 0);
        while (n3 < n) {
            int n4 = 0;
            while (n4 < n2) {
                SubbandAn subbandAn = codedCBlkDataSrcEnc.getSubbandTree(n3, n4);
                int n5 = subbandAn.resLvl + 1;
                if (this.maxNumPrec == null) {
                    this.maxNumPrec = new Coord[n][n2][];
                }
                if (this.maxNumPrec[n3][n4] == null) {
                    this.maxNumPrec[n3][n4] = new Coord[n5];
                }
                int n6 = codedCBlkDataSrcEnc.getULX(n4);
                int n7 = codedCBlkDataSrcEnc.getULY(n4);
                int n8 = n6 + codedCBlkDataSrcEnc.getWidth();
                int n9 = n7 + codedCBlkDataSrcEnc.getHeight();
                int n10 = codedCBlkDataSrcEnc.getCompSubsX(n4);
                int n11 = codedCBlkDataSrcEnc.getCompSubsY(n4);
                int n12 = (int)Math.ceil((double)n6 / (double)n10);
                int n13 = (int)Math.ceil((double)n7 / (double)n11);
                int n14 = (int)Math.ceil((double)n8 / (double)n10);
                int n15 = (int)Math.ceil((double)n9 / (double)n11);
                this.cblks[n3][n4] = new CBlkRateDistStats[n5][][];
                int n16 = 0;
                while (n16 < this.numLayers) {
                    this.truncIdxs[n3][n16][n4] = new int[n5][][];
                    ++n16;
                }
                int n17 = n5 - 1;
                while (n17 >= 0) {
                    int n18 = (int)Math.ceil((double)n12 / (double)(1 << n5 - 1 - n17));
                    int n19 = (int)Math.ceil((double)n13 / (double)(1 << n5 - 1 - n17));
                    int n20 = (int)Math.ceil((double)n14 / (double)(1 << n5 - 1 - n17));
                    int n21 = (int)Math.ceil((double)n15 / (double)(1 << n5 - 1 - n17));
                    double d = encoderSpecs.pss.getPPX(n3, n4, n17);
                    double d2 = encoderSpecs.pss.getPPY(n3, n4, n17);
                    this.maxNumPrec[n3][n4][n17] = new Coord();
                    if (n20 > n18) {
                        this.maxNumPrec[n3][n4][n17].x = (int)Math.ceil((double)n20 / d) - (int)Math.floor((double)n18 / d);
                    }
                    if (n21 > n19) {
                        this.maxNumPrec[n3][n4][n17].y = (int)Math.ceil((double)n21 / d2) - (int)Math.floor((double)n19 / d2);
                    }
                    SubbandAn subbandAn2 = subbandAn;
                    while (subbandAn2.subb_HH != null) {
                        subbandAn2 = subbandAn2.subb_HH;
                    }
                    int n22 = subbandAn2.sbandIdx + 1;
                    int n23 = n22 >> 2;
                    this.cblks[n3][n4][n17] = new CBlkRateDistStats[n22][];
                    n16 = 0;
                    while (n16 < this.numLayers) {
                        this.truncIdxs[n3][n16][n4][n17] = new int[n22][];
                        ++n16;
                    }
                    subbandAn2 = (SubbandAn)subbandAn.getSubbandByIdx(n17, n23);
                    int n24 = n23;
                    while (n24 < n22) {
                        coord = codedCBlkDataSrcEnc.getNumCodeBlocks(subbandAn2, coord);
                        int n25 = coord.x * coord.y;
                        this.cblks[n3][n4][n17][n24] = new CBlkRateDistStats[n25];
                        n16 = 0;
                        while (n16 < this.numLayers) {
                            this.truncIdxs[n3][n16][n4][n17][n24] = new int[n25];
                            int n26 = 0;
                            while (n26 < n25) {
                                this.truncIdxs[n3][n16][n4][n17][n24][n26] = -1;
                                ++n26;
                            }
                            ++n16;
                        }
                        subbandAn2 = (SubbandAn)subbandAn2.nextSubband();
                        ++n24;
                    }
                    subbandAn = subbandAn.subb_LL;
                    --n17;
                }
                ++n4;
            }
            if (n3 < n - 1) {
                codedCBlkDataSrcEnc.nextTile();
            }
            ++n3;
        }
        this.packetEnc = new PktEncoder(codedCBlkDataSrcEnc, encoderSpecs, this.maxNumPrec, parameterList);
    }

    private void buildAndWriteLayers() throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        BitOutputBuffer bitOutputBuffer = null;
        byte[] byArray = null;
        int n5 = this.src.getNumComps();
        int n6 = this.src.getNumTiles();
        int[][] nArray = this.packetEnc.getMRL();
        long l = 0L;
        float f = this.maxSlope;
        int[] nArray2 = new int[n6];
        int n7 = 0;
        int n8 = 0;
        while (n8 < this.numLayers) {
            int n9 = this.layers[n8].maxBytes;
            if (this.layers[n8].optimize) {
                f = this.optimizeBitstreamLayer(n8, f, n9, n7);
            } else {
                if (n8 <= 0 || n8 >= this.numLayers - 1) {
                    throw new IllegalArgumentException("The first and the last layer thresholds must be optimized");
                }
                f = this.estimateLayerThreshold(n9, this.layers[n8 - 1]);
            }
            this.src.setTile(0, 0);
            int n10 = 0;
            while (n10 < n6) {
                if (n8 == 0) {
                    this.headEnc.reset();
                    this.headEnc.encodeTilePartHeader(0, n10);
                    int n11 = n10;
                    nArray2[n11] = nArray2[n11] + this.headEnc.getLength();
                }
                n4 = 0;
                while (n4 < n5) {
                    boolean bl = ((String)this.encSpec.sops.getTileDef(n10)).equalsIgnoreCase("on");
                    boolean bl2 = ((String)this.encSpec.ephs.getTileDef(n10)).equalsIgnoreCase("on");
                    SubbandAn subbandAn = this.src.getSubbandTree(n10, n4);
                    while (subbandAn.subb_LL != null) {
                        subbandAn = subbandAn.subb_LL;
                    }
                    int n12 = nArray[n10][n4] + 1;
                    n3 = 0;
                    while (n3 < n12) {
                        int n13 = 0;
                        Coord[] coordArray = this.packetEnc.getSotEotArrayMax(n10, n4);
                        int n14 = coordArray[0].x;
                        int n15 = coordArray[0].y;
                        int n16 = coordArray[1].x;
                        int n17 = coordArray[1].y;
                        Coord coord = this.packetEnc.getIncArrayMax(n10, n4);
                        int n18 = coord.x;
                        int n19 = coord.y;
                        coord = this.packetEnc.getIncArray(n10, n4, n3);
                        int n20 = coord.x;
                        int n21 = coord.y;
                        coordArray = this.packetEnc.getSotEotArray(n10, n4, n3);
                        int n22 = coordArray[0].x;
                        int n23 = coordArray[0].y;
                        n2 = n15;
                        while (n2 < n17) {
                            n = n14;
                            while (n < n16) {
                                if (!(n != n14 && n % n20 != 0 || n2 != n15 && n2 % n21 != 0 || n13 >= this.maxNumPrec[n10][n4][n3].x * this.maxNumPrec[n10][n4][n3].y)) {
                                    this.findTruncIndices(n8, n4, n3, n10, subbandAn, f, n13);
                                    bitOutputBuffer = this.packetEnc.encodePacket(n8 + 1, n4, n3, n10, this.cblks[n10][n4][n3], this.truncIdxs[n10][n8][n4][n3], bitOutputBuffer, byArray, n13);
                                    if (this.packetEnc.isPacketWritable()) {
                                        int n24 = this.bsWriter.writePacketHead(bitOutputBuffer.getBuffer(), bitOutputBuffer.getLength(), true, bl, bl2);
                                        n7 += (n24 += this.bsWriter.writePacketBody(this.packetEnc.getLastBodyBuf(), this.packetEnc.getLastBodyLen(), true, this.packetEnc.isROIinPkt(), this.packetEnc.getROILen()));
                                        int n25 = n10;
                                        nArray2[n25] = nArray2[n25] + n24;
                                    }
                                    ++n13;
                                }
                                n += n18;
                            }
                            n2 += n19;
                        }
                        subbandAn = subbandAn.parent;
                        ++n3;
                    }
                    ++n4;
                }
                if (n10 != n6 - 1) {
                    this.src.nextTile();
                }
                ++n10;
            }
            this.layers[n8].rdThreshold = f;
            this.layers[n8].actualBytes = n7;
            ++n8;
        }
        this.packetEnc.reset();
        int n26 = 0;
        while (n26 < n6) {
            int[][] nArray3 = new int[n5][];
            int n27 = 0;
            while (n27 < n5) {
                nArray3[n27] = new int[nArray[n26][n27] + 1];
                ++n27;
            }
            this.headEnc.reset();
            this.headEnc.encodeTilePartHeader(nArray2[n26], n26);
            this.bsWriter.commitBitstreamHeader(this.headEnc);
            Progression[] progressionArray = (Progression[])this.encSpec.ps.getTileDef(n26);
            int n28 = 0;
            while (n28 < progressionArray.length) {
                int n29 = progressionArray[n28].lye;
                n4 = progressionArray[n28].cs;
                n3 = progressionArray[n28].ce;
                n2 = progressionArray[n28].rs;
                n = progressionArray[n28].re;
                switch (progressionArray[n28].type) {
                    case 1: {
                        this.writeResLyCompPos(n26, n2, n, n4, n3, nArray3, n29);
                        break;
                    }
                    case 0: {
                        this.writeLyResCompPos(n26, n2, n, n4, n3, nArray3, n29);
                        break;
                    }
                    case 3: {
                        this.writePosCompResLy(n26, n2, n, n4, n3, nArray3, n29);
                        break;
                    }
                    case 4: {
                        this.writeCompPosResLy(n26, n2, n, n4, n3, nArray3, n29);
                        break;
                    }
                    case 2: {
                        this.writeResPosCompLy(n26, n2, n, n4, n3, nArray3, n29);
                        break;
                    }
                    default: {
                        throw new Error("Unsupported bit stream progression type");
                    }
                }
                int n30 = n4;
                while (n30 < n3) {
                    int n31 = n2;
                    while (n31 < n) {
                        if (n31 <= nArray[n26][n30]) {
                            nArray3[n30][n31] = n29;
                        }
                        ++n31;
                    }
                    ++n30;
                }
                ++n28;
            }
            ++n26;
        }
    }

    private float estimateLayerThreshold(int n, EBCOTLayer eBCOTLayer) {
        float f;
        float f2;
        float f3;
        float f4 = eBCOTLayer.rdThreshold;
        if (f4 > this.maxSlope) {
            f4 = this.maxSlope;
        }
        if (f4 < 1.0E-10f) {
            return 0.0f;
        }
        int n2 = EBCOTRateAllocator.getLimitedSIndexFromSlope(f4);
        if (n2 >= 63) {
            n2 = 62;
        }
        if (this.RDSlopesRates[n2 + 1] == 0) {
            f3 = (float)Math.log((this.RDSlopesRates[n2] << 1) + 1);
            f2 = (float)Math.log(this.RDSlopesRates[n2] + 1);
            f = (float)Math.log(eBCOTLayer.actualBytes + this.RDSlopesRates[n2] + 1);
        } else {
            f3 = (float)Math.log(this.RDSlopesRates[n2]);
            f2 = (float)Math.log(this.RDSlopesRates[n2 + 1]);
            f = (float)Math.log(eBCOTLayer.actualBytes);
        }
        float f5 = (float)Math.log(EBCOTRateAllocator.getSlopeFromSIndex(n2));
        float f6 = (float)Math.log(EBCOTRateAllocator.getSlopeFromSIndex(n2 + 1));
        float f7 = (float)Math.log(f4);
        float f8 = f3 + (f7 - f5) * (f3 - f2) / (f5 - f6);
        float f9 = f - f8;
        if (f9 < 0.0f) {
            f9 = 0.0f;
        }
        int n3 = (int)((float)n / (float)Math.exp(f9));
        n2 = 63;
        while (n2 >= 0) {
            if (this.RDSlopesRates[n2] >= n3) break;
            --n2;
        }
        if (++n2 >= 64) {
            n2 = 63;
        }
        if (n2 <= 0) {
            n2 = 1;
        }
        if (this.RDSlopesRates[n2] == 0) {
            f3 = (float)Math.log(this.RDSlopesRates[n2 - 1] + 1);
            f2 = (float)Math.log((this.RDSlopesRates[n2 - 1] << 1) + 1);
            f8 = (float)Math.log(n3 + this.RDSlopesRates[n2 - 1] + 1);
        } else {
            f3 = (float)Math.log(this.RDSlopesRates[n2]);
            f2 = (float)Math.log(this.RDSlopesRates[n2 - 1]);
            f8 = (float)Math.log(n3);
        }
        f5 = (float)Math.log(EBCOTRateAllocator.getSlopeFromSIndex(n2));
        f6 = (float)Math.log(EBCOTRateAllocator.getSlopeFromSIndex(n2 - 1));
        f7 = f5 + (f8 - f3) * (f5 - f6) / (f3 - f2);
        float f10 = (float)Math.exp(f7);
        if (f10 > f4) {
            f10 = f4;
        }
        if (f10 < 1.0E-10f) {
            f10 = 0.0f;
        }
        return f10;
    }

    public void finalize() throws Throwable {
        super.finalize();
    }

    private void findTruncIndices(int n, int n2, int n3, int n4, SubbandAn subbandAn, float f, int n5) {
        Object var14_8 = null;
        Vector vector = null;
        SubbandAn subbandAn2 = subbandAn;
        while (subbandAn2.subb_HH != null) {
            subbandAn2 = subbandAn2.subb_HH;
        }
        int n6 = subbandAn2.sbandIdx + 1;
        int n7 = n6 >> 2;
        subbandAn2 = (SubbandAn)subbandAn.getSubbandByIdx(n3, n7);
        int n8 = n7;
        while (n8 < n6) {
            vector = this.packetEnc.getCBlkInPrec(n4, n2, n3, n8, n5, vector);
            int n9 = 1;
            while (n9 < vector.size()) {
                int n10 = (Integer)vector.elementAt(n9);
                CBlkRateDistStats cBlkRateDistStats = this.cblks[n4][n2][n3][n8][n10];
                int n11 = 0;
                while (n11 < cBlkRateDistStats.nVldTrunc) {
                    if (cBlkRateDistStats.truncSlopes[n11] < f) break;
                    ++n11;
                }
                this.truncIdxs[n4][n][n2][n3][n8][n10] = n11 - 1;
                ++n9;
            }
            subbandAn2 = (SubbandAn)subbandAn2.nextSubband();
            ++n8;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void getAllCodeBlocks() {
        var12_1 = null;
        var13_2 = null;
        var16_3 = 0L;
        this.maxSlope = 0.0f;
        this.minSlope = 3.4028235E38f;
        var1_4 = this.src.getNumComps();
        var2_5 = this.src.getNumTiles();
        this.src.setTile(0, 0);
        var6_6 = 0;
        while (var6_6 < var2_5) {
            var4_7 = 0;
            ** GOTO lbl38
            {
                var11_12 = var12_1.sb;
                var5_8 = var11_12.resLvl;
                var7_9 = var11_12.sbandIdx;
                var13_2 = this.src.getNumCodeBlocks(var11_12, var13_2);
                var14_13 = -1;
                var9_11 = var12_1.nVldTrunc - 1;
                while (var9_11 >= 0) {
                    var15_14 = var12_1.truncSlopes[var9_11];
                    if (var15_14 > this.maxSlope) {
                        this.maxSlope = var15_14;
                    }
                    if (var15_14 < this.minSlope) {
                        this.minSlope = var15_14;
                    }
                    var8_10 = EBCOTRateAllocator.getLimitedSIndexFromSlope(var15_14);
                    while (var8_10 > var14_13) {
                        v0 = var8_10--;
                        this.RDSlopesRates[v0] = this.RDSlopesRates[v0] + var12_1.truncRates[var12_1.truncIdxs[var9_11]];
                    }
                    var14_13 = EBCOTRateAllocator.getLimitedSIndexFromSlope(var15_14);
                    --var9_11;
                }
                this.cblks[var6_6][var4_7][var5_8][var7_9][var12_1.m * var13_2.x + var12_1.n] = var12_1;
                var12_1 = null;
                do {
                    if ((var12_1 = this.src.getNextCodeBlock(var4_7, var12_1)) != null) continue block1;
                    ++var4_7;
lbl38:
                    // 2 sources

                } while (var4_7 < var1_4);
            }
            if (var6_6 < var2_5 - 1) {
                this.src.nextTile();
            }
            ++var6_6;
        }
    }

    private static int getLimitedSIndexFromSlope(float f) {
        int n = (int)Math.floor(Math.log(f) / LOG2) + 24;
        if (n < 0) {
            return 0;
        }
        if (n >= 64) {
            return 63;
        }
        return n;
    }

    private static float getSlopeFromSIndex(int n) {
        return (float)Math.pow(2.0, n - 24);
    }

    public void initialize() throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = this.src.getNumTiles();
        int n9 = this.src.getNumComps();
        long l = 0L;
        this.getAllCodeBlocks();
        int n10 = this.RDSlopesRates[0];
        int n11 = 0;
        while (n11 < n8) {
            int n12 = 2;
            if (((String)this.encSpec.sops.getTileDef(n11)).equalsIgnoreCase("on")) {
                n12 += 6;
            }
            if (((String)this.encSpec.ephs.getTileDef(n11)).equalsIgnoreCase("on")) {
                n12 += 2;
            }
            n7 = 0;
            while (n7 < n9) {
                n6 = this.src.getSubbandTree((int)n11, (int)n7).resLvl + 1;
                if (!this.src.precinctPartitionUsed(n7, n11)) {
                    n10 += this.numLayers * n12 * n6;
                } else {
                    n5 = 0;
                    while (n5 < n6) {
                        n4 = this.maxNumPrec[n11][n7][n5].x * this.maxNumPrec[n11][n7][n5].y;
                        n10 += this.numLayers * n12 * n4;
                        ++n5;
                    }
                }
                ++n7;
            }
            ++n11;
        }
        int n13 = this.headEnc.getLength();
        float f = (float)(this.src.getImgWidth() * this.src.getImgHeight()) / 8.0f;
        n7 = 0;
        while (n7 < n8) {
            this.headEnc.reset();
            this.headEnc.encodeTilePartHeader(0, n7);
            n13 += this.headEnc.getLength();
            ++n7;
        }
        this.layers = new EBCOTLayer[this.numLayers];
        int n14 = this.numLayers - 1;
        while (n14 >= 0) {
            this.layers[n14] = new EBCOTLayer();
            --n14;
        }
        int n15 = 0;
        n5 = 0;
        while (n5 < n8) {
            int n16 = 0;
            while (n16 < n9) {
                n6 = this.src.getSubbandTree((int)n5, (int)n16).resLvl + 1;
                if (!this.src.precinctPartitionUsed(n16, n5)) {
                    n15 += 32 * n6;
                } else {
                    int n17 = 0;
                    while (n17 < n6) {
                        n4 = this.maxNumPrec[n5][n16][n17].x * this.maxNumPrec[n5][n16][n17].y;
                        n15 += 32 * n4;
                        ++n17;
                    }
                }
                ++n16;
            }
            ++n5;
        }
        n14 = 0;
        int n18 = 0;
        int n19 = 0;
        while (n14 < this.numLayers - 1) {
            double d = Math.floor(this.lyrSpec.getTargetBitrate(n18) * f);
            if (n18 < this.lyrSpec.getNOptPoints() - 1) {
                n3 = (int)(this.lyrSpec.getTargetBitrate(n18 + 1) * f);
                if (n3 > n10) {
                    n3 = n10;
                }
            } else {
                n3 = 1;
            }
            int n20 = this.lyrSpec.getExtraLayers(n18) + 1;
            double d2 = Math.exp(Math.log((double)n3 / d) / (double)n20);
            this.layers[n14].optimize = true;
            int n21 = 0;
            while (n21 < n20) {
                n2 = (int)d - n19 - n13;
                if (n2 < n15) {
                    d *= d2;
                    --this.numLayers;
                } else {
                    this.layers[n14].maxBytes = n19 = (int)d - n13;
                    d *= d2;
                    ++n14;
                }
                ++n21;
            }
            ++n18;
        }
        n14 = this.numLayers - 2;
        n3 = (int)(this.lyrSpec.getTotBitrate() * f) - n13;
        n2 = n3 - (n14 >= 0 ? this.layers[n14].maxBytes : 0);
        while (n2 < n15) {
            if (this.numLayers == 1) {
                if (n2 > 0) break;
                throw new IllegalArgumentException("Overall target bitrate too low, given the current bit stream header overhead");
            }
            --this.numLayers;
            n2 = n3 - (--n14 >= 0 ? this.layers[n14].maxBytes : 0);
        }
        this.layers[++n14].maxBytes = n3;
        this.layers[n14].optimize = true;
        Progression[] progressionArray = (Progression[])this.encSpec.ps.getDefault();
        int n22 = progressionArray.length;
        int n23 = 0;
        while (n23 < progressionArray.length) {
            if (progressionArray[n23].lye > this.numLayers) {
                progressionArray[n23].lye = this.numLayers;
                n22 = n23 + 1;
                break;
            }
            ++n23;
        }
        if (n22 == 0) {
            throw new Error("Unable to initialize rate allocator");
        }
        if (n22 != progressionArray.length) {
            Progression[] progressionArray2 = new Progression[n22];
            n = 0;
            while (n < n22) {
                progressionArray2[n] = progressionArray[n];
                ++n;
            }
            this.encSpec.ps.setDefault(progressionArray2);
        }
        n = 0;
        while (n < n8) {
            if (this.encSpec.ps.isTileSpecified(n)) {
                progressionArray = (Progression[])this.encSpec.ps.getTileDef(n);
                n22 = progressionArray.length;
                int n24 = 0;
                while (n24 < progressionArray.length) {
                    if (progressionArray[n24].lye > this.numLayers) {
                        progressionArray[n24].lye = this.numLayers;
                        n22 = n24 + 1;
                        break;
                    }
                    ++n24;
                }
                if (n22 == 0) {
                    throw new Error("Unable to initialize rate allocator");
                }
                if (n22 != progressionArray.length) {
                    Progression[] progressionArray3 = new Progression[n22];
                    int n25 = 0;
                    while (n25 < n22) {
                        progressionArray3[n25] = progressionArray[n25];
                        ++n25;
                    }
                    this.encSpec.ps.setTileDef(n, progressionArray3);
                }
            }
            ++n;
        }
    }

    private float optimizeBitstreamLayer(int n, float f, int n2, int n3) throws IOException {
        float f2;
        this.packetEnc.save();
        int n4 = this.src.getNumTiles();
        int n5 = this.src.getNumComps();
        BitOutputBuffer bitOutputBuffer = null;
        byte[] byArray = null;
        int n6 = 63;
        while (n6 > 0) {
            if (this.RDSlopesRates[n6] >= n2) break;
            --n6;
        }
        float f3 = EBCOTRateAllocator.getSlopeFromSIndex(n6);
        if (f3 >= f) {
            f3 = EBCOTRateAllocator.getSlopeFromSIndex(--n6);
        }
        if (n6 <= 0) {
            f3 = 0.0f;
        }
        if ((f2 = (f + f3) / 2.0f) <= f3) {
            f2 = f;
        }
        do {
            int n7 = n3;
            this.src.setTile(0, 0);
            int n8 = 0;
            while (n8 < n4) {
                int n9 = 0;
                while (n9 < n5) {
                    boolean bl = ((String)this.encSpec.sops.getTileDef(n8)).equalsIgnoreCase("on");
                    boolean bl2 = ((String)this.encSpec.ephs.getTileDef(n8)).equalsIgnoreCase("on");
                    SubbandAn subbandAn = this.src.getSubbandTree(n8, n9);
                    int n10 = subbandAn.resLvl + 1;
                    subbandAn = (SubbandAn)subbandAn.getSubbandByIdx(0, 0);
                    int n11 = 0;
                    while (n11 < n10) {
                        int n12 = 0;
                        Coord[] coordArray = this.packetEnc.getSotEotArrayMax(n8, n9);
                        int n13 = coordArray[0].x;
                        int n14 = coordArray[0].y;
                        int n15 = coordArray[1].x;
                        int n16 = coordArray[1].y;
                        Coord coord = this.packetEnc.getIncArrayMax(n8, n9);
                        int n17 = coord.x;
                        int n18 = coord.y;
                        coord = this.packetEnc.getIncArray(n8, n9, n11);
                        int n19 = coord.x;
                        int n20 = coord.y;
                        coordArray = this.packetEnc.getSotEotArray(n8, n9, n11);
                        int n21 = coordArray[0].x;
                        int n22 = coordArray[0].y;
                        int n23 = n14;
                        while (n23 < n16) {
                            int n24 = n13;
                            while (n24 < n15) {
                                if (!(n24 != n13 && n24 % n19 != 0 || n23 != n14 && n23 % n20 != 0 || n12 >= this.maxNumPrec[n8][n9][n11].x * this.maxNumPrec[n8][n9][n11].y)) {
                                    this.findTruncIndices(n, n9, n11, n8, subbandAn, f2, n12);
                                    bitOutputBuffer = this.packetEnc.encodePacket(n + 1, n9, n11, n8, this.cblks[n8][n9][n11], this.truncIdxs[n8][n][n9][n11], bitOutputBuffer, byArray, n12);
                                    byArray = this.packetEnc.getLastBodyBuf();
                                    n7 += this.bsWriter.writePacketHead(bitOutputBuffer.getBuffer(), bitOutputBuffer.getLength(), true, bl, bl2);
                                    n7 += this.bsWriter.writePacketBody(byArray, this.packetEnc.getLastBodyLen(), true, this.packetEnc.isROIinPkt(), this.packetEnc.getROILen());
                                    ++n12;
                                }
                                n24 += n17;
                            }
                            n23 += n18;
                        }
                        subbandAn = subbandAn.parent;
                        ++n11;
                    }
                    ++n9;
                }
                ++n8;
            }
            if (n7 > n2) {
                f3 = f2;
            } else {
                f = f2;
            }
            f2 = (f + f3) / 2.0f;
            if (f2 <= f3) {
                f2 = f;
            }
            this.packetEnc.restore();
        } while (f2 < f * 0.9999f && f2 < f - 1.0E-10f);
        f2 = f2 <= 1.0E-10f ? 0.0f : f;
        return f2;
    }

    public void runAndWrite() throws IOException {
        this.buildAndWriteLayers();
    }

    public void writeCompPosResLy(int n, int n2, int n3, int n4, int n5, int[][] nArray, int n6) throws IOException {
        int[][] nArray2 = this.packetEnc.getMRL();
        int n7 = this.src.getNumComps();
        BitOutputBuffer bitOutputBuffer = null;
        byte[] byArray = null;
        int n8 = n4;
        while (n8 < n5) {
            boolean bl = ((String)this.encSpec.sops.getTileDef(n)).equalsIgnoreCase("on");
            boolean bl2 = ((String)this.encSpec.ephs.getTileDef(n)).equalsIgnoreCase("on");
            int[][][] nArray3 = new int[n7][nArray2[n][n8] + 1][this.numLayers];
            Coord[] coordArray = this.packetEnc.getSotEotArrayMax(n, n8);
            int n9 = coordArray[0].x;
            int n10 = coordArray[0].y;
            int n11 = coordArray[1].x;
            int n12 = coordArray[1].y;
            Coord coord = this.packetEnc.getIncArrayMax(n, n8);
            int n13 = coord.x;
            int n14 = coord.y;
            int n15 = n10;
            while (n15 < n12) {
                int n16 = n9;
                while (n16 < n11) {
                    int n17 = n2;
                    while (n17 < n3) {
                        if (n17 <= nArray2[n][n8]) {
                            SubbandAn subbandAn = this.src.getSubbandTree(n, n8);
                            int n18 = subbandAn.resLvl + 1;
                            int n19 = n18 - 1;
                            while (n19 > n17) {
                                subbandAn = subbandAn.subb_LL;
                                --n19;
                            }
                            coord = this.packetEnc.getIncArray(n, n8, n17);
                            int n20 = coord.x;
                            int n21 = coord.y;
                            coordArray = this.packetEnc.getSotEotArray(n, n8, n17);
                            int n22 = coordArray[0].x;
                            int n23 = coordArray[0].y;
                            if (!(n16 != n9 && n16 % n20 != 0 || n15 != n10 && n15 % n21 != 0)) {
                                int n24 = nArray[n8][n17];
                                while (n24 < n6) {
                                    if (nArray3[n8][n17][n24] < this.maxNumPrec[n][n8][n17].x * this.maxNumPrec[n][n8][n17].y) {
                                        int n25 = nArray3[n8][n17][n24];
                                        float f = this.layers[n24].rdThreshold;
                                        this.findTruncIndices(n24, n8, n17, n, subbandAn, f, n25);
                                        bitOutputBuffer = this.packetEnc.encodePacket(n24 + 1, n8, n17, n, this.cblks[n][n8][n17], this.truncIdxs[n][n24][n8][n17], bitOutputBuffer, byArray, n25);
                                        if (this.packetEnc.isPacketWritable()) {
                                            this.bsWriter.writePacketHead(bitOutputBuffer.getBuffer(), bitOutputBuffer.getLength(), false, bl, bl2);
                                            this.bsWriter.writePacketBody(this.packetEnc.getLastBodyBuf(), this.packetEnc.getLastBodyLen(), false, this.packetEnc.isROIinPkt(), this.packetEnc.getROILen());
                                        }
                                        int[] nArray4 = nArray3[n8][n17];
                                        int n26 = n24;
                                        nArray4[n26] = nArray4[n26] + 1;
                                    }
                                    ++n24;
                                }
                            }
                        }
                        ++n17;
                    }
                    n16 += n13;
                }
                n15 += n14;
            }
            ++n8;
        }
    }

    public void writeLyResCompPos(int n, int n2, int n3, int n4, int n5, int[][] nArray, int n6) throws IOException {
        int n7;
        int[][] nArray2 = this.packetEnc.getMRL();
        int n8 = this.src.getNumComps();
        BitOutputBuffer bitOutputBuffer = null;
        byte[] byArray = null;
        int n9 = nArray2[n][0];
        int n10 = 0;
        while (n10 < n8) {
            if (nArray2[n][n10] > n9) {
                n9 = nArray2[n][n10];
            }
            ++n10;
        }
        ++n9;
        int n11 = 10000;
        int n12 = n4;
        while (n12 < n5) {
            if (n12 < nArray.length) {
                n7 = n2;
                while (n7 < n3) {
                    if (n7 < nArray[n12].length && nArray[n12][n7] < n11) {
                        n11 = nArray[n12][n7];
                    }
                    ++n7;
                }
            }
            ++n12;
        }
        n7 = n11;
        while (n7 < n6) {
            float f = this.layers[n7].rdThreshold;
            int n13 = n2;
            while (n13 < n3) {
                int n14 = n4;
                while (n14 < n5) {
                    if (n13 <= nArray2[n][n14] && n7 >= nArray[n14][n13]) {
                        int[][][] nArray3 = new int[n8][n9][this.numLayers];
                        Coord[] coordArray = this.packetEnc.getSotEotArrayMax(n, n14);
                        int n15 = coordArray[0].x;
                        int n16 = coordArray[0].y;
                        int n17 = coordArray[1].x;
                        int n18 = coordArray[1].y;
                        Coord coord = this.packetEnc.getIncArrayMax(n, n14);
                        int n19 = coord.x;
                        int n20 = coord.y;
                        coord = this.packetEnc.getIncArray(n, n14, n13);
                        int n21 = coord.x;
                        int n22 = coord.y;
                        coordArray = this.packetEnc.getSotEotArray(n, n14, n13);
                        int n23 = coordArray[0].x;
                        int n24 = coordArray[0].y;
                        int n25 = n16;
                        while (n25 < n18) {
                            int n26 = n15;
                            while (n26 < n17) {
                                if (!(n26 != n15 && n26 % n21 != 0 || n25 != n16 && n25 % n22 != 0)) {
                                    int n27 = nArray3[n14][n13][n7];
                                    if (nArray3[n14][n13][n7] < this.maxNumPrec[n][n14][n13].x * this.maxNumPrec[n][n14][n13].y) {
                                        boolean bl = ((String)this.encSpec.sops.getTileDef(n)).equals("on");
                                        boolean bl2 = ((String)this.encSpec.ephs.getTileDef(n)).equals("on");
                                        SubbandAn subbandAn = this.src.getSubbandTree(n, n14);
                                        int n28 = n9 - 1;
                                        while (n28 > n13) {
                                            subbandAn = subbandAn.subb_LL;
                                            --n28;
                                        }
                                        this.findTruncIndices(n7, n14, n13, n, subbandAn, f, n27);
                                        bitOutputBuffer = this.packetEnc.encodePacket(n7 + 1, n14, n13, n, this.cblks[n][n14][n13], this.truncIdxs[n][n7][n14][n13], bitOutputBuffer, byArray, n27);
                                        if (this.packetEnc.isPacketWritable()) {
                                            this.bsWriter.writePacketHead(bitOutputBuffer.getBuffer(), bitOutputBuffer.getLength(), false, bl, bl2);
                                            this.bsWriter.writePacketBody(this.packetEnc.getLastBodyBuf(), this.packetEnc.getLastBodyLen(), false, this.packetEnc.isROIinPkt(), this.packetEnc.getROILen());
                                        }
                                        int[] nArray4 = nArray3[n14][n13];
                                        int n29 = n7;
                                        nArray4[n29] = nArray4[n29] + 1;
                                    }
                                }
                                n26 += n19;
                            }
                            n25 += n20;
                        }
                    }
                    ++n14;
                }
                ++n13;
            }
            ++n7;
        }
    }

    public void writePosCompResLy(int n, int n2, int n3, int n4, int n5, int[][] nArray, int n6) throws IOException {
        int[][] nArray2 = this.packetEnc.getMRL();
        int n7 = this.src.getNumComps();
        BitOutputBuffer bitOutputBuffer = null;
        byte[] byArray = null;
        int n8 = nArray2[n][0];
        int n9 = 0;
        while (n9 < n7) {
            if (nArray2[n][n9] > n8) {
                n8 = nArray2[n][n9];
            }
            ++n9;
        }
        int[][][] nArray3 = new int[n7][++n8][this.numLayers];
        Coord[] coordArray = this.packetEnc.getSotEotArrayMax(n, 0);
        int n10 = coordArray[0].x;
        int n11 = coordArray[0].y;
        int n12 = coordArray[1].x;
        int n13 = coordArray[1].y;
        Coord coord = this.packetEnc.getIncArrayMax(n, 0);
        int n14 = coord.x;
        int n15 = coord.y;
        int n16 = n11;
        while (n16 < n13) {
            int n17 = n10;
            while (n17 < n12) {
                int n18 = n4;
                while (n18 < n5) {
                    boolean bl = ((String)this.encSpec.sops.getTileDef(n)).equalsIgnoreCase("on");
                    boolean bl2 = ((String)this.encSpec.ephs.getTileDef(n)).equalsIgnoreCase("on");
                    int n19 = n2;
                    while (n19 < n3) {
                        if (n19 <= nArray2[n][n18]) {
                            SubbandAn subbandAn = this.src.getSubbandTree(n, n18);
                            n8 = subbandAn.resLvl + 1;
                            int n20 = n8 - 1;
                            while (n20 > n19) {
                                subbandAn = subbandAn.subb_LL;
                                --n20;
                            }
                            coord = this.packetEnc.getIncArray(n, n18, n19);
                            int n21 = coord.x;
                            int n22 = coord.y;
                            coordArray = this.packetEnc.getSotEotArray(n, n18, n19);
                            int n23 = coordArray[0].x;
                            int n24 = coordArray[0].y;
                            if (!(n17 != n10 && n17 % n21 != 0 || n16 != n11 && n16 % n22 != 0)) {
                                int n25 = nArray[n18][n19];
                                while (n25 < n6) {
                                    if (nArray3[n18][n19][n25] < this.maxNumPrec[n][n18][n19].x * this.maxNumPrec[n][n18][n19].y) {
                                        int n26 = nArray3[n18][n19][n25];
                                        float f = this.layers[n25].rdThreshold;
                                        this.findTruncIndices(n25, n18, n19, n, subbandAn, f, n26);
                                        bitOutputBuffer = this.packetEnc.encodePacket(n25 + 1, n18, n19, n, this.cblks[n][n18][n19], this.truncIdxs[n][n25][n18][n19], bitOutputBuffer, byArray, n26);
                                        if (this.packetEnc.isPacketWritable()) {
                                            this.bsWriter.writePacketHead(bitOutputBuffer.getBuffer(), bitOutputBuffer.getLength(), false, bl, bl2);
                                            this.bsWriter.writePacketBody(this.packetEnc.getLastBodyBuf(), this.packetEnc.getLastBodyLen(), false, this.packetEnc.isROIinPkt(), this.packetEnc.getROILen());
                                        }
                                        int[] nArray4 = nArray3[n18][n19];
                                        int n27 = n25;
                                        nArray4[n27] = nArray4[n27] + 1;
                                    }
                                    ++n25;
                                }
                            }
                        }
                        ++n19;
                    }
                    ++n18;
                }
                n17 += n14;
            }
            n16 += n15;
        }
    }

    public void writeResLyCompPos(int n, int n2, int n3, int n4, int n5, int[][] nArray, int n6) throws IOException {
        int[][] nArray2 = this.packetEnc.getMRL();
        int n7 = this.src.getNumComps();
        BitOutputBuffer bitOutputBuffer = null;
        byte[] byArray = null;
        int n8 = nArray2[n][0];
        int n9 = 0;
        while (n9 < n7) {
            if (nArray2[n][n9] > n8) {
                n8 = nArray2[n][n9];
            }
            ++n9;
        }
        int[][][] nArray3 = new int[n7][++n8][this.numLayers];
        int n10 = n2;
        while (n10 < n3) {
            if (n10 < n8) {
                int n11 = 100000;
                int n12 = n4;
                while (n12 < n5) {
                    if (n10 < nArray[n12].length && nArray[n12][n10] < n11) {
                        n11 = nArray[n12][n10];
                    }
                    ++n12;
                }
                int n13 = n11;
                while (n13 < n6) {
                    int n14 = n4;
                    while (n14 < n5) {
                        if (n10 < nArray[n14].length && n13 >= nArray[n14][n10] && n10 <= nArray2[n][n14]) {
                            Coord[] coordArray = this.packetEnc.getSotEotArrayMax(n, n14);
                            int n15 = coordArray[0].x;
                            int n16 = coordArray[0].y;
                            int n17 = coordArray[1].x;
                            int n18 = coordArray[1].y;
                            Coord coord = this.packetEnc.getIncArrayMax(n, n14);
                            int n19 = coord.x;
                            int n20 = coord.y;
                            coord = this.packetEnc.getIncArray(n, n14, n10);
                            int n21 = coord.x;
                            int n22 = coord.y;
                            coordArray = this.packetEnc.getSotEotArray(n, n14, n10);
                            int n23 = coordArray[0].x;
                            int n24 = coordArray[0].y;
                            int n25 = n16;
                            while (n25 < n18) {
                                int n26 = n15;
                                while (n26 < n17) {
                                    if (!(n26 != n15 && n26 % n21 != 0 || n25 != n16 && n25 % n22 != 0 || nArray3[n14][n10][n13] >= this.maxNumPrec[n][n14][n10].x * this.maxNumPrec[n][n14][n10].y)) {
                                        int n27 = nArray3[n14][n10][n13];
                                        boolean bl = ((String)this.encSpec.sops.getTileDef(n)).equals("on");
                                        boolean bl2 = ((String)this.encSpec.ephs.getTileDef(n)).equals("on");
                                        SubbandAn subbandAn = this.src.getSubbandTree(n, n14);
                                        int n28 = nArray2[n][n14];
                                        while (n28 > n10) {
                                            subbandAn = subbandAn.subb_LL;
                                            --n28;
                                        }
                                        float f = this.layers[n13].rdThreshold;
                                        this.findTruncIndices(n13, n14, n10, n, subbandAn, f, n27);
                                        bitOutputBuffer = this.packetEnc.encodePacket(n13 + 1, n14, n10, n, this.cblks[n][n14][n10], this.truncIdxs[n][n13][n14][n10], bitOutputBuffer, byArray, n27);
                                        if (this.packetEnc.isPacketWritable()) {
                                            this.bsWriter.writePacketHead(bitOutputBuffer.getBuffer(), bitOutputBuffer.getLength(), false, bl, bl2);
                                            this.bsWriter.writePacketBody(this.packetEnc.getLastBodyBuf(), this.packetEnc.getLastBodyLen(), false, this.packetEnc.isROIinPkt(), this.packetEnc.getROILen());
                                        }
                                        int[] nArray4 = nArray3[n14][n10];
                                        int n29 = n13;
                                        nArray4[n29] = nArray4[n29] + 1;
                                    }
                                    n26 += n19;
                                }
                                n25 += n20;
                            }
                        }
                        ++n14;
                    }
                    ++n13;
                }
            }
            ++n10;
        }
    }

    public void writeResPosCompLy(int n, int n2, int n3, int n4, int n5, int[][] nArray, int n6) throws IOException {
        int[][] nArray2 = this.packetEnc.getMRL();
        int n7 = this.src.getNumComps();
        BitOutputBuffer bitOutputBuffer = null;
        byte[] byArray = null;
        int n8 = nArray2[n][0];
        int n9 = 0;
        while (n9 < n7) {
            if (nArray2[n][n9] > n8) {
                n8 = nArray2[n][n9];
            }
            ++n9;
        }
        int[][][] nArray3 = new int[n7][++n8][this.numLayers];
        Coord[] coordArray = this.packetEnc.getSotEotArrayMax(n, 0);
        int n10 = coordArray[0].x;
        int n11 = coordArray[0].y;
        int n12 = coordArray[1].x;
        int n13 = coordArray[1].y;
        Coord coord = this.packetEnc.getIncArrayMax(n, 0);
        int n14 = coord.x;
        int n15 = coord.y;
        int n16 = n2;
        while (n16 < n3) {
            int n17 = n11;
            while (n17 < n13) {
                int n18 = n10;
                while (n18 < n12) {
                    int n19 = n4;
                    while (n19 < n5) {
                        if (n16 <= nArray2[n][n19]) {
                            boolean bl = ((String)this.encSpec.sops.getTileDef(n)).equalsIgnoreCase("on");
                            boolean bl2 = ((String)this.encSpec.ephs.getTileDef(n)).equalsIgnoreCase("on");
                            SubbandAn subbandAn = this.src.getSubbandTree(n, n19);
                            n8 = subbandAn.resLvl + 1;
                            int n20 = n8 - 1;
                            while (n20 > n16) {
                                subbandAn = subbandAn.subb_LL;
                                --n20;
                            }
                            coord = this.packetEnc.getIncArray(n, n19, n16);
                            int n21 = coord.x;
                            int n22 = coord.y;
                            coordArray = this.packetEnc.getSotEotArray(n, n19, n16);
                            int n23 = coordArray[0].x;
                            int n24 = coordArray[0].y;
                            if (!(n18 != n10 && n18 % n21 != 0 || n17 != n11 && n17 % n22 != 0)) {
                                int n25 = nArray[n19][n16];
                                while (n25 < n6) {
                                    if (nArray3[n19][n16][n25] < this.maxNumPrec[n][n19][n16].x * this.maxNumPrec[n][n19][n16].y) {
                                        int n26 = nArray3[n19][n16][n25];
                                        float f = this.layers[n25].rdThreshold;
                                        this.findTruncIndices(n25, n19, n16, n, subbandAn, f, n26);
                                        bitOutputBuffer = this.packetEnc.encodePacket(n25 + 1, n19, n16, n, this.cblks[n][n19][n16], this.truncIdxs[n][n25][n19][n16], bitOutputBuffer, byArray, n26);
                                        if (this.packetEnc.isPacketWritable()) {
                                            this.bsWriter.writePacketHead(bitOutputBuffer.getBuffer(), bitOutputBuffer.getLength(), false, bl, bl2);
                                            this.bsWriter.writePacketBody(this.packetEnc.getLastBodyBuf(), this.packetEnc.getLastBodyLen(), false, this.packetEnc.isROIinPkt(), this.packetEnc.getROILen());
                                        }
                                        int[] nArray4 = nArray3[n19][n16];
                                        int n27 = n25;
                                        nArray4[n27] = nArray4[n27] + 1;
                                    }
                                    ++n25;
                                }
                            }
                        }
                        ++n19;
                    }
                    n18 += n14;
                }
                n17 += n15;
            }
            ++n16;
        }
    }
}

