/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.entropy.encoder;

import jj2000.j2k.entropy.encoder.ByteOutputBuffer;

class BitToByteOutput {
    static final int PAD_SEQ = 42;
    boolean delFF = false;
    ByteOutputBuffer out;
    int bbuf;
    int bpos = 7;
    int nb = 0;

    BitToByteOutput(ByteOutputBuffer byteOutputBuffer) {
        this.out = byteOutputBuffer;
    }

    void flush() {
        if (this.delFF) {
            if (this.bpos != 6) {
                this.out.write(255);
                this.delFF = false;
                ++this.nb;
                this.bbuf |= 42 >>> 6 - this.bpos;
                this.out.write(this.bbuf);
                ++this.nb;
                this.bpos = 7;
                this.bbuf = 0;
            }
        } else if (this.bpos != 7) {
            this.bbuf |= 42 >>> 6 - this.bpos;
            this.out.write(this.bbuf);
            ++this.nb;
            this.bpos = 7;
            this.bbuf = 0;
        }
    }

    int length() {
        if (this.delFF) {
            return this.nb + (this.bpos == 6 ? 0 : 2);
        }
        return this.nb + (this.bpos == 7 ? 0 : 1);
    }

    void reset() {
        this.delFF = false;
        this.bpos = 7;
        this.bbuf = 0;
        this.nb = 0;
    }

    public void terminate() {
        this.flush();
        this.reset();
    }

    final void writeBit(int n) {
        this.bbuf |= (n & 1) << this.bpos--;
        if (this.bpos < 0) {
            if (this.bbuf != 255) {
                if (this.delFF) {
                    this.out.write(255);
                    this.delFF = false;
                    ++this.nb;
                }
                this.out.write(this.bbuf);
                ++this.nb;
                this.bpos = 7;
            } else {
                this.delFF = true;
                this.bpos = 6;
            }
            this.bbuf = 0;
        }
    }

    final void writeBits(int[] nArray, int n) {
        int n2 = this.bbuf;
        int n3 = this.bpos;
        int n4 = 0;
        while (n4 < n) {
            n2 |= (nArray[n4] & 1) << n3--;
            if (n3 < 0) {
                if (n2 != 255) {
                    if (this.delFF) {
                        this.out.write(255);
                        this.delFF = false;
                        ++this.nb;
                    }
                    this.out.write(n2);
                    ++this.nb;
                    n3 = 7;
                } else {
                    this.delFF = true;
                    n3 = 6;
                }
                n2 = 0;
            }
            ++n4;
        }
        this.bbuf = n2;
        this.bpos = n3;
    }
}

