/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.entropy.decoder;

import jj2000.j2k.entropy.decoder.ByteInputBuffer;
import jj2000.j2k.util.ArrayUtil;

public class MQDecoder {
    static final int[] qe = new int[]{22017, 13313, 6145, 2753, 1313, 545, 22017, 21505, 18433, 14337, 12289, 9217, 7169, 5633, 22017, 21505, 20737, 18433, 14337, 13313, 12289, 10241, 9217, 8705, 7169, 6145, 5633, 5121, 4609, 4353, 2753, 2497, 2209, 1313, 1089, 673, 545, 321, 273, 133, 73, 37, 21, 9, 5, 1, 22017};
    static final int[] nMPS = new int[]{1, 2, 3, 4, 5, 38, 7, 8, 9, 10, 11, 12, 13, 29, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 45, 46};
    static final int[] nLPS = new int[]{1, 6, 9, 12, 29, 33, 6, 14, 14, 14, 17, 18, 20, 21, 14, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 46};
    static final int[] switchLM;
    ByteInputBuffer in;
    int[] mPS;
    int[] I;
    int c;
    int cT;
    int a;
    int b;
    boolean markerFound;
    final int[] initStates;

    static {
        int[] nArray = new int[47];
        nArray[0] = 1;
        nArray[6] = 1;
        nArray[14] = 1;
        switchLM = nArray;
    }

    public MQDecoder(ByteInputBuffer byteInputBuffer, int n, int[] nArray) {
        this.in = byteInputBuffer;
        this.I = new int[n];
        this.mPS = new int[n];
        this.initStates = nArray;
        this.init();
        this.resetCtxts();
    }

    private void byteIn() {
        if (!this.markerFound) {
            if (this.b == 255) {
                this.b = this.in.read() & 0xFF;
                if (this.b > 143) {
                    this.markerFound = true;
                    this.cT = 8;
                } else {
                    this.c += 65024 - (this.b << 9);
                    this.cT = 7;
                }
            } else {
                this.b = this.in.read() & 0xFF;
                this.c += 65280 - (this.b << 8);
                this.cT = 8;
            }
        } else {
            this.cT = 8;
        }
    }

    public boolean checkPredTerm() {
        if (this.b != 255 && !this.markerFound) {
            return true;
        }
        if (this.cT != 0 && !this.markerFound) {
            return true;
        }
        if (this.cT == 1) {
            return false;
        }
        if (this.cT == 0) {
            if (!this.markerFound) {
                this.b = this.in.read() & 0xFF;
                if (this.b <= 143) {
                    return true;
                }
            }
            this.cT = 8;
        }
        int n = this.cT - 1;
        int n2 = 32768 >> n;
        this.a -= n2;
        if (this.c >>> 16 < this.a) {
            return true;
        }
        this.c -= this.a << 16;
        this.a = n2;
        do {
            if (this.cT == 0) {
                this.byteIn();
            }
            this.a <<= 1;
            this.c <<= 1;
            --this.cT;
        } while (this.a < 32768);
        return false;
    }

    public final int decodeSymbol(int n) {
        int n2;
        int n3 = this.I[n];
        int n4 = qe[n3];
        this.a -= n4;
        if (this.c >>> 16 < this.a) {
            if (this.a >= 32768) {
                n2 = this.mPS[n];
            } else {
                int n5 = this.a;
                if (n5 >= n4) {
                    n2 = this.mPS[n];
                    this.I[n] = nMPS[n3];
                    if (this.cT == 0) {
                        this.byteIn();
                    }
                    n5 <<= 1;
                    this.c <<= 1;
                    --this.cT;
                } else {
                    n2 = 1 - this.mPS[n];
                    if (switchLM[n3] == 1) {
                        this.mPS[n] = 1 - this.mPS[n];
                    }
                    this.I[n] = nLPS[n3];
                    do {
                        if (this.cT == 0) {
                            this.byteIn();
                        }
                        this.c <<= 1;
                        --this.cT;
                    } while ((n5 <<= 1) < 32768);
                }
                this.a = n5;
            }
        } else {
            int n6 = this.a;
            this.c -= n6 << 16;
            if (n6 < n4) {
                n6 = n4;
                n2 = this.mPS[n];
                this.I[n] = nMPS[n3];
                if (this.cT == 0) {
                    this.byteIn();
                }
                n6 <<= 1;
                this.c <<= 1;
                --this.cT;
            } else {
                n6 = n4;
                n2 = 1 - this.mPS[n];
                if (switchLM[n3] == 1) {
                    this.mPS[n] = 1 - this.mPS[n];
                }
                this.I[n] = nLPS[n3];
                do {
                    if (this.cT == 0) {
                        this.byteIn();
                    }
                    this.c <<= 1;
                    --this.cT;
                } while ((n6 <<= 1) < 32768);
            }
            this.a = n6;
        }
        return n2;
    }

    public final void decodeSymbols(int[] nArray, int[] nArray2, int n) {
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4 = nArray2[n2];
            int n5 = this.I[n4];
            int n6 = qe[n5];
            this.a -= n6;
            if (this.c >>> 16 < this.a) {
                if (this.a >= 32768) {
                    nArray[n2] = this.mPS[n4];
                } else {
                    n3 = this.a;
                    if (n3 >= n6) {
                        nArray[n2] = this.mPS[n4];
                        this.I[n4] = nMPS[n5];
                        if (this.cT == 0) {
                            this.byteIn();
                        }
                        n3 <<= 1;
                        this.c <<= 1;
                        --this.cT;
                    } else {
                        nArray[n2] = 1 - this.mPS[n4];
                        if (switchLM[n5] == 1) {
                            this.mPS[n4] = 1 - this.mPS[n4];
                        }
                        this.I[n4] = nLPS[n5];
                        do {
                            if (this.cT == 0) {
                                this.byteIn();
                            }
                            this.c <<= 1;
                            --this.cT;
                        } while ((n3 <<= 1) < 32768);
                    }
                    this.a = n3;
                }
            } else {
                n3 = this.a;
                this.c -= n3 << 16;
                if (n3 < n6) {
                    n3 = n6;
                    nArray[n2] = this.mPS[n4];
                    this.I[n4] = nMPS[n5];
                    if (this.cT == 0) {
                        this.byteIn();
                    }
                    n3 <<= 1;
                    this.c <<= 1;
                    --this.cT;
                } else {
                    n3 = n6;
                    nArray[n2] = 1 - this.mPS[n4];
                    if (switchLM[n5] == 1) {
                        this.mPS[n4] = 1 - this.mPS[n4];
                    }
                    this.I[n4] = nLPS[n5];
                    do {
                        if (this.cT == 0) {
                            this.byteIn();
                        }
                        this.c <<= 1;
                        --this.cT;
                    } while ((n3 <<= 1) < 32768);
                }
                this.a = n3;
            }
            ++n2;
        }
    }

    public final boolean fastDecodeSymbols(int[] nArray, int n, int n2) {
        int n3 = this.I[n];
        int n4 = qe[n3];
        if (n4 < 16384 && n2 <= (this.a - (this.c >>> 16) - 1) / n4 && n2 <= (this.a - 32768) / n4 + 1) {
            this.a -= n2 * n4;
            if (this.a >= 32768) {
                nArray[0] = this.mPS[n];
                return true;
            }
            this.I[n] = nMPS[n3];
            if (this.cT == 0) {
                this.byteIn();
            }
            this.a <<= 1;
            this.c <<= 1;
            --this.cT;
            nArray[0] = this.mPS[n];
            return true;
        }
        int n5 = this.a;
        int n6 = 0;
        while (n6 < n2) {
            if (this.c >>> 16 < (n5 -= n4)) {
                if (n5 >= 32768) {
                    nArray[n6] = this.mPS[n];
                } else if (n5 >= n4) {
                    nArray[n6] = this.mPS[n];
                    n3 = nMPS[n3];
                    n4 = qe[n3];
                    if (this.cT == 0) {
                        this.byteIn();
                    }
                    n5 <<= 1;
                    this.c <<= 1;
                    --this.cT;
                } else {
                    nArray[n6] = 1 - this.mPS[n];
                    if (switchLM[n3] == 1) {
                        this.mPS[n] = 1 - this.mPS[n];
                    }
                    n3 = nLPS[n3];
                    n4 = qe[n3];
                    do {
                        if (this.cT == 0) {
                            this.byteIn();
                        }
                        this.c <<= 1;
                        --this.cT;
                    } while ((n5 <<= 1) < 32768);
                }
            } else {
                this.c -= n5 << 16;
                if (n5 < n4) {
                    n5 = n4;
                    nArray[n6] = this.mPS[n];
                    n3 = nMPS[n3];
                    n4 = qe[n3];
                    if (this.cT == 0) {
                        this.byteIn();
                    }
                    n5 <<= 1;
                    this.c <<= 1;
                    --this.cT;
                } else {
                    n5 = n4;
                    nArray[n6] = 1 - this.mPS[n];
                    if (switchLM[n3] == 1) {
                        this.mPS[n] = 1 - this.mPS[n];
                    }
                    n3 = nLPS[n3];
                    n4 = qe[n3];
                    do {
                        if (this.cT == 0) {
                            this.byteIn();
                        }
                        this.c <<= 1;
                        --this.cT;
                    } while ((n5 <<= 1) < 32768);
                }
            }
            ++n6;
        }
        this.a = n5;
        this.I[n] = n3;
        return false;
    }

    public ByteInputBuffer getByteInputBuffer() {
        return this.in;
    }

    public final int getNumCtxts() {
        return this.I.length;
    }

    private void init() {
        this.markerFound = false;
        this.b = this.in.read() & 0xFF;
        this.c = (this.b ^ 0xFF) << 16;
        this.byteIn();
        this.c <<= 7;
        this.cT -= 7;
        this.a = 32768;
    }

    public final void nextSegment(byte[] byArray, int n, int n2) {
        this.in.setByteArray(byArray, n, n2);
        this.init();
    }

    public final void resetCtxt(int n) {
        this.I[n] = this.initStates[n];
        this.mPS[n] = 0;
    }

    public final void resetCtxts() {
        System.arraycopy(this.initStates, 0, this.I, 0, this.I.length);
        ArrayUtil.intArraySet(this.mPS, 0);
    }
}

