/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.entropy.decoder;

import java.io.EOFException;
import java.io.IOException;

public class ByteInputBuffer {
    byte[] buf;
    int count;
    int pos;

    public ByteInputBuffer(byte[] byArray) {
        this.buf = byArray;
        this.count = byArray.length;
    }

    public ByteInputBuffer(byte[] byArray, int n, int n2) {
        this.buf = byArray;
        this.pos = n;
        this.count = n + n2;
    }

    public synchronized void addByteArray(byte[] byArray, int n, int n2) {
        if (n2 < 0 || n < 0 || n2 + n > this.buf.length) {
            throw new IllegalArgumentException();
        }
        if (this.count + n2 <= this.buf.length) {
            System.arraycopy(byArray, n, this.buf, this.count, n2);
            this.count += n2;
        } else {
            if (this.count - this.pos + n2 <= this.buf.length) {
                System.arraycopy(this.buf, this.pos, this.buf, 0, this.count - this.pos);
            } else {
                byte[] byArray2 = this.buf;
                this.buf = new byte[this.count - this.pos + n2];
                System.arraycopy(byArray2, this.count, this.buf, 0, this.count - this.pos);
            }
            this.count -= this.pos;
            this.pos = 0;
            System.arraycopy(byArray, n, this.buf, this.count, n2);
            this.count += n2;
        }
    }

    public int read() {
        if (this.pos < this.count) {
            return this.buf[this.pos++] & 0xFF;
        }
        return -1;
    }

    public int readChecked() throws IOException {
        if (this.pos < this.count) {
            return this.buf[this.pos++] & 0xFF;
        }
        throw new EOFException();
    }

    public void setByteArray(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            if (n2 < 0 || this.count + n2 > this.buf.length) {
                throw new IllegalArgumentException();
            }
            if (n < 0) {
                this.pos = this.count;
                this.count += n2;
            } else {
                this.count = n + n2;
                this.pos = n;
            }
        } else {
            if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
                throw new IllegalArgumentException();
            }
            this.buf = byArray;
            this.count = n + n2;
            this.pos = n;
        }
    }
}

