/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.decoder;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import jj2000.disp.ImgKeyListener;
import jj2000.disp.ImgMouseListener;
import jj2000.disp.ImgScrollPane;
import jj2000.j2k.decoder.Decoder;
import jj2000.j2k.util.ParameterList;

public class SimpleAppletDecoder
extends Applet
implements Runnable {
    private static String[][] pinfo = Decoder.getAllParameters();
    private Decoder dec;
    private ParameterList pl;
    private Thread decThread;
    private boolean decStarted;
    private ImgScrollPane isp;

    /*
     * Unable to fully structure code
     */
    public void destroy() {
        if (this.decStarted) ** GOTO lbl9
        return;
lbl-1000:
        // 1 sources

        {
            try {
                Thread.currentThread();
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException v0) {}
lbl9:
            // 3 sources

            ** while (this.decThread != null && this.decThread.isAlive())
        }
lbl10:
        // 1 sources

        this.decThread = null;
    }

    public String getAppletInfo() {
        return "JJ2000's JPEG 2000 simple applet decoder\nVersion: 4.1\nCopyright:\n\nThis software module was originally developed by Rapha\u00ebl Grosbois and Diego Santa Cruz (Swiss Federal Institute of Technology-EPFL); Joel Askel\u00f6f (Ericsson Radio Systems AB); and Bertrand Berthelot, David Bouchard, F\u00e9lix Henry, Gerard Mozelle and Patrice Onno (Canon Research Centre France S.A) in the course of development of the JPEG 2000 standard as specified by ISO/IEC 15444 (JPEG 2000 Standard). This software module is an implementation of a part of the JPEG 2000 Standard. Swiss Federal Institute of Technology-EPFL, Ericsson Radio Systems AB and Canon Research Centre France S.A (collectively JJ2000 Partners) agree not to assert against ISO/IEC and users of the JPEG 2000 Standard (Users) any of their rights under the copyright, not including other intellectual property rights, for this software module with respect to the usage by ISO/IEC and Users of this software module or modifications thereof for use in hardware or software products claiming conformance to the JPEG 2000 Standard. Those intending to use this software module in hardware or software products are advised that their use may infringe existing patents. The original developers of this software module, JJ2000 Partners and ISO/IEC assume no liability for use of this software module or modifications thereof. No license or right to this software module is granted for non JPEG 2000 Standard conforming products. JJ2000 Partners have full right to use this software module for his/her own purpose, assign or donate this software module to any third party and to inhibit third parties from using this software module for non JPEG 2000 Standard conforming products. This copyright notice must be included in all copies or derivative works of this software module.\n\nCopyright (c) 1999/2000 JJ2000 Partners.\nSend bug reports to: jj2000-bugs@ltssg3.epfl.ch\n";
    }

    public String[][] getParameterInfo() {
        return pinfo;
    }

    public void init() {
        URL uRL;
        String string;
        ParameterList parameterList = new ParameterList();
        int n = pinfo.length - 1;
        while (n >= 0) {
            if (pinfo[n][3] != null) {
                ((Hashtable)parameterList).put(pinfo[n][0], pinfo[n][3]);
            }
            --n;
        }
        this.pl = new ParameterList(parameterList);
        n = 0;
        while (n < pinfo.length) {
            string = this.getParameter(pinfo[n][0]);
            if (string != null) {
                ((Hashtable)this.pl).put(pinfo[n][0], string);
            }
            ++n;
        }
        string = this.pl.getParameter("i");
        if (string != null) {
            try {
                uRL = new URL(this.getDocumentBase(), string);
            }
            catch (MalformedURLException malformedURLException) {
                throw new IllegalArgumentException("Malformed URL in parameter 'i'");
            }
        } else {
            throw new IllegalArgumentException("Missing input");
        }
        string = uRL.toExternalForm();
        ((Hashtable)this.pl).put("i", string);
        if (this.pl.getParameter("o") != null) {
            throw new IllegalArgumentException("Can not specify output files for applet");
        }
        this.setLayout(new BorderLayout());
        this.isp = new ImgScrollPane(0);
        this.add((Component)this.isp, "Center");
        this.validate();
        this.setVisible(true);
        this.decThread = new Thread(this);
        this.decStarted = false;
    }

    public void run() {
        int n;
        if (this.dec != null) {
            return;
        }
        this.showStatus("Initializing JJ2000 decoder...");
        this.dec = new Decoder(this.pl, this.isp);
        this.dec.setChildProcess(true);
        this.showStatus("Decoding...");
        this.dec.run();
        Image image = this.isp.getImage();
        do {
            if (((n = this.isp.checkImage(image, null)) & 0x40) != 0) {
                this.showStatus("An unknown error occurred while producing the image");
                return;
            }
            if ((n & 0x80) != 0) {
                this.showStatus("Image production was aborted for some unknown reason");
                continue;
            }
            if ((n & 0x20) != 0) {
                this.showStatus("Done.");
                continue;
            }
            try {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        } while ((n & 0xE0) == 0);
        if ((n & 0x40) == 0) {
            ImgMouseListener imgMouseListener = new ImgMouseListener(this.isp);
            this.isp.addKeyListener(new ImgKeyListener(this.isp, this.dec));
            this.isp.addMouseListener(imgMouseListener);
            this.isp.addMouseMotionListener(imgMouseListener);
        }
    }

    public void start() {
        if (this.decStarted) {
            return;
        }
        this.decStarted = true;
        this.decThread.start();
    }

    public void stop() {
    }
}

