/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.decoder;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Insets;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Vector;
import jj2000.disp.BlkImgDataSrcImageProducer;
import jj2000.disp.ExitHandler;
import jj2000.disp.ImgKeyListener;
import jj2000.disp.ImgMouseListener;
import jj2000.disp.ImgScrollPane;
import jj2000.disp.TitleUpdater;
import jj2000.j2k.codestream.reader.BitstreamReaderAgent;
import jj2000.j2k.codestream.reader.HeaderDecoder;
import jj2000.j2k.decoder.DecoderSpecs;
import jj2000.j2k.entropy.decoder.EntropyDecoder;
import jj2000.j2k.fileformat.reader.FileFormatReader;
import jj2000.j2k.image.BlkImgDataSrc;
import jj2000.j2k.image.ImgDataConverter;
import jj2000.j2k.image.invcomptransf.InvCompTransf;
import jj2000.j2k.image.output.ImgWriter;
import jj2000.j2k.image.output.ImgWriterPGM;
import jj2000.j2k.image.output.ImgWriterPGX;
import jj2000.j2k.image.output.ImgWriterPPM;
import jj2000.j2k.io.BEBufferedRandomAccessFile;
import jj2000.j2k.io.RandomAccessIO;
import jj2000.j2k.quantization.dequantizer.Dequantizer;
import jj2000.j2k.roi.ROIDeScaler;
import jj2000.j2k.util.FacilityManager;
import jj2000.j2k.util.ISRandomAccessIO;
import jj2000.j2k.util.MsgLogger;
import jj2000.j2k.util.ParameterList;
import jj2000.j2k.util.StringFormatException;
import jj2000.j2k.wavelet.synthesis.InverseWT;

public class Decoder
implements Runnable {
    TitleUpdater title = null;
    private boolean isChildProcess = false;
    private int exitCode;
    private ParameterList pl;
    private ParameterList defpl;
    private static final char[] vprfxs = new char[]{'B', 'C', 'R', 'Q', 'M', 'H'};
    private Frame win = null;
    private ImgScrollPane isp;
    private static final String[][] pinfo = new String[][]{{"u", "[on|off]", "Prints usage information. If specified all other arguments (except 'v') are ignored", "off"}, {"v", "[on|off]", "Prints version and copyright information", "off"}, {"verbose", "[on|off]", "Prints information about the decoded codestream", "on"}, {"pfile", "<filename>", "Loads the arguments from the specified file. Arguments that are specified on the command line override the ones from the file.\nThe arguments file is a simple text file with one argument per line of the following form:\n  <argument name>=<argument value>\nIf the argument is of boolean type (i.e. its presence turns a feature on), then the 'on' value turns it on, while the 'off' value turns it off. The argument name does not include the '-' or '+' character. Long lines can be broken into several lines by terminating them with '\\'. Lines starting with '#' are considered as comments. This option is not recursive: any 'pfile' argument appearing in the file is ignored.", null}, {"res", "<resolution level index>", "Specifies the resolution level wanted for the decoded image (0 means the lowest available resolution, the last resolution  level gives an image with original dimension). If given index is greater than the number of available resolution levels of the compressed image, the decoded image has the lowest available resolution (among all tile-components). Note that this option affects only the inverse wavelet transform and not the number  of bytes read by the codestream parser: this number of bytes depends only on options '-nbytes' or '-rate'.", null}, {"i", "<filename or url>", "The file containing the JPEG 2000 compressed data. This can be either a JPEG 2000 codestream or a JP2 file containing a JPEG 2000 codestream. In the latter case the first codestream in the file will be decoded. If an URL is specified (e.g., http://...) the data will be downloaded and cached in memory before decoding. This is intended for easy use in applets, but it is not a very efficient way of decoding network served data.", null}, {"o", "<filename>", "This is the name of the file to which the decompressed image is written. If no output filename is given, the image is displayed on the screen. Output file format is PGX by default. If the extension is '.pgm' then a PGM file is written as output, however this is only permitted if the component bitdepth does not exceed 8. If the extension is '.ppm' then a PPM file is written, however this is only permitted if there are 3 components and none of them has a bitdepth of more than 8. If there is more than 1 component, suffices '-1', '-2', '-3', ... are added to the file name, just before the extension, except for PPM files where all three components are written to the same file.", null}, {"rate", "<decoding rate in bpp>", "Specifies the decoding rate in bits per pixel (bpp) where the number of pixels is related to the image's original size (Note: this number is not affected by the '-res' option). The codestream is either parsed (default) or truncated depending the command line option '-parsing'. To specify the decoding rate in bytes, use '-nbytes' options instead.", "100"}, {"nbytes", "<decoding rate in bytes>", "Specifies the decoding rate in bytes. The codestream is either parsed (default) or truncated depending the command line option '-parsing'. To specify the decoding rate in bits per pixel, use '-rate' options instead.", "-1"}, {"parsing", null, "Enable or not the parsing mode when decoding rate is specified ('-nbytes' or '-rate' options). If it is false, the codestream is decoded as if it were truncated to the given rate. If it is true, the decoder creates, truncates and decodes a virtual layer progressive codestream with the same truncation points in each code-block.", "on"}, {"debug", null, "Print debugging messages when an error is encountered.", "off"}, {"cdstr_info", null, "Display information about the codestream. This information is: \n- Marker segments value in main and tile-part headers,\n- Tile-part length and position within the code-stream.", "off"}};

    public Decoder(ParameterList parameterList) {
        this(parameterList, null);
    }

    public Decoder(ParameterList parameterList, ImgScrollPane imgScrollPane) {
        this.pl = parameterList;
        this.defpl = parameterList.getDefaultParameterList();
        this.isp = imgScrollPane;
    }

    private void error(String string, int n) {
        this.exitCode = n;
        FacilityManager.getMsgLogger().printmsg(3, string);
    }

    public void exit() {
        if (this.isChildProcess) {
            if (this.win != null) {
                this.win.dispose();
            }
            if (this.title != null) {
                this.title.done = true;
            }
            return;
        }
        System.exit(0);
    }

    public static String[][] getAllParameters() {
        int n;
        Vector<String[]> vector = new Vector<String[]>();
        String[][] stringArray = BitstreamReaderAgent.getParameterInfo();
        if (stringArray != null) {
            n = stringArray.length - 1;
            while (n >= 0) {
                vector.addElement(stringArray[n]);
                --n;
            }
        }
        if ((stringArray = EntropyDecoder.getParameterInfo()) != null) {
            n = stringArray.length - 1;
            while (n >= 0) {
                vector.addElement(stringArray[n]);
                --n;
            }
        }
        if ((stringArray = ROIDeScaler.getParameterInfo()) != null) {
            n = stringArray.length - 1;
            while (n >= 0) {
                vector.addElement(stringArray[n]);
                --n;
            }
        }
        if ((stringArray = Dequantizer.getParameterInfo()) != null) {
            n = stringArray.length - 1;
            while (n >= 0) {
                vector.addElement(stringArray[n]);
                --n;
            }
        }
        if ((stringArray = InvCompTransf.getParameterInfo()) != null) {
            n = stringArray.length - 1;
            while (n >= 0) {
                vector.addElement(stringArray[n]);
                --n;
            }
        }
        if ((stringArray = HeaderDecoder.getParameterInfo()) != null) {
            n = stringArray.length - 1;
            while (n >= 0) {
                vector.addElement(stringArray[n]);
                --n;
            }
        }
        if ((stringArray = Decoder.getParameterInfo()) != null) {
            n = stringArray.length - 1;
            while (n >= 0) {
                vector.addElement(stringArray[n]);
                --n;
            }
        }
        if ((stringArray = new String[vector.size()][4]) != null) {
            n = stringArray.length - 1;
            while (n >= 0) {
                stringArray[n] = (String[])vector.elementAt(n);
                --n;
            }
        }
        return stringArray;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public static String[][] getParameterInfo() {
        return pinfo;
    }

    private void printParamInfo(MsgLogger msgLogger, String[][] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            String string = this.defpl.getParameter(stringArray[n][0]);
            if (string != null) {
                msgLogger.println("-" + stringArray[n][0] + (stringArray[n][1] != null ? " " + stringArray[n][1] + " " : " ") + "(default = " + string + ")", 4, 8);
            } else {
                msgLogger.println("-" + stringArray[n][0] + (stringArray[n][1] != null ? " " + stringArray[n][1] : ""), 4, 8);
            }
            if (stringArray[n][2] != null) {
                msgLogger.println(stringArray[n][2], 6, 6);
            }
            ++n;
        }
    }

    private void printUsage() {
        MsgLogger msgLogger = FacilityManager.getMsgLogger();
        msgLogger.println("Usage:", 0, 0);
        msgLogger.println("JJ2KDecoder args...\n", 10, 12);
        msgLogger.println("The exit code of the decoder is non-zero if an error occurs.", 2, 4);
        msgLogger.println("The following arguments are recongnized:\n", 2, 4);
        this.printParamInfo(msgLogger, Decoder.getAllParameters());
        FacilityManager.getMsgLogger().println("\n\n", 0, 0);
        FacilityManager.getMsgLogger().println("Send bug reports to: jj2000-bugs@ltssg3.epfl.ch\n", 2, 4);
    }

    private void printVersionAndCopyright() {
        FacilityManager.getMsgLogger().println("JJ2000's JPEG 2000 Decoder\n", 2, 4);
        FacilityManager.getMsgLogger().println("Version: 4.1\n", 2, 4);
        FacilityManager.getMsgLogger().println("Copyright:\n\nThis software module was originally developed by Rapha\u00ebl Grosbois and Diego Santa Cruz (Swiss Federal Institute of Technology-EPFL); Joel Askel\u00f6f (Ericsson Radio Systems AB); and Bertrand Berthelot, David Bouchard, F\u00e9lix Henry, Gerard Mozelle and Patrice Onno (Canon Research Centre France S.A) in the course of development of the JPEG 2000 standard as specified by ISO/IEC 15444 (JPEG 2000 Standard). This software module is an implementation of a part of the JPEG 2000 Standard. Swiss Federal Institute of Technology-EPFL, Ericsson Radio Systems AB and Canon Research Centre France S.A (collectively JJ2000 Partners) agree not to assert against ISO/IEC and users of the JPEG 2000 Standard (Users) any of their rights under the copyright, not including other intellectual property rights, for this software module with respect to the usage by ISO/IEC and Users of this software module or modifications thereof for use in hardware or software products claiming conformance to the JPEG 2000 Standard. Those intending to use this software module in hardware or software products are advised that their use may infringe existing patents. The original developers of this software module, JJ2000 Partners and ISO/IEC assume no liability for use of this software module or modifications thereof. No license or right to this software module is granted for non JPEG 2000 Standard conforming products. JJ2000 Partners have full right to use this software module for his/her own purpose, assign or donate this software module to any third party and to inhibit third parties from using this software module for non JPEG 2000 Standard conforming products. This copyright notice must be included in all copies or derivative works of this software module.\n\nCopyright (c) 1999/2000 JJ2000 Partners.\n", 2, 4);
        FacilityManager.getMsgLogger().println("Send bug reports to: jj2000-bugs@ltssg3.epfl.ch\n", 2, 4);
    }

    public void run() {
        String string = "";
        String string2 = "";
        String string3 = "";
        ImgWriter[] imgWriterArray = null;
        DecoderSpecs decoderSpecs = null;
        boolean bl = false;
        Image image = null;
        Insets insets = null;
        String string4 = "";
        try {
            InverseWT inverseWT;
            Dequantizer dequantizer;
            ROIDeScaler rOIDeScaler;
            EntropyDecoder entropyDecoder;
            BitstreamReaderAgent bitstreamReaderAgent;
            HeaderDecoder headerDecoder;
            RandomAccessIO randomAccessIO;
            Object object;
            boolean bl2;
            try {
                if (this.pl.getBooleanParameter("v")) {
                    this.printVersionAndCopyright();
                }
                if (this.pl.getParameter("u").equals("on")) {
                    this.printUsage();
                    return;
                }
                bl2 = this.pl.getBooleanParameter("verbose");
            }
            catch (StringFormatException stringFormatException) {
                this.error("An error occured while parsing the arguments:\n" + stringFormatException.getMessage(), 1);
                if (this.pl.getParameter("debug").equals("on")) {
                    stringFormatException.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            catch (NumberFormatException numberFormatException) {
                this.error("An error occured while parsing the arguments:\n" + numberFormatException.getMessage(), 1);
                if (this.pl.getParameter("debug").equals("on")) {
                    numberFormatException.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            try {
                this.pl.checkList(vprfxs, ParameterList.toNameArray(pinfo));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.error(illegalArgumentException.getMessage(), 2);
                if (this.pl.getParameter("debug").equals("on")) {
                    illegalArgumentException.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            String string5 = this.pl.getParameter("i");
            if (string5 == null) {
                this.error("Input file ('-i' option) has not been specified", 1);
                return;
            }
            string = this.pl.getParameter("o");
            if (string == null) {
                bl = true;
            } else if (string.lastIndexOf(46) != -1) {
                string3 = string.substring(string.lastIndexOf(46), string.length());
                string2 = string.substring(0, string.lastIndexOf(46));
            } else {
                string2 = string;
                string3 = ".pgx";
            }
            if (string5.indexOf("/") >= 1 && string5.charAt(string5.indexOf("/") - 1) == ':') {
                InputStream inputStream;
                URL uRL;
                try {
                    uRL = new URL(string5);
                }
                catch (MalformedURLException malformedURLException) {
                    this.error("Malformed URL for input file " + string5, 4);
                    if (this.pl.getParameter("debug").equals("on")) {
                        malformedURLException.printStackTrace();
                    } else {
                        this.error("Use '-debug' option for more details", 2);
                    }
                    return;
                }
                try {
                    object = uRL.openConnection();
                    ((URLConnection)object).connect();
                }
                catch (IOException iOException) {
                    this.error("Could not open connection to " + string5 + (iOException.getMessage() != null ? ":\n" + iOException.getMessage() : ""), 4);
                    if (this.pl.getParameter("debug").equals("on")) {
                        iOException.printStackTrace();
                    } else {
                        this.error("Use '-debug' option for more details", 2);
                    }
                    return;
                }
                int n = ((URLConnection)object).getContentLength();
                try {
                    inputStream = ((URLConnection)object).getInputStream();
                }
                catch (IOException iOException) {
                    this.error("Could not get data from connection to " + string5 + (iOException.getMessage() != null ? ":\n" + iOException.getMessage() : ""), 4);
                    if (this.pl.getParameter("debug").equals("on")) {
                        iOException.printStackTrace();
                    } else {
                        this.error("Use '-debug' option for more details", 2);
                    }
                    return;
                }
                randomAccessIO = n != -1 ? new ISRandomAccessIO(inputStream, n, 1, n) : new ISRandomAccessIO(inputStream);
                try {
                    randomAccessIO.read();
                    randomAccessIO.seek(0);
                }
                catch (IOException iOException) {
                    this.error("Could not get input data from " + string5 + " Invalid URL?", 4);
                    if (this.pl.getParameter("debug").equals("on")) {
                        iOException.printStackTrace();
                    } else {
                        this.error("Use '-debug' option for more details", 2);
                    }
                    return;
                }
            }
            try {
                randomAccessIO = new BEBufferedRandomAccessFile(string5, "r");
            }
            catch (IOException iOException) {
                this.error("Could not open input file " + (iOException.getMessage() != null ? ":\n" + iOException.getMessage() : ""), 4);
                if (this.pl.getParameter("debug").equals("on")) {
                    iOException.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            FileFormatReader fileFormatReader = new FileFormatReader(randomAccessIO);
            fileFormatReader.readFileFormat();
            if (fileFormatReader.JP2FFUsed) {
                randomAccessIO.seek(fileFormatReader.getFirstCodeStreamPos());
            }
            try {
                headerDecoder = new HeaderDecoder(randomAccessIO, bl2, this.pl);
            }
            catch (EOFException eOFException) {
                this.error("Codestream too short or bad header, unable to decode.", 2);
                if (this.pl.getParameter("debug").equals("on")) {
                    eOFException.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            decoderSpecs = headerDecoder.getDecoderSpecs();
            int n = headerDecoder.getNumComps();
            int[] nArray = new int[n];
            int n2 = 0;
            while (n2 < n) {
                nArray[n2] = headerDecoder.getOriginalBitDepth(n2);
                ++n2;
            }
            try {
                bitstreamReaderAgent = BitstreamReaderAgent.createInstance(randomAccessIO, headerDecoder, this.pl, decoderSpecs);
            }
            catch (IOException iOException) {
                this.error("Error while reading bit stream header or parsing packets" + (iOException.getMessage() != null ? ":\n" + iOException.getMessage() : ""), 4);
                if (this.pl.getParameter("debug").equals("on")) {
                    iOException.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.error("Could not instantiate bit stream reader" + (illegalArgumentException.getMessage() != null ? ":\n" + illegalArgumentException.getMessage() : ""), 2);
                if (this.pl.getParameter("debug").equals("on")) {
                    illegalArgumentException.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            try {
                entropyDecoder = headerDecoder.createEntropyDecoder(bitstreamReaderAgent, this.pl);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.error("Could not instantiate entropy decoder" + (illegalArgumentException.getMessage() != null ? ":\n" + illegalArgumentException.getMessage() : ""), 2);
                if (this.pl.getParameter("debug").equals("on")) {
                    illegalArgumentException.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            try {
                rOIDeScaler = headerDecoder.createROIDeScaler(entropyDecoder, this.pl);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.error("Could not instantiate roi de-scaler." + (illegalArgumentException.getMessage() != null ? ":\n" + illegalArgumentException.getMessage() : ""), 2);
                if (this.pl.getParameter("debug").equals("on")) {
                    illegalArgumentException.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            try {
                dequantizer = headerDecoder.createDequantizer(rOIDeScaler, nArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.error("Could not instantiate dequantizer" + (illegalArgumentException.getMessage() != null ? ":\n" + illegalArgumentException.getMessage() : ""), 2);
                if (this.pl.getParameter("debug").equals("on")) {
                    illegalArgumentException.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            try {
                inverseWT = InverseWT.createInstance(dequantizer, decoderSpecs);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.error("Could not instantiate inverse wavelet transform" + (illegalArgumentException.getMessage() != null ? ":\n" + illegalArgumentException.getMessage() : ""), 2);
                if (this.pl.getParameter("debug").equals("on")) {
                    illegalArgumentException.printStackTrace();
                } else {
                    this.error("Use '-debug' option for more details", 2);
                }
                return;
            }
            int n3 = bitstreamReaderAgent.getImgRes();
            int n4 = decoderSpecs.dls.getMin();
            inverseWT.setImgResLevel(n3);
            ImgDataConverter imgDataConverter = new ImgDataConverter(inverseWT, 0);
            InvCompTransf invCompTransf = new InvCompTransf(imgDataConverter, decoderSpecs, nArray);
            if (bl) {
                string4 = "JJ2000: " + new File(string5).getName() + " " + invCompTransf.getImgWidth() + "x" + invCompTransf.getImgHeight();
                if (this.isp == null) {
                    this.win = new Frame(String.valueOf(string4) + " @ (0,0) : 1");
                    ((Component)this.win).setBackground(Color.white);
                    this.win.addWindowListener(new ExitHandler(this));
                    this.isp = new ImgScrollPane(0);
                    this.win.add((Component)this.isp, "Center");
                    this.isp.addKeyListener(new ImgKeyListener(this.isp, this));
                    this.win.addKeyListener(new ImgKeyListener(this.isp, this));
                } else {
                    this.win = null;
                }
                if (this.win != null) {
                    this.win.addNotify();
                    insets = this.win.getInsets();
                    Dimension dimension = new Dimension(invCompTransf.getImgWidth() + insets.left + insets.right, invCompTransf.getImgHeight() + insets.top + insets.bottom);
                    Dimension dimension2 = this.win.getToolkit().getScreenSize();
                    if ((float)dimension.width > (float)(dimension2.width * 8) / 10.0f) {
                        dimension.width = (int)((float)(dimension2.width * 8) / 10.0f);
                    }
                    if ((float)dimension.height > (float)(dimension2.height * 8) / 10.0f) {
                        dimension.height = (int)((float)(dimension2.height * 8) / 10.0f);
                    }
                    ((Component)this.win).setSize(dimension);
                    this.win.validate();
                    ((Component)this.win).setVisible(true);
                    this.title = new TitleUpdater(this.isp, this.win, string4);
                    object = new Thread(this.title);
                    ((Thread)object).start();
                } else {
                    this.title = null;
                }
            } else {
                if (string3.equalsIgnoreCase(".PPM") && (n != 3 || invCompTransf.getNomRangeBits(0) > 8 || invCompTransf.getNomRangeBits(1) > 8 || invCompTransf.getNomRangeBits(2) > 8 || headerDecoder.isOriginalSigned(0) || headerDecoder.isOriginalSigned(1) || headerDecoder.isOriginalSigned(2))) {
                    this.error("Specified PPM output file but compressed image is not of the correct format for PPM or limited decoded components to less than 3.", 1);
                    return;
                }
                String[] stringArray = new String[n];
                if (n > 1 && !string3.equalsIgnoreCase(".PPM")) {
                    if (string3.equalsIgnoreCase(".PGM")) {
                        n2 = 0;
                        while (n2 < n) {
                            if (invCompTransf.getNomRangeBits(n2) > 8 || headerDecoder.isOriginalSigned(n2)) {
                                this.error("Specified PGM output file but compressed image is not of the correct format for PGM.", 1);
                                return;
                            }
                            ++n2;
                        }
                    }
                    n2 = 0;
                    while (n2 < n) {
                        stringArray[n2] = String.valueOf(string2) + "-" + (n2 + 1) + string3;
                        ++n2;
                    }
                } else {
                    stringArray[0] = String.valueOf(string2) + string3;
                }
                if (string3.equalsIgnoreCase(".PPM")) {
                    imgWriterArray = new ImgWriter[1];
                    try {
                        imgWriterArray[0] = new ImgWriterPPM(stringArray[0], (BlkImgDataSrc)invCompTransf, 0, 1, 2);
                    }
                    catch (IOException iOException) {
                        this.error("Could not write PPM header or open output file" + n2 + (iOException.getMessage() != null ? ":\n" + iOException.getMessage() : ""), 2);
                        if (this.pl.getParameter("debug").equals("on")) {
                            iOException.printStackTrace();
                        } else {
                            this.error("Use '-debug' option for more details", 2);
                        }
                        return;
                    }
                }
                if (string3.equalsIgnoreCase(".PGM")) {
                    imgWriterArray = new ImgWriter[n];
                    try {
                        n2 = 0;
                        while (n2 < n) {
                            imgWriterArray[n2] = new ImgWriterPGM(stringArray[n2], (BlkImgDataSrc)invCompTransf, n2);
                            ++n2;
                        }
                    }
                    catch (IOException iOException) {
                        this.error("Could not write PGM header or open output file for component " + n2 + (iOException.getMessage() != null ? ":\n" + iOException.getMessage() : ""), 2);
                        if (this.pl.getParameter("debug").equals("on")) {
                            iOException.printStackTrace();
                        } else {
                            this.error("Use '-debug' option for more details", 2);
                        }
                        return;
                    }
                }
                imgWriterArray = new ImgWriter[n];
                try {
                    n2 = 0;
                    while (n2 < n) {
                        imgWriterArray[n2] = new ImgWriterPGX(stringArray[n2], (BlkImgDataSrc)invCompTransf, n2, headerDecoder.isOriginalSigned(n2));
                        ++n2;
                    }
                }
                catch (IOException iOException) {
                    this.error("Could not write PGX header or open output file for component " + n2 + (iOException.getMessage() != null ? ":\n" + iOException.getMessage() : ""), 2);
                    if (this.pl.getParameter("debug").equals("on")) {
                        iOException.printStackTrace();
                    } else {
                        this.error("Use '-debug' option for more details", 2);
                    }
                    return;
                }
                if (imgWriterArray.length == 3 && invCompTransf.getNomRangeBits(0) <= 8 && invCompTransf.getNomRangeBits(1) <= 8 && invCompTransf.getNomRangeBits(2) <= 8 && !headerDecoder.isOriginalSigned(0) && !headerDecoder.isOriginalSigned(1) && !headerDecoder.isOriginalSigned(2) && decoderSpecs.cts.isCompTransfUsed()) {
                    this.warning("JJ2000 is quicker with one PPM output file than with 3 PGM output files when a component transformation is applied.");
                }
            }
            if (bl2) {
                if (n4 != n3) {
                    FacilityManager.getMsgLogger().println("Reconstructing resolution " + n3 + " on " + n4 + " (" + bitstreamReaderAgent.getImgWidth(n3) + "x" + bitstreamReaderAgent.getImgHeight(n3) + ")", 8, 8);
                }
                FacilityManager.getMsgLogger().println("Target rate = " + bitstreamReaderAgent.getTargetRate() + " bpp (" + bitstreamReaderAgent.getTargetNbytes() + " bytes)", 8, 8);
            }
            if (bl) {
                Thread.currentThread().setPriority(2);
                image = BlkImgDataSrcImageProducer.createImage(invCompTransf, this.isp);
                this.isp.setCursor(Cursor.getPredefinedCursor(3));
                if (this.win != null) {
                    this.win.setCursor(Cursor.getPredefinedCursor(3));
                }
                this.isp.setImage(image);
                this.isp.setCursor(Cursor.getPredefinedCursor(0));
                if (this.win != null) {
                    this.win.setCursor(Cursor.getPredefinedCursor(0));
                }
                if (this.win != null) {
                    int n5;
                    do {
                        if (((n5 = this.isp.checkImage(image, null)) & 0x40) != 0) {
                            FacilityManager.getMsgLogger().printmsg(3, "An unknown error occurred while producing the image");
                            return;
                        }
                        if ((n5 & 0x80) != 0) {
                            FacilityManager.getMsgLogger().printmsg(3, "Image production was aborted for some unknown reason");
                            continue;
                        }
                        if ((n5 & 0x20) != 0) {
                            ImgMouseListener imgMouseListener = new ImgMouseListener(this.isp);
                            this.isp.addMouseListener(imgMouseListener);
                            this.isp.addMouseMotionListener(imgMouseListener);
                            continue;
                        }
                        try {
                            Thread.currentThread();
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {}
                    } while ((n5 & 0xE0) == 0);
                }
            } else {
                n2 = 0;
                while (n2 < imgWriterArray.length) {
                    try {
                        imgWriterArray[n2].writeAll();
                    }
                    catch (IOException iOException) {
                        this.error("I/O error while writing output file" + (iOException.getMessage() != null ? ":\n" + iOException.getMessage() : ""), 2);
                        if (this.pl.getParameter("debug").equals("on")) {
                            iOException.printStackTrace();
                        } else {
                            this.error("Use '-debug' option for more details", 2);
                        }
                        return;
                    }
                    try {
                        imgWriterArray[n2].close();
                    }
                    catch (IOException iOException) {
                        this.error("I/O error while closing output file (data may be corrupted" + (iOException.getMessage() != null ? ":\n" + iOException.getMessage() : ""), 2);
                        if (this.pl.getParameter("debug").equals("on")) {
                            iOException.printStackTrace();
                        } else {
                            this.error("Use '-debug' option for more details", 2);
                        }
                        return;
                    }
                    ++n2;
                }
            }
            if (bl2) {
                float f = bitstreamReaderAgent.getActualRate();
                int n6 = bitstreamReaderAgent.getActualNbytes();
                if (fileFormatReader.JP2FFUsed) {
                    int n7 = (int)(8.0f * (float)n6 / f);
                    f = (float)(n6 += fileFormatReader.getFirstCodeStreamPos()) * 8.0f / (float)n7;
                }
                FacilityManager.getMsgLogger().println("Actual bitrate = " + f + " bpp (i.e. " + n6 + " bytes)", 8, 8);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.error(illegalArgumentException.getMessage(), 2);
            if (this.pl.getParameter("debug").equals("on")) {
                illegalArgumentException.printStackTrace();
            }
            return;
        }
        catch (Error error) {
            if (error.getMessage() != null) {
                this.error(error.getMessage(), 2);
            } else {
                this.error("An error has occured during decoding.", 2);
            }
            if (this.pl.getParameter("debug").equals("on")) {
                error.printStackTrace();
            } else {
                this.error("Use '-debug' option for more details", 2);
            }
            return;
        }
        catch (RuntimeException runtimeException) {
            if (runtimeException.getMessage() != null) {
                this.error("An uncaught runtime exception has occurred:\n" + runtimeException.getMessage(), 2);
            } else {
                this.error("An uncaught runtime exception has occurred.", 2);
            }
            if (this.pl.getParameter("debug").equals("on")) {
                runtimeException.printStackTrace();
            } else {
                this.error("Use '-debug' option for more details", 2);
            }
            return;
        }
        catch (Throwable throwable) {
            this.error("An uncaught exception has occurred.", 2);
            if (this.pl.getParameter("debug").equals("on")) {
                throwable.printStackTrace();
            } else {
                this.error("Use '-debug' option for more details", 2);
            }
            return;
        }
    }

    public void setChildProcess(boolean bl) {
        this.isChildProcess = bl;
    }

    private void warning(String string) {
        FacilityManager.getMsgLogger().printmsg(2, string);
    }
}

