/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.codestream.writer;

import java.util.Vector;
import jj2000.j2k.codestream.CBlkCoordInfo;
import jj2000.j2k.codestream.PrecCoordInfo;
import jj2000.j2k.codestream.writer.BitOutputBuffer;
import jj2000.j2k.codestream.writer.TagTreeEncoder;
import jj2000.j2k.encoder.EncoderSpecs;
import jj2000.j2k.entropy.encoder.CBlkRateDistStats;
import jj2000.j2k.entropy.encoder.CodedCBlkDataSrcEnc;
import jj2000.j2k.image.Coord;
import jj2000.j2k.util.ArrayUtil;
import jj2000.j2k.util.MathUtil;
import jj2000.j2k.util.ParameterList;
import jj2000.j2k.wavelet.analysis.SubbandAn;

public class PktEncoder {
    public static final char OPT_PREFIX = 'P';
    private static final String[][] pinfo = new String[][]{{"Psop", "[<tile idx>] on|off[ [<tile idx>] on|off ...]", "Specifies whether start of packet (SOP) markers should be used. 'on' enables, 'off' disables it.", "off"}, {"Peph", "[<tile idx>] on|off[ [<tile  idx>] on|off ...]", "Specifies whether end of packet header (EPH) markers should be  used. 'on' enables, 'off' disables it.", "off"}};
    private static final int INIT_LBLOCK = 3;
    private CodedCBlkDataSrcEnc infoSrc;
    EncoderSpecs encSpec;
    private TagTreeEncoder[][][][][] ttIncl;
    private TagTreeEncoder[][][][][] ttMaxBP;
    private int[][][][][] lblock;
    private int[][][][][] prevtIdxs;
    private int[][][][][] bak_lblock;
    private int[][][][][] bak_prevtIdxs;
    private byte[] lbbuf;
    private int lblen;
    private boolean saved;
    private boolean roiInPkt = false;
    private int roiLen = 0;
    private PrecCoordInfo[][][][][] precArrayI;
    private CBlkCoordInfo[][][][][] cbArrayI;
    private Coord[][][] maxNumPrec;
    private Coord[][][] incArray;
    private Coord[][] incArrayMax;
    private Coord[][][][] sot_eotArray;
    private Coord[][][] sot_eotArrayMax;
    int[][] mrl;
    private int[][][][] subRange;
    private boolean packetWritable;
    private SubbandAn[][] savedSbTree;

    public PktEncoder(CodedCBlkDataSrcEnc codedCBlkDataSrcEnc, EncoderSpecs encoderSpecs, Coord[][][] coordArray, ParameterList parameterList) {
        Coord coord = null;
        Vector vector = null;
        parameterList.checkList('P', ParameterList.toNameArray(pinfo));
        String string = parameterList.getParameter("Psop");
        if (string == null) {
            throw new IllegalArgumentException("Missing option 'Psop'");
        }
        String string2 = parameterList.getParameter("Peph");
        if (string2 == null) {
            throw new IllegalArgumentException("Missing option 'Peph'");
        }
        this.infoSrc = codedCBlkDataSrcEnc;
        this.encSpec = encoderSpecs;
        this.maxNumPrec = coordArray;
        Coord coord2 = codedCBlkDataSrcEnc.getTile(null);
        int n = codedCBlkDataSrcEnc.getNumComps();
        int n2 = codedCBlkDataSrcEnc.getNumTiles();
        this.ttIncl = new TagTreeEncoder[n2][n][][][];
        this.ttMaxBP = new TagTreeEncoder[n2][n][][][];
        this.lblock = new int[n2][n][][][];
        this.prevtIdxs = new int[n2][n][][][];
        this.cbArrayI = new CBlkCoordInfo[n2][n][][][];
        this.precArrayI = new PrecCoordInfo[n2][n][][][];
        this.incArray = new Coord[n2][n][];
        this.incArrayMax = new Coord[n2][n];
        this.sot_eotArray = new Coord[n2][n][][];
        this.sot_eotArrayMax = new Coord[n2][n][2];
        this.mrl = new int[n2][n];
        this.subRange = new int[n2][n][][];
        this.savedSbTree = new SubbandAn[n2][n];
        codedCBlkDataSrcEnc.setTile(0, 0);
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < n) {
                this.savedSbTree[n3][n4] = codedCBlkDataSrcEnc.getSubbandTree(n3, n4);
                SubbandAn subbandAn = this.savedSbTree[n3][n4];
                this.mrl[n3][n4] = subbandAn.resLvl;
                this.subRange[n3][n4] = this.findSubInResLvl(n4, n3);
                this.incArray[n3][n4] = new Coord[this.mrl[n3][n4] + 1];
                this.sot_eotArray[n3][n4] = new Coord[this.mrl[n3][n4] + 1][2];
                this.buildIncArrays(n4, n3);
                this.buildSotEotArrays(n4, n3);
                this.lblock[n3][n4] = new int[this.mrl[n3][n4] + 1][][];
                this.ttIncl[n3][n4] = new TagTreeEncoder[this.mrl[n3][n4] + 1][][];
                this.ttMaxBP[n3][n4] = new TagTreeEncoder[this.mrl[n3][n4] + 1][][];
                this.prevtIdxs[n3][n4] = new int[this.mrl[n3][n4] + 1][][];
                this.cbArrayI[n3][n4] = new CBlkCoordInfo[this.mrl[n3][n4] + 1][][];
                this.precArrayI[n3][n4] = new PrecCoordInfo[this.mrl[n3][n4] + 1][][];
                int n5 = this.mrl[n3][n4];
                while (n5 >= 0) {
                    int n6 = coordArray[n3][n4][n5].x * coordArray[n3][n4][n5].y;
                    this.ttIncl[n3][n4][n5] = new TagTreeEncoder[this.subRange[n3][n4][n5][1] + 1][n6];
                    this.ttMaxBP[n3][n4][n5] = new TagTreeEncoder[this.subRange[n3][n4][n5][1] + 1][n6];
                    this.prevtIdxs[n3][n4][n5] = new int[this.subRange[n3][n4][n5][1] + 1][];
                    this.lblock[n3][n4][n5] = new int[this.subRange[n3][n4][n5][1] + 1][];
                    this.cbArrayI[n3][n4][n5] = new CBlkCoordInfo[this.subRange[n3][n4][n5][1] + 1][];
                    this.precArrayI[n3][n4][n5] = new PrecCoordInfo[this.subRange[n3][n4][n5][1] + 1][];
                    this.buildCblkPrec(n3, n4, n5);
                    int n7 = this.subRange[n3][n4][n5][0];
                    while (n7 <= this.subRange[n3][n4][n5][1]) {
                        SubbandAn subbandAn2 = (SubbandAn)subbandAn.getSubbandByIdx(n5, n7);
                        coord = codedCBlkDataSrcEnc.getNumCodeBlocks(subbandAn2, coord);
                        int n8 = coord.x * coord.y;
                        this.lblock[n3][n4][n5][n7] = new int[n8];
                        ArrayUtil.intArraySet(this.lblock[n3][n4][n5][n7], 3);
                        this.prevtIdxs[n3][n4][n5][n7] = new int[n8];
                        ArrayUtil.intArraySet(this.prevtIdxs[n3][n4][n5][n7], -1);
                        int n9 = 0;
                        while (n9 < n6) {
                            vector = this.getCBlkInPrec(n3, n4, n5, n7, n9, vector);
                            coord = (Coord)vector.elementAt(0);
                            this.ttIncl[n3][n4][n5][n7][n9] = new TagTreeEncoder(coord.y, coord.x);
                            this.ttMaxBP[n3][n4][n5][n7][n9] = new TagTreeEncoder(coord.y, coord.x);
                            ++n9;
                        }
                        ++n7;
                    }
                    --n5;
                }
                ++n4;
            }
            if (n3 < n2 - 1) {
                codedCBlkDataSrcEnc.nextTile();
            }
            ++n3;
        }
        codedCBlkDataSrcEnc.setTile(coord2.x, coord2.y);
    }

    private void buildCblkPrec(int n, int n2, int n3) {
        SubbandAn subbandAn;
        Coord coord = null;
        CBlkCoordInfo cBlkCoordInfo = null;
        SubbandAn subbandAn2 = this.savedSbTree[n][n2];
        int[] nArray = new int[this.subRange[n][n2][n3][1] + 1];
        int n4 = this.subRange[n][n2][n3][0];
        while (n4 <= this.subRange[n][n2][n3][1]) {
            subbandAn = (SubbandAn)subbandAn2.getSubbandByIdx(n3, n4);
            int n5 = this.infoSrc.getPartitionULX();
            int n6 = this.infoSrc.getPartitionULY();
            block0 : switch (subbandAn.gOrient) {
                case 1: {
                    n5 = 0;
                    SubbandAn subbandAn3 = subbandAn;
                    do {
                        if (subbandAn3.orientation != 3 && subbandAn3.orientation != 2) continue;
                        n6 = 0;
                        break block0;
                    } while (subbandAn3.gOrient != 0 && (subbandAn3 = (SubbandAn)subbandAn3.getParent()) != null);
                    break;
                }
                case 2: {
                    SubbandAn subbandAn3 = subbandAn;
                    do {
                        if (subbandAn3.orientation != 3 && subbandAn3.orientation != 1) continue;
                        n5 = 0;
                        break;
                    } while (subbandAn3.gOrient != 0 && (subbandAn3 = (SubbandAn)subbandAn3.getParent()) != null);
                    n6 = 0;
                    break;
                }
                case 3: {
                    n5 = 0;
                    n6 = 0;
                    break;
                }
                default: {
                    throw new Error("Internal JJ2000 error");
                }
                case 0: 
            }
            coord = this.infoSrc.getNumCodeBlocks(subbandAn, coord);
            int n7 = coord.x * coord.y;
            if (n7 > 0) {
                if (this.cbArrayI[n][n2][subbandAn.resLvl][subbandAn.sbandIdx] == null) {
                    this.cbArrayI[n][n2][subbandAn.resLvl][subbandAn.sbandIdx] = new CBlkCoordInfo[n7];
                }
                int n8 = 0;
                int n9 = -1;
                int n10 = 0;
                do {
                    if (++n9 == coord.x) {
                        n9 = 0;
                        ++n10;
                    }
                    this.cbArrayI[n][n2][subbandAn.resLvl][subbandAn.sbandIdx][n8] = new CBlkCoordInfo();
                    this.cbArrayI[n][n2][subbandAn.resLvl][subbandAn.sbandIdx][n8].idx = new Coord(n9, n10);
                    cBlkCoordInfo = this.cbArrayI[n][n2][subbandAn.resLvl][subbandAn.sbandIdx][n8];
                    int n11 = (subbandAn.ulcx - n5 + subbandAn.nomCBlkW) / subbandAn.nomCBlkW - 1;
                    int n12 = (subbandAn.ulcy - n6 + subbandAn.nomCBlkH) / subbandAn.nomCBlkH - 1;
                    cBlkCoordInfo.ulx = n9 == 0 ? subbandAn.ulx : (n11 + n9) * subbandAn.nomCBlkW - (subbandAn.ulcx - n5) + subbandAn.ulx;
                    cBlkCoordInfo.uly = n10 == 0 ? subbandAn.uly : (n12 + n10) * subbandAn.nomCBlkH - (subbandAn.ulcy - n6) + subbandAn.uly;
                    cBlkCoordInfo.w = n9 < coord.x - 1 ? (n11 + n9 + 1) * subbandAn.nomCBlkW - (subbandAn.ulcx - n5) + subbandAn.ulx - cBlkCoordInfo.ulx : subbandAn.ulx + subbandAn.w - cBlkCoordInfo.ulx;
                    cBlkCoordInfo.h = n10 < coord.y - 1 ? (n12 + n10 + 1) * subbandAn.nomCBlkH - (subbandAn.ulcy - n6) + subbandAn.uly - cBlkCoordInfo.uly : subbandAn.uly + subbandAn.h - cBlkCoordInfo.uly;
                } while (++n8 != n7);
            }
            ++n4;
        }
        int n13 = 0;
        int n14 = 0;
        int n15 = -1;
        boolean bl = false;
        int n16 = this.incArray[n][n2][n3].x;
        int n17 = this.incArray[n][n2][n3].y;
        Coord coord2 = this.maxNumPrec[n][n2][n3];
        int n18 = coord2.x * coord2.y;
        int n19 = this.subRange[n][n2][n3][0];
        while (n19 <= this.subRange[n][n2][n3][1]) {
            if (n18 > 0) {
                this.precArrayI[n][n2][n3][n19] = new PrecCoordInfo[n18];
            }
            ++n19;
        }
        int n20 = this.sot_eotArrayMax[n][n2][0].y;
        while (n20 < this.sot_eotArrayMax[n][n2][1].y) {
            int n21 = this.sot_eotArrayMax[n][n2][0].x;
            while (n21 < this.sot_eotArrayMax[n][n2][1].x) {
                if (!(n21 != this.sot_eotArrayMax[n][n2][0].x && n21 % n16 != 0 || n20 != this.sot_eotArrayMax[n][n2][0].y && n20 % n17 != 0)) {
                    bl = false;
                    int n22 = this.subRange[n][n2][n3][0];
                    while (n22 <= this.subRange[n][n2][n3][1]) {
                        subbandAn = (SubbandAn)subbandAn2.getSubbandByIdx(n3, n22);
                        if (this.maxNumPrec[n][n2][n3].x * this.maxNumPrec[n][n2][n3].y != 0) {
                            if (!this.infoSrc.precinctPartitionUsed(n2, n)) {
                                this.precArrayI[n][n2][n3][n22][0] = new PrecCoordInfo(0, 0, subbandAn.w, subbandAn.h, n21, n20);
                            } else {
                                int n23 = this.infoSrc.getPPX(n, n2, n3);
                                int n24 = this.infoSrc.getPPY(n, n2, n3);
                                n15 = nArray[n22];
                                if (n15 >= 0 && n15 <= n18 - 1) {
                                    if (n21 == this.sot_eotArrayMax[n][n2][0].x && this.sot_eotArrayMax[n][n2][0].x != this.sot_eotArray[n][n2][n3][0].x >> this.mrl[n][n2] - n3) {
                                        if (n3 == 0) {
                                            n13 = (int)((double)this.sot_eotArray[n][n2][n3][0].x / Math.pow(2.0, this.mrl[n][n2] - n3) - (double)subbandAn.ulcx);
                                        } else {
                                            n13 = (int)((double)this.sot_eotArray[n][n2][n3][0].x / Math.pow(2.0, this.mrl[n][n2] - n3 + 1) - (double)subbandAn.ulcx);
                                            n23 >>= 1;
                                        }
                                    } else if (n3 == 0) {
                                        n13 = (int)((double)n21 / Math.pow(2.0, this.mrl[n][n2] - n3) - (double)subbandAn.ulcx);
                                    } else {
                                        n13 = (int)((double)n21 / Math.pow(2.0, this.mrl[n][n2] - n3 + 1) - (double)subbandAn.ulcx);
                                        n23 >>= 1;
                                    }
                                    if (n20 == this.sot_eotArrayMax[n][n2][0].y && this.sot_eotArrayMax[n][n2][0].y != this.sot_eotArray[n][n2][n3][0].y >> this.mrl[n][n2] - n3) {
                                        if (n3 == 0) {
                                            n14 = (int)((double)this.sot_eotArray[n][n2][n3][0].y / Math.pow(2.0, this.mrl[n][n2] - n3) - (double)subbandAn.ulcy);
                                        } else {
                                            n14 = (int)((double)this.sot_eotArray[n][n2][n3][0].y / Math.pow(2.0, this.mrl[n][n2] - n3 + 1) - (double)subbandAn.ulcy);
                                            n24 >>= 1;
                                        }
                                    } else if (n3 == 0) {
                                        n14 = (int)((double)n20 / Math.pow(2.0, this.mrl[n][n2] - n3) - (double)subbandAn.ulcy);
                                    } else {
                                        n14 = (int)((double)n20 / Math.pow(2.0, this.mrl[n][n2] - n3 + 1) - (double)subbandAn.ulcy);
                                        n24 >>= 1;
                                    }
                                    if (n13 + n23 > 0 && n14 + n24 > 0 && n13 < subbandAn.w && n14 < subbandAn.h) {
                                        this.precArrayI[n][n2][n3][n22][n15] = new PrecCoordInfo(n13 < 0 ? 0 : n13, n14 < 0 ? 0 : n14, n13 + n23 >= subbandAn.w ? subbandAn.w : n13 + n23, n14 + n24 >= subbandAn.h ? subbandAn.h : n14 + n24, n21, n20);
                                        bl = true;
                                    }
                                }
                            }
                        }
                        ++n22;
                    }
                    if (this.infoSrc.precinctPartitionUsed(n2, n) && bl) {
                        int n25 = this.subRange[n][n2][n3][0];
                        while (n25 < this.subRange[n][n2][n3][1] + 1) {
                            int n26 = n25++;
                            nArray[n26] = nArray[n26] + 1;
                        }
                    }
                }
                n21 += this.incArrayMax[n][n2].x;
            }
            n20 += this.incArrayMax[n][n2].y;
        }
    }

    private void buildIncArrays(int n, int n2) {
        if (this.incArrayMax[n2][n] != null) {
            return;
        }
        this.incArrayMax[n2][n] = new Coord();
        Coord coord = this.incArrayMax[n2][n];
        int n3 = 0;
        while (n3 < this.mrl[n2][n] + 1) {
            int n4 = this.infoSrc.getPPX(n2, n, n3);
            int n5 = this.infoSrc.getPPY(n2, n, n3);
            if (this.incArray[n2][n][n3] == null) {
                this.incArray[n2][n][n3] = new Coord();
            }
            Coord coord2 = this.incArray[n2][n][n3];
            coord2.x = this.infoSrc.getCompSubsX(n);
            coord2.x <<= MathUtil.log2(n4) + this.mrl[n2][n] - n3;
            if (coord.x == 0 || coord2.x < coord.x) {
                coord.x = coord2.x;
            }
            coord2.y = this.infoSrc.getCompSubsY(n);
            coord2.y <<= MathUtil.log2(n5) + this.mrl[n2][n] - n3;
            if (coord.y == 0 || coord2.y < coord.y) {
                coord.y = coord2.y;
            }
            ++n3;
        }
    }

    private void buildSotEotArrays(int n, int n2) {
        Coord[] coordArray = null;
        Coord[] coordArray2 = null;
        if (this.sot_eotArrayMax[n2][n][0] == null) {
            this.sot_eotArrayMax[n2][n][0] = new Coord();
            this.sot_eotArrayMax[n2][n][1] = new Coord();
            coordArray = this.sot_eotArrayMax[n2][n];
            if (this.incArrayMax[n2][n].x == 0) {
                coordArray[0].x = 0;
                coordArray[1].x = 1;
                this.incArrayMax[n2][n].x = 1;
            } else {
                coordArray[0].x = this.infoSrc.getULX(n);
                coordArray[1].x = coordArray[0].x + this.infoSrc.getWidth();
                coordArray[0].x &= ~(this.incArrayMax[n2][n].x - 1);
            }
            if (this.incArrayMax[n2][n].y == 0) {
                coordArray[0].y = 0;
                coordArray[1].y = 1;
                this.incArrayMax[n2][n].y = 1;
            } else {
                coordArray[0].y = this.infoSrc.getULY(n);
                coordArray[1].y = coordArray[0].y + this.infoSrc.getHeight();
                coordArray[0].y &= ~(this.incArrayMax[n2][n].y - 1);
            }
        }
        int n3 = 0;
        while (n3 < this.mrl[n2][n] + 1) {
            if (this.sot_eotArray[n2][n][n3][0] == null) {
                this.sot_eotArray[n2][n][n3][0] = new Coord();
                this.sot_eotArray[n2][n][n3][1] = new Coord();
                coordArray2 = this.sot_eotArray[n2][n][n3];
                if (this.incArray[n2][n][n3].x == 0) {
                    coordArray2[0].x = 0;
                    coordArray2[1].x = 1;
                    this.incArray[n2][n][n3].x = 1;
                } else {
                    coordArray2[0].x = this.infoSrc.getULX(n);
                    coordArray2[1].x = coordArray2[0].x + this.infoSrc.getWidth();
                    coordArray2[0].x &= ~(this.incArray[n2][n][n3].x - 1);
                }
                if (this.incArray[n2][n][n3].y == 0) {
                    coordArray2[0].y = 0;
                    coordArray2[1].y = 1;
                    this.incArray[n2][n][n3].y = 1;
                } else {
                    coordArray2[0].y = this.infoSrc.getULY(n);
                    coordArray2[1].y = coordArray2[0].y + this.infoSrc.getHeight();
                    coordArray2[0].y &= ~(this.incArray[n2][n][n3].y - 1);
                }
            }
            ++n3;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BitOutputBuffer encodePacket(int n, int n2, int n3, int n4, CBlkRateDistStats[][] cBlkRateDistStatsArray, int[][] nArray, BitOutputBuffer bitOutputBuffer, byte[] byArray, int n5) {
        int n6;
        int n7;
        int n8;
        int[] nArray2;
        CBlkRateDistStats[] cBlkRateDistStatsArray2;
        int[] nArray3;
        Vector vector = null;
        Coord coord = null;
        boolean bl = this.infoSrc.precinctPartitionUsed(n2, n4);
        int n9 = -1;
        int n10 = -1;
        boolean bl2 = false;
        boolean bl3 = false;
        Object var39_17 = null;
        this.roiInPkt = false;
        this.roiLen = 0;
        int n11 = this.subRange[n4][n2][n3][1] + 1;
        int n12 = this.subRange[n4][n2][n3][0];
        boolean bl4 = true;
        int n13 = n12;
        while (n13 < n11) {
            if (this.precArrayI[n4][n2][n3][n13] != null && (vector = this.getCBlkInPrec(n4, n2, n3, n13, n5, vector)).size() != 1) {
                bl4 = false;
                break;
            }
            ++n13;
        }
        if (bl4) {
            this.packetWritable = true;
            if (bitOutputBuffer == null) {
                bitOutputBuffer = new BitOutputBuffer();
            } else {
                bitOutputBuffer.reset();
            }
            if (byArray == null) {
                byArray = new byte[1];
                this.lbbuf = byArray;
            }
            bitOutputBuffer.writeBit(0);
            this.lblen = 0;
            return bitOutputBuffer;
        }
        if (bitOutputBuffer == null) {
            bitOutputBuffer = new BitOutputBuffer();
        } else {
            bitOutputBuffer.reset();
        }
        this.lbbuf = null;
        this.lblen = 0;
        bitOutputBuffer.writeBit(1);
        n13 = n12;
        while (n13 < n11) {
            if (!(this.precArrayI[n4][n2][n3][n13] == null || n5 >= this.precArrayI[n4][n2][n3][n13].length && bl)) {
                int n14;
                int n15;
                int n16;
                bl3 = true;
                vector = this.getCBlkInPrec(n4, n2, n3, n13, n5, vector);
                TagTreeEncoder tagTreeEncoder = this.ttIncl[n4][n2][n3][n13][n5];
                TagTreeEncoder tagTreeEncoder2 = this.ttMaxBP[n4][n2][n3][n13][n5];
                nArray3 = this.prevtIdxs[n4][n2][n3][n13];
                cBlkRateDistStatsArray2 = cBlkRateDistStatsArray[n13];
                nArray2 = nArray[n13];
                int n17 = tagTreeEncoder.getWidth();
                int n18 = tagTreeEncoder.getHeight();
                n8 = 1;
                while (n8 < vector.size()) {
                    n7 = (Integer)vector.elementAt(n8);
                    coord = this.cbArrayI[n4][n2][n3][n13][n7].idx;
                    n16 = coord.x;
                    n15 = coord.y;
                    if (n8 == 1) {
                        n9 = n16;
                        n10 = n15;
                    }
                    if (nArray2[n7] > nArray3[n7] && nArray3[n7] < 0) {
                        tagTreeEncoder.setValue(n15 - n10, n16 - n9, n - 1);
                    }
                    ++n8;
                }
                if (n == 1) {
                    n14 = 1;
                    while (n14 < vector.size()) {
                        n7 = (Integer)vector.elementAt(n14);
                        coord = this.cbArrayI[n4][n2][n3][n13][n7].idx;
                        n16 = coord.x;
                        n15 = coord.y;
                        if (n14 == 1) {
                            n9 = n16;
                            n10 = n15;
                        }
                        tagTreeEncoder2.setValue(n15 - n10, n16 - n9, cBlkRateDistStatsArray2[n7].skipMSBP);
                        ++n14;
                    }
                }
                n14 = 1;
                while (n14 < vector.size()) {
                    n7 = (Integer)vector.elementAt(n14);
                    coord = this.cbArrayI[n4][n2][n3][n13][n7].idx;
                    n16 = coord.x;
                    n15 = coord.y;
                    if (n14 == 1) {
                        n9 = n16;
                        n10 = n15;
                    }
                    if (nArray2[n7] <= nArray3[n7]) {
                        if (nArray3[n7] >= 0) {
                            bitOutputBuffer.writeBit(0);
                        } else {
                            tagTreeEncoder.encode(n15 - n10, n16 - n9, n, bitOutputBuffer);
                        }
                    } else {
                        int n19;
                        int n20;
                        int n21;
                        int n22;
                        if (nArray3[n7] < 0) {
                            tagTreeEncoder.encode(n15 - n10, n16 - n9, n, bitOutputBuffer);
                            int n23 = cBlkRateDistStatsArray2[n7].skipMSBP + 1;
                            n22 = 1;
                            while (n22 <= n23) {
                                tagTreeEncoder2.encode(n15 - n10, n16 - n9, n22, bitOutputBuffer);
                                ++n22;
                            }
                            this.lblen += cBlkRateDistStatsArray2[n7].truncRates[cBlkRateDistStatsArray2[n7].truncIdxs[nArray2[n7]]];
                        } else {
                            bitOutputBuffer.writeBit(1);
                            this.lblen += cBlkRateDistStatsArray2[n7].truncRates[cBlkRateDistStatsArray2[n7].truncIdxs[nArray2[n7]]] - cBlkRateDistStatsArray2[n7].truncRates[cBlkRateDistStatsArray2[n7].truncIdxs[nArray3[n7]]];
                        }
                        int n24 = nArray3[n7] < 0 ? cBlkRateDistStatsArray2[n7].truncIdxs[nArray2[n7]] : cBlkRateDistStatsArray2[n7].truncIdxs[nArray2[n7]] - cBlkRateDistStatsArray2[n7].truncIdxs[nArray3[n7]] - 1;
                        switch (n24) {
                            case 0: {
                                bitOutputBuffer.writeBit(0);
                                break;
                            }
                            case 1: {
                                bitOutputBuffer.writeBits(2, 2);
                                break;
                            }
                            case 2: 
                            case 3: 
                            case 4: {
                                bitOutputBuffer.writeBits(0xC | n24 - 2, 4);
                                break;
                            }
                            default: {
                                if (n24 <= 35) {
                                    bitOutputBuffer.writeBits(0x1E0 | n24 - 5, 9);
                                } else {
                                    if (n24 > 163) throw new ArithmeticException("Maximum number of truncation points exceeded");
                                    bitOutputBuffer.writeBits(0xFF80 | n24 - 36, 16);
                                }
                            }
                        }
                        n24 = 1;
                        int n25 = cBlkRateDistStatsArray2[n7].truncIdxs[nArray2[n7]];
                        n6 = nArray3[n7] < 0 ? 0 : cBlkRateDistStatsArray2[n7].truncRates[cBlkRateDistStatsArray2[n7].truncIdxs[nArray3[n7]]];
                        n22 = nArray3[n7] < 0 ? 0 : cBlkRateDistStatsArray2[n7].truncIdxs[nArray3[n7]] + 1;
                        int n26 = 0;
                        while (n22 < n25) {
                            if (cBlkRateDistStatsArray2[n7].isTermPass != null && cBlkRateDistStatsArray2[n7].isTermPass[n22]) {
                                n6 = cBlkRateDistStatsArray2[n7].truncRates[n22] - n6;
                                n21 = this.lblock[n4][n2][n3][n13][n7] + MathUtil.log2(n24);
                                n26 = (n6 > 0 ? MathUtil.log2(n6) : 0) + 1;
                                n20 = n21;
                                while (n20 < n26) {
                                    int[] nArray4 = this.lblock[n4][n2][n3][n13];
                                    int n27 = n7;
                                    nArray4[n27] = nArray4[n27] + 1;
                                    bitOutputBuffer.writeBit(1);
                                    ++n20;
                                }
                                n24 = 0;
                                n6 = cBlkRateDistStatsArray2[n7].truncRates[n22];
                            }
                            ++n22;
                            ++n24;
                        }
                        n6 = cBlkRateDistStatsArray2[n7].truncRates[n22] - n6;
                        n21 = this.lblock[n4][n2][n3][n13][n7] + MathUtil.log2(n24);
                        n26 = (n6 > 0 ? MathUtil.log2(n6) : 0) + 1;
                        n20 = n21;
                        while (n20 < n26) {
                            int[] nArray5 = this.lblock[n4][n2][n3][n13];
                            int n28 = n7;
                            nArray5[n28] = nArray5[n28] + 1;
                            bitOutputBuffer.writeBit(1);
                            ++n20;
                        }
                        bitOutputBuffer.writeBit(0);
                        n24 = 1;
                        n25 = cBlkRateDistStatsArray2[n7].truncIdxs[nArray2[n7]];
                        n6 = nArray3[n7] < 0 ? 0 : cBlkRateDistStatsArray2[n7].truncRates[cBlkRateDistStatsArray2[n7].truncIdxs[nArray3[n7]]];
                        n22 = nArray3[n7] < 0 ? 0 : cBlkRateDistStatsArray2[n7].truncIdxs[nArray3[n7]] + 1;
                        while (n22 < n25) {
                            if (cBlkRateDistStatsArray2[n7].isTermPass != null && cBlkRateDistStatsArray2[n7].isTermPass[n22]) {
                                n6 = cBlkRateDistStatsArray2[n7].truncRates[n22] - n6;
                                n19 = MathUtil.log2(n24) + this.lblock[n4][n2][n3][n13][n7];
                                bitOutputBuffer.writeBits(n6, n19);
                                n24 = 0;
                                n6 = cBlkRateDistStatsArray2[n7].truncRates[n22];
                            }
                            ++n22;
                            ++n24;
                        }
                        n6 = cBlkRateDistStatsArray2[n7].truncRates[n22] - n6;
                        n19 = MathUtil.log2(n24) + this.lblock[n4][n2][n3][n13][n7];
                        bitOutputBuffer.writeBits(n6, n19);
                    }
                    ++n14;
                }
            }
            ++n13;
        }
        if (byArray == null || byArray.length < this.lblen) {
            byArray = new byte[this.lblen];
        }
        this.lbbuf = byArray;
        this.lblen = 0;
        n13 = n12;
        while (n13 < n11) {
            vector = this.getCBlkInPrec(n4, n2, n3, n13, n5, vector);
            nArray3 = this.prevtIdxs[n4][n2][n3][n13];
            cBlkRateDistStatsArray2 = cBlkRateDistStatsArray[n13];
            nArray2 = nArray[n13];
            int n29 = nArray3.length;
            n8 = 1;
            while (n8 < vector.size()) {
                n7 = (Integer)vector.elementAt(n8);
                if (nArray2[n7] > nArray3[n7]) {
                    if (nArray3[n7] < 0) {
                        n6 = cBlkRateDistStatsArray2[n7].truncRates[cBlkRateDistStatsArray2[n7].truncIdxs[nArray2[n7]]];
                        System.arraycopy(cBlkRateDistStatsArray2[n7].data, 0, this.lbbuf, this.lblen, n6);
                    } else {
                        n6 = cBlkRateDistStatsArray2[n7].truncRates[cBlkRateDistStatsArray2[n7].truncIdxs[nArray2[n7]]] - cBlkRateDistStatsArray2[n7].truncRates[cBlkRateDistStatsArray2[n7].truncIdxs[nArray3[n7]]];
                        System.arraycopy(cBlkRateDistStatsArray2[n7].data, cBlkRateDistStatsArray2[n7].truncRates[cBlkRateDistStatsArray2[n7].truncIdxs[nArray3[n7]]], this.lbbuf, this.lblen, n6);
                    }
                    this.lblen += n6;
                    if (cBlkRateDistStatsArray2[n7].nROIcoeff != 0 && (nArray3[n7] == -1 || cBlkRateDistStatsArray2[n7].truncIdxs[nArray3[n7]] <= cBlkRateDistStatsArray2[n7].nROIcp - 1)) {
                        this.roiInPkt = true;
                        this.roiLen = this.lblen;
                    }
                    nArray3[n7] = nArray2[n7];
                }
                ++n8;
            }
            ++n13;
        }
        if (!bl3) {
            this.packetWritable = false;
            return bitOutputBuffer;
        }
        this.packetWritable = true;
        if (bitOutputBuffer.getLength() != 0) return bitOutputBuffer;
        throw new Error("You have found a bug in PktEncoder, method: encodePacket");
    }

    private int[][] findSubInResLvl(int n, int n2) {
        int[][] nArray = new int[this.mrl[n2][n] + 1][2];
        int n3 = this.mrl[n2][n];
        while (n3 > 0) {
            nArray[n3][0] = 1;
            nArray[n3][1] = 3;
            --n3;
        }
        nArray[0][0] = 0;
        nArray[0][1] = 0;
        return nArray;
    }

    public Vector getCBlkInPrec(int n, int n2, int n3, int n4, int n5, Vector vector) {
        Coord coord = new Coord();
        SubbandAn subbandAn = null;
        subbandAn = (SubbandAn)this.savedSbTree[n][n2].getSubbandByIdx(n3, n4);
        if (vector == null) {
            vector = new Vector<Object>();
        } else {
            vector.removeAllElements();
        }
        if (subbandAn.h == 0 || subbandAn.w == 0 || this.precArrayI[n][n2][n3][n4] == null || n5 >= this.precArrayI[n][n2][n3][n4].length) {
            vector.addElement(new Coord(0, 0));
            return vector;
        }
        PrecCoordInfo precCoordInfo = this.precArrayI[n][n2][n3][n4][n5];
        if (precCoordInfo == null) {
            vector.addElement(new Coord(0, 0));
            return vector;
        }
        if (this.cbArrayI[n][n2][n3][n4] == null) {
            vector.addElement(new Coord(0, 0));
            return vector;
        }
        int n6 = precCoordInfo.ulx;
        int n7 = precCoordInfo.uly;
        int n8 = precCoordInfo.w;
        int n9 = precCoordInfo.h;
        coord.y = 0;
        coord.x = 0;
        int n10 = -1;
        int n11 = -1;
        int n12 = 0;
        while (n12 < this.cbArrayI[n][n2][n3][n4].length) {
            CBlkCoordInfo cBlkCoordInfo = this.cbArrayI[n][n2][n3][n4][n12];
            int n13 = cBlkCoordInfo.ulx - subbandAn.ulx;
            int n14 = cBlkCoordInfo.uly - subbandAn.uly;
            int n15 = cBlkCoordInfo.w;
            int n16 = cBlkCoordInfo.h;
            if (this.infoSrc.precinctPartitionUsed(n2, n)) {
                if (n13 >= n6 && n13 + n15 <= n8 && n14 >= n7 && n14 + n16 <= n9) {
                    if (n13 > n11) {
                        ++coord.x;
                        n11 = n13;
                    }
                    if (n14 > n10) {
                        ++coord.y;
                        n10 = n14;
                    }
                    vector.addElement(new Integer(n12));
                }
            } else {
                if (n13 > n11) {
                    ++coord.x;
                    n11 = n13;
                }
                if (n14 > n10) {
                    ++coord.y;
                    n10 = n14;
                }
                vector.addElement(new Integer(n12));
            }
            ++n12;
        }
        vector.insertElementAt(coord, 0);
        return vector;
    }

    public Coord getIncArray(int n, int n2, int n3) {
        return this.incArray[n][n2][n3];
    }

    public Coord getIncArrayMax(int n, int n2) {
        return this.incArrayMax[n][n2];
    }

    public byte[] getLastBodyBuf() {
        if (this.lbbuf == null) {
            throw new IllegalArgumentException();
        }
        return this.lbbuf;
    }

    public int getLastBodyLen() {
        return this.lblen;
    }

    public int[][] getMRL() {
        return this.mrl;
    }

    public static String[][] getParameterInfo() {
        return pinfo;
    }

    public int getROILen() {
        return this.roiLen;
    }

    public Coord[] getSotEotArray(int n, int n2, int n3) {
        return this.sot_eotArray[n][n2][n3];
    }

    public Coord[] getSotEotArrayMax(int n, int n2) {
        return this.sot_eotArrayMax[n][n2];
    }

    public boolean isPacketWritable() {
        return this.packetWritable;
    }

    public boolean isROIinPkt() {
        return this.roiInPkt;
    }

    public void reset() {
        this.saved = false;
        this.lbbuf = null;
        int n = this.ttIncl.length - 1;
        while (n >= 0) {
            int n2 = this.ttIncl[n].length - 1;
            while (n2 >= 0) {
                int[][][] nArray = this.lblock[n][n2];
                TagTreeEncoder[][][] tagTreeEncoderArray = this.ttIncl[n][n2];
                TagTreeEncoder[][][] tagTreeEncoderArray2 = this.ttMaxBP[n][n2];
                int n3 = nArray.length - 1;
                while (n3 >= 0) {
                    int n4;
                    TagTreeEncoder[][] tagTreeEncoderArray3 = tagTreeEncoderArray[n3];
                    TagTreeEncoder[][] tagTreeEncoderArray4 = tagTreeEncoderArray2[n3];
                    int[][] nArray2 = this.prevtIdxs[n][n2][n3];
                    int n5 = tagTreeEncoderArray3.length;
                    int n6 = n4 = n5 >> 2;
                    while (n6 < n5) {
                        ArrayUtil.intArraySet(nArray2[n6], -1);
                        ArrayUtil.intArraySet(nArray[n3][n6], 3);
                        if (this.precArrayI[n][n2][n3][n6] != null) {
                            int n7 = this.precArrayI[n][n2][n3][n6].length - 1;
                            while (n7 >= 0) {
                                if (n7 < tagTreeEncoderArray3[n6].length) {
                                    tagTreeEncoderArray3[n6][n7].reset();
                                    tagTreeEncoderArray4[n6][n7].reset();
                                }
                                --n7;
                            }
                        }
                        ++n6;
                    }
                    --n3;
                }
                --n2;
            }
            --n;
        }
    }

    public void restore() {
        if (!this.saved) {
            throw new IllegalArgumentException();
        }
        this.lbbuf = null;
        int n = this.ttIncl.length - 1;
        while (n >= 0) {
            int n2 = this.ttIncl[n].length - 1;
            while (n2 >= 0) {
                int[][][] nArray = this.lblock[n][n2];
                int[][][] nArray2 = this.bak_lblock[n][n2];
                TagTreeEncoder[][][] tagTreeEncoderArray = this.ttIncl[n][n2];
                TagTreeEncoder[][][] tagTreeEncoderArray2 = this.ttMaxBP[n][n2];
                int n3 = nArray.length - 1;
                while (n3 >= 0) {
                    int n4;
                    TagTreeEncoder[][] tagTreeEncoderArray3 = tagTreeEncoderArray[n3];
                    TagTreeEncoder[][] tagTreeEncoderArray4 = tagTreeEncoderArray2[n3];
                    int[][] nArray3 = this.prevtIdxs[n][n2][n3];
                    int[][] nArray4 = this.bak_prevtIdxs[n][n2][n3];
                    int n5 = tagTreeEncoderArray3.length;
                    int n6 = n4 = n5 >> 2;
                    while (n6 < n5) {
                        System.arraycopy(nArray2[n3][n6], 0, nArray[n3][n6], 0, nArray[n3][n6].length);
                        System.arraycopy(nArray4[n6], 0, nArray3[n6], 0, nArray3[n6].length);
                        if (this.precArrayI[n][n2][n3][n6] != null) {
                            int n7 = this.precArrayI[n][n2][n3][n6].length - 1;
                            while (n7 >= 0) {
                                if (n7 < tagTreeEncoderArray3[n6].length) {
                                    tagTreeEncoderArray3[n6][n7].restore();
                                    tagTreeEncoderArray4[n6][n7].restore();
                                }
                                --n7;
                            }
                        }
                        ++n6;
                    }
                    --n3;
                }
                --n2;
            }
            --n;
        }
    }

    public void save() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        if (this.bak_lblock == null) {
            this.bak_lblock = new int[this.ttIncl.length][][][][];
            this.bak_prevtIdxs = new int[this.ttIncl.length][][][][];
            n6 = this.ttIncl.length - 1;
            while (n6 >= 0) {
                this.bak_lblock[n6] = new int[this.ttIncl[n6].length][][][];
                this.bak_prevtIdxs[n6] = new int[this.ttIncl[n6].length][][][];
                n5 = this.ttIncl[n6].length - 1;
                while (n5 >= 0) {
                    this.bak_lblock[n6][n5] = new int[this.lblock[n6][n5].length][][];
                    this.bak_prevtIdxs[n6][n5] = new int[this.ttIncl[n6][n5].length][][];
                    n4 = this.lblock[n6][n5].length - 1;
                    while (n4 >= 0) {
                        this.bak_lblock[n6][n5][n4] = new int[this.lblock[n6][n5][n4].length][];
                        this.bak_prevtIdxs[n6][n5][n4] = new int[this.ttIncl[n6][n5][n4].length][];
                        n3 = this.ttIncl[n6][n5][n4].length;
                        n = n2 = n3 >> 2;
                        while (n < n3) {
                            this.bak_lblock[n6][n5][n4][n] = new int[this.lblock[n6][n5][n4][n].length];
                            this.bak_prevtIdxs[n6][n5][n4][n] = new int[this.prevtIdxs[n6][n5][n4][n].length];
                            ++n;
                        }
                        --n4;
                    }
                    --n5;
                }
                --n6;
            }
        }
        n6 = this.ttIncl.length - 1;
        while (n6 >= 0) {
            n5 = this.ttIncl[n6].length - 1;
            while (n5 >= 0) {
                int[][][] nArray = this.lblock[n6][n5];
                int[][][] nArray2 = this.bak_lblock[n6][n5];
                TagTreeEncoder[][][] tagTreeEncoderArray = this.ttIncl[n6][n5];
                TagTreeEncoder[][][] tagTreeEncoderArray2 = this.ttMaxBP[n6][n5];
                n4 = nArray.length - 1;
                while (n4 >= 0) {
                    TagTreeEncoder[][] tagTreeEncoderArray3 = tagTreeEncoderArray[n4];
                    TagTreeEncoder[][] tagTreeEncoderArray4 = tagTreeEncoderArray2[n4];
                    int[][] nArray3 = this.prevtIdxs[n6][n5][n4];
                    int[][] nArray4 = this.bak_prevtIdxs[n6][n5][n4];
                    n3 = tagTreeEncoderArray3.length;
                    n = n2 = n3 >> 2;
                    while (n < n3) {
                        System.arraycopy(nArray[n4][n], 0, nArray2[n4][n], 0, nArray[n4][n].length);
                        System.arraycopy(nArray3[n], 0, nArray4[n], 0, nArray3[n].length);
                        if (this.precArrayI[n6][n5][n4][n] != null) {
                            int n7 = this.precArrayI[n6][n5][n4][n].length - 1;
                            while (n7 >= 0) {
                                if (n7 < tagTreeEncoderArray3[n].length) {
                                    tagTreeEncoderArray3[n][n7].save();
                                    tagTreeEncoderArray4[n][n7].save();
                                }
                                --n7;
                            }
                        }
                        ++n;
                    }
                    --n4;
                }
                --n5;
            }
            --n6;
        }
        this.saved = true;
    }
}

