/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.codestream.writer;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import jj2000.j2k.codestream.Markers;
import jj2000.j2k.encoder.EncoderSpecs;
import jj2000.j2k.entropy.Progression;
import jj2000.j2k.entropy.StdEntropyCoderOptions;
import jj2000.j2k.entropy.encoder.PostCompRateAllocator;
import jj2000.j2k.image.Coord;
import jj2000.j2k.image.ImgData;
import jj2000.j2k.image.Tiler;
import jj2000.j2k.io.BinaryDataOutput;
import jj2000.j2k.quantization.quantizer.StdQuantizer;
import jj2000.j2k.roi.encoder.ROIScaler;
import jj2000.j2k.util.MathUtil;
import jj2000.j2k.wavelet.analysis.AnWTFilter;
import jj2000.j2k.wavelet.analysis.ForwardWT;
import jj2000.j2k.wavelet.analysis.SubbandAn;

public class HeaderEncoder
implements Markers,
StdEntropyCoderOptions {
    private int defimgn;
    private int deftilenr;
    protected int nComp;
    protected ByteArrayOutputStream baos;
    protected DataOutputStream hbuf;
    protected ImgData origSrc;
    protected boolean[] isOrigSig;
    protected PostCompRateAllocator ralloc;
    protected ForwardWT dwt;
    protected Tiler tiler;
    protected ROIScaler roiSc;
    protected EncoderSpecs encSpec;

    public HeaderEncoder(ImgData imgData, boolean[] blArray, ForwardWT forwardWT, Tiler tiler, EncoderSpecs encoderSpecs, ROIScaler rOIScaler, PostCompRateAllocator postCompRateAllocator) {
        if (imgData.getNumComps() != blArray.length) {
            throw new IllegalArgumentException();
        }
        this.origSrc = imgData;
        this.isOrigSig = blArray;
        this.dwt = forwardWT;
        this.tiler = tiler;
        this.encSpec = encoderSpecs;
        this.roiSc = rOIScaler;
        this.ralloc = postCompRateAllocator;
        this.baos = new ByteArrayOutputStream();
        this.hbuf = new DataOutputStream(this.baos);
        this.nComp = imgData.getNumComps();
    }

    public void encodeMainHeader() throws IOException {
        this.writeSOC();
        this.writeSIZ();
        boolean bl = ((String)this.encSpec.tts.getDefault()).equals("predict");
        this.writeCOD(true, 0);
        int n = 0;
        while (n < this.nComp) {
            boolean bl2 = ((String)this.encSpec.tts.getCompDef(n)).equals("predict");
            if (this.encSpec.wfs.isCompSpecified(n) || this.encSpec.dls.isCompSpecified(n) || this.encSpec.bms.isCompSpecified(n) || this.encSpec.mqrs.isCompSpecified(n) || this.encSpec.rts.isCompSpecified(n) || this.encSpec.sss.isCompSpecified(n) || this.encSpec.css.isCompSpecified(n) || this.encSpec.pss.isCompSpecified(n) || this.encSpec.cblks.isCompSpecified(n) || bl != bl2) {
                this.writeCOC(true, 0, n);
            }
            ++n;
        }
        this.writeMainQCD();
        n = 0;
        while (n < this.nComp) {
            if (this.dwt.getNomRangeBits(n) != this.defimgn || this.encSpec.qts.isCompSpecified(n) || this.encSpec.qsss.isCompSpecified(n) || this.encSpec.dls.isCompSpecified(n) || this.encSpec.gbs.isCompSpecified(n)) {
                this.writeMainQCC(n);
            }
            ++n;
        }
        Progression[] progressionArray = (Progression[])this.encSpec.ps.getDefault();
        if (progressionArray.length > 1) {
            this.writePOC(true, 0);
        }
        this.writeCOM();
    }

    public void encodeTilePartHeader(int n, int n2) throws IOException {
        Progression[] progressionArray;
        boolean bl;
        this.hbuf.writeByte(-1);
        this.hbuf.writeByte(-112);
        this.hbuf.writeByte(0);
        this.hbuf.writeByte(10);
        if (n2 > 65534) {
            throw new IllegalArgumentException("Trying to write a tile-part header whose tile index is too high");
        }
        this.hbuf.writeByte(n2 >> 8);
        this.hbuf.writeByte(n2);
        int n3 = n;
        this.hbuf.writeByte(n3 >> 24);
        this.hbuf.writeByte(n3 >> 16);
        this.hbuf.writeByte(n3 >> 8);
        this.hbuf.writeByte(n3);
        this.hbuf.writeByte(0);
        this.hbuf.writeByte(1);
        boolean bl2 = ((String)this.encSpec.tts.getDefault()).equals("predict");
        boolean bl3 = ((String)this.encSpec.tts.getTileDef(n2)).equals("predict");
        boolean bl4 = false;
        if (this.encSpec.wfs.isTileSpecified(n2) || this.encSpec.cts.isTileSpecified(n2) || this.encSpec.dls.isTileSpecified(n2) || this.encSpec.bms.isTileSpecified(n2) || this.encSpec.mqrs.isTileSpecified(n2) || this.encSpec.rts.isTileSpecified(n2) || this.encSpec.css.isTileSpecified(n2) || this.encSpec.pss.isTileSpecified(n2) || this.encSpec.sops.isTileSpecified(n2) || this.encSpec.sss.isTileSpecified(n2) || this.encSpec.ps.isTileSpecified(n2) || this.encSpec.ephs.isTileSpecified(n2) || this.encSpec.cblks.isTileSpecified(n2) || bl2 != bl3) {
            this.writeCOD(false, n2);
            bl4 = true;
        }
        int n4 = 0;
        while (n4 < this.nComp) {
            bl = ((String)this.encSpec.tts.getTileCompVal(n2, n4)).equals("predict");
            if (this.encSpec.wfs.isTileCompSpecified(n2, n4) || this.encSpec.dls.isTileCompSpecified(n2, n4) || this.encSpec.bms.isTileCompSpecified(n2, n4) || this.encSpec.mqrs.isTileCompSpecified(n2, n4) || this.encSpec.rts.isTileCompSpecified(n2, n4) || this.encSpec.css.isTileCompSpecified(n2, n4) || this.encSpec.pss.isTileCompSpecified(n2, n4) || this.encSpec.sss.isTileCompSpecified(n2, n4) || this.encSpec.cblks.isTileCompSpecified(n2, n4) || bl != bl2) {
                this.writeCOC(false, n2, n4);
            } else if (bl4 && (this.encSpec.wfs.isCompSpecified(n4) || this.encSpec.dls.isCompSpecified(n4) || this.encSpec.bms.isCompSpecified(n4) || this.encSpec.mqrs.isCompSpecified(n4) || this.encSpec.rts.isCompSpecified(n4) || this.encSpec.sss.isCompSpecified(n4) || this.encSpec.css.isCompSpecified(n4) || this.encSpec.pss.isCompSpecified(n4) || this.encSpec.cblks.isCompSpecified(n4) || this.encSpec.tts.isCompSpecified(n4) && ((String)this.encSpec.tts.getCompDef(n4)).equals("predict"))) {
                this.writeCOC(false, n2, n4);
            }
            ++n4;
        }
        bl = false;
        if (this.encSpec.qts.isTileSpecified(n2) || this.encSpec.qsss.isTileSpecified(n2) || this.encSpec.dls.isTileSpecified(n2) || this.encSpec.gbs.isTileSpecified(n2)) {
            this.writeTileQCD(n2);
            bl = true;
        } else {
            this.deftilenr = this.defimgn;
        }
        int n5 = 0;
        while (n5 < this.nComp) {
            if (this.dwt.getNomRangeBits(n5) != this.deftilenr || this.encSpec.qts.isTileCompSpecified(n2, n5) || this.encSpec.qsss.isTileCompSpecified(n2, n5) || this.encSpec.dls.isTileCompSpecified(n2, n5) || this.encSpec.gbs.isTileCompSpecified(n2, n5)) {
                this.writeTileQCC(n2, n5);
            } else if (bl && (this.encSpec.qts.isCompSpecified(n5) || this.encSpec.qsss.isCompSpecified(n5) || this.encSpec.dls.isCompSpecified(n5) || this.encSpec.gbs.isCompSpecified(n5))) {
                this.writeTileQCC(n2, n5);
            }
            ++n5;
        }
        if (this.roiSc.useRoi() && !this.roiSc.getBlockAligned()) {
            this.writeRGN(n2);
        }
        if (this.encSpec.ps.isTileSpecified(n2) && (progressionArray = (Progression[])this.encSpec.ps.getTileDef(n2)).length > 1) {
            this.writePOC(false, n2);
        }
        this.hbuf.writeByte(-1);
        this.hbuf.writeByte(-109);
    }

    protected byte[] getBuffer() {
        return this.baos.toByteArray();
    }

    protected int getBufferLength() {
        return this.baos.size();
    }

    public int getLength() {
        return this.hbuf.size();
    }

    public void reset() {
        this.baos.reset();
        this.hbuf = new DataOutputStream(this.baos);
    }

    protected void writeCOC(boolean bl, int n, int n2) throws IOException {
        AnWTFilter[][] anWTFilterArray;
        Progression[] progressionArray;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (bl) {
            n3 = (Integer)this.encSpec.dls.getCompDef(n2);
            n5 = this.encSpec.pss.getPPX(-1, n2, n3);
            n6 = this.encSpec.pss.getPPY(-1, n2, n3);
            progressionArray = (Progression[])this.encSpec.ps.getCompDef(n2);
        } else {
            n3 = (Integer)this.encSpec.dls.getTileCompVal(n, n2);
            n5 = this.encSpec.pss.getPPX(n, n2, n3);
            n6 = this.encSpec.pss.getPPY(n, n2, n3);
            progressionArray = (Progression[])this.encSpec.ps.getTileCompVal(n, n2);
        }
        boolean bl2 = n5 != 65535 || n6 != 65535;
        if (bl2) {
            n4 = n3 + 1;
        }
        this.hbuf.writeShort(-173);
        int n7 = 8 + (this.nComp < 257 ? 1 : 2) + n4;
        this.hbuf.writeShort(n7);
        if (this.nComp < 257) {
            this.hbuf.write(n2);
        } else {
            this.hbuf.writeShort(n2);
        }
        int n8 = 0;
        if (bl2) {
            n8 = 1;
        }
        this.hbuf.write(n8);
        this.hbuf.write(n3);
        if (bl) {
            n8 = this.encSpec.cblks.getCBlkWidth((byte)1, -1, n2);
            this.hbuf.write(MathUtil.log2(n8) - 2);
            n8 = this.encSpec.cblks.getCBlkHeight((byte)1, -1, n2);
            this.hbuf.write(MathUtil.log2(n8) - 2);
        } else {
            n8 = this.encSpec.cblks.getCBlkWidth((byte)3, n, n2);
            this.hbuf.write(MathUtil.log2(n8) - 2);
            n8 = this.encSpec.cblks.getCBlkHeight((byte)3, n, n2);
            this.hbuf.write(MathUtil.log2(n8) - 2);
        }
        n8 = 0;
        if (bl) {
            if (((String)this.encSpec.bms.getCompDef(n2)).equals("on")) {
                n8 |= 1;
            }
            if (((String)this.encSpec.mqrs.getCompDef(n2)).equalsIgnoreCase("on")) {
                n8 |= 2;
            }
            if (((String)this.encSpec.rts.getCompDef(n2)).equals("on")) {
                n8 |= 4;
            }
            if (((String)this.encSpec.css.getCompDef(n2)).equals("on")) {
                n8 |= 8;
            }
            if (((String)this.encSpec.tts.getCompDef(n2)).equals("predict")) {
                n8 |= 0x10;
            }
            if (((String)this.encSpec.sss.getCompDef(n2)).equals("on")) {
                n8 |= 0x20;
            }
        } else {
            if (((String)this.encSpec.bms.getTileCompVal(n, n2)).equals("on")) {
                n8 |= 1;
            }
            if (((String)this.encSpec.mqrs.getTileCompVal(n, n2)).equals("on")) {
                n8 |= 2;
            }
            if (((String)this.encSpec.rts.getTileCompVal(n, n2)).equals("on")) {
                n8 |= 4;
            }
            if (((String)this.encSpec.css.getTileCompVal(n, n2)).equals("on")) {
                n8 |= 8;
            }
            if (((String)this.encSpec.tts.getTileCompVal(n, n2)).equals("predict")) {
                n8 |= 0x10;
            }
            if (((String)this.encSpec.sss.getTileCompVal(n, n2)).equals("on")) {
                n8 |= 0x20;
            }
        }
        this.hbuf.write(n8);
        if (bl) {
            anWTFilterArray = (AnWTFilter[][])this.encSpec.wfs.getCompDef(n2);
            this.hbuf.write(anWTFilterArray[0][0].getFilterType());
        } else {
            anWTFilterArray = (AnWTFilter[][])this.encSpec.wfs.getTileCompVal(n, n2);
            this.hbuf.write(anWTFilterArray[0][0].getFilterType());
        }
        if (bl2) {
            Vector[] vectorArray = null;
            vectorArray = bl ? (Vector[])this.encSpec.pss.getCompDef(n2) : (Vector[])this.encSpec.pss.getTileCompVal(n, n2);
            int n9 = n3;
            while (n9 >= 0) {
                n8 = n9 >= vectorArray[1].size() ? ((Integer)vectorArray[1].elementAt(vectorArray[1].size() - 1)).intValue() : ((Integer)vectorArray[1].elementAt(n9)).intValue();
                int n10 = MathUtil.log2(n8) << 4 & 0xF0;
                n8 = n9 >= vectorArray[0].size() ? ((Integer)vectorArray[0].elementAt(vectorArray[0].size() - 1)).intValue() : ((Integer)vectorArray[0].elementAt(n9)).intValue();
                int n11 = MathUtil.log2(n8) & 0xF;
                this.hbuf.write(n10 | n11);
                --n9;
            }
        }
    }

    protected void writeCOD(boolean bl, int n) throws IOException {
        AnWTFilter[][] anWTFilterArray;
        Progression[] progressionArray;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (bl) {
            n2 = (Integer)this.encSpec.dls.getDefault();
            n4 = this.encSpec.pss.getPPX(-1, -1, n2);
            n5 = this.encSpec.pss.getPPY(-1, -1, n2);
            progressionArray = (Progression[])this.encSpec.ps.getDefault();
        } else {
            n2 = (Integer)this.encSpec.dls.getTileDef(n);
            n4 = this.encSpec.pss.getPPX(n, -1, n2);
            n5 = this.encSpec.pss.getPPY(n, -1, n2);
            progressionArray = (Progression[])this.encSpec.ps.getTileDef(n);
        }
        boolean bl2 = n4 != 65535 || n5 != 65535;
        if (bl2) {
            n3 = n2 + 1;
        }
        this.hbuf.writeShort(-174);
        int n6 = 12 + n3;
        this.hbuf.writeShort(n6);
        int n7 = 0;
        if (bl2) {
            n7 = 1;
        }
        if (bl) {
            if (this.encSpec.sops.getDefault().toString().equalsIgnoreCase("on")) {
                n7 |= 2;
            }
        } else if (this.encSpec.sops.getTileDef(n).toString().equalsIgnoreCase("on")) {
            n7 |= 2;
        }
        if (bl) {
            if (this.encSpec.ephs.getDefault().toString().equalsIgnoreCase("on")) {
                n7 |= 4;
            }
        } else if (this.encSpec.ephs.getTileDef(n).toString().equalsIgnoreCase("on")) {
            n7 |= 4;
        }
        this.hbuf.write(n7);
        this.hbuf.write(progressionArray[0].type);
        this.hbuf.writeShort(this.ralloc.getNumLayers());
        String string = null;
        string = bl ? (String)this.encSpec.cts.getDefault() : (String)this.encSpec.cts.getTileDef(n);
        if (string.equals("none")) {
            this.hbuf.write(0);
        } else {
            this.hbuf.write(1);
        }
        this.hbuf.write(n2);
        if (bl) {
            n7 = this.encSpec.cblks.getCBlkWidth((byte)0, -1, -1);
            this.hbuf.write(MathUtil.log2(n7) - 2);
            n7 = this.encSpec.cblks.getCBlkHeight((byte)0, -1, -1);
            this.hbuf.write(MathUtil.log2(n7) - 2);
        } else {
            n7 = this.encSpec.cblks.getCBlkWidth((byte)2, n, -1);
            this.hbuf.write(MathUtil.log2(n7) - 2);
            n7 = this.encSpec.cblks.getCBlkHeight((byte)2, n, -1);
            this.hbuf.write(MathUtil.log2(n7) - 2);
        }
        n7 = 0;
        if (bl) {
            if (((String)this.encSpec.bms.getDefault()).equals("on")) {
                n7 |= 1;
            }
            if (((String)this.encSpec.mqrs.getDefault()).equals("on")) {
                n7 |= 2;
            }
            if (((String)this.encSpec.rts.getDefault()).equals("on")) {
                n7 |= 4;
            }
            if (((String)this.encSpec.css.getDefault()).equals("on")) {
                n7 |= 8;
            }
            if (((String)this.encSpec.tts.getDefault()).equals("predict")) {
                n7 |= 0x10;
            }
            if (((String)this.encSpec.sss.getDefault()).equals("on")) {
                n7 |= 0x20;
            }
        } else {
            if (((String)this.encSpec.bms.getTileDef(n)).equals("on")) {
                n7 |= 1;
            }
            if (((String)this.encSpec.mqrs.getTileDef(n)).equals("on")) {
                n7 |= 2;
            }
            if (((String)this.encSpec.rts.getTileDef(n)).equals("on")) {
                n7 |= 4;
            }
            if (((String)this.encSpec.css.getTileDef(n)).equals("on")) {
                n7 |= 8;
            }
            if (((String)this.encSpec.tts.getTileDef(n)).equals("predict")) {
                n7 |= 0x10;
            }
            if (((String)this.encSpec.sss.getTileDef(n)).equals("on")) {
                n7 |= 0x20;
            }
        }
        this.hbuf.write(n7);
        if (bl) {
            anWTFilterArray = (AnWTFilter[][])this.encSpec.wfs.getDefault();
            this.hbuf.write(anWTFilterArray[0][0].getFilterType());
        } else {
            anWTFilterArray = (AnWTFilter[][])this.encSpec.wfs.getTileDef(n);
            this.hbuf.write(anWTFilterArray[0][0].getFilterType());
        }
        if (bl2) {
            Vector[] vectorArray = null;
            vectorArray = bl ? (Vector[])this.encSpec.pss.getDefault() : (Vector[])this.encSpec.pss.getTileDef(n);
            int n8 = n2;
            while (n8 >= 0) {
                n7 = n8 >= vectorArray[1].size() ? ((Integer)vectorArray[1].elementAt(vectorArray[1].size() - 1)).intValue() : ((Integer)vectorArray[1].elementAt(n8)).intValue();
                int n9 = MathUtil.log2(n7) << 4 & 0xF0;
                n7 = n8 >= vectorArray[0].size() ? ((Integer)vectorArray[0].elementAt(vectorArray[0].size() - 1)).intValue() : ((Integer)vectorArray[0].elementAt(n8)).intValue();
                int n10 = MathUtil.log2(n7) & 0xF;
                this.hbuf.write(n9 | n10);
                --n8;
            }
        }
    }

    private void writeCOM() throws IOException {
        String string = "CREATOR: JJ2000 version 4.1";
        this.hbuf.writeShort(-156);
        int n = 4 + string.length();
        this.hbuf.writeShort(n);
        this.hbuf.writeShort(1);
        byte[] byArray = string.getBytes();
        int n2 = 0;
        while (n2 < byArray.length) {
            this.hbuf.writeByte(byArray[n2]);
            ++n2;
        }
    }

    protected void writeMainQCC(int n) throws IOException {
        SubbandAn subbandAn;
        int n2;
        SubbandAn subbandAn2;
        int n3;
        int n4 = this.encSpec.qts.isCompSpecified(n) ? this.encSpec.qts.getCompDefRep(n) : this.encSpec.qts.getDefRep()[0];
        SubbandAn subbandAn3 = this.dwt.getSubbandTree(n4, n);
        int n5 = this.dwt.getNomRangeBits(n);
        String string = (String)this.encSpec.qts.getCompDef(n);
        float f = ((Float)this.encSpec.qsss.getCompDef(n)).floatValue();
        int n6 = (Integer)this.encSpec.gbs.getCompDef(n);
        boolean bl = string.equals("reversible");
        boolean bl2 = string.equals("derived");
        int n7 = (Integer)this.encSpec.dls.getCompDef(n);
        int n8 = bl ? 0 : (bl2 ? 1 : 2);
        this.hbuf.writeShort(-163);
        switch (n8) {
            case 1: {
                n3 = 1;
                break;
            }
            case 0: 
            case 2: {
                n3 = 0;
                subbandAn2 = subbandAn3;
                n7 = subbandAn2.resLvl;
                subbandAn2 = (SubbandAn)subbandAn2.getSubbandByIdx(0, 0);
                while (subbandAn2.resLvl != 0) {
                    subbandAn2 = subbandAn2.subb_LL;
                }
                n2 = 0;
                while (n2 <= n7) {
                    subbandAn = subbandAn2;
                    while (subbandAn != null) {
                        ++n3;
                        subbandAn = (SubbandAn)subbandAn.nextSubband();
                    }
                    subbandAn2 = (SubbandAn)subbandAn2.getNextResLevel();
                    ++n2;
                }
                break;
            }
            default: {
                throw new Error("Internal JJ2000 error");
            }
        }
        n2 = 3 + (this.nComp < 257 ? 1 : 2) + (bl ? n3 : 2 * n3);
        this.hbuf.writeShort(n2);
        if (this.nComp < 257) {
            this.hbuf.write(n);
        } else {
            this.hbuf.writeShort(n);
        }
        this.hbuf.write(n8 + (n6 << 5));
        switch (n8) {
            case 0: {
                subbandAn2 = subbandAn3;
                subbandAn2 = (SubbandAn)subbandAn2.getSubbandByIdx(0, 0);
                int n9 = 0;
                while (n9 <= n7) {
                    subbandAn = subbandAn2;
                    while (subbandAn != null) {
                        int n10 = n5 + subbandAn.anGainExp;
                        this.hbuf.write(n10 << 3);
                        subbandAn = (SubbandAn)subbandAn.nextSubband();
                    }
                    subbandAn2 = (SubbandAn)subbandAn2.getNextResLevel();
                    ++n9;
                }
                break;
            }
            case 1: {
                subbandAn2 = subbandAn3;
                subbandAn2 = (SubbandAn)subbandAn2.getSubbandByIdx(0, 0);
                float f2 = f / (float)(1 << subbandAn2.level);
                this.hbuf.writeShort(StdQuantizer.convertToExpMantissa(f2));
                break;
            }
            case 2: {
                subbandAn2 = subbandAn3;
                n7 = subbandAn2.resLvl;
                subbandAn2 = (SubbandAn)subbandAn2.getSubbandByIdx(0, 0);
                int n11 = 0;
                while (n11 <= n7) {
                    subbandAn = subbandAn2;
                    while (subbandAn != null) {
                        float f3 = f / (subbandAn.l2Norm * (float)(1 << subbandAn.anGainExp));
                        this.hbuf.writeShort(StdQuantizer.convertToExpMantissa(f3));
                        subbandAn = (SubbandAn)subbandAn.nextSubband();
                    }
                    subbandAn2 = (SubbandAn)subbandAn2.getNextResLevel();
                    ++n11;
                }
                break;
            }
            default: {
                throw new Error("Internal JJ2000 error");
            }
        }
    }

    protected void writeMainQCD() throws IOException {
        SubbandAn subbandAn;
        int n;
        SubbandAn subbandAn2;
        int n2;
        int[] nArray = this.encSpec.dls.getDefRep();
        SubbandAn subbandAn3 = this.dwt.getSubbandTree(nArray[0], nArray[1]);
        this.defimgn = this.dwt.getNomRangeBits(nArray[1]);
        String string = (String)this.encSpec.qts.getDefault();
        float f = ((Float)this.encSpec.qsss.getDefault()).floatValue();
        int n3 = (Integer)this.encSpec.gbs.getDefault();
        boolean bl = string.equals("derived");
        boolean bl2 = string.equals("reversible");
        int n4 = bl2 ? 0 : (bl ? 1 : 2);
        this.hbuf.writeShort(-164);
        int n5 = (Integer)this.encSpec.dls.getDefault();
        switch (n4) {
            case 1: {
                n2 = 1;
                break;
            }
            case 0: 
            case 2: {
                n2 = 0;
                subbandAn2 = subbandAn3;
                subbandAn2 = (SubbandAn)subbandAn2.getSubbandByIdx(0, 0);
                n = 0;
                while (n <= n5) {
                    subbandAn = subbandAn2;
                    while (subbandAn != null) {
                        ++n2;
                        subbandAn = (SubbandAn)subbandAn.nextSubband();
                    }
                    subbandAn2 = (SubbandAn)subbandAn2.getNextResLevel();
                    ++n;
                }
                break;
            }
            default: {
                throw new Error("Internal JJ2000 error");
            }
        }
        n = 3 + (bl2 ? n2 : 2 * n2);
        this.hbuf.writeShort(n);
        this.hbuf.write(n4 + (n3 << 5));
        switch (n4) {
            case 0: {
                subbandAn2 = subbandAn3;
                subbandAn2 = (SubbandAn)subbandAn2.getSubbandByIdx(0, 0);
                int n6 = 0;
                while (n6 <= n5) {
                    subbandAn = subbandAn2;
                    while (subbandAn != null) {
                        int n7 = this.defimgn + subbandAn.anGainExp;
                        this.hbuf.write(n7 << 3);
                        subbandAn = (SubbandAn)subbandAn.nextSubband();
                    }
                    subbandAn2 = (SubbandAn)subbandAn2.getNextResLevel();
                    ++n6;
                }
                break;
            }
            case 1: {
                subbandAn2 = subbandAn3;
                subbandAn2 = (SubbandAn)subbandAn2.getSubbandByIdx(0, 0);
                float f2 = f / (float)(1 << subbandAn2.level);
                this.hbuf.writeShort(StdQuantizer.convertToExpMantissa(f2));
                break;
            }
            case 2: {
                subbandAn2 = subbandAn3;
                subbandAn2 = (SubbandAn)subbandAn2.getSubbandByIdx(0, 0);
                int n8 = 0;
                while (n8 <= n5) {
                    subbandAn = subbandAn2;
                    while (subbandAn != null) {
                        float f3 = f / (subbandAn.l2Norm * (float)(1 << subbandAn.anGainExp));
                        this.hbuf.writeShort(StdQuantizer.convertToExpMantissa(f3));
                        subbandAn = (SubbandAn)subbandAn.nextSubband();
                    }
                    subbandAn2 = (SubbandAn)subbandAn2.getNextResLevel();
                    ++n8;
                }
                break;
            }
            default: {
                throw new Error("Internal JJ2000 error");
            }
        }
    }

    protected void writePOC(boolean bl, int n) throws IOException {
        int n2 = 0;
        Progression[] progressionArray = null;
        progressionArray = bl ? (Progression[])this.encSpec.ps.getDefault() : (Progression[])this.encSpec.ps.getTileDef(n);
        int n3 = this.nComp < 257 ? 1 : 2;
        this.hbuf.writeShort(-161);
        int n4 = progressionArray.length - 1;
        n2 = 2 + n4 * (1 + n3 + 2 + 1 + n3 + 1);
        this.hbuf.writeShort(n2);
        int n5 = 0;
        while (n5 < n4) {
            this.hbuf.write(progressionArray[n5].rs);
            if (n3 == 2) {
                this.hbuf.writeShort(progressionArray[n5].cs);
            } else {
                this.hbuf.write(progressionArray[n5].cs);
            }
            this.hbuf.writeShort(progressionArray[n5].lye);
            this.hbuf.write(progressionArray[n5].re);
            if (n3 == 2) {
                this.hbuf.writeShort(progressionArray[n5].ce);
            } else {
                this.hbuf.write(progressionArray[n5].ce);
            }
            this.hbuf.write(progressionArray[n5 + 1].type);
            ++n5;
        }
    }

    private void writeRGN(int n) throws IOException {
        int n2 = 0;
        while (n2 < this.nComp) {
            this.hbuf.writeShort(-162);
            int n3 = 4 + (this.nComp < 257 ? 1 : 2);
            this.hbuf.writeShort(n3);
            if (this.nComp < 257) {
                this.hbuf.writeByte(n2);
            } else {
                this.hbuf.writeShort(n2);
            }
            this.hbuf.writeByte(0);
            this.hbuf.writeByte((Integer)this.encSpec.rois.getTileCompVal(n, n2));
            ++n2;
        }
    }

    private void writeSIZ() throws IOException {
        this.hbuf.writeShort(-175);
        int n = 38 + 3 * this.nComp;
        this.hbuf.writeShort(n);
        this.hbuf.writeShort(0);
        this.hbuf.writeInt(this.tiler.getImgWidth() + this.tiler.getImgULX());
        this.hbuf.writeInt(this.tiler.getImgHeight() + this.tiler.getImgULY());
        this.hbuf.writeInt(this.tiler.getImgULX());
        this.hbuf.writeInt(this.tiler.getImgULY());
        this.hbuf.writeInt(this.tiler.getNomTileWidth());
        this.hbuf.writeInt(this.tiler.getNomTileHeight());
        Coord coord = this.tiler.getTilingOrigin(null);
        this.hbuf.writeInt(coord.x);
        this.hbuf.writeInt(coord.y);
        this.hbuf.writeShort(this.nComp);
        int n2 = 0;
        while (n2 < this.nComp) {
            int n3 = this.origSrc.getNomRangeBits(n2) - 1;
            this.hbuf.write(n3 |= (this.isOrigSig[n2] ? 1 : 0) << 7);
            this.hbuf.write(this.tiler.getCompSubsX(n2));
            this.hbuf.write(this.tiler.getCompSubsY(n2));
            ++n2;
        }
    }

    private void writeSOC() throws IOException {
        this.hbuf.writeShort(-177);
    }

    protected void writeTileQCC(int n, int n2) throws IOException {
        SubbandAn subbandAn;
        int n3;
        SubbandAn subbandAn2;
        int n4;
        SubbandAn subbandAn3 = this.dwt.getSubbandTree(n, n2);
        int n5 = this.dwt.getNomRangeBits(n2);
        String string = (String)this.encSpec.qts.getTileCompVal(n, n2);
        float f = ((Float)this.encSpec.qsss.getTileCompVal(n, n2)).floatValue();
        int n6 = (Integer)this.encSpec.gbs.getTileCompVal(n, n2);
        boolean bl = string.equals("reversible");
        boolean bl2 = string.equals("derived");
        int n7 = (Integer)this.encSpec.dls.getTileCompVal(n, n2);
        int n8 = bl ? 0 : (bl2 ? 1 : 2);
        this.hbuf.writeShort(-163);
        switch (n8) {
            case 1: {
                n4 = 1;
                break;
            }
            case 0: 
            case 2: {
                n4 = 0;
                subbandAn2 = subbandAn3;
                n7 = subbandAn2.resLvl;
                subbandAn2 = (SubbandAn)subbandAn2.getSubbandByIdx(0, 0);
                while (subbandAn2.resLvl != 0) {
                    subbandAn2 = subbandAn2.subb_LL;
                }
                n3 = 0;
                while (n3 <= n7) {
                    subbandAn = subbandAn2;
                    while (subbandAn != null) {
                        ++n4;
                        subbandAn = (SubbandAn)subbandAn.nextSubband();
                    }
                    subbandAn2 = (SubbandAn)subbandAn2.getNextResLevel();
                    ++n3;
                }
                break;
            }
            default: {
                throw new Error("Internal JJ2000 error");
            }
        }
        n3 = 3 + (this.nComp < 257 ? 1 : 2) + (bl ? n4 : 2 * n4);
        this.hbuf.writeShort(n3);
        if (this.nComp < 257) {
            this.hbuf.write(n2);
        } else {
            this.hbuf.writeShort(n2);
        }
        this.hbuf.write(n8 + (n6 << 5));
        switch (n8) {
            case 0: {
                subbandAn2 = subbandAn3;
                subbandAn2 = (SubbandAn)subbandAn2.getSubbandByIdx(0, 0);
                int n9 = 0;
                while (n9 <= n7) {
                    subbandAn = subbandAn2;
                    while (subbandAn != null) {
                        int n10 = n5 + subbandAn.anGainExp;
                        this.hbuf.write(n10 << 3);
                        subbandAn = (SubbandAn)subbandAn.nextSubband();
                    }
                    subbandAn2 = (SubbandAn)subbandAn2.getNextResLevel();
                    ++n9;
                }
                break;
            }
            case 1: {
                subbandAn2 = subbandAn3;
                subbandAn2 = (SubbandAn)subbandAn2.getSubbandByIdx(0, 0);
                float f2 = f / (float)(1 << subbandAn2.level);
                this.hbuf.writeShort(StdQuantizer.convertToExpMantissa(f2));
                break;
            }
            case 2: {
                subbandAn2 = subbandAn3;
                n7 = subbandAn2.resLvl;
                subbandAn2 = (SubbandAn)subbandAn2.getSubbandByIdx(0, 0);
                int n11 = 0;
                while (n11 <= n7) {
                    subbandAn = subbandAn2;
                    while (subbandAn != null) {
                        float f3 = f / (subbandAn.l2Norm * (float)(1 << subbandAn.anGainExp));
                        this.hbuf.writeShort(StdQuantizer.convertToExpMantissa(f3));
                        subbandAn = (SubbandAn)subbandAn.nextSubband();
                    }
                    subbandAn2 = (SubbandAn)subbandAn2.getNextResLevel();
                    ++n11;
                }
                break;
            }
            default: {
                throw new Error("Internal JJ2000 error");
            }
        }
    }

    protected void writeTileQCD(int n) throws IOException {
        SubbandAn subbandAn;
        int n2;
        SubbandAn subbandAn2;
        int n3;
        SubbandAn subbandAn3;
        int n4;
        if (this.encSpec.qts.isTileSpecified(n)) {
            n4 = this.encSpec.qts.getTileDefRep(n);
            subbandAn3 = this.dwt.getSubbandTree(n, n4);
            this.deftilenr = this.dwt.getNomRangeBits(n4);
        } else {
            n4 = 0;
            n4 = 0;
            while (n4 < this.nComp) {
                if (!this.encSpec.qts.isCompSpecified(n4)) break;
                ++n4;
            }
            if (n4 >= this.nComp) {
                throw new IllegalArgumentException("No component default value for quantization type");
            }
            subbandAn3 = this.dwt.getSubbandTree(n, n4);
            this.deftilenr = this.dwt.getNomRangeBits(n4);
        }
        String string = (String)this.encSpec.qts.getTileDef(n);
        float f = ((Float)this.encSpec.qsss.getTileDef(n)).floatValue();
        int n5 = (Integer)this.encSpec.gbs.getTileDef(n);
        boolean bl = string.equals("derived");
        boolean bl2 = string.equals("reversible");
        int n6 = bl2 ? 0 : (bl ? 1 : 2);
        this.hbuf.writeShort(-164);
        int n7 = (Integer)this.encSpec.dls.getTileDef(n);
        switch (n6) {
            case 1: {
                n3 = 1;
                break;
            }
            case 0: 
            case 2: {
                n3 = 0;
                subbandAn2 = subbandAn3;
                subbandAn2 = (SubbandAn)subbandAn2.getSubbandByIdx(0, 0);
                n2 = 0;
                while (n2 <= n7) {
                    subbandAn = subbandAn2;
                    while (subbandAn != null) {
                        ++n3;
                        subbandAn = (SubbandAn)subbandAn.nextSubband();
                    }
                    subbandAn2 = (SubbandAn)subbandAn2.getNextResLevel();
                    ++n2;
                }
                break;
            }
            default: {
                throw new Error("Internal JJ2000 error");
            }
        }
        n2 = 3 + (bl2 ? n3 : 2 * n3);
        this.hbuf.writeShort(n2);
        this.hbuf.write(n6 + (n5 << 5));
        switch (n6) {
            case 0: {
                subbandAn2 = subbandAn3;
                subbandAn2 = (SubbandAn)subbandAn2.getSubbandByIdx(0, 0);
                int n8 = 0;
                while (n8 <= n7) {
                    subbandAn = subbandAn2;
                    while (subbandAn != null) {
                        int n9 = this.deftilenr + subbandAn.anGainExp;
                        this.hbuf.write(n9 << 3);
                        subbandAn = (SubbandAn)subbandAn.nextSubband();
                    }
                    subbandAn2 = (SubbandAn)subbandAn2.getNextResLevel();
                    ++n8;
                }
                break;
            }
            case 1: {
                subbandAn2 = subbandAn3;
                subbandAn2 = (SubbandAn)subbandAn2.getSubbandByIdx(0, 0);
                float f2 = f / (float)(1 << subbandAn2.level);
                this.hbuf.writeShort(StdQuantizer.convertToExpMantissa(f2));
                break;
            }
            case 2: {
                subbandAn2 = subbandAn3;
                subbandAn2 = (SubbandAn)subbandAn2.getSubbandByIdx(0, 0);
                int n10 = 0;
                while (n10 <= n7) {
                    subbandAn = subbandAn2;
                    while (subbandAn != null) {
                        float f3 = f / (subbandAn.l2Norm * (float)(1 << subbandAn.anGainExp));
                        this.hbuf.writeShort(StdQuantizer.convertToExpMantissa(f3));
                        subbandAn = (SubbandAn)subbandAn.nextSubband();
                    }
                    subbandAn2 = (SubbandAn)subbandAn2.getNextResLevel();
                    ++n10;
                }
                break;
            }
            default: {
                throw new Error("Internal JJ2000 error");
            }
        }
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.getBuffer(), 0, this.getBufferLength());
    }

    public void writeTo(BinaryDataOutput binaryDataOutput) throws IOException {
        byte[] byArray = this.getBuffer();
        int n = this.getLength();
        int n2 = 0;
        while (n2 < n) {
            binaryDataOutput.writeByte(byArray[n2]);
            ++n2;
        }
    }
}

