/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.codestream.reader;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import jj2000.j2k.io.RandomAccessIO;

class PktHeaderBitReader {
    RandomAccessIO in;
    ByteArrayInputStream bais;
    boolean usebais;
    int bbuf;
    int bpos;
    int nextbbuf;

    PktHeaderBitReader(ByteArrayInputStream byteArrayInputStream) {
        this.bais = byteArrayInputStream;
        this.usebais = true;
    }

    PktHeaderBitReader(RandomAccessIO randomAccessIO) {
        this.in = randomAccessIO;
        this.usebais = false;
    }

    final int readBit() throws IOException {
        if (this.bpos == 0) {
            if (this.bbuf != 255) {
                this.bbuf = this.usebais ? this.bais.read() : this.in.read();
                this.bpos = 8;
                if (this.bbuf == 255) {
                    this.nextbbuf = this.usebais ? this.bais.read() : this.in.read();
                }
            } else {
                this.bbuf = this.nextbbuf;
                this.bpos = 7;
            }
        }
        return this.bbuf >> --this.bpos & 1;
    }

    final int readBits(int n) throws IOException {
        if (n <= this.bpos) {
            return this.bbuf >> (this.bpos -= n) & (1 << n) - 1;
        }
        int n2 = 0;
        do {
            n2 <<= this.bpos;
            n -= this.bpos;
            n2 |= this.readBits(this.bpos);
            if (this.bbuf != 255) {
                this.bbuf = this.usebais ? this.bais.read() : this.in.read();
                this.bpos = 8;
                if (this.bbuf != 255) continue;
                if (this.usebais) {
                    this.nextbbuf = this.bais.read();
                    continue;
                }
                this.nextbbuf = this.in.read();
                continue;
            }
            this.bbuf = this.nextbbuf;
            this.bpos = 7;
        } while (n > this.bpos);
        n2 <<= n;
        return n2 |= this.bbuf >> (this.bpos -= n) & (1 << n) - 1;
    }

    void setInput(ByteArrayInputStream byteArrayInputStream) {
        this.bais = byteArrayInputStream;
        this.bbuf = 0;
        this.bpos = 0;
    }

    void setInput(RandomAccessIO randomAccessIO) {
        this.in = randomAccessIO;
        this.bbuf = 0;
        this.bpos = 0;
    }

    void sync() {
        this.bbuf = 0;
        this.bpos = 0;
    }
}

