/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.codestream.reader;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Vector;
import jj2000.j2k.codestream.CBlkCoordInfo;
import jj2000.j2k.codestream.PrecCoordInfo;
import jj2000.j2k.codestream.reader.CBlkInfo;
import jj2000.j2k.codestream.reader.FileBitstreamReaderAgent;
import jj2000.j2k.codestream.reader.HeaderDecoder;
import jj2000.j2k.codestream.reader.PktHeaderBitReader;
import jj2000.j2k.codestream.reader.TagTreeDecoder;
import jj2000.j2k.decoder.DecoderSpecs;
import jj2000.j2k.entropy.StdEntropyCoderOptions;
import jj2000.j2k.image.Coord;
import jj2000.j2k.io.RandomAccessIO;
import jj2000.j2k.util.ArrayUtil;
import jj2000.j2k.util.MathUtil;
import jj2000.j2k.wavelet.Subband;
import jj2000.j2k.wavelet.synthesis.SubbandSyn;

public class PktDecoder
implements StdEntropyCoderOptions {
    private FileBitstreamReaderAgent src;
    private boolean pph = false;
    private ByteArrayInputStream pphbais;
    private DecoderSpecs decSpec;
    private HeaderDecoder hd;
    private final int INIT_LBLOCK = 3;
    private PktHeaderBitReader bin;
    private RandomAccessIO ehs;
    private Coord[][] maxNumPrecincts;
    private int tIdx;
    private CBlkCoordInfo[][][][][] cbCoord;
    private PrecCoordInfo[][][][] precCoord;
    private int[][][][][] lblock;
    private TagTreeDecoder[][][][] tdInclA;
    private TagTreeDecoder[][][][] tdBDA;
    private int nl = 0;
    private int[][][] subRange;
    private int[] mdl = null;
    private int nc;
    private Coord[][] incArray;
    private Coord[] incArrayMax;
    private Coord[][][] sotEotArray;
    private Coord[][] sotEotArrayMax;
    private boolean sopUsed = false;
    private boolean ephUsed = false;
    private int pktIdx;
    private Vector[] cblks;
    private boolean isTruncMode;

    public PktDecoder(DecoderSpecs decoderSpecs, HeaderDecoder headerDecoder, RandomAccessIO randomAccessIO, FileBitstreamReaderAgent fileBitstreamReaderAgent, boolean bl) {
        this.decSpec = decoderSpecs;
        this.hd = headerDecoder;
        this.ehs = randomAccessIO;
        this.isTruncMode = bl;
        this.bin = new PktHeaderBitReader(randomAccessIO);
        this.src = fileBitstreamReaderAgent;
    }

    private void buildCBlkPrecCoord(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        SubbandSyn subbandSyn;
        int n7 = this.subRange[n][n2][0];
        while (n7 <= this.subRange[n][n2][1]) {
            subbandSyn = (SubbandSyn)this.src.getSubbandTree(this.tIdx, n).getSubbandByIdx(n2, n7);
            int n8 = this.src.getPartitionULX();
            int n9 = this.src.getPartitionULY();
            block0 : switch (subbandSyn.gOrient) {
                case 1: {
                    n8 = 0;
                    Subband subband = subbandSyn;
                    do {
                        if (subband.orientation != 3 && subband.orientation != 2) continue;
                        n9 = 0;
                        break block0;
                    } while (subband.gOrient != 0 && (subband = ((Subband)subband).getParent()) != null);
                    break;
                }
                case 2: {
                    Subband subband = subbandSyn;
                    do {
                        if (subband.orientation != 3 && subband.orientation != 1) continue;
                        n8 = 0;
                        break;
                    } while (subband.gOrient != 0 && (subband = ((Subband)subband).getParent()) != null);
                    n9 = 0;
                    break;
                }
                case 3: {
                    n8 = 0;
                    n9 = 0;
                    break;
                }
                default: {
                    throw new Error("Internal JJ2000 error");
                }
                case 0: 
            }
            CBlkCoordInfo cBlkCoordInfo = null;
            if (this.cbCoord[n][n2][n7] != null) {
                n6 = this.cbCoord[n][n2][n7].length;
                n5 = n6 != 0 ? this.cbCoord[n][n2][n7][0].length : 0;
                n4 = 0;
                while (n4 < n6) {
                    n3 = 0;
                    while (n3 < n5) {
                        CBlkCoordInfo cBlkCoordInfo2 = new CBlkCoordInfo();
                        this.cbCoord[n][n2][n7][n4][n3] = cBlkCoordInfo2;
                        cBlkCoordInfo = cBlkCoordInfo2;
                        cBlkCoordInfo.idx = new Coord(n3, n4);
                        int n10 = (subbandSyn.ulcx - n8 + subbandSyn.nomCBlkW) / subbandSyn.nomCBlkW - 1;
                        int n11 = (subbandSyn.ulcy - n9 + subbandSyn.nomCBlkH) / subbandSyn.nomCBlkH - 1;
                        cBlkCoordInfo.ulx = n3 == 0 ? subbandSyn.ulx : (n10 + n3) * subbandSyn.nomCBlkW - (subbandSyn.ulcx - n8) + subbandSyn.ulx;
                        cBlkCoordInfo.uly = n4 == 0 ? subbandSyn.uly : (n11 + n4) * subbandSyn.nomCBlkH - (subbandSyn.ulcy - n9) + subbandSyn.uly;
                        cBlkCoordInfo.w = n3 < n5 - 1 ? (n10 + n3 + 1) * subbandSyn.nomCBlkW - (subbandSyn.ulcx - n8) + subbandSyn.ulx - cBlkCoordInfo.ulx : subbandSyn.ulx + subbandSyn.w - cBlkCoordInfo.ulx;
                        cBlkCoordInfo.h = n4 < n6 - 1 ? (n11 + n4 + 1) * subbandSyn.nomCBlkH - (subbandSyn.ulcy - n9) + subbandSyn.uly - cBlkCoordInfo.uly : subbandSyn.uly + subbandSyn.h - cBlkCoordInfo.uly;
                        ++n3;
                    }
                    ++n4;
                }
            }
            ++n7;
        }
        n3 = 0;
        int n12 = 0;
        int n13 = -1;
        int[] nArray = new int[this.subRange[n][n2][1] + 1];
        boolean bl = false;
        n5 = this.incArray[n][n2].x;
        n4 = this.incArray[n][n2].y;
        int n14 = this.sotEotArrayMax[n][0].y;
        while (n14 < this.sotEotArrayMax[n][1].y) {
            int n15 = this.sotEotArrayMax[n][0].x;
            while (n15 < this.sotEotArrayMax[n][1].x) {
                if (!(n15 != this.sotEotArrayMax[n][0].x && n15 % n5 != 0 || n14 != this.sotEotArrayMax[n][0].y && n14 % n4 != 0)) {
                    bl = false;
                    int n16 = this.subRange[n][n2][0];
                    while (n16 <= this.subRange[n][n2][1]) {
                        subbandSyn = (SubbandSyn)this.src.getSubbandTree(this.tIdx, n).getSubbandByIdx(n2, n16);
                        if (!this.hd.precinctPartitionUsed()) {
                            subbandSyn = (SubbandSyn)this.src.getSubbandTree(this.tIdx, n).getSubbandByIdx(n2, n16);
                            if (this.precCoord[n][n2][n16][0] == null) {
                                this.precCoord[n][n2][n16][0] = new PrecCoordInfo(0, 0, subbandSyn.w, subbandSyn.h, n15, n14);
                            }
                        } else {
                            int n17 = this.src.getPPX(this.tIdx, n, n2);
                            n6 = this.src.getPPY(this.tIdx, n, n2);
                            n13 = nArray[n16];
                            if (n13 >= 0 && n13 <= this.maxNumPrecincts[n][n2].x * this.maxNumPrecincts[n][n2].y - 1) {
                                if (n15 == this.sotEotArrayMax[n][0].x && this.sotEotArrayMax[n][0].x != this.sotEotArray[n][n2][0].x >> this.mdl[n] - n2) {
                                    if (n2 == 0) {
                                        n3 = (int)((double)this.sotEotArray[n][n2][0].x / Math.pow(2.0, this.mdl[n] - n2) - (double)subbandSyn.ulcx);
                                    } else {
                                        n3 = (int)((double)this.sotEotArray[n][n2][0].x / Math.pow(2.0, this.mdl[n] - n2 + 1) - (double)subbandSyn.ulcx);
                                        n17 >>= 1;
                                    }
                                } else if (n2 == 0) {
                                    n3 = (int)((double)n15 / Math.pow(2.0, this.mdl[n] - n2) - (double)subbandSyn.ulcx);
                                } else {
                                    n3 = (int)((double)n15 / Math.pow(2.0, this.mdl[n] - n2 + 1) - (double)subbandSyn.ulcx);
                                    n17 >>= 1;
                                }
                                if (n14 == this.sotEotArrayMax[n][0].y && this.sotEotArrayMax[n][0].y != this.sotEotArray[n][n2][0].y >> this.mdl[n] - n2) {
                                    if (n2 == 0) {
                                        n12 = (int)((double)this.sotEotArray[n][n2][0].y / Math.pow(2.0, this.mdl[n] - n2) - (double)subbandSyn.ulcy);
                                    } else {
                                        n12 = (int)((double)this.sotEotArray[n][n2][0].y / Math.pow(2.0, this.mdl[n] - n2 + 1) - (double)subbandSyn.ulcy);
                                        n6 >>= 1;
                                    }
                                } else if (n2 == 0) {
                                    n12 = (int)((double)n14 / Math.pow(2.0, this.mdl[n] - n2) - (double)subbandSyn.ulcy);
                                } else {
                                    n12 = (int)((double)n14 / Math.pow(2.0, this.mdl[n] - n2 + 1) - (double)subbandSyn.ulcy);
                                    n6 >>= 1;
                                }
                                if (n3 + n17 > 0 && n12 + n6 > 0 && n3 < subbandSyn.w && n12 < subbandSyn.h) {
                                    this.precCoord[n][n2][n16][n13] = new PrecCoordInfo(n3 < 0 ? 0 : n3, n12 < 0 ? 0 : n12, n3 + n17 >= subbandSyn.w ? subbandSyn.w : n3 + n17, n12 + n6 >= subbandSyn.h ? subbandSyn.h : n12 + n6, n15, n14);
                                    bl = true;
                                }
                            }
                        }
                        ++n16;
                    }
                    if (this.hd.precinctPartitionUsed() && bl) {
                        int n18 = this.subRange[n][n2][0];
                        while (n18 <= this.subRange[n][n2][1]) {
                            int n19 = n18++;
                            nArray[n19] = nArray[n19] + 1;
                        }
                    }
                }
                n15 += this.incArrayMax[n].x;
            }
            n14 += this.incArrayMax[n].y;
        }
    }

    private void buildIncArrays(int n) {
        this.incArrayMax[n] = new Coord();
        int n2 = 0;
        while (n2 <= this.mdl[n]) {
            int n3 = this.getPPX(this.tIdx, n, n2);
            int n4 = this.getPPY(this.tIdx, n, n2);
            this.incArray[n][n2] = new Coord();
            this.incArray[n][n2].x = this.src.getCompSubsX(n);
            this.incArray[n][n2].x <<= MathUtil.log2(n3) + this.mdl[n] - n2;
            if (this.incArrayMax[n].x == 0 || this.incArray[n][n2].x < this.incArrayMax[n].x) {
                this.incArrayMax[n].x = this.incArray[n][n2].x;
            }
            this.incArray[n][n2].y = this.src.getCompSubsY(n);
            this.incArray[n][n2].y <<= MathUtil.log2(n4) + this.mdl[n] - n2;
            if (this.incArrayMax[n].y == 0 || this.incArray[n][n2].y < this.incArrayMax[n].y) {
                this.incArrayMax[n].y = this.incArray[n][n2].y;
            }
            ++n2;
        }
    }

    private void buildSotEotArrays(int n) {
        this.sotEotArrayMax[n][0] = new Coord();
        this.sotEotArrayMax[n][1] = new Coord();
        if (this.incArrayMax[n].x == 0) {
            this.sotEotArrayMax[n][0].x = 0;
            this.sotEotArrayMax[n][1].x = 1;
            this.incArrayMax[n].x = 1;
        } else {
            this.sotEotArrayMax[n][0].x = this.src.getULX(n, this.mdl[n]);
            this.sotEotArrayMax[n][1].x = this.sotEotArrayMax[n][0].x + this.src.getCompWidth(n, this.mdl[n]);
            this.sotEotArrayMax[n][0].x &= ~(this.incArrayMax[n].x - 1);
        }
        if (this.incArrayMax[n].y == 0) {
            this.sotEotArrayMax[n][0].y = 0;
            this.sotEotArrayMax[n][1].y = 1;
            this.incArrayMax[n].y = 1;
        } else {
            this.sotEotArrayMax[n][0].y = this.src.getULY(n, this.mdl[n]);
            this.sotEotArrayMax[n][1].y = this.sotEotArrayMax[n][0].y + this.src.getCompHeight(n, this.mdl[n]);
            this.sotEotArrayMax[n][0].y &= ~(this.incArrayMax[n].y - 1);
        }
        int n2 = 0;
        while (n2 <= this.mdl[n]) {
            this.sotEotArray[n][n2][0] = new Coord();
            this.sotEotArray[n][n2][1] = new Coord();
            if (this.incArray[n][n2].x == 0) {
                this.sotEotArray[n][n2][0].x = 0;
                this.sotEotArray[n][n2][1].x = 1;
                this.incArray[n][n2].x = 1;
            } else {
                this.sotEotArray[n][n2][0].x = this.src.getULX(n, this.mdl[n]);
                this.sotEotArray[n][n2][1].x = this.sotEotArray[n][n2][0].x + this.src.getCompWidth(n, this.mdl[n]);
                this.sotEotArray[n][n2][0].x &= ~(this.incArray[n][n2].x - 1);
            }
            if (this.incArray[n][n2].y == 0) {
                this.sotEotArray[n][n2][0].y = 0;
                this.sotEotArray[n][n2][1].y = 1;
                this.incArray[n][n2].y = 1;
            } else {
                this.sotEotArray[n][n2][0].y = this.src.getULY(n, this.mdl[n]);
                this.sotEotArray[n][n2][1].y = this.sotEotArray[n][n2][0].y + this.src.getCompHeight(n, this.mdl[n]);
                this.sotEotArray[n][n2][0].y &= ~(this.incArray[n][n2].y - 1);
            }
            ++n2;
        }
    }

    private int[][][] findSubInResLvl() {
        int[][][] nArray = new int[this.nc][][];
        int n = 0;
        while (n < this.nc) {
            nArray[n] = new int[this.mdl[n] + 1][2];
            int n2 = this.mdl[n];
            while (n2 > 0) {
                nArray[n][n2][0] = 1;
                nArray[n][n2][1] = 3;
                --n2;
            }
            nArray[n][0][0] = 0;
            nArray[n][0][1] = 0;
            ++n;
        }
        return nArray;
    }

    private Vector getCBlkInPrecinct(int n, int n2, int n3, int n4) {
        Vector<Coord> vector = new Vector<Coord>();
        Coord coord = new Coord();
        SubbandSyn subbandSyn = null;
        subbandSyn = (SubbandSyn)this.src.getSubbandTree(this.tIdx, n).getSubbandByIdx(n2, n3);
        if (subbandSyn.h == 0 || subbandSyn.w == 0 || this.precCoord[n][n2] == null || this.precCoord[n][n2][n3] == null || this.precCoord[n][n2][n3][n4] == null || this.cbCoord[n][n2][n3] == null) {
            vector.addElement(new Coord(0, 0));
            return vector;
        }
        int n5 = this.precCoord[n][n2][n3][n4].ulx;
        int n6 = this.precCoord[n][n2][n3][n4].uly;
        int n7 = this.precCoord[n][n2][n3][n4].w;
        int n8 = this.precCoord[n][n2][n3][n4].h;
        coord.y = 0;
        coord.x = 0;
        int n9 = -1;
        int n10 = -1;
        int n11 = 0;
        while (n11 < this.cbCoord[n][n2][n3].length) {
            int n12 = 0;
            while (n12 < this.cbCoord[n][n2][n3][n11].length) {
                int n13 = this.cbCoord[n][n2][n3][n11][n12].ulx - subbandSyn.ulx;
                int n14 = this.cbCoord[n][n2][n3][n11][n12].uly - subbandSyn.uly;
                int n15 = this.cbCoord[n][n2][n3][n11][n12].w;
                int n16 = this.cbCoord[n][n2][n3][n11][n12].h;
                if (this.hd.precinctPartitionUsed()) {
                    if (n13 >= n5 && n13 + n15 <= n7 && n14 >= n6 && n14 + n16 <= n8) {
                        if (n13 > n10) {
                            n10 = n13;
                            ++coord.x;
                        }
                        if (n14 > n9) {
                            n9 = n14;
                            ++coord.y;
                        }
                        vector.addElement(new Coord(n11, n12));
                    }
                } else {
                    if (n13 > n10) {
                        ++coord.x;
                        n10 = n13;
                    }
                    if (n14 > n9) {
                        ++coord.y;
                        n9 = n14;
                    }
                    vector.addElement(new Coord(n11, n12));
                }
                ++n12;
            }
            ++n11;
        }
        vector.insertElementAt(coord, 0);
        return vector;
    }

    public Coord getIncArray(int n, int n2) {
        return this.incArray[n][n2];
    }

    public Coord getIncArrayMax(int n) {
        return this.incArrayMax[n];
    }

    public int getNumPrecinct(int n, int n2) {
        return this.maxNumPrecincts[n][n2].x * this.maxNumPrecincts[n][n2].y;
    }

    public final int getPPX(int n, int n2, int n3) {
        return this.decSpec.pss.getPPX(n, n2, n3);
    }

    public final int getPPY(int n, int n2, int n3) {
        return this.decSpec.pss.getPPY(n, n2, n3);
    }

    public Coord[] getSotEotArray(int n, int n2) {
        return this.sotEotArray[n][n2];
    }

    public Coord[] getSotEotArrayMax(int n) {
        return this.sotEotArrayMax[n];
    }

    public void readEPHMarker(PktHeaderBitReader pktHeaderBitReader) throws IOException {
        byte[] byArray = new byte[2];
        if (pktHeaderBitReader.usebais) {
            pktHeaderBitReader.bais.read(byArray, 0, 2);
        } else {
            pktHeaderBitReader.in.readFully(byArray, 0, 2);
        }
        int n = byArray[0];
        n <<= 8;
        if ((n |= byArray[1]) != -110) {
            throw new Error("Corrupted Bitstream: Could not parse EPH marker ! ");
        }
    }

    public boolean readPktBody(int n, int n2, int n3, int n4, CBlkInfo[][][] cBlkInfoArray, int[] nArray) throws IOException {
        int n5 = this.ehs.getPos();
        boolean bl = false;
        int n6 = this.src.getTileIdx();
        boolean bl2 = false;
        int n7 = this.subRange[n3][n2][0];
        while (n7 <= this.subRange[n3][n2][1]) {
            if (n4 < this.precCoord[n3][n2][n7].length) {
                bl2 = true;
            }
            ++n7;
        }
        if (!bl2) {
            return false;
        }
        int n8 = this.subRange[n3][n2][0];
        while (n8 <= this.subRange[n3][n2][1]) {
            int n9 = 0;
            while (n9 < this.cblks[n8].size()) {
                Coord coord = (Coord)this.cblks[n8].elementAt(n9);
                CBlkInfo cBlkInfo = cBlkInfoArray[n8][coord.x][coord.y];
                cBlkInfo.off[n] = n5;
                n5 += cBlkInfo.len[n];
                try {
                    this.ehs.seek(n5);
                }
                catch (EOFException eOFException) {
                    if (n == 0) {
                        cBlkInfoArray[n8][coord.x][coord.y] = null;
                    } else {
                        cBlkInfo.len[n] = 0;
                        cBlkInfo.off[n] = 0;
                        cBlkInfo.ctp -= cBlkInfo.ntp[n];
                        cBlkInfo.ntp[n] = 0;
                        cBlkInfo.pktIdx[n] = -1;
                    }
                    throw new EOFException();
                }
                if (this.isTruncMode) {
                    if (bl || cBlkInfo.len[n] > nArray[n6]) {
                        if (n == 0) {
                            cBlkInfoArray[n8][coord.x][coord.y] = null;
                        } else {
                            cBlkInfo.len[n] = 0;
                            cBlkInfo.off[n] = 0;
                            cBlkInfo.ctp -= cBlkInfo.ntp[n];
                            cBlkInfo.ntp[n] = 0;
                            cBlkInfo.pktIdx[n] = -1;
                        }
                        bl = true;
                    }
                    if (!bl) {
                        int n10 = n6;
                        nArray[n10] = nArray[n10] - cBlkInfo.len[n];
                    }
                }
                ++n9;
            }
            this.cblks[n8].removeAllElements();
            ++n8;
        }
        this.ehs.seek(n5);
        return bl;
    }

    public boolean readPktHead(int n, int n2, int n3, int n4, CBlkInfo[][][] cBlkInfoArray, int[] nArray) throws IOException {
        int n5;
        int n6 = 0;
        int n7 = this.ehs.getPos();
        int n8 = this.src.getTileIdx();
        PktHeaderBitReader pktHeaderBitReader = this.pph ? new PktHeaderBitReader(this.pphbais) : this.bin;
        boolean bl = false;
        int n9 = this.subRange[n3][n2][0];
        while (n9 <= this.subRange[n3][n2][1]) {
            if (n4 < this.precCoord[n3][n2][n9].length) {
                bl = true;
            }
            ++n9;
        }
        if (!bl) {
            return false;
        }
        pktHeaderBitReader.sync();
        int n10 = pktHeaderBitReader.readBit();
        if (n10 == 0) {
            this.cblks = new Vector[this.subRange[n3][n2][1] + 1];
            int n11 = this.subRange[n3][n2][0];
            while (n11 <= this.subRange[n3][n2][1]) {
                this.cblks[n11] = new Vector();
                ++n11;
            }
            ++this.pktIdx;
            if (this.isTruncMode) {
                int n12 = this.ehs.getPos() - n7;
                if (n12 > nArray[n8]) {
                    nArray[n8] = 0;
                    return true;
                }
                int n13 = n8;
                nArray[n13] = nArray[n13] - n12;
            }
            if (this.ephUsed) {
                this.readEPHMarker(pktHeaderBitReader);
            }
            return false;
        }
        this.cblks = new Vector[this.subRange[n3][n2][1] + 1];
        int n14 = this.subRange[n3][n2][0];
        while (n14 <= this.subRange[n3][n2][1]) {
            this.cblks[n14] = this.getCBlkInPrecinct(n3, n2, n14, n4);
            if (this.cblks[n14].size() == 1) {
                this.cblks[n14].removeAllElements();
            } else {
                Coord coord = (Coord)this.cblks[n14].elementAt(0);
                TagTreeDecoder tagTreeDecoder = this.tdInclA[n3][n2][n14][n4];
                TagTreeDecoder tagTreeDecoder2 = this.tdBDA[n3][n2][n14][n4];
                if (tagTreeDecoder == null) {
                    TagTreeDecoder tagTreeDecoder3 = new TagTreeDecoder(coord.y, coord.x);
                    this.tdInclA[n3][n2][n14][n4] = tagTreeDecoder3;
                    tagTreeDecoder = tagTreeDecoder3;
                }
                if (tagTreeDecoder2 == null) {
                    TagTreeDecoder tagTreeDecoder4 = new TagTreeDecoder(coord.y, coord.x);
                    this.tdBDA[n3][n2][n14][n4] = tagTreeDecoder4;
                    tagTreeDecoder2 = tagTreeDecoder4;
                }
                Coord coord2 = (Coord)this.cblks[n14].elementAt(1);
                int n15 = 1;
                while (n15 < this.cblks[n14].size()) {
                    coord = (Coord)this.cblks[n14].elementAt(n15);
                    CBlkInfo cBlkInfo = cBlkInfoArray[n14][coord.x][coord.y];
                    try {
                        int n16;
                        int n17;
                        int n18;
                        int n19;
                        int n20;
                        if (cBlkInfo == null || cBlkInfo.ctp == 0) {
                            if (cBlkInfo == null) {
                                CBlkCoordInfo cBlkCoordInfo = this.cbCoord[n3][n2][n14][coord.x][coord.y];
                                CBlkInfo cBlkInfo2 = new CBlkInfo(cBlkCoordInfo.ulx, cBlkCoordInfo.uly, cBlkCoordInfo.w, cBlkCoordInfo.h, this.nl);
                                cBlkInfoArray[n14][coord.x][coord.y] = cBlkInfo2;
                                cBlkInfo = cBlkInfo2;
                            }
                            cBlkInfo.pktIdx[n] = this.pktIdx;
                            n5 = tagTreeDecoder.update(coord.x - coord2.x, coord.y - coord2.y, n + 1, pktHeaderBitReader);
                            if (n5 > n) {
                                this.cblks[n14].removeElementAt(n15);
                                continue;
                            }
                            n5 = 1;
                            int n21 = 1;
                            while (n5 >= n21) {
                                n5 = tagTreeDecoder2.update(coord.x - coord2.x, coord.y - coord2.y, n21, pktHeaderBitReader);
                                ++n21;
                            }
                            cBlkInfo.msbSkipped = n21 - 2;
                            n20 = 1;
                            cBlkInfo.addNTP(n, 0);
                        } else {
                            cBlkInfo.pktIdx[n] = this.pktIdx;
                            if (pktHeaderBitReader.readBit() != 1) {
                                this.cblks[n14].removeElementAt(n15);
                                continue;
                            }
                            n20 = 1;
                        }
                        if (pktHeaderBitReader.readBit() == 1) {
                            ++n20;
                            if (pktHeaderBitReader.readBit() == 1) {
                                ++n20;
                                n5 = pktHeaderBitReader.readBits(2);
                                n20 += n5;
                                if (n5 == 3) {
                                    n5 = pktHeaderBitReader.readBits(5);
                                    n20 += n5;
                                    if (n5 == 31) {
                                        n20 += pktHeaderBitReader.readBits(7);
                                    }
                                }
                            }
                        }
                        cBlkInfo.addNTP(n, n20);
                        n6 += n20;
                        int n22 = (Integer)this.decSpec.ecopts.getTileCompVal(n8, n3);
                        if ((n22 & 4) != 0) {
                            n19 = n20;
                        } else if ((n22 & 1) != 0) {
                            if (cBlkInfo.ctp <= 10) {
                                n19 = 1;
                            } else {
                                n19 = 1;
                                n18 = cBlkInfo.ctp - n20;
                                while (n18 < cBlkInfo.ctp - 1) {
                                    if (n18 >= 9 && ((n17 = (n18 + 2) % 3) == 1 || n17 == 2)) {
                                        ++n19;
                                    }
                                    ++n18;
                                }
                            }
                        } else {
                            n19 = 1;
                        }
                        while (pktHeaderBitReader.readBit() != 0) {
                            int[] nArray2 = this.lblock[n3][n2][n14][coord.x];
                            int n23 = coord.y;
                            nArray2[n23] = nArray2[n23] + 1;
                        }
                        if (n19 == 1) {
                            n16 = pktHeaderBitReader.readBits(this.lblock[n3][n2][n14][coord.x][coord.y] + MathUtil.log2(n20));
                        } else {
                            int n24;
                            int n25;
                            cBlkInfo.segLen[n] = new int[n19];
                            n16 = 0;
                            if ((n22 & 4) != 0) {
                                n18 = cBlkInfo.ctp - n20;
                                n25 = 0;
                                while (n18 < cBlkInfo.ctp) {
                                    n24 = this.lblock[n3][n2][n14][coord.x][coord.y];
                                    cBlkInfo.segLen[n][n25] = n5 = pktHeaderBitReader.readBits(n24);
                                    n16 += n5;
                                    ++n18;
                                    ++n25;
                                }
                            } else {
                                int n26 = cBlkInfo.ctp - n20 - 1;
                                n18 = cBlkInfo.ctp - n20;
                                n25 = 0;
                                while (n18 < cBlkInfo.ctp - 1) {
                                    if (n18 >= 9 && (n17 = (n18 + 2) % 3) != 0) {
                                        n24 = this.lblock[n3][n2][n14][coord.x][coord.y];
                                        cBlkInfo.segLen[n][n25] = n5 = pktHeaderBitReader.readBits(n24 + MathUtil.log2(n18 - n26));
                                        n16 += n5;
                                        n26 = n18;
                                        ++n25;
                                    }
                                    ++n18;
                                }
                                n24 = this.lblock[n3][n2][n14][coord.x][coord.y];
                                n5 = pktHeaderBitReader.readBits(n24 + MathUtil.log2(n18 - n26));
                                n16 += n5;
                                cBlkInfo.segLen[n][n25] = n5;
                            }
                        }
                        cBlkInfo.len[n] = n16;
                        if (this.isTruncMode && (n5 = this.ehs.getPos() - n7) > nArray[n8]) {
                            nArray[n8] = 0;
                            if (n == 0) {
                                cBlkInfoArray[n14][coord.x][coord.y] = null;
                            } else {
                                cBlkInfo.len[n] = 0;
                                cBlkInfo.off[n] = 0;
                                cBlkInfo.ctp -= cBlkInfo.ntp[n];
                                cBlkInfo.ntp[n] = 0;
                                cBlkInfo.pktIdx[n] = -1;
                            }
                            return true;
                        }
                        ++n15;
                    }
                    catch (EOFException eOFException) {
                        if (n == 0) {
                            cBlkInfoArray[n14][coord.x][coord.y] = null;
                        } else {
                            cBlkInfo.len[n] = 0;
                            cBlkInfo.off[n] = 0;
                            cBlkInfo.ctp -= cBlkInfo.ntp[n];
                            cBlkInfo.ntp[n] = 0;
                            cBlkInfo.pktIdx[n] = -1;
                        }
                        throw new EOFException();
                    }
                }
                this.cblks[n14].removeElementAt(0);
            }
            ++n14;
        }
        if (this.ephUsed) {
            this.readEPHMarker(pktHeaderBitReader);
        }
        ++this.pktIdx;
        if (this.isTruncMode) {
            n5 = this.ehs.getPos() - n7;
            if (n5 > nArray[n8]) {
                nArray[n8] = 0;
                return true;
            }
            int n27 = n8;
            nArray[n27] = nArray[n27] - n5;
        }
        return false;
    }

    public boolean readSOPMarker(int[] nArray, int n, int n2, int n3) throws IOException {
        byte[] byArray = new byte[6];
        int n4 = this.src.getTileIdx();
        boolean bl = false;
        int n5 = this.subRange[n2][n3][0];
        while (n5 <= this.subRange[n2][n3][1]) {
            if (n < this.precCoord[n2][n3][n5].length) {
                bl = true;
            }
            ++n5;
        }
        if (!bl) {
            return false;
        }
        if (!this.sopUsed) {
            return false;
        }
        if (nArray[n4] < 6) {
            return true;
        }
        int n6 = n4;
        nArray[n6] = nArray[n6] - 6;
        this.ehs.readFully(byArray, 0, 6);
        int n7 = byArray[0];
        n7 <<= 8;
        if ((n7 |= byArray[1]) != -111) {
            throw new Error("Corrupted Bitstream: Could not parse SOP marker !");
        }
        n7 = byArray[2] & 0xFF;
        n7 <<= 8;
        if ((n7 |= byArray[3] & 0xFF) != 4) {
            throw new Error("Corrupted Bitstream: Corrupted SOP marker !");
        }
        n7 = byArray[4] & 0xFF;
        n7 <<= 8;
        if (!this.pph && (n7 |= byArray[5] & 0xFF) != this.pktIdx) {
            throw new Error("Corrupted Bitstream: SOP marker out of sequence !");
        }
        if (this.pph && n7 != this.pktIdx - 1) {
            throw new Error("Corrupted Bitstream: SOP marker out of sequence !");
        }
        return false;
    }

    CBlkInfo[][][][][] restart(int n, int[] nArray, int n2, CBlkInfo[][][][][] cBlkInfoArray, boolean bl, ByteArrayInputStream byteArrayInputStream) {
        this.nc = n;
        this.nl = n2;
        this.mdl = nArray;
        this.tIdx = this.src.getTileIdx();
        this.pph = bl;
        this.pphbais = byteArrayInputStream;
        this.sopUsed = (Boolean)this.decSpec.sops.getTileDef(this.tIdx);
        this.pktIdx = 0;
        this.ephUsed = (Boolean)this.decSpec.ephs.getTileDef(this.tIdx);
        cBlkInfoArray = new CBlkInfo[n][][][][];
        this.lblock = new int[n][][][][];
        this.tdInclA = new TagTreeDecoder[n][][][];
        this.tdBDA = new TagTreeDecoder[n][][][];
        this.maxNumPrecincts = new Coord[n][];
        this.cbCoord = new CBlkCoordInfo[n][][][][];
        this.precCoord = new PrecCoordInfo[n][][][];
        this.incArray = new Coord[n][];
        this.incArrayMax = new Coord[n];
        this.sotEotArray = new Coord[n][][];
        this.sotEotArrayMax = new Coord[n][2];
        this.subRange = this.findSubInResLvl();
        Coord coord = null;
        int n3 = 0;
        while (n3 < n) {
            cBlkInfoArray[n3] = new CBlkInfo[nArray[n3] + 1][][][];
            this.lblock[n3] = new int[nArray[n3] + 1][][][];
            this.tdInclA[n3] = new TagTreeDecoder[nArray[n3] + 1][][];
            this.tdBDA[n3] = new TagTreeDecoder[nArray[n3] + 1][][];
            this.maxNumPrecincts[n3] = new Coord[nArray[n3] + 1];
            this.cbCoord[n3] = new CBlkCoordInfo[nArray[n3] + 1][][][];
            this.precCoord[n3] = new PrecCoordInfo[nArray[n3] + 1][][];
            this.sotEotArray[n3] = new Coord[nArray[n3] + 1][2];
            this.incArray[n3] = new Coord[nArray[n3] + 1];
            int n4 = this.src.getULX(n3, nArray[n3]);
            int n5 = this.src.getULY(n3, nArray[n3]);
            int n6 = n4 + this.src.getCompWidth(n3, nArray[n3]);
            int n7 = n5 + this.src.getCompHeight(n3, nArray[n3]);
            int n8 = this.src.getCompSubsX(n3);
            int n9 = this.src.getCompSubsY(n3);
            int n10 = (int)Math.ceil((double)n4 / (double)n8);
            int n11 = (int)Math.ceil((double)n5 / (double)n9);
            int n12 = (int)Math.ceil((double)n6 / (double)n8);
            int n13 = (int)Math.ceil((double)n7 / (double)n9);
            this.buildIncArrays(n3);
            this.buildSotEotArrays(n3);
            int n14 = 0;
            while (n14 <= nArray[n3]) {
                int n15 = (int)Math.ceil((double)n10 / (double)(1 << nArray[n3] - n14));
                int n16 = (int)Math.ceil((double)n11 / (double)(1 << nArray[n3] - n14));
                int n17 = (int)Math.ceil((double)n12 / (double)(1 << nArray[n3] - n14));
                int n18 = (int)Math.ceil((double)n13 / (double)(1 << nArray[n3] - n14));
                cBlkInfoArray[n3][n14] = new CBlkInfo[this.subRange[n3][n14][1] + 1][][];
                this.lblock[n3][n14] = new int[this.subRange[n3][n14][1] + 1][][];
                double d = this.getPPX(this.tIdx, n3, n14);
                double d2 = this.getPPY(this.tIdx, n3, n14);
                this.maxNumPrecincts[n3][n14] = new Coord();
                if (n17 > n15) {
                    this.maxNumPrecincts[n3][n14].x = (int)Math.ceil((double)n17 / d) - (int)Math.floor((double)n15 / d);
                }
                if (n18 > n16) {
                    this.maxNumPrecincts[n3][n14].y = (int)Math.ceil((double)n18 / d2) - (int)Math.floor((double)n16 / d2);
                }
                int n19 = this.maxNumPrecincts[n3][n14].x * this.maxNumPrecincts[n3][n14].y;
                this.tdInclA[n3][n14] = new TagTreeDecoder[this.subRange[n3][n14][1] + 1][n19];
                this.tdBDA[n3][n14] = new TagTreeDecoder[this.subRange[n3][n14][1] + 1][n19];
                this.cbCoord[n3][n14] = new CBlkCoordInfo[this.subRange[n3][n14][1] + 1][][];
                this.precCoord[n3][n14] = new PrecCoordInfo[this.subRange[n3][n14][1] + 1][n19];
                int n20 = this.subRange[n3][n14][0];
                while (n20 <= this.subRange[n3][n14][1]) {
                    SubbandSyn subbandSyn = (SubbandSyn)this.src.getSubbandTree(this.tIdx, n3).getSubbandByIdx(n14, n20);
                    coord = this.src.getNumCodeBlocks(subbandSyn, n3, coord);
                    cBlkInfoArray[n3][n14][n20] = new CBlkInfo[coord.y][coord.x];
                    this.cbCoord[n3][n14][n20] = new CBlkCoordInfo[coord.y][coord.x];
                    this.lblock[n3][n14][n20] = new int[coord.y][coord.x];
                    int n21 = coord.y - 1;
                    while (n21 >= 0) {
                        ArrayUtil.intArraySet(this.lblock[n3][n14][n20][n21], 3);
                        --n21;
                    }
                    ++n20;
                }
                this.buildCBlkPrecCoord(n3, n14);
                ++n14;
            }
            ++n3;
        }
        return cBlkInfoArray;
    }
}

