/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.codestream.reader;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import jj2000.j2k.NotImplementedError;
import jj2000.j2k.codestream.CorruptedCodestreamException;
import jj2000.j2k.codestream.Markers;
import jj2000.j2k.codestream.ProgressionType;
import jj2000.j2k.codestream.reader.BitstreamReaderAgent;
import jj2000.j2k.decoder.DecoderSpecs;
import jj2000.j2k.entropy.StdEntropyCoderOptions;
import jj2000.j2k.entropy.decoder.EntropyDecoder;
import jj2000.j2k.entropy.decoder.StdEntropyDecoder;
import jj2000.j2k.image.Coord;
import jj2000.j2k.io.RandomAccessIO;
import jj2000.j2k.quantization.dequantizer.CBlkQuantDataSrcDec;
import jj2000.j2k.quantization.dequantizer.Dequantizer;
import jj2000.j2k.quantization.dequantizer.StdDequantizer;
import jj2000.j2k.quantization.dequantizer.StdDequantizerParams;
import jj2000.j2k.roi.MaxShiftSpec;
import jj2000.j2k.roi.ROIDeScaler;
import jj2000.j2k.util.FacilityManager;
import jj2000.j2k.util.ParameterList;
import jj2000.j2k.wavelet.synthesis.SynWTFilter;
import jj2000.j2k.wavelet.synthesis.SynWTFilterFloatLift9x7;
import jj2000.j2k.wavelet.synthesis.SynWTFilterIntLift5x3;

public class HeaderDecoder
implements ProgressionType,
Markers,
StdEntropyCoderOptions {
    public static final char OPT_PREFIX = 'H';
    private static final String[][] pinfo = null;
    private boolean printHeader = false;
    private String hdStr = "";
    private boolean printInfo;
    private ParameterList pl;
    private int nTiles;
    public int[] nTileParts;
    int markersFound = 0;
    private int nCOCmarker = 0;
    private int nQCCmarker = 0;
    private int nCOMmarker = 0;
    private int nRGNmarker = 0;
    private int nPPMmarker = 0;
    private int[] nPPTmarker;
    private int nReadPPMmarker = 0;
    private int[] nReadPPTmarker;
    private static final int SIZ_FOUND = 1;
    private static final int COD_FOUND = 2;
    private static final int COC_FOUND = 4;
    private static final int QCD_FOUND = 8;
    private static final int TLM_FOUND = 16;
    private static final int PLM_FOUND = 32;
    private static final int SOT_FOUND = 64;
    private static final int PLT_FOUND = 128;
    private static final int QCC_FOUND = 256;
    private static final int RGN_FOUND = 512;
    private static final int POC_FOUND = 1024;
    private static final int COM_FOUND = 2048;
    public static final int SOD_FOUND = 8192;
    public static final int PPM_FOUND = 16384;
    public static final int PPT_FOUND = 32768;
    public static final int CRG_FOUND = 65536;
    private static final int TILE_RESET = -546;
    private Hashtable ht = new Hashtable();
    private int thlen;
    private int cdstrmCap;
    private int imgW;
    private int imgH;
    private int imgOrigX;
    private int imgOrigY;
    private int tileW;
    private int tileH;
    private int tilingOrigX;
    private int tilingOrigY;
    private int nComp;
    private int[] compSubsX;
    private int[] compSubsY;
    private int[] origBitDepth;
    private boolean[] isOrigSigned;
    private int partOrigX;
    private int partOrigY;
    private DecoderSpecs decSpec;
    private int[] maxBoost;
    boolean precinctPartitionIsUsed;
    public int initPos;
    public Vector tileOfTileParts;
    private Vector unsortedPkdPktHeaders;
    private ByteArrayOutputStream[] pkdPktHeaders;
    private int remPPMData;
    private byte[] readIPPMData;
    private Vector[] tilePartPktHeadLen;
    private int[] lastTilePartRead;

    public HeaderDecoder(RandomAccessIO randomAccessIO, boolean bl, ParameterList parameterList) throws IOException {
        this.pl = parameterList;
        this.printInfo = bl;
        parameterList.checkList('H', ParameterList.toNameArray(null));
        this.initPos = randomAccessIO.getPos();
        if (randomAccessIO.readShort() != -177) {
            throw new CorruptedCodestreamException("SOC marker segment not  found at the beginning of the codestream.");
        }
        do {
            this.extractMainMarkSeg(randomAccessIO.readShort(), randomAccessIO);
        } while ((this.markersFound & 0x40) == 0);
        randomAccessIO.seek(randomAccessIO.getPos() - 2);
        this.readFoundMainMarkSeg();
        this.thlen = randomAccessIO.getPos() - this.initPos;
    }

    public void checkMarkerLength(DataInputStream dataInputStream, String string) throws IOException {
        if (dataInputStream.available() != 0) {
            FacilityManager.getMsgLogger().printmsg(2, String.valueOf(string) + " length was short, attempting to resync.");
        }
    }

    public final Dequantizer createDequantizer(CBlkQuantDataSrcDec cBlkQuantDataSrcDec, int[] nArray) {
        return new StdDequantizer(cBlkQuantDataSrcDec, nArray, this.decSpec);
    }

    public EntropyDecoder createEntropyDecoder(BitstreamReaderAgent bitstreamReaderAgent, ParameterList parameterList) {
        parameterList.checkList('C', ParameterList.toNameArray(EntropyDecoder.getParameterInfo()));
        boolean bl = parameterList.getBooleanParameter("Cer");
        boolean bl2 = parameterList.getBooleanParameter("Cverber");
        return new StdEntropyDecoder(bitstreamReaderAgent, this.decSpec, bl, bl2);
    }

    public ROIDeScaler createROIDeScaler(CBlkQuantDataSrcDec cBlkQuantDataSrcDec, ParameterList parameterList) {
        return ROIDeScaler.createInstance(cBlkQuantDataSrcDec, parameterList, this.decSpec);
    }

    private void extractMainMarkSeg(short s, RandomAccessIO randomAccessIO) throws IOException {
        if (this.markersFound == 0 && s != -175) {
            throw new CorruptedCodestreamException("First marker after SOC must be SIZ " + Integer.toHexString(s));
        }
        String string = "";
        switch (s) {
            case -175: {
                if ((this.markersFound & 1) != 0) {
                    throw new CorruptedCodestreamException("More than one SIZ flag found in main header");
                }
                this.markersFound |= 1;
                string = "SIZ";
                break;
            }
            case -109: {
                throw new CorruptedCodestreamException("SOD found in main header");
            }
            case -39: {
                throw new CorruptedCodestreamException("EOC found in main header");
            }
            case -112: {
                if ((this.markersFound & 0x40) != 0) {
                    throw new CorruptedCodestreamException("More than one SOT marker found right after main or tile header");
                }
                this.markersFound |= 0x40;
                break;
            }
            case -174: {
                if ((this.markersFound & 2) != 0) {
                    throw new CorruptedCodestreamException("More than one COD marker found in main header");
                }
                this.markersFound |= 2;
                string = "COD";
                break;
            }
            case -173: {
                this.markersFound |= 4;
                string = "COC" + this.nCOCmarker++;
                break;
            }
            case -164: {
                if ((this.markersFound & 8) != 0) {
                    throw new CorruptedCodestreamException("More than one QCD marker found in main header");
                }
                this.markersFound |= 8;
                string = "QCD";
                break;
            }
            case -163: {
                this.markersFound |= 0x100;
                string = "QCC" + this.nQCCmarker++;
                break;
            }
            case -162: {
                this.markersFound |= 0x200;
                string = "RGN" + this.nRGNmarker++;
                break;
            }
            case -156: {
                this.markersFound |= 0x800;
                string = "COM" + this.nCOMmarker++;
                break;
            }
            case -157: {
                if ((this.markersFound & 0x10000) != 0) {
                    throw new CorruptedCodestreamException("More than one CRG marker found in main header");
                }
                this.markersFound |= 0x10000;
                string = "CRG";
                break;
            }
            case -160: {
                this.markersFound |= 0x4000;
                string = "PPM" + this.nPPMmarker++;
                break;
            }
            case -171: {
                if ((this.markersFound & 0x10) != 0) {
                    throw new CorruptedCodestreamException("More than one TLM marker found in main header");
                }
                this.markersFound |= 0x10;
                break;
            }
            case -169: {
                if ((this.markersFound & 0x20) != 0) {
                    throw new CorruptedCodestreamException("More than one PLM marker found in main header");
                }
                FacilityManager.getMsgLogger().printmsg(2, "PLM marker segment found but not used by by JJ2000 decoder.");
                this.markersFound |= 0x20;
                string = "PLM";
                break;
            }
            case -161: {
                if ((this.markersFound & 0x400) != 0) {
                    throw new CorruptedCodestreamException("More than one POC marker segment found in main header");
                }
                this.markersFound |= 0x400;
                string = "POC";
                break;
            }
            case -168: {
                throw new CorruptedCodestreamException("PPT found in main header");
            }
            case -159: {
                throw new CorruptedCodestreamException("PPT found in main header");
            }
            default: {
                string = "UNKNOWN";
                FacilityManager.getMsgLogger().printmsg(2, "Non recognized marker segment (0x" + Integer.toHexString(s) + ") in main header!");
            }
        }
        if (string.equals("")) {
            return;
        }
        int n = randomAccessIO.readUnsignedShort();
        byte[] byArray = new byte[n];
        byArray[0] = (byte)(n >> 8 & 0xFF);
        byArray[1] = (byte)(n & 0xFF);
        randomAccessIO.readFully(byArray, 2, n - 2);
        if (!string.equals("UNKNOWN")) {
            this.ht.put(string, byArray);
        }
    }

    public void extractTilePartMarkSeg(short s, RandomAccessIO randomAccessIO, int n) throws IOException {
        String string = "";
        switch (s) {
            case -175: {
                throw new CorruptedCodestreamException("SIZ found in tile-part header");
            }
            case -39: {
                throw new CorruptedCodestreamException("EOC found in tile-part header");
            }
            case -112: {
                throw new CorruptedCodestreamException("New SOT found in tile-part header");
            }
            case -171: {
                throw new CorruptedCodestreamException("TLM found in tile-part header");
            }
            case -169: {
                throw new CorruptedCodestreamException("PLM found in tile-part header");
            }
            case -160: {
                throw new CorruptedCodestreamException("PPM found in tile-part header");
            }
            case -174: {
                if ((this.markersFound & 2) != 0) {
                    throw new CorruptedCodestreamException("More than one COD marker found in tile-part header");
                }
                this.markersFound |= 2;
                string = "COD";
                break;
            }
            case -173: {
                this.markersFound |= 4;
                string = "COC" + this.nCOCmarker++;
                break;
            }
            case -164: {
                if ((this.markersFound & 8) != 0) {
                    throw new CorruptedCodestreamException("More than one QCD marker found in tile-part header");
                }
                this.markersFound |= 8;
                string = "QCD";
                break;
            }
            case -163: {
                this.markersFound |= 0x100;
                string = "QCC" + this.nQCCmarker++;
                break;
            }
            case -162: {
                this.markersFound |= 0x200;
                string = "RGN" + this.nRGNmarker++;
                break;
            }
            case -156: {
                this.markersFound |= 0x800;
                string = "COM" + this.nCOMmarker++;
                break;
            }
            case -157: {
                throw new CorruptedCodestreamException("CRG marker found in tile-part header");
            }
            case -159: {
                this.markersFound |= 0x8000;
                if (this.nPPTmarker == null) {
                    this.nPPTmarker = new int[this.nTiles];
                }
                int n2 = n;
                int n3 = this.nPPTmarker[n2];
                this.nPPTmarker[n2] = n3 + 1;
                string = "PPT" + n3;
                break;
            }
            case -109: {
                this.markersFound |= 0x2000;
                break;
            }
            case -161: {
                if ((this.markersFound & 0x400) != 0) {
                    throw new CorruptedCodestreamException("More than one POC marker segment found in tile-part header");
                }
                this.markersFound |= 0x400;
                string = "POC";
                break;
            }
            case -168: {
                if ((this.markersFound & 0x20) != 0) {
                    throw new CorruptedCodestreamException("PLT marker found eventhough PLM marker found in main header");
                }
                FacilityManager.getMsgLogger().printmsg(2, "PLT marker segment found but not used by JJ2000 decoder.");
            }
            default: {
                string = "UNKNOWN";
                FacilityManager.getMsgLogger().printmsg(2, "Non recognized marker segment (0x" + Integer.toHexString(s) + ") in tile-part header" + " of tile " + n + " !");
            }
        }
        if (string.equals("")) {
            return;
        }
        int n4 = randomAccessIO.readUnsignedShort();
        byte[] byArray = new byte[n4];
        byArray[0] = (byte)(n4 >> 8 & 0xFF);
        byArray[1] = (byte)(n4 & 0xFF);
        randomAccessIO.readFully(byArray, 2, n4 - 2);
        if (!string.equals("UNKNOWN")) {
            this.ht.put(string, byArray);
        }
    }

    public final int getCodeStreamCaps() {
        return this.cdstrmCap;
    }

    public final int getCompSubsX(int n) {
        return this.compSubsX[n];
    }

    public final int getCompSubsY(int n) {
        return this.compSubsY[n];
    }

    public DecoderSpecs getDecoderSpecs() {
        return this.decSpec;
    }

    public final int getImgHeight() {
        return this.imgH;
    }

    public final int getImgULX() {
        return this.imgOrigX;
    }

    public final int getImgULY() {
        return this.imgOrigY;
    }

    public final int getImgWidth() {
        return this.imgW;
    }

    public final int[] getMaxBoost() {
        return this.maxBoost;
    }

    public final int getNomTileHeight() {
        return this.tileH;
    }

    public final int getNomTileWidth() {
        return this.tileW;
    }

    public final int getNumComps() {
        return this.nComp;
    }

    public int getNumTiles() {
        return this.nTiles;
    }

    public final int getOriginalBitDepth(int n) {
        return this.origBitDepth[n];
    }

    public final int getPPX(int n, int n2, int n3) {
        return this.decSpec.pss.getPPX(n, n2, n3);
    }

    public final int getPPY(int n, int n2, int n3) {
        return this.decSpec.pss.getPPY(n, n2, n3);
    }

    public ByteArrayInputStream getPackedPktHead(int n) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream;
        if (this.nPPMmarker != 0) {
            int n2 = this.tileOfTileParts.size();
            byteArrayOutputStream = new ByteArrayOutputStream();
            int n3 = 0;
            while (n3 < n2) {
                if ((Integer)this.tileOfTileParts.elementAt(n3) == n) {
                    byte[] byArray = (byte[])this.unsortedPkdPktHeaders.elementAt(n3);
                    byteArrayOutputStream.write(byArray);
                }
                ++n3;
            }
        } else {
            byteArrayOutputStream = this.pkdPktHeaders[n];
        }
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    public static String[][] getParameterInfo() {
        return null;
    }

    public final int getPartitionULX() {
        return this.partOrigX;
    }

    public final int getPartitionULY() {
        return this.partOrigY;
    }

    public final Coord getTilingOrigin(Coord coord) {
        if (coord != null) {
            coord.x = this.tilingOrigX;
            coord.y = this.tilingOrigY;
            return coord;
        }
        return new Coord(this.tilingOrigX, this.tilingOrigY);
    }

    public final int getTotalHeaderLength() {
        return this.thlen;
    }

    public final boolean isOriginalSigned(int n) {
        return this.isOrigSigned[n];
    }

    public final boolean precinctPartitionUsed() {
        return this.precinctPartitionIsUsed;
    }

    private void readCOC(DataInputStream dataInputStream, boolean bl, int n) throws IOException {
        int n2;
        int n3 = dataInputStream.readUnsignedShort();
        int n4 = this.nComp < 257 ? dataInputStream.readUnsignedByte() : dataInputStream.readUnsignedShort();
        if (n4 >= this.nComp) {
            throw new CorruptedCodestreamException("Invalid component index in QCC marker");
        }
        int n5 = n2 = dataInputStream.readUnsignedByte();
        if ((n2 & 1) != 0) {
            this.precinctPartitionIsUsed = true;
            n2 &= 0xFFFFFFFE;
        } else {
            this.precinctPartitionIsUsed = false;
        }
        int n6 = dataInputStream.readUnsignedByte();
        Integer[] integerArray = new Integer[2];
        integerArray[0] = new Integer(1 << dataInputStream.readUnsignedByte() + 2);
        if (integerArray[0] < 4 || integerArray[0] > 1024) {
            String string = "Non-valid code-block width in SPcod field, COC marker";
            throw new CorruptedCodestreamException(string);
        }
        integerArray[1] = new Integer(1 << dataInputStream.readUnsignedByte() + 2);
        if (integerArray[1] < 4 || integerArray[1] > 1024) {
            String string = "Non-valid code-block height in SPcod field, COC marker";
            throw new CorruptedCodestreamException(string);
        }
        if (integerArray[0] * integerArray[1] > 4096) {
            String string = "Non-valid code-block area in SPcod field, COC marker";
            throw new CorruptedCodestreamException(string);
        }
        if (bl) {
            this.decSpec.cblks.setCompDef(n4, integerArray);
        } else {
            this.decSpec.cblks.setTileCompVal(n, n4, integerArray);
        }
        int n7 = dataInputStream.readUnsignedByte();
        if ((n7 & 0xFFFFFFC0) != 0) {
            throw new CorruptedCodestreamException("Unknown \"code-block context\" in SPcoc field, COC marker: 0x" + Integer.toHexString(n7));
        }
        SynWTFilter[] synWTFilterArray = new SynWTFilter[1];
        SynWTFilter[] synWTFilterArray2 = new SynWTFilter[1];
        synWTFilterArray[0] = this.readFilter(dataInputStream);
        synWTFilterArray2[0] = synWTFilterArray[0];
        SynWTFilter[][] synWTFilterArray3 = new SynWTFilter[][]{synWTFilterArray, synWTFilterArray2};
        Vector[] vectorArray = new Vector[]{new Vector(), new Vector()};
        int n8 = 65535;
        if (!this.precinctPartitionIsUsed) {
            Integer n9 = new Integer(1 << (n8 & 0xF));
            vectorArray[0].addElement(n9);
            Integer n10 = new Integer(1 << ((n8 & 0xF0) >> 4));
            vectorArray[1].addElement(n10);
        } else {
            int n11 = n6;
            while (n11 >= 0) {
                n8 = dataInputStream.readUnsignedByte();
                Integer n12 = new Integer(1 << (n8 & 0xF));
                vectorArray[0].insertElementAt(n12, 0);
                Integer n13 = new Integer(1 << ((n8 & 0xF0) >> 4));
                vectorArray[1].insertElementAt(n13, 0);
                --n11;
            }
        }
        if (bl) {
            this.decSpec.pss.setCompDef(n4, vectorArray);
        } else {
            this.decSpec.pss.setTileCompVal(n, n4, vectorArray);
        }
        this.precinctPartitionIsUsed = true;
        this.checkMarkerLength(dataInputStream, "COD marker");
        if (bl) {
            this.decSpec.wfs.setCompDef(n4, synWTFilterArray3);
            this.decSpec.dls.setCompDef(n4, new Integer(n6));
            this.decSpec.ecopts.setCompDef(n4, new Integer(n7));
        } else {
            this.decSpec.wfs.setTileCompVal(n, n4, synWTFilterArray3);
            this.decSpec.dls.setTileCompVal(n, n4, new Integer(n6));
            this.decSpec.ecopts.setTileCompVal(n, n4, new Integer(n7));
        }
        if (this.printHeader) {
            this.hdStr = String.valueOf(this.hdStr) + " --- COC(" + n4 + ") ---\n";
            this.hdStr = String.valueOf(this.hdStr) + " Coding style  : " + n5 + "\n";
            this.hdStr = String.valueOf(this.hdStr) + " Num. of levels: " + (Integer)this.decSpec.dls.getDefault() + "\n";
            this.hdStr = String.valueOf(this.hdStr) + " Cblk width    : " + integerArray[0] + "\n";
            this.hdStr = String.valueOf(this.hdStr) + " Cblk height   : " + integerArray[1] + "\n";
            this.hdStr = String.valueOf(this.hdStr) + " EC options    : " + n7 + "\n";
            this.hdStr = String.valueOf(this.hdStr) + " Filter        : " + synWTFilterArray[0] + "\n";
            this.hdStr = String.valueOf(this.hdStr) + " Precincts     : w:" + vectorArray[0] + ", h:" + vectorArray[1] + "\n";
        }
    }

    private void readCOD(DataInputStream dataInputStream, boolean bl, int n) throws IOException {
        int n2;
        boolean bl2 = false;
        boolean bl3 = false;
        int n3 = dataInputStream.readUnsignedShort();
        int n4 = n2 = dataInputStream.readUnsignedByte();
        if ((n2 & 1) != 0) {
            this.precinctPartitionIsUsed = true;
            n2 &= 0xFFFFFFFE;
        } else {
            this.precinctPartitionIsUsed = false;
        }
        if (bl) {
            if ((n2 & 2) != 0) {
                this.decSpec.sops.setDefault(new Boolean("true"));
                bl2 = true;
                n2 &= 0xFFFFFFFD;
            } else {
                this.decSpec.sops.setDefault(new Boolean("false"));
            }
        } else if ((n2 & 2) != 0) {
            this.decSpec.sops.setTileDef(n, new Boolean("true"));
            bl2 = true;
            n2 &= 0xFFFFFFFD;
        } else {
            this.decSpec.sops.setTileDef(n, new Boolean("false"));
        }
        if (bl) {
            if ((n2 & 4) != 0) {
                this.decSpec.ephs.setDefault(new Boolean("true"));
                bl3 = true;
                n2 &= 0xFFFFFFFB;
            } else {
                this.decSpec.ephs.setDefault(new Boolean("false"));
            }
        } else if ((n2 & 4) != 0) {
            this.decSpec.ephs.setTileDef(n, new Boolean("true"));
            bl3 = true;
            n2 &= 0xFFFFFFFB;
        } else {
            this.decSpec.ephs.setTileDef(n, new Boolean("false"));
        }
        int n5 = dataInputStream.readUnsignedByte();
        int n6 = dataInputStream.readUnsignedShort();
        if (n6 <= 0 || n6 > 65535) {
            throw new CorruptedCodestreamException("Number of layers out of range: 1--65535");
        }
        int n7 = dataInputStream.readUnsignedByte();
        int n8 = dataInputStream.readUnsignedByte();
        if (n8 > 32) {
            throw new CorruptedCodestreamException("Number of decomposition levels out of range: 0--32");
        }
        Integer[] integerArray = new Integer[2];
        integerArray[0] = new Integer(1 << dataInputStream.readUnsignedByte() + 2);
        if (integerArray[0] < 4 || integerArray[0] > 1024) {
            String string = "Non-valid code-block width in SPcod field, COD marker";
            throw new CorruptedCodestreamException(string);
        }
        integerArray[1] = new Integer(1 << dataInputStream.readUnsignedByte() + 2);
        if (integerArray[1] < 4 || integerArray[1] > 1024) {
            String string = "Non-valid code-block height in SPcod field, COD marker";
            throw new CorruptedCodestreamException(string);
        }
        if (integerArray[0] * integerArray[1] > 4096) {
            String string = "Non-valid code-block area in SPcod field, COD marker";
            throw new CorruptedCodestreamException(string);
        }
        if (bl) {
            this.decSpec.cblks.setDefault(integerArray);
        } else {
            this.decSpec.cblks.setTileDef(n, integerArray);
        }
        int n9 = dataInputStream.readUnsignedByte();
        if ((n9 & 0xFFFFFFC0) != 0) {
            throw new CorruptedCodestreamException("Unknown \"code-block style\" in SPcod field, COD marker: 0x" + Integer.toHexString(n9));
        }
        SynWTFilter[] synWTFilterArray = new SynWTFilter[1];
        SynWTFilter[] synWTFilterArray2 = new SynWTFilter[1];
        synWTFilterArray[0] = this.readFilter(dataInputStream);
        synWTFilterArray2[0] = synWTFilterArray[0];
        SynWTFilter[][] synWTFilterArray3 = new SynWTFilter[][]{synWTFilterArray, synWTFilterArray2};
        Vector[] vectorArray = new Vector[]{new Vector(), new Vector()};
        int n10 = 65535;
        if (!this.precinctPartitionIsUsed) {
            Integer n11 = new Integer(1 << (n10 & 0xF));
            vectorArray[0].addElement(n11);
            Integer n12 = new Integer(1 << ((n10 & 0xF0) >> 4));
            vectorArray[1].addElement(n12);
        } else {
            int n13 = n8;
            while (n13 >= 0) {
                n10 = dataInputStream.readUnsignedByte();
                Integer n14 = new Integer(1 << (n10 & 0xF));
                vectorArray[0].insertElementAt(n14, 0);
                Integer n15 = new Integer(1 << ((n10 & 0xF0) >> 4));
                vectorArray[1].insertElementAt(n15, 0);
                --n13;
            }
        }
        if (bl) {
            this.decSpec.pss.setDefault(vectorArray);
        } else {
            this.decSpec.pss.setTileDef(n, vectorArray);
        }
        this.precinctPartitionIsUsed = true;
        this.checkMarkerLength(dataInputStream, "COD marker");
        if (bl) {
            this.decSpec.wfs.setDefault(synWTFilterArray3);
            this.decSpec.dls.setDefault(new Integer(n8));
            this.decSpec.ecopts.setDefault(new Integer(n9));
            this.decSpec.cts.setDefault(new Integer(n7));
            this.decSpec.nls.setDefault(new Integer(n6));
            this.decSpec.pos.setDefault(new Integer(n5));
        } else {
            this.decSpec.wfs.setTileDef(n, synWTFilterArray3);
            this.decSpec.dls.setTileDef(n, new Integer(n8));
            this.decSpec.ecopts.setTileDef(n, new Integer(n9));
            this.decSpec.cts.setTileDef(n, new Integer(n7));
            this.decSpec.nls.setTileDef(n, new Integer(n6));
            this.decSpec.pos.setTileDef(n, new Integer(n5));
        }
        if (this.printHeader) {
            this.hdStr = String.valueOf(this.hdStr) + " --- COD ---\n";
            this.hdStr = String.valueOf(this.hdStr) + " Coding style  : " + n4 + "\n";
            this.hdStr = String.valueOf(this.hdStr) + " Num. of levels: " + n8 + "\n";
            switch (n5) {
                case 0: {
                    this.hdStr = String.valueOf(this.hdStr) + " Progress. type: LY_RES_COMP_POS_PROG\n";
                    break;
                }
                case 1: {
                    this.hdStr = String.valueOf(this.hdStr) + " Progress. type: RES_LY_COMP_POS_PROG\n";
                    break;
                }
                case 2: {
                    this.hdStr = String.valueOf(this.hdStr) + " Progress. type: RES_POS_COMP_LY_PROG\n";
                    break;
                }
                case 3: {
                    this.hdStr = String.valueOf(this.hdStr) + " Progress. type: POS_COMP_RES_LY_PROG\n";
                    break;
                }
                case 4: {
                    this.hdStr = String.valueOf(this.hdStr) + " Progress. type: COMP_POS_RES_LY_PROG\n";
                    break;
                }
            }
            this.hdStr = String.valueOf(this.hdStr) + " Num. of layers: " + n6 + "\n";
            this.hdStr = String.valueOf(this.hdStr) + " Cblk width    : " + integerArray[0] + "\n";
            this.hdStr = String.valueOf(this.hdStr) + " Cblk height   : " + integerArray[1] + "\n";
            this.hdStr = String.valueOf(this.hdStr) + " EC options    : " + n9 + "\n";
            this.hdStr = String.valueOf(this.hdStr) + " Filter        : " + synWTFilterArray[0] + "\n";
            this.hdStr = String.valueOf(this.hdStr) + " Multi comp tr.: " + (n7 == 1) + "\n";
            this.hdStr = String.valueOf(this.hdStr) + " Precincts     : w:" + vectorArray[0] + ", h:" + vectorArray[1] + "\n";
            this.hdStr = String.valueOf(this.hdStr) + " SOP markers   : " + bl2 + "\n";
            this.hdStr = String.valueOf(this.hdStr) + " EPH markers   : " + bl3 + "\n";
        }
    }

    private void readCOM(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        int n2 = dataInputStream.readUnsignedShort();
        switch (n2) {
            case 1: {
                byte[] byArray = new byte[n - 4];
                int n3 = 0;
                while (n3 < byArray.length) {
                    byArray[n3] = dataInputStream.readByte();
                    ++n3;
                }
                if (!this.pl.getBooleanParameter("verbose")) break;
                FacilityManager.getMsgLogger().println(new String(byArray), 8, 2);
                break;
            }
            default: {
                FacilityManager.getMsgLogger().printmsg(2, "COM marker registered as 0x" + Integer.toHexString(n2) + " unknown, ignoring (this might crash the " + "decoder or decode a quality degraded or even " + "useless image)");
                dataInputStream.skipBytes(n - 4);
            }
        }
        this.checkMarkerLength(dataInputStream, "COM marker");
    }

    private void readCRG(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        FacilityManager.getMsgLogger().printmsg(2, "Information in CRG marker segment not taken into account. This may affect the display of the decoded image.");
        dataInputStream.skipBytes(n - 2);
        this.checkMarkerLength(dataInputStream, "CRG marker");
    }

    private SynWTFilter readFilter(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readUnsignedByte();
        if (n >= 128) {
            throw new NotImplementedError("Custom filters not supported");
        }
        switch (n) {
            case 0: {
                return new SynWTFilterFloatLift9x7();
            }
            case 1: {
                return new SynWTFilterIntLift5x3();
            }
        }
        throw new CorruptedCodestreamException("Specified wavelet filter not JPEG 2000 part I compliant");
    }

    private void readFoundMainMarkSeg() throws IOException {
        int n;
        ByteArrayInputStream byteArrayInputStream;
        if (this.pl.getBooleanParameter("cdstr_info")) {
            this.printHeader = true;
        }
        if ((this.markersFound & 1) != 0) {
            byteArrayInputStream = new ByteArrayInputStream((byte[])this.ht.get("SIZ"));
            this.readSIZ(new DataInputStream(byteArrayInputStream));
        }
        if ((this.markersFound & 0x800) != 0) {
            n = 0;
            while (n < this.nCOMmarker) {
                byteArrayInputStream = new ByteArrayInputStream((byte[])this.ht.get("COM" + n));
                this.readCOM(new DataInputStream(byteArrayInputStream));
                ++n;
            }
        }
        if ((this.markersFound & 0x10000) != 0) {
            byteArrayInputStream = new ByteArrayInputStream((byte[])this.ht.get("CRG"));
            this.readCRG(new DataInputStream(byteArrayInputStream));
        }
        if ((this.markersFound & 2) != 0) {
            byteArrayInputStream = new ByteArrayInputStream((byte[])this.ht.get("COD"));
            this.readCOD(new DataInputStream(byteArrayInputStream), true, 0);
        }
        if ((this.markersFound & 4) != 0) {
            n = 0;
            while (n < this.nCOCmarker) {
                byteArrayInputStream = new ByteArrayInputStream((byte[])this.ht.get("COC" + n));
                this.readCOC(new DataInputStream(byteArrayInputStream), true, 0);
                ++n;
            }
        }
        if ((this.markersFound & 0x200) != 0) {
            n = 0;
            while (n < this.nRGNmarker) {
                byteArrayInputStream = new ByteArrayInputStream((byte[])this.ht.get("RGN" + n));
                this.readRGN(new DataInputStream(byteArrayInputStream), true, 0);
                ++n;
            }
        }
        if ((this.markersFound & 8) != 0) {
            byteArrayInputStream = new ByteArrayInputStream((byte[])this.ht.get("QCD"));
            this.readQCD(new DataInputStream(byteArrayInputStream), true, 0);
        }
        if ((this.markersFound & 0x100) != 0) {
            n = 0;
            while (n < this.nQCCmarker) {
                byteArrayInputStream = new ByteArrayInputStream((byte[])this.ht.get("QCC" + n));
                this.readQCC(new DataInputStream(byteArrayInputStream), true, 0);
                ++n;
            }
        }
        if ((this.markersFound & 0x400) != 0) {
            byteArrayInputStream = new ByteArrayInputStream((byte[])this.ht.get("POC"));
            this.readPOC(new DataInputStream(byteArrayInputStream), true, 0);
        }
        if ((this.markersFound & 0x4000) != 0) {
            n = 0;
            while (n < this.nPPMmarker) {
                byteArrayInputStream = new ByteArrayInputStream((byte[])this.ht.get("PPM" + n));
                this.readPPM(new DataInputStream(byteArrayInputStream));
                ++n;
            }
        }
        if (this.printHeader) {
            String string = this.toString();
            if (string != "") {
                FacilityManager.getMsgLogger().printmsg(1, "Main Header:\n" + this.toString());
            }
            this.hdStr = "";
        }
    }

    public void readFoundTilePartMarkSeg(int n) throws IOException {
        int n2;
        ByteArrayInputStream byteArrayInputStream;
        if ((this.markersFound & 2) != 0) {
            byteArrayInputStream = new ByteArrayInputStream((byte[])this.ht.get("COD"));
            this.readCOD(new DataInputStream(byteArrayInputStream), false, n);
        }
        if ((this.markersFound & 4) != 0) {
            n2 = 0;
            while (n2 < this.nCOCmarker) {
                byteArrayInputStream = new ByteArrayInputStream((byte[])this.ht.get("COC" + n2));
                this.readCOC(new DataInputStream(byteArrayInputStream), false, n);
                ++n2;
            }
        }
        if ((this.markersFound & 0x200) != 0) {
            n2 = 0;
            while (n2 < this.nRGNmarker) {
                byteArrayInputStream = new ByteArrayInputStream((byte[])this.ht.get("RGN" + n2));
                this.readRGN(new DataInputStream(byteArrayInputStream), false, n);
                ++n2;
            }
        }
        if ((this.markersFound & 8) != 0) {
            byteArrayInputStream = new ByteArrayInputStream((byte[])this.ht.get("QCD"));
            this.readQCD(new DataInputStream(byteArrayInputStream), false, n);
        }
        if ((this.markersFound & 0x100) != 0) {
            n2 = 0;
            while (n2 < this.nQCCmarker) {
                byteArrayInputStream = new ByteArrayInputStream((byte[])this.ht.get("QCC" + n2));
                this.readQCC(new DataInputStream(byteArrayInputStream), false, n);
                ++n2;
            }
        }
        if ((this.markersFound & 0x400) != 0) {
            byteArrayInputStream = new ByteArrayInputStream((byte[])this.ht.get("POC"));
            this.readPOC(new DataInputStream(byteArrayInputStream), false, n);
        }
        if ((this.markersFound & 0x800) != 0) {
            n2 = 0;
            while (n2 < this.nCOMmarker) {
                byteArrayInputStream = new ByteArrayInputStream((byte[])this.ht.get("COM" + n2));
                this.readCOM(new DataInputStream(byteArrayInputStream));
                ++n2;
            }
        }
        if ((this.markersFound & 0x8000) != 0) {
            n2 = 0;
            while (n2 < this.nPPTmarker[n]) {
                byteArrayInputStream = new ByteArrayInputStream((byte[])this.ht.get("PPT" + n2));
                this.readPPT(new DataInputStream(byteArrayInputStream), n);
                ++n2;
            }
        }
        if (this.printHeader) {
            String string = this.toString();
            if (string != "") {
                FacilityManager.getMsgLogger().printmsg(1, "Tile Header (" + n + "):\n" + this.toString());
            }
            this.hdStr = "";
        }
    }

    private void readPLM(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        dataInputStream.skipBytes(n - 2);
        FacilityManager.getMsgLogger().printmsg(1, "Skipping unsupported PLM marker");
    }

    private void readPLTFields(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        dataInputStream.skipBytes(n - 2);
        FacilityManager.getMsgLogger().printmsg(1, "Skipping unsupported PLT marker");
    }

    private void readPOC(DataInputStream dataInputStream, boolean bl, int n) throws IOException {
        boolean bl2 = this.nComp >= 256;
        int n2 = dataInputStream.readUnsignedShort();
        int n3 = (n2 - 2) / (5 + (bl2 ? 4 : 2));
        int[][] nArray = new int[n3][6];
        int n4 = 0;
        while (n4 < n3) {
            nArray[n4][0] = dataInputStream.readUnsignedByte();
            nArray[n4][1] = bl2 ? dataInputStream.readUnsignedShort() : dataInputStream.readUnsignedByte();
            nArray[n4][2] = dataInputStream.readUnsignedShort();
            nArray[n4][3] = dataInputStream.readUnsignedByte();
            nArray[n4][4] = bl2 ? dataInputStream.readUnsignedShort() : dataInputStream.readUnsignedByte();
            nArray[n4][5] = dataInputStream.readUnsignedByte();
            ++n4;
        }
        this.checkMarkerLength(dataInputStream, "POC marker");
        if (bl) {
            this.decSpec.pcs.setDefault(nArray);
        } else {
            this.decSpec.pcs.setTileDef(n, nArray);
        }
        if (this.printHeader) {
            this.hdStr = String.valueOf(this.hdStr) + " --- POC ---\n";
            this.hdStr = String.valueOf(this.hdStr) + " Chg_idx RSpos CSpos LYEpos REpos CEpos Cpos\n";
            int n5 = 0;
            while (n5 < n3) {
                this.hdStr = String.valueOf(this.hdStr) + "   " + n5 + "      " + nArray[n5][0] + "     " + nArray[n5][1] + "     " + nArray[n5][2] + "      " + nArray[n5][3] + "     " + nArray[n5][4] + "     " + nArray[n5][5];
                ++n5;
            }
        }
    }

    private void readPPM(DataInputStream dataInputStream) throws IOException {
        if (this.unsortedPkdPktHeaders == null) {
            this.tileOfTileParts = new Vector();
            this.unsortedPkdPktHeaders = new Vector();
            this.decSpec.pphs.setDefault(new Boolean(true));
        }
        int n = dataInputStream.readUnsignedShort();
        int n2 = n - 3;
        int n3 = dataInputStream.readUnsignedByte();
        while (n2 > 0) {
            int n4;
            if (this.remPPMData == 0) {
                this.remPPMData = dataInputStream.readInt();
                n2 -= 4;
                n4 = 0;
            } else {
                n4 = this.readIPPMData.length - this.remPPMData;
            }
            int n5 = n2 < this.remPPMData ? n2 : this.remPPMData;
            byte[] byArray = new byte[n5];
            dataInputStream.read(byArray, 0, n5);
            this.remPPMData -= n5;
            n2 -= n5;
            if (this.remPPMData == 0) {
                this.unsortedPkdPktHeaders.addElement(byArray);
            } else {
                int n6 = 0;
                while (n6 < n5) {
                    this.readIPPMData[n4] = byArray[n6];
                    ++n6;
                    ++n4;
                }
                if (this.remPPMData == 0) {
                    this.unsortedPkdPktHeaders.addElement(this.readIPPMData);
                }
            }
            ++this.nReadPPMmarker;
        }
        this.checkMarkerLength(dataInputStream, "PPM marker");
    }

    private void readPPT(DataInputStream dataInputStream, int n) throws IOException {
        int n2 = 0;
        if (this.nReadPPTmarker == null) {
            this.nReadPPTmarker = new int[this.nTiles];
        }
        byte[][] byArray = new byte[this.nPPTmarker[n]][];
        int n3 = dataInputStream.readUnsignedShort();
        int n4 = dataInputStream.readUnsignedByte();
        byte[] byArray2 = new byte[n3 - 3];
        dataInputStream.read(byArray2);
        byArray[n4] = byArray2;
        this.checkMarkerLength(dataInputStream, "PPT marker");
        this.decSpec.pphs.setTileDef(n, new Boolean(true));
        int n5 = n;
        this.nReadPPTmarker[n5] = this.nReadPPTmarker[n5] + 1;
        if (this.nReadPPTmarker[n] == this.nPPTmarker[n]) {
            if (this.pkdPktHeaders == null) {
                this.pkdPktHeaders = new ByteArrayOutputStream[this.nTiles];
            }
            if (this.pkdPktHeaders[n] == null) {
                this.pkdPktHeaders[n] = new ByteArrayOutputStream();
            }
            int n6 = 0;
            while (n6 < this.nPPTmarker[n]) {
                n2 += byArray[n6].length;
                this.pkdPktHeaders[n].write(byArray[n6], 0, byArray[n6].length);
                ++n6;
            }
        }
    }

    private void readQCC(DataInputStream dataInputStream, boolean bl, int n) throws IOException {
        block31: {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int[][] nArray;
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            float[][] fArray;
            block30: {
                block29: {
                    fArray = null;
                    int n12 = dataInputStream.readUnsignedShort();
                    n11 = this.nComp < 257 ? dataInputStream.readUnsignedByte() : dataInputStream.readUnsignedShort();
                    if (n11 >= this.nComp) {
                        throw new CorruptedCodestreamException("Invalid component index in QCC marker");
                    }
                    n10 = dataInputStream.readUnsignedByte();
                    n9 = n10 >> 5 & 7;
                    n8 = n10 &= 0xFFFFFF1F;
                    if (!bl) break block29;
                    switch (n8) {
                        case 0: {
                            this.decSpec.qts.setCompDef(n11, "reversible");
                            break block30;
                        }
                        case 1: {
                            this.decSpec.qts.setCompDef(n11, "derived");
                            break block30;
                        }
                        case 2: {
                            this.decSpec.qts.setCompDef(n11, "expounded");
                            break block30;
                        }
                        default: {
                            throw new CorruptedCodestreamException("Unknown or unsupported quantization style in Sqcd field, QCD marker, main header");
                        }
                    }
                }
                switch (n8) {
                    case 0: {
                        this.decSpec.qts.setTileCompVal(n, n11, "reversible");
                        break;
                    }
                    case 1: {
                        this.decSpec.qts.setTileCompVal(n, n11, "derived");
                        break;
                    }
                    case 2: {
                        this.decSpec.qts.setTileCompVal(n, n11, "expounded");
                        break;
                    }
                    default: {
                        throw new CorruptedCodestreamException("Unknown or unsupported quantization style in Sqcd field, QCD marker, main header");
                    }
                }
            }
            StdDequantizerParams stdDequantizerParams = new StdDequantizerParams();
            if (n8 == 0) {
                n7 = n8 == 1 ? 0 : (bl ? ((Integer)this.decSpec.dls.getCompDef(n11)).intValue() : ((Integer)this.decSpec.dls.getTileCompVal(n, n11)).intValue());
                stdDequantizerParams.exp = new int[n7 + 1][];
                nArray = stdDequantizerParams.exp;
                n6 = 0;
                while (n6 <= n7) {
                    if (n6 == 0) {
                        n5 = 0;
                        n4 = 1;
                    } else {
                        n3 = 1;
                        n3 = n3 > n7 - n6 ? (n3 -= n7 - n6) : 1;
                        n5 = 1 << (n3 - 1 << 1);
                        n4 = 1 << (n3 << 1);
                    }
                    nArray[n6] = new int[n4];
                    n2 = n5;
                    while (n2 < n4) {
                        n10 = dataInputStream.readUnsignedByte();
                        nArray[n6][n2] = n10 >> 3 & 0x1F;
                        ++n2;
                    }
                    ++n6;
                }
            } else {
                n7 = n8 == 1 ? 0 : (bl ? ((Integer)this.decSpec.dls.getCompDef(n11)).intValue() : ((Integer)this.decSpec.dls.getTileCompVal(n, n11)).intValue());
                stdDequantizerParams.nStep = new float[n7 + 1][];
                fArray = stdDequantizerParams.nStep;
                stdDequantizerParams.exp = new int[n7 + 1][];
                nArray = stdDequantizerParams.exp;
                n6 = 0;
                while (n6 <= n7) {
                    if (n6 == 0) {
                        n5 = 0;
                        n4 = 1;
                    } else {
                        n3 = 1;
                        n3 = n3 > n7 - n6 ? (n3 -= n7 - n6) : 1;
                        n5 = 1 << (n3 - 1 << 1);
                        n4 = 1 << (n3 << 1);
                    }
                    nArray[n6] = new int[n4];
                    fArray[n6] = new float[n4];
                    n2 = n5;
                    while (n2 < n4) {
                        n10 = dataInputStream.readUnsignedShort();
                        nArray[n6][n2] = n10 >> 11 & 0x1F;
                        fArray[n6][n2] = (-1.0f - (float)(n10 & 0x7FF) / 2048.0f) / (float)(-1 << nArray[n6][n2]);
                        ++n2;
                    }
                    ++n6;
                }
            }
            if (bl) {
                this.decSpec.qsss.setCompDef(n11, stdDequantizerParams);
                this.decSpec.gbs.setCompDef(n11, new Integer(n9));
            } else {
                this.decSpec.qsss.setTileCompVal(n, n11, stdDequantizerParams);
                this.decSpec.gbs.setTileCompVal(n, n11, new Integer(n9));
            }
            this.checkMarkerLength(dataInputStream, "QCC marker");
            if (!this.printHeader) break block31;
            this.hdStr = String.valueOf(this.hdStr) + " --- QCC(" + n11 + ") ---\n";
            this.hdStr = String.valueOf(this.hdStr) + " Quant. type : " + n8 + "\n";
            this.hdStr = String.valueOf(this.hdStr) + " Guard bits  : " + n9 + "\n";
            if (n8 == 0) {
                this.hdStr = String.valueOf(this.hdStr) + " Exponent    : \n";
                n7 = 0;
                while (n7 < nArray.length) {
                    int n13 = 0;
                    while (n13 < nArray[n7].length) {
                        this.hdStr = String.valueOf(this.hdStr) + "   " + n7 + "," + n13 + " = " + nArray[n7][n13] + "\n";
                        ++n13;
                    }
                    ++n7;
                }
            } else {
                this.hdStr = String.valueOf(this.hdStr) + " Exp / nStep : \n";
                n7 = 0;
                while (n7 < nArray.length) {
                    int n14 = 0;
                    while (n14 < nArray[n7].length) {
                        this.hdStr = String.valueOf(this.hdStr) + "   " + n7 + "," + n14 + " = " + nArray[n7][n14] + "  " + fArray[n7][n14] + "\n";
                        ++n14;
                    }
                    ++n7;
                }
            }
        }
    }

    private void readQCD(DataInputStream dataInputStream, boolean bl, int n) throws IOException {
        block30: {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int[][] nArray;
            int n8;
            int n9;
            int n10;
            float[][] fArray;
            block29: {
                block28: {
                    fArray = null;
                    int n11 = dataInputStream.readUnsignedShort();
                    n10 = dataInputStream.readUnsignedByte();
                    n9 = n10 >> 5 & 7;
                    n10 &= 0xFFFFFF1F;
                    if (!bl) break block28;
                    switch (n10) {
                        case 0: {
                            this.decSpec.qts.setDefault("reversible");
                            break block29;
                        }
                        case 1: {
                            this.decSpec.qts.setDefault("derived");
                            break block29;
                        }
                        case 2: {
                            this.decSpec.qts.setDefault("expounded");
                            break block29;
                        }
                        default: {
                            throw new CorruptedCodestreamException("Unknown or unsupported quantization style in Sqcd field, QCD marker main header");
                        }
                    }
                }
                switch (n10) {
                    case 0: {
                        this.decSpec.qts.setTileDef(n, "reversible");
                        break;
                    }
                    case 1: {
                        this.decSpec.qts.setTileDef(n, "derived");
                        break;
                    }
                    case 2: {
                        this.decSpec.qts.setTileDef(n, "expounded");
                        break;
                    }
                    default: {
                        throw new CorruptedCodestreamException("Unknown or unsupported quantization style in Sqcd field, QCD marker, tile header");
                    }
                }
            }
            StdDequantizerParams stdDequantizerParams = new StdDequantizerParams();
            if (n10 == 0) {
                n8 = n10 == 1 ? 0 : (bl ? ((Integer)this.decSpec.dls.getDefault()).intValue() : ((Integer)this.decSpec.dls.getTileDef(n)).intValue());
                stdDequantizerParams.exp = new int[n8 + 1][];
                nArray = stdDequantizerParams.exp;
                n7 = 0;
                while (n7 <= n8) {
                    if (n7 == 0) {
                        n6 = 0;
                        n5 = 1;
                    } else {
                        n4 = 1;
                        n4 = n4 > n8 - n7 ? (n4 -= n8 - n7) : 1;
                        n6 = 1 << (n4 - 1 << 1);
                        n5 = 1 << (n4 << 1);
                    }
                    nArray[n7] = new int[n5];
                    n3 = n6;
                    while (n3 < n5) {
                        n2 = dataInputStream.readUnsignedByte();
                        nArray[n7][n3] = n2 >> 3 & 0x1F;
                        ++n3;
                    }
                    ++n7;
                }
            } else {
                n8 = n10 == 1 ? 0 : (bl ? ((Integer)this.decSpec.dls.getDefault()).intValue() : ((Integer)this.decSpec.dls.getTileDef(n)).intValue());
                stdDequantizerParams.exp = new int[n8 + 1][];
                nArray = stdDequantizerParams.exp;
                stdDequantizerParams.nStep = new float[n8 + 1][];
                fArray = stdDequantizerParams.nStep;
                n7 = 0;
                while (n7 <= n8) {
                    if (n7 == 0) {
                        n6 = 0;
                        n5 = 1;
                    } else {
                        n4 = 1;
                        n4 = n4 > n8 - n7 ? (n4 -= n8 - n7) : 1;
                        n6 = 1 << (n4 - 1 << 1);
                        n5 = 1 << (n4 << 1);
                    }
                    nArray[n7] = new int[n5];
                    fArray[n7] = new float[n5];
                    n3 = n6;
                    while (n3 < n5) {
                        n2 = dataInputStream.readUnsignedShort();
                        nArray[n7][n3] = n2 >> 11 & 0x1F;
                        fArray[n7][n3] = (-1.0f - (float)(n2 & 0x7FF) / 2048.0f) / (float)(-1 << nArray[n7][n3]);
                        ++n3;
                    }
                    ++n7;
                }
            }
            if (bl) {
                this.decSpec.qsss.setDefault(stdDequantizerParams);
                this.decSpec.gbs.setDefault(new Integer(n9));
            } else {
                this.decSpec.qsss.setTileDef(n, stdDequantizerParams);
                this.decSpec.gbs.setTileDef(n, new Integer(n9));
            }
            this.checkMarkerLength(dataInputStream, "QCD marker");
            if (!this.printHeader) break block30;
            this.hdStr = String.valueOf(this.hdStr) + " --- QCD ---\n";
            this.hdStr = String.valueOf(this.hdStr) + " Quant. type : " + n10 + "\n";
            this.hdStr = String.valueOf(this.hdStr) + " Guard bits  : " + n9 + "\n";
            if (n10 == 0) {
                this.hdStr = String.valueOf(this.hdStr) + " Exponent    : \n";
                n8 = 0;
                while (n8 < nArray.length) {
                    int n12 = 0;
                    while (n12 < nArray[n8].length) {
                        this.hdStr = String.valueOf(this.hdStr) + "   " + n8 + "," + n12 + " = " + nArray[n8][n12] + "\n";
                        ++n12;
                    }
                    ++n8;
                }
            } else {
                this.hdStr = String.valueOf(this.hdStr) + " Exp / nStep : \n";
                n8 = 0;
                while (n8 < nArray.length) {
                    int n13 = 0;
                    while (n13 < nArray[n8].length) {
                        this.hdStr = String.valueOf(this.hdStr) + "   " + n8 + "," + n13 + " = " + nArray[n8][n13] + "  " + fArray[n8][n13] + "\n";
                        ++n13;
                    }
                    ++n8;
                }
            }
        }
    }

    private void readRGN(DataInputStream dataInputStream, boolean bl, int n) throws IOException {
        int n2;
        int n3;
        int n4 = dataInputStream.readUnsignedShort();
        int n5 = n3 = this.nComp < 257 ? dataInputStream.readUnsignedByte() : dataInputStream.readUnsignedShort();
        if (n3 >= this.nComp) {
            throw new CorruptedCodestreamException("Invalid component index in RGN marker" + n3);
        }
        int n6 = dataInputStream.readUnsignedByte();
        if (n6 != 0) {
            throw new CorruptedCodestreamException("Unknown or unsupported Srgn parameter in ROI marker");
        }
        if (this.decSpec.rois == null) {
            this.decSpec.rois = new MaxShiftSpec(this.nTiles, this.nComp, 2);
        }
        if (bl) {
            n2 = dataInputStream.readUnsignedByte();
            this.decSpec.rois.setCompDef(n3, new Integer(n2));
        } else {
            n2 = dataInputStream.readUnsignedByte();
            this.decSpec.rois.setTileCompVal(n, n3, new Integer(n2));
        }
        this.checkMarkerLength(dataInputStream, "RGN marker");
        if (this.printHeader) {
            this.hdStr = String.valueOf(this.hdStr) + " --- RGN(" + n3 + ") ---\n";
            this.hdStr = String.valueOf(this.hdStr) + " ROI scaling value: " + n2 + "\n";
        }
    }

    private void readSIZ(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        this.cdstrmCap = dataInputStream.readUnsignedShort();
        if (this.cdstrmCap != 0) {
            throw new Error("Codestream capabiities not JPEG 2000 - Part I compliant");
        }
        this.imgW = dataInputStream.readInt();
        this.imgH = dataInputStream.readInt();
        if (this.imgW <= 0 || this.imgH <= 0) {
            throw new IOException("JJ2000 does not support images whose width and/or height not in the range: 1 -- (2^31)-1");
        }
        this.imgOrigX = dataInputStream.readInt();
        this.imgW -= this.imgOrigX;
        this.imgOrigY = dataInputStream.readInt();
        this.imgH -= this.imgOrigY;
        if (this.imgOrigX < 0 || this.imgOrigY < 0) {
            throw new IOException("JJ2000 does not support images offset not in the range: 0 -- (2^31)-1");
        }
        this.tileW = dataInputStream.readInt();
        this.tileH = dataInputStream.readInt();
        if (this.tileW <= 0 || this.tileH <= 0) {
            throw new IOException("JJ2000 does not support tiles whose width and/or height are not in  the range: 1 -- (2^31)-1");
        }
        this.tilingOrigX = dataInputStream.readInt();
        this.tilingOrigY = dataInputStream.readInt();
        if (this.tilingOrigX < 0 || this.tilingOrigY < 0) {
            throw new IOException("JJ2000 does not support tiles whose offset is not in  the range: 0 -- (2^31)-1");
        }
        this.nComp = dataInputStream.readUnsignedShort();
        if (this.nComp < 1 || this.nComp > 16384) {
            throw new IllegalArgumentException("Number of component out of range 1--16384: " + this.nComp);
        }
        this.origBitDepth = new int[this.nComp];
        this.isOrigSigned = new boolean[this.nComp];
        this.compSubsX = new int[this.nComp];
        this.compSubsY = new int[this.nComp];
        int n2 = 0;
        while (n2 < this.nComp) {
            int n3 = dataInputStream.readUnsignedByte();
            this.isOrigSigned[n2] = n3 >>> 7 == 1;
            this.origBitDepth[n2] = (n3 & 0x7F) + 1;
            if (this.origBitDepth[n2] + (this.isOrigSigned[n2] ? 1 : 0) > 38) {
                throw new Error("More than 38 bit-planes signalled for component " + n2);
            }
            this.compSubsX[n2] = dataInputStream.readUnsignedByte();
            this.compSubsY[n2] = dataInputStream.readUnsignedByte();
            ++n2;
        }
        this.checkMarkerLength(dataInputStream, "SIZ marker");
        this.nTiles = (this.imgOrigX + this.imgW - this.tilingOrigX + this.tileW - 1) / this.tileW * ((this.imgOrigY + this.imgH - this.tilingOrigY + this.tileH - 1) / this.tileH);
        this.decSpec = new DecoderSpecs(this.nTiles, this.nComp);
        if (this.printInfo) {
            String string = String.valueOf(this.nComp) + " component(s), " + this.nTiles + " tile(s)\n";
            string = String.valueOf(string) + "Image dimension: " + this.imgW + "x" + this.imgH;
            if (this.nTiles != 1) {
                string = String.valueOf(string) + "\nNominal Tile dimension: " + this.tileW + "x" + this.tileH;
            }
            FacilityManager.getMsgLogger().printmsg(1, string);
        }
        if (this.printHeader) {
            this.hdStr = String.valueOf(this.hdStr) + " --- SIZ ---\n";
            this.hdStr = String.valueOf(this.hdStr) + " Capabilities: " + this.cdstrmCap + "\n";
            this.hdStr = String.valueOf(this.hdStr) + " Image dim.  : " + this.imgW + "x" + this.imgH + ", (off=" + this.imgOrigX + "," + this.imgOrigY + ")\n";
            this.hdStr = String.valueOf(this.hdStr) + " Tile dim.   : " + this.tileW + "x" + this.tileH + ", (off=" + this.tilingOrigX + "," + this.tilingOrigY + ")\n";
            this.hdStr = String.valueOf(this.hdStr) + " Component(s): " + this.nComp + "\n";
            this.hdStr = String.valueOf(this.hdStr) + " Orig. depth :";
            int n4 = 0;
            while (n4 < this.nComp) {
                this.hdStr = String.valueOf(this.hdStr) + " " + this.origBitDepth[n4];
                ++n4;
            }
            this.hdStr = String.valueOf(this.hdStr) + "\n";
            this.hdStr = String.valueOf(this.hdStr) + " Orig. signed:";
            int n5 = 0;
            while (n5 < this.nComp) {
                this.hdStr = String.valueOf(this.hdStr) + " " + this.isOrigSigned[n5];
                ++n5;
            }
            this.hdStr = String.valueOf(this.hdStr) + "\n";
            this.hdStr = String.valueOf(this.hdStr) + " Subs. factor:";
            int n6 = 0;
            while (n6 < this.nComp) {
                this.hdStr = String.valueOf(this.hdStr) + " " + this.compSubsX[n6] + "," + this.compSubsY[n6];
                ++n6;
            }
            this.hdStr = String.valueOf(this.hdStr) + "\n";
        }
    }

    private void readTLM(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readUnsignedShort();
        dataInputStream.skipBytes(n - 2);
        FacilityManager.getMsgLogger().printmsg(1, "Skipping unsupported TLM marker");
    }

    public void resetHeaderMarkers() {
        this.markersFound &= 0x4020;
        this.nCOCmarker = 0;
        this.nQCCmarker = 0;
        this.nCOMmarker = 0;
        this.nRGNmarker = 0;
        this.nPPTmarker = new int[this.nTiles];
        this.nReadPPTmarker = new int[this.nTiles];
        this.ht = new Hashtable();
    }

    public void setTileOfTileParts(int n) {
        if (this.nPPMmarker != 0) {
            this.tileOfTileParts.addElement(new Integer(n));
        }
    }

    public String toString() {
        return this.hdStr;
    }
}

