/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.codestream.reader;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Vector;
import jj2000.j2k.JJ2KExceptionHandler;
import jj2000.j2k.NoNextElementException;
import jj2000.j2k.NotImplementedError;
import jj2000.j2k.codestream.CorruptedCodestreamException;
import jj2000.j2k.codestream.Markers;
import jj2000.j2k.codestream.ProgressionType;
import jj2000.j2k.codestream.reader.BitstreamReaderAgent;
import jj2000.j2k.codestream.reader.CBlkInfo;
import jj2000.j2k.codestream.reader.HeaderDecoder;
import jj2000.j2k.codestream.reader.PktDecoder;
import jj2000.j2k.decoder.DecoderSpecs;
import jj2000.j2k.entropy.StdEntropyCoderOptions;
import jj2000.j2k.entropy.decoder.DecLyrdCBlk;
import jj2000.j2k.image.Coord;
import jj2000.j2k.io.RandomAccessIO;
import jj2000.j2k.quantization.dequantizer.StdDequantizerParams;
import jj2000.j2k.util.ArrayUtil;
import jj2000.j2k.util.FacilityManager;
import jj2000.j2k.util.ParameterList;
import jj2000.j2k.wavelet.synthesis.SubbandSyn;

public class FileBitstreamReaderAgent
extends BitstreamReaderAgent
implements Markers,
ProgressionType,
StdEntropyCoderOptions {
    public PktDecoder pktDec;
    private ParameterList pl;
    private RandomAccessIO in;
    private int nt;
    private int[][] firstPackOff;
    private int[] nBytes;
    private int[][] tilePartLen;
    private int[] totTileLen;
    private int[] totTileHeadLen;
    private int firstTilePartHeadLen;
    private double totAllTileLen;
    private int mainHeadLen;
    private int[][] tilePartHeadLen;
    private Vector pktHL;
    private boolean isTruncMode;
    private int remainingTileParts;
    private int[] tilePartsRead;
    private int totTilePartsRead = 0;
    private int[] tileParts;
    private int curTilePart;
    private int[][] tilePartNum;
    private CBlkInfo[][][][][] cbI;

    public FileBitstreamReaderAgent(HeaderDecoder headerDecoder, RandomAccessIO randomAccessIO, DecoderSpecs decoderSpecs, ParameterList parameterList) throws IOException {
        super(headerDecoder, decoderSpecs);
        this.pl = parameterList;
        String string = "Codestream elements information in bytes (offset, total length, header length):\n\n";
        boolean bl = parameterList.getBooleanParameter("parsing");
        try {
            this.trate = parameterList.getFloatParameter("rate");
        }
        catch (NumberFormatException numberFormatException) {
            throw new Error("Invalid value in 'rate' option: " + parameterList.getParameter("rate"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new Error("'rate' option is missing");
        }
        try {
            this.tnbytes = parameterList.getIntParameter("nbytes");
        }
        catch (NumberFormatException numberFormatException) {
            throw new Error("Invalid value in 'nbytes' option: " + parameterList.getParameter("nbytes"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new Error("'nbytes' option is missing");
        }
        ParameterList parameterList2 = parameterList.getDefaultParameterList();
        boolean bl2 = (float)this.tnbytes != parameterList2.getFloatParameter("nbytes");
        if (bl2 && this.trate != (float)parameterList2.getIntParameter("rate")) {
            throw new Error("Cannot use '-rate' and '-nbytes' options at the same time.");
        }
        if (bl2) {
            this.trate = (float)this.tnbytes * 8.0f / (float)headerDecoder.getImgWidth() / (float)headerDecoder.getImgHeight();
        } else {
            this.tnbytes = (int)(this.trate * (float)headerDecoder.getImgWidth() * (float)headerDecoder.getImgHeight()) / 8;
        }
        this.isTruncMode = parameterList.getBooleanParameter("parsing") ^ true;
        this.nt = this.ntX * this.ntY;
        this.in = randomAccessIO;
        this.pktDec = new PktDecoder(decoderSpecs, headerDecoder, randomAccessIO, this, this.isTruncMode);
        this.tileParts = new int[this.nt];
        this.totTileLen = new int[this.nt];
        this.tilePartLen = new int[this.nt][];
        this.tilePartNum = new int[this.nt][];
        this.firstPackOff = new int[this.nt][];
        this.tilePartsRead = new int[this.nt];
        this.totTileHeadLen = new int[this.nt];
        this.tilePartHeadLen = new int[this.nt][];
        this.nBytes = new int[this.nt];
        headerDecoder.nTileParts = new int[this.nt];
        this.isTruncMode = this.isTruncMode;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = headerDecoder.initPos;
        this.anbytes = this.mainHeadLen = this.in.getPos() - n4;
        string = String.valueOf(string) + "Main header length    : " + n4 + ", " + this.mainHeadLen + ", " + this.mainHeadLen + "\n";
        if (this.anbytes > this.tnbytes) {
            throw new Error("Requested bitrate is too small.");
        }
        boolean bl3 = false;
        this.totAllTileLen = 0.0;
        this.remainingTileParts = this.nt;
        try {
            while (this.remainingTileParts != 0) {
                int n5 = this.in.getPos();
                try {
                    n = this.readTilePartHeader();
                    n2 = this.tilePartsRead[n];
                }
                catch (EOFException eOFException) {
                    this.firstPackOff[n][n2] = this.in.length();
                    throw eOFException;
                }
                int n6 = this.in.getPos();
                if (this.isTruncMode && n6 - n4 > this.tnbytes) {
                    this.firstPackOff[n][n2] = this.in.length();
                    bl3 = true;
                    break;
                }
                this.firstPackOff[n][n2] = n6;
                this.tilePartHeadLen[n][n2] = n6 - n5;
                string = String.valueOf(string) + "Tile-part " + n2 + " of tile " + n + " : " + n5 + ", " + this.tilePartLen[n][n2] + ", " + this.tilePartHeadLen[n][n2] + "\n";
                int n7 = n;
                this.totTileLen[n7] = this.totTileLen[n7] + this.tilePartLen[n][n2];
                int n8 = n;
                this.totTileHeadLen[n8] = this.totTileHeadLen[n8] + this.tilePartHeadLen[n][n2];
                this.totAllTileLen += (double)this.tilePartLen[n][n2];
                if (this.isTruncMode) {
                    if (this.anbytes + this.tilePartLen[n][n2] > this.tnbytes) {
                        this.anbytes += this.tilePartHeadLen[n][n2];
                        bl3 = true;
                        int n9 = n;
                        this.nBytes[n9] = this.nBytes[n9] + (this.tnbytes - this.anbytes);
                        break;
                    }
                    this.anbytes += this.tilePartHeadLen[n][n2];
                    int n10 = n;
                    this.nBytes[n10] = this.nBytes[n10] + (this.tilePartLen[n][n2] - this.tilePartHeadLen[n][n2]);
                } else {
                    if (this.anbytes + this.tilePartHeadLen[n][n2] > this.tnbytes) break;
                    this.anbytes += this.tilePartHeadLen[n][n2];
                }
                if (n3 == 0) {
                    this.firstTilePartHeadLen = this.tilePartHeadLen[n][n2];
                }
                int n11 = n;
                this.tilePartsRead[n11] = this.tilePartsRead[n11] + 1;
                this.in.seek(n5 + this.tilePartLen[n][n2]);
                --this.remainingTileParts;
                ++n3;
            }
        }
        catch (EOFException eOFException) {
            if (parameterList.getBooleanParameter("cdstr_info")) {
                FacilityManager.getMsgLogger().printmsg(1, string);
            }
            FacilityManager.getMsgLogger().printmsg(2, "Codestream truncated in tile " + n);
            if (!this.isTruncMode) {
                this.allocateRate();
            }
            if (parameterList.getParameter("res") == null) {
                this.res = decoderSpecs.dls.getMin();
            } else {
                try {
                    this.res = parameterList.getIntParameter("res");
                    if (this.res < 0) {
                        throw new IllegalArgumentException("Specified negative resolution level index: " + this.res);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException("Invalid resolution level index ('-res' option) " + parameterList.getParameter("res"));
                }
            }
            int n12 = decoderSpecs.dls.getMin();
            if (this.res > n12) {
                FacilityManager.getMsgLogger().printmsg(2, "Specified resolution level (" + this.res + ") is larger" + " than the maximum value. Setting it to " + n12 + " (maximum value)");
                this.res = n12;
            }
            return;
        }
        this.remainingTileParts = 0;
        if (parameterList.getParameter("res") == null) {
            this.res = decoderSpecs.dls.getMin();
        } else {
            try {
                this.res = parameterList.getIntParameter("res");
                if (this.res < 0) {
                    throw new IllegalArgumentException("Specified negative resolution level index: " + this.res);
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Invalid resolution level index ('-res' option) " + parameterList.getParameter("res"));
            }
        }
        int n13 = decoderSpecs.dls.getMin();
        if (this.res > n13) {
            FacilityManager.getMsgLogger().printmsg(2, "Specified resolution level (" + this.res + ") is larger" + " than the maximum possible. Setting it to " + n13 + " (maximum possible)");
            this.res = n13;
        }
        if (parameterList.getBooleanParameter("cdstr_info")) {
            FacilityManager.getMsgLogger().printmsg(1, string);
        }
        try {
            if (!bl3 && this.in.readShort() != -39) {
                FacilityManager.getMsgLogger().printmsg(2, "EOC marker not found. Codestream is corrupted.");
            }
        }
        catch (EOFException eOFException) {
            FacilityManager.getMsgLogger().printmsg(2, "EOC marker is missing");
        }
        if (!this.isTruncMode) {
            this.allocateRate();
        } else if (this.in.getPos() >= this.tnbytes) {
            this.anbytes += 2;
        }
    }

    private void allocateRate() throws IOException {
        int n;
        int n2 = this.tnbytes;
        this.anbytes += 2;
        if (this.anbytes > n2) {
            throw new Error("Requested bitrate is too small for parsing");
        }
        int n3 = n = n2 - this.anbytes;
        int n4 = this.nt - 1;
        while (n4 > 0) {
            this.nBytes[n4] = (int)((double)n3 * ((double)this.totTileLen[n4] / this.totAllTileLen));
            n -= this.nBytes[n4];
            --n4;
        }
        this.nBytes[0] = n;
    }

    public DecLyrdCBlk getCodeBlock(int n, int n2, int n3, SubbandSyn subbandSyn, int n4, int n5, DecLyrdCBlk decLyrdCBlk) {
        int n6;
        int n7;
        int n8;
        int n9;
        CBlkInfo cBlkInfo;
        int n10 = this.getTileIdx();
        int n11 = subbandSyn.resLvl;
        int n12 = subbandSyn.sbandIdx;
        int n13 = (Integer)this.decSpec.nls.getTileDef(n10);
        int n14 = (Integer)this.decSpec.ecopts.getTileCompVal(n10, n);
        if (n5 < 0) {
            n5 = n13 - n4 + 1;
        }
        try {
            cBlkInfo = this.cbI[n][n11][n12][n2][n3];
            if (n4 < 1 || n4 > n13 || n4 + n5 - 1 > n13) {
                throw new IllegalArgumentException();
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException("Block (t:" + n10 + ", c:" + n + ", r:" + n11 + ", s:" + n12 + ", " + n2 + "x" + n3 + ") not found in bit stream");
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalArgumentException("Block (t:" + n10 + ", c:" + n + ", r:" + n11 + ", s:" + n12 + ", " + n2 + "x" + n3 + ") not found in bit stream");
        }
        if (decLyrdCBlk == null) {
            decLyrdCBlk = new DecLyrdCBlk();
        }
        decLyrdCBlk.m = n2;
        decLyrdCBlk.n = n3;
        decLyrdCBlk.nl = 0;
        decLyrdCBlk.dl = 0;
        decLyrdCBlk.nTrunc = 0;
        if (cBlkInfo == null) {
            decLyrdCBlk.skipMSBP = 0;
            decLyrdCBlk.prog = false;
            decLyrdCBlk.uly = 0;
            decLyrdCBlk.ulx = 0;
            decLyrdCBlk.h = 0;
            decLyrdCBlk.w = 0;
            return decLyrdCBlk;
        }
        decLyrdCBlk.skipMSBP = cBlkInfo.msbSkipped;
        decLyrdCBlk.ulx = cBlkInfo.ulx;
        decLyrdCBlk.uly = cBlkInfo.uly;
        decLyrdCBlk.w = cBlkInfo.w;
        decLyrdCBlk.h = cBlkInfo.h;
        decLyrdCBlk.ftpIdx = 0;
        int n15 = 0;
        while (n15 < cBlkInfo.len.length && cBlkInfo.len[n15] == 0) {
            decLyrdCBlk.ftpIdx += cBlkInfo.ntp[n15];
            ++n15;
        }
        n15 = n4 - 1;
        while (n15 < n4 + n5 - 1) {
            ++decLyrdCBlk.nl;
            decLyrdCBlk.dl += cBlkInfo.len[n15];
            decLyrdCBlk.nTrunc += cBlkInfo.ntp[n15];
            ++n15;
        }
        if ((n14 & 4) != 0) {
            n9 = decLyrdCBlk.nTrunc - decLyrdCBlk.ftpIdx;
        } else if ((n14 & 1) != 0) {
            if (decLyrdCBlk.nTrunc <= 10) {
                n9 = 1;
            } else {
                n9 = 1;
                n8 = decLyrdCBlk.ftpIdx;
                while (n8 < decLyrdCBlk.nTrunc) {
                    if (n8 >= 9 && ((n7 = (n8 + 2) % 3) == 1 || n7 == 2)) {
                        ++n9;
                    }
                    ++n8;
                }
            }
        } else {
            n9 = 1;
        }
        if (decLyrdCBlk.data == null || decLyrdCBlk.data.length < decLyrdCBlk.dl) {
            decLyrdCBlk.data = new byte[decLyrdCBlk.dl];
        }
        if (n9 > 1 && (decLyrdCBlk.tsLengths == null || decLyrdCBlk.tsLengths.length < n9)) {
            decLyrdCBlk.tsLengths = new int[n9];
        } else if (n9 > 1 && (n14 & 5) == 1) {
            ArrayUtil.intArraySet(decLyrdCBlk.tsLengths, 0);
        }
        int n16 = -1;
        n8 = decLyrdCBlk.ftpIdx;
        int n17 = decLyrdCBlk.ftpIdx;
        int n18 = 0;
        n15 = n4 - 1;
        while (n15 < n4 + n5 - 1) {
            n17 += cBlkInfo.ntp[n15];
            if (cBlkInfo.len[n15] != 0) {
                try {
                    this.in.seek(cBlkInfo.off[n15]);
                    this.in.readFully(decLyrdCBlk.data, n16 + 1, cBlkInfo.len[n15]);
                    n16 += cBlkInfo.len[n15];
                }
                catch (IOException iOException) {
                    JJ2KExceptionHandler.handleException(iOException);
                }
                if (n9 != 1) {
                    int n19;
                    if ((n14 & 4) != 0) {
                        n19 = 0;
                        while (n8 < n17) {
                            decLyrdCBlk.tsLengths[n18++] = cBlkInfo.segLen[n15] != null ? cBlkInfo.segLen[n15][n19] : cBlkInfo.len[n15];
                            ++n19;
                            ++n8;
                        }
                    } else {
                        n19 = 0;
                        while (n8 < n17) {
                            if (n8 >= 9 && (n7 = (n8 + 2) % 3) != 0) {
                                if (cBlkInfo.segLen[n15] != null) {
                                    int n20 = n18++;
                                    decLyrdCBlk.tsLengths[n20] = decLyrdCBlk.tsLengths[n20] + cBlkInfo.segLen[n15][n19++];
                                    int n21 = n15;
                                    cBlkInfo.len[n21] = cBlkInfo.len[n21] - cBlkInfo.segLen[n15][n19 - 1];
                                } else {
                                    int n22 = n18++;
                                    decLyrdCBlk.tsLengths[n22] = decLyrdCBlk.tsLengths[n22] + cBlkInfo.len[n15];
                                    cBlkInfo.len[n15] = 0;
                                }
                            }
                            ++n8;
                        }
                        if (cBlkInfo.segLen[n15] != null && n19 < cBlkInfo.segLen[n15].length) {
                            int n23 = n18;
                            decLyrdCBlk.tsLengths[n23] = decLyrdCBlk.tsLengths[n23] + cBlkInfo.segLen[n15][n19];
                            int n24 = n15;
                            cBlkInfo.len[n24] = cBlkInfo.len[n24] - cBlkInfo.segLen[n15][n19];
                        } else if (n18 < n9) {
                            int n25 = n18;
                            decLyrdCBlk.tsLengths[n25] = decLyrdCBlk.tsLengths[n25] + cBlkInfo.len[n15];
                            cBlkInfo.len[n15] = 0;
                        }
                    }
                }
            }
            ++n15;
        }
        if (n9 == 1 && decLyrdCBlk.tsLengths != null) {
            decLyrdCBlk.tsLengths[0] = decLyrdCBlk.dl;
        }
        if ((n6 = n4 + n5 - 1) < n13 - 1) {
            n15 = n6 + 1;
            while (n15 < n13) {
                if (cBlkInfo.len[n15] != 0) {
                    decLyrdCBlk.prog = true;
                }
                ++n15;
            }
        }
        return decLyrdCBlk;
    }

    private void initTile(int n) throws IOException {
        int n2;
        int n3;
        Object object;
        this.pktHL = new Vector();
        int n4 = (Integer)this.decSpec.nls.getTileDef(n);
        if (((Boolean)this.decSpec.pphs.getTileDef(n)).booleanValue()) {
            object = this.hd.getPackedPktHead(n);
            this.cbI = this.pktDec.restart(this.nc, this.mdl, n4, this.cbI, true, (ByteArrayInputStream)object);
        } else {
            this.cbI = this.pktDec.restart(this.nc, this.mdl, n4, this.cbI, false, null);
        }
        object = (int[][])this.decSpec.pcs.getTileDef(n);
        int n5 = object == null ? 0 : ((Object)object).length;
        int[][] nArray = new int[n5 + 1][6];
        int n6 = 0;
        nArray[0][0] = (Integer)this.decSpec.pos.getTileDef(n);
        nArray[0][1] = 0;
        n6 = 0;
        while (n6 < n5) {
            nArray[n6][1] = (int)object[n6][2];
            nArray[n6][2] = (int)object[n6][0];
            nArray[n6][3] = (int)object[n6][3];
            nArray[n6][4] = (int)object[n6][1];
            nArray[n6][5] = (int)object[n6][4];
            nArray[n6 + 1][0] = (int)object[n6][5];
            ++n6;
        }
        nArray[n6][1] = n4;
        nArray[n6][2] = 0;
        nArray[n6][3] = this.decSpec.dls.getMaxInTile(n) + 1;
        nArray[n6][4] = 0;
        nArray[n6][5] = this.nc;
        try {
            if (this.isTruncMode && this.firstPackOff == null || this.firstPackOff[n] == null) {
                return;
            }
            this.in.seek(this.firstPackOff[n][0]);
        }
        catch (EOFException eOFException) {
            FacilityManager.getMsgLogger().printmsg(2, "Codestream truncated in tile " + n);
            return;
        }
        this.curTilePart = 0;
        boolean bl = false;
        int n7 = this.nBytes[n];
        int[][] nArray2 = new int[this.nc][];
        int n8 = 0;
        while (n8 < this.nc) {
            nArray2[n8] = new int[(Integer)this.decSpec.dls.getTileCompVal(n, n8) + 1];
            ++n8;
        }
        int n9 = 0;
        while (n9 <= n5) {
            int n10 = nArray[n9][1];
            int n11 = nArray[n9][2];
            int n12 = nArray[n9][3];
            int n13 = nArray[n9][4];
            int n14 = nArray[n9][5];
            switch (nArray[n9][0]) {
                case 0: {
                    bl = this.readLyResCompPos(nArray2, n10, n11, n12, n13, n14, this.curTilePart);
                    break;
                }
                case 1: {
                    bl = this.readResLyCompPos(nArray2, n10, n11, n12, n13, n14, this.curTilePart);
                    break;
                }
                case 2: {
                    bl = this.readResPosCompLy(nArray2, n10, n11, n12, n13, n14, this.curTilePart);
                    break;
                }
                case 3: {
                    bl = this.readPosCompResLy(nArray2, n10, n11, n12, n13, n14, this.curTilePart);
                    break;
                }
                case 4: {
                    bl = this.readCompPosResLy(nArray2, n10, n11, n12, n13, n14, this.curTilePart);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Not recognized progression type");
                }
            }
            n3 = n13;
            while (n3 < n14) {
                if (n3 < nArray2.length) {
                    n2 = n11;
                    while (n2 < n12) {
                        if (n2 < nArray2[n3].length) {
                            nArray2[n3][n2] = n10;
                        }
                        ++n2;
                    }
                }
                ++n3;
            }
            if (!bl) {
                ++n9;
                continue;
            }
            break;
        }
        if (this.isTruncMode) {
            this.anbytes += n7 - this.nBytes[n];
            if (bl) {
                this.nBytes[n] = 0;
            }
        } else if (this.nBytes[n] < this.totTileLen[n] - this.totTileHeadLen[n]) {
            n2 = 0;
            int[] nArray3 = new int[this.pktHL.size()];
            int n15 = this.pktHL.size() - 1;
            while (n15 >= 0) {
                nArray3[n15] = (Integer)this.pktHL.elementAt(n15);
                --n15;
            }
            n3 = 0;
            int n16 = 0;
            while (n16 < n4) {
                if (this.cbI != null) {
                    int n17 = this.cbI.length;
                    int n18 = 0;
                    int n19 = 0;
                    while (n19 < n17) {
                        if (this.cbI[n19] != null && this.cbI[n19].length > n18) {
                            n18 = this.cbI[n19].length;
                        }
                        ++n19;
                    }
                    int n20 = 0;
                    while (n20 < n18) {
                        int n21 = 0;
                        int n22 = 0;
                        while (n22 < n17) {
                            if (this.cbI[n22] != null && this.cbI[n22][n20] != null && this.cbI[n22][n20].length > n21) {
                                n21 = this.cbI[n22][n20].length;
                            }
                            ++n22;
                        }
                        int n23 = 0;
                        while (n23 < n21) {
                            if (!(n20 == 0 && n23 != 0 || n20 != 0 && n23 == 0)) {
                                int n24 = 0;
                                int n25 = 0;
                                while (n25 < n17) {
                                    if (this.cbI[n25] != null && this.cbI[n25][n20] != null && this.cbI[n25][n20][n23] != null && this.cbI[n25][n20][n23].length > n24) {
                                        n24 = this.cbI[n25][n20][n23].length;
                                    }
                                    ++n25;
                                }
                                int n26 = 0;
                                while (n26 < n24) {
                                    int n27 = 0;
                                    int n28 = 0;
                                    while (n28 < n17) {
                                        if (this.cbI[n28] != null && this.cbI[n28][n20] != null && this.cbI[n28][n20][n23] != null && this.cbI[n28][n20][n23][n26] != null && this.cbI[n28][n20][n23][n26].length > n27) {
                                            n27 = this.cbI[n28][n20][n23][n26].length;
                                        }
                                        ++n28;
                                    }
                                    int n29 = 0;
                                    while (n29 < n27) {
                                        int n30 = 0;
                                        while (n30 < n17) {
                                            if (this.cbI[n30] != null && this.cbI[n30][n20] != null && this.cbI[n30][n20][n23] != null && this.cbI[n30][n20][n23][n26] != null && this.cbI[n30][n20][n23][n26][n29] != null) {
                                                CBlkInfo cBlkInfo = this.cbI[n30][n20][n23][n26][n29];
                                                if (n3 == 0) {
                                                    if (this.nBytes[n] < nArray3[cBlkInfo.pktIdx[n16]]) {
                                                        n2 = 1;
                                                        n3 = 1;
                                                    } else if (n2 == 0) {
                                                        int n31 = n;
                                                        this.nBytes[n31] = this.nBytes[n31] - nArray3[cBlkInfo.pktIdx[n16]];
                                                        this.anbytes += nArray3[cBlkInfo.pktIdx[n16]];
                                                        nArray3[cBlkInfo.pktIdx[n16]] = 0;
                                                    }
                                                }
                                                if (cBlkInfo.len[n16] != 0) {
                                                    if (cBlkInfo.len[n16] < this.nBytes[n] && n3 == 0) {
                                                        int n32 = n;
                                                        this.nBytes[n32] = this.nBytes[n32] - cBlkInfo.len[n16];
                                                        this.anbytes += cBlkInfo.len[n16];
                                                    } else {
                                                        cBlkInfo.ntp[n16] = 0;
                                                        cBlkInfo.off[n16] = 0;
                                                        cBlkInfo.len[n16] = 0;
                                                        n3 = 1;
                                                    }
                                                }
                                            }
                                            ++n30;
                                        }
                                        ++n29;
                                    }
                                    ++n26;
                                }
                            }
                            ++n23;
                        }
                        ++n20;
                    }
                }
                ++n16;
            }
        } else {
            this.anbytes += this.totTileLen[n] - this.totTileHeadLen[n];
            if (n < this.getNumTiles() - 1) {
                int n33 = n + 1;
                this.nBytes[n33] = this.nBytes[n33] + (this.nBytes[n] - (this.totTileLen[n] - this.totTileHeadLen[n]));
            }
        }
    }

    public void nextTile() {
        if (this.ctX == this.ntX - 1 && this.ctY == this.ntY - 1) {
            throw new NoNextElementException();
        }
        if (this.ctX < this.ntX - 1) {
            this.setTile(this.ctX + 1, this.ctY);
        } else {
            this.setTile(0, this.ctY + 1);
        }
    }

    private boolean readCompPosResLy(int[][] nArray, int n, int n2, int n3, int n4, int n5, int n6) throws IOException {
        boolean bl = false;
        int n7 = this.getTileIdx();
        boolean bl2 = false;
        int n8 = this.in.getPos() + this.tilePartLen[n7][n6] - 1 - this.tilePartHeadLen[n7][n6];
        String string = "Tile " + this.getTileIdx() + " (tile-part:" + n6 + "): offset, length, header length\n";
        if (((Boolean)this.decSpec.pphs.getTileDef(n7)).booleanValue()) {
            bl = true;
        }
        int[][][] nArray2 = new int[n5][n3][n];
        int n9 = n4;
        while (n9 < n5) {
            Coord[] coordArray = this.pktDec.getSotEotArrayMax(n9);
            int n10 = coordArray[0].x;
            int n11 = coordArray[0].y;
            int n12 = coordArray[1].x;
            int n13 = coordArray[1].y;
            Coord coord = this.pktDec.getIncArrayMax(n9);
            int n14 = coord.x;
            int n15 = coord.y;
            int n16 = n11;
            while (n16 < n13) {
                int n17 = n10;
                while (n17 < n12) {
                    int n18 = n2;
                    while (n18 < n3) {
                        if (n18 <= this.mdl[n9]) {
                            coord = this.pktDec.getIncArray(n9, n18);
                            int n19 = coord.x;
                            int n20 = coord.y;
                            coordArray = this.pktDec.getSotEotArray(n9, n18);
                            int n21 = coordArray[0].x;
                            int n22 = coordArray[0].y;
                            if (!(n17 != n10 && n17 % n19 != 0 || n16 != n11 && n16 % n20 != 0)) {
                                int n23 = nArray[n9][n18];
                                while (n23 < n) {
                                    int n24 = this.in.getPos();
                                    if (bl) {
                                        bl2 = this.pktDec.readPktHead(n23, n18, n9, nArray2[n9][n18][n23], this.cbI[n9][n18], this.nBytes);
                                    }
                                    if (n24 > n8 && n6 < this.firstPackOff[n7].length - 1) {
                                        this.in.seek(this.firstPackOff[n7][++n6]);
                                        n8 = this.in.getPos() + this.tilePartLen[n7][n6] - 1 - this.tilePartHeadLen[n7][n6];
                                    }
                                    if (bl2 = this.pktDec.readSOPMarker(this.nBytes, nArray2[n9][n18][n23], n9, n18)) {
                                        if (this.pl.getBooleanParameter("cdstr_info")) {
                                            FacilityManager.getMsgLogger().printmsg(1, string);
                                        }
                                        return true;
                                    }
                                    if (!bl) {
                                        bl2 = this.pktDec.readPktHead(n23, n18, n9, nArray2[n9][n18][n23], this.cbI[n9][n18], this.nBytes);
                                    }
                                    if (bl2) {
                                        if (this.pl.getBooleanParameter("cdstr_info")) {
                                            FacilityManager.getMsgLogger().printmsg(1, string);
                                        }
                                        return true;
                                    }
                                    int n25 = this.in.getPos() - n24;
                                    this.pktHL.addElement(new Integer(n25));
                                    bl2 = this.pktDec.readPktBody(n23, n18, n9, nArray2[n9][n18][n23], this.cbI[n9][n18], this.nBytes);
                                    int n26 = this.in.getPos() - n24;
                                    string = String.valueOf(string) + " Pkt l=" + n23 + ",r=" + n18 + ",c=" + n9 + ": " + n24 + ", " + n26 + ", " + n25 + "\n";
                                    if (bl2) {
                                        if (this.pl.getBooleanParameter("cdstr_info")) {
                                            FacilityManager.getMsgLogger().printmsg(1, string);
                                        }
                                        return true;
                                    }
                                    int[] nArray3 = nArray2[n9][n18];
                                    int n27 = n23++;
                                    nArray3[n27] = nArray3[n27] + 1;
                                }
                            }
                        }
                        ++n18;
                    }
                    n17 += n14;
                }
                n16 += n15;
            }
            ++n9;
        }
        if (this.pl.getBooleanParameter("cdstr_info")) {
            FacilityManager.getMsgLogger().printmsg(1, string);
        }
        return false;
    }

    private boolean readLyResCompPos(int[][] nArray, int n, int n2, int n3, int n4, int n5, int n6) throws IOException {
        int n7;
        boolean bl = false;
        int n8 = this.getTileIdx();
        boolean bl2 = false;
        int n9 = this.in.getPos() + this.tilePartLen[n8][n6] - 1 - this.tilePartHeadLen[n8][n6];
        int n10 = 10000;
        int n11 = n4;
        while (n11 < n5) {
            n7 = n2;
            while (n7 < n3) {
                if (nArray[n11] != null && n7 < nArray[n11].length && nArray[n11][n7] < n10) {
                    n10 = nArray[n11][n7];
                }
                ++n7;
            }
            ++n11;
        }
        String string = "Tile " + this.getTileIdx() + " (tile-part:" + n6 + "): offset, length, header length\n";
        if (((Boolean)this.decSpec.pphs.getTileDef(n8)).booleanValue()) {
            bl = true;
        }
        int n12 = n10;
        while (n12 < n) {
            int n13 = n2;
            while (n13 < n3) {
                int n14 = n4;
                while (n14 < n5) {
                    if (n13 <= this.mdl[n14] && n12 >= nArray[n14][n13]) {
                        int n15 = this.pktDec.getNumPrecinct(n14, n13);
                        int n16 = 0;
                        while (n16 < n15) {
                            int n17 = this.in.getPos();
                            if (bl) {
                                this.pktDec.readPktHead(n12, n13, n14, n16, this.cbI[n14][n13], this.nBytes);
                            }
                            if (n17 > n9 && n6 < this.firstPackOff[n8].length - 1) {
                                this.in.seek(this.firstPackOff[n8][++n6]);
                                n9 = this.in.getPos() + this.tilePartLen[n8][n6] - 1 - this.tilePartHeadLen[n8][n6];
                            }
                            if (bl2 = this.pktDec.readSOPMarker(this.nBytes, n16, n14, n13)) {
                                if (this.pl.getBooleanParameter("cdstr_info")) {
                                    FacilityManager.getMsgLogger().printmsg(1, string);
                                }
                                return true;
                            }
                            if (!bl) {
                                bl2 = this.pktDec.readPktHead(n12, n13, n14, n16, this.cbI[n14][n13], this.nBytes);
                            }
                            if (bl2) {
                                if (this.pl.getBooleanParameter("cdstr_info")) {
                                    FacilityManager.getMsgLogger().printmsg(1, string);
                                }
                                return true;
                            }
                            n7 = this.in.getPos() - n17;
                            this.pktHL.addElement(new Integer(n7));
                            bl2 = this.pktDec.readPktBody(n12, n13, n14, n16, this.cbI[n14][n13], this.nBytes);
                            int n18 = this.in.getPos() - n17;
                            string = String.valueOf(string) + " Pkt l=" + n12 + ",r=" + n13 + ",c=" + n14 + ": " + n17 + ", " + n18 + ", " + n7 + "\n";
                            if (bl2) {
                                if (this.pl.getBooleanParameter("cdstr_info")) {
                                    FacilityManager.getMsgLogger().printmsg(1, string);
                                }
                                return true;
                            }
                            ++n16;
                        }
                    }
                    ++n14;
                }
                ++n13;
            }
            ++n12;
        }
        if (this.pl.getBooleanParameter("cdstr_info")) {
            FacilityManager.getMsgLogger().printmsg(1, string);
        }
        return false;
    }

    private boolean readPosCompResLy(int[][] nArray, int n, int n2, int n3, int n4, int n5, int n6) throws IOException {
        boolean bl = false;
        int n7 = this.getTileIdx();
        boolean bl2 = false;
        int n8 = this.in.getPos() + this.tilePartLen[n7][n6] - 1 - this.tilePartHeadLen[n7][n6];
        String string = "Tile " + this.getTileIdx() + " (tile-part:" + n6 + "): offset, length, header length\n";
        if (((Boolean)this.decSpec.pphs.getTileDef(n7)).booleanValue()) {
            bl = true;
        }
        Coord[] coordArray = this.pktDec.getSotEotArrayMax(0);
        int n9 = coordArray[0].x;
        int n10 = coordArray[0].y;
        int n11 = coordArray[1].x;
        int n12 = coordArray[1].y;
        Coord coord = this.pktDec.getIncArrayMax(0);
        int n13 = coord.x;
        int n14 = coord.y;
        int[][][] nArray2 = new int[n5][n3][n];
        int n15 = n10;
        while (n15 < n12) {
            int n16 = n9;
            while (n16 < n11) {
                int n17 = n4;
                while (n17 < n5) {
                    int n18 = n2;
                    while (n18 < n3) {
                        if (n18 <= this.mdl[n17]) {
                            coord = this.pktDec.getIncArray(n17, n18);
                            int n19 = coord.x;
                            int n20 = coord.y;
                            coordArray = this.pktDec.getSotEotArray(n17, n18);
                            int n21 = coordArray[0].x;
                            int n22 = coordArray[0].y;
                            if (!(n16 != n9 && n16 % n19 != 0 || n15 != n10 && n15 % n20 != 0)) {
                                int n23 = nArray[n17][n18];
                                while (n23 < n) {
                                    int n24 = this.in.getPos();
                                    if (bl) {
                                        bl2 = this.pktDec.readPktHead(n23, n18, n17, nArray2[n17][n18][n23], this.cbI[n17][n18], this.nBytes);
                                    }
                                    if (n24 > n8 && n6 < this.firstPackOff[n7].length - 1) {
                                        this.in.seek(this.firstPackOff[n7][++n6]);
                                        n8 = this.in.getPos() + this.tilePartLen[n7][n6] - 1 - this.tilePartHeadLen[n7][n6];
                                    }
                                    if (bl2 = this.pktDec.readSOPMarker(this.nBytes, nArray2[n17][n18][n23], n17, n18)) {
                                        if (this.pl.getBooleanParameter("cdstr_info")) {
                                            FacilityManager.getMsgLogger().printmsg(1, string);
                                        }
                                        return true;
                                    }
                                    if (!bl) {
                                        bl2 = this.pktDec.readPktHead(n23, n18, n17, nArray2[n17][n18][n23], this.cbI[n17][n18], this.nBytes);
                                    }
                                    if (bl2) {
                                        if (this.pl.getBooleanParameter("cdstr_info")) {
                                            FacilityManager.getMsgLogger().printmsg(1, string);
                                        }
                                        return true;
                                    }
                                    int n25 = this.in.getPos() - n24;
                                    this.pktHL.addElement(new Integer(n25));
                                    bl2 = this.pktDec.readPktBody(n23, n18, n17, nArray2[n17][n18][n23], this.cbI[n17][n18], this.nBytes);
                                    int n26 = this.in.getPos() - n24;
                                    string = String.valueOf(string) + " Pkt l=" + n23 + ",r=" + n18 + ",c=" + n17 + ": " + n24 + ", " + n26 + ", " + n25 + "\n";
                                    if (bl2) {
                                        if (this.pl.getBooleanParameter("cdstr_info")) {
                                            FacilityManager.getMsgLogger().printmsg(1, string);
                                        }
                                        return true;
                                    }
                                    int[] nArray3 = nArray2[n17][n18];
                                    int n27 = n23++;
                                    nArray3[n27] = nArray3[n27] + 1;
                                }
                            }
                        }
                        ++n18;
                    }
                    ++n17;
                }
                n16 += n13;
            }
            n15 += n14;
        }
        if (this.pl.getBooleanParameter("cdstr_info")) {
            FacilityManager.getMsgLogger().printmsg(1, string);
        }
        return false;
    }

    private boolean readResLyCompPos(int[][] nArray, int n, int n2, int n3, int n4, int n5, int n6) throws IOException {
        boolean bl = false;
        int n7 = this.getTileIdx();
        boolean bl2 = false;
        int n8 = this.in.getPos() + this.tilePartLen[n7][n6] - 1 - this.tilePartHeadLen[n7][n6];
        String string = "Tile " + this.getTileIdx() + " (tile-part:" + n6 + "): offset, length, header length\n";
        if (((Boolean)this.decSpec.pphs.getTileDef(n7)).booleanValue()) {
            bl = true;
        }
        int n9 = n2;
        while (n9 < n3) {
            if (nArray != null) {
                int n10 = 100000;
                int n11 = n4;
                while (n11 < n5) {
                    if (nArray[n11] != null && n9 < nArray[n11].length && nArray[n11][n9] < n10) {
                        n10 = nArray[n11][n9];
                    }
                    ++n11;
                }
                int n12 = n10;
                while (n12 < n) {
                    int n13 = n4;
                    while (n13 < n5) {
                        if (n9 <= this.mdl[n13] && n12 >= nArray[n13][n9]) {
                            int n14 = this.pktDec.getNumPrecinct(n13, n9);
                            int n15 = 0;
                            while (n15 < n14) {
                                int n16 = this.in.getPos();
                                if (bl) {
                                    bl2 = this.pktDec.readPktHead(n12, n9, n13, n15, this.cbI[n13][n9], this.nBytes);
                                }
                                if (n16 > n8 && n6 < this.firstPackOff[n7].length - 1) {
                                    this.in.seek(this.firstPackOff[n7][++n6]);
                                    n8 = this.in.getPos() + this.tilePartLen[n7][n6] - 1 - this.tilePartHeadLen[n7][n6];
                                }
                                if (bl2 = this.pktDec.readSOPMarker(this.nBytes, n15, n13, n9)) {
                                    if (this.pl.getBooleanParameter("cdstr_info")) {
                                        FacilityManager.getMsgLogger().printmsg(1, string);
                                    }
                                    return true;
                                }
                                if (!bl) {
                                    bl2 = this.pktDec.readPktHead(n12, n9, n13, n15, this.cbI[n13][n9], this.nBytes);
                                }
                                if (bl2) {
                                    if (this.pl.getBooleanParameter("cdstr_info")) {
                                        FacilityManager.getMsgLogger().printmsg(1, string);
                                    }
                                    return true;
                                }
                                int n17 = this.in.getPos() - n16;
                                this.pktHL.addElement(new Integer(n17));
                                bl2 = this.pktDec.readPktBody(n12, n9, n13, n15, this.cbI[n13][n9], this.nBytes);
                                int n18 = this.in.getPos() - n16;
                                string = String.valueOf(string) + " Pkt l=" + n12 + ",r=" + n9 + ",c=" + n13 + ": " + n16 + ", " + n18 + ", " + n17 + "\n";
                                if (bl2) {
                                    if (this.pl.getBooleanParameter("cdstr_info")) {
                                        FacilityManager.getMsgLogger().printmsg(1, string);
                                    }
                                    return true;
                                }
                                ++n15;
                            }
                        }
                        ++n13;
                    }
                    ++n12;
                }
            }
            ++n9;
        }
        if (this.pl.getBooleanParameter("cdstr_info")) {
            FacilityManager.getMsgLogger().printmsg(1, string);
        }
        return false;
    }

    private boolean readResPosCompLy(int[][] nArray, int n, int n2, int n3, int n4, int n5, int n6) throws IOException {
        boolean bl = false;
        int n7 = this.getTileIdx();
        boolean bl2 = false;
        int n8 = this.in.getPos() + this.tilePartLen[n7][n6] - 1 - this.tilePartHeadLen[n7][n6];
        String string = "Tile " + this.getTileIdx() + " (tile-part:" + n6 + "): offset, length, header length\n";
        if (((Boolean)this.decSpec.pphs.getTileDef(n7)).booleanValue()) {
            bl = true;
        }
        Coord[] coordArray = this.pktDec.getSotEotArrayMax(0);
        int n9 = coordArray[0].x;
        int n10 = coordArray[0].y;
        int n11 = coordArray[1].x;
        int n12 = coordArray[1].y;
        Coord coord = this.pktDec.getIncArrayMax(0);
        int n13 = coord.x;
        int n14 = coord.y;
        int[][][] nArray2 = new int[n5][n3][n];
        int n15 = n2;
        while (n15 < n3) {
            int n16 = n10;
            while (n16 < n12) {
                int n17 = n9;
                while (n17 < n11) {
                    int n18 = n4;
                    while (n18 < n5) {
                        if (n15 <= this.mdl[n18]) {
                            coord = this.pktDec.getIncArray(n18, n15);
                            int n19 = coord.x;
                            int n20 = coord.y;
                            coordArray = this.pktDec.getSotEotArray(n18, n15);
                            int n21 = coordArray[0].x;
                            int n22 = coordArray[0].y;
                            if (!(n17 != n9 && n17 % n19 != 0 || n16 != n10 && n16 % n20 != 0)) {
                                int n23 = nArray[n18][n15];
                                while (n23 < n) {
                                    int n24 = this.in.getPos();
                                    if (bl) {
                                        bl2 = this.pktDec.readPktHead(n23, n15, n18, nArray2[n18][n15][n23], this.cbI[n18][n15], this.nBytes);
                                    }
                                    if (n24 > n8 && n6 < this.firstPackOff[n7].length - 1) {
                                        this.in.seek(this.firstPackOff[n7][++n6]);
                                        n8 = this.in.getPos() + this.tilePartLen[n7][n6] - 1 - this.tilePartHeadLen[n7][n6];
                                    }
                                    if (bl2 = this.pktDec.readSOPMarker(this.nBytes, nArray2[n18][n15][n23], n18, n15)) {
                                        if (this.pl.getBooleanParameter("cdstr_info")) {
                                            FacilityManager.getMsgLogger().printmsg(1, string);
                                        }
                                        return true;
                                    }
                                    if (!bl) {
                                        bl2 = this.pktDec.readPktHead(n23, n15, n18, nArray2[n18][n15][n23], this.cbI[n18][n15], this.nBytes);
                                    }
                                    if (bl2) {
                                        if (this.pl.getBooleanParameter("cdstr_info")) {
                                            FacilityManager.getMsgLogger().printmsg(1, string);
                                        }
                                        return true;
                                    }
                                    int n25 = this.in.getPos() - n24;
                                    this.pktHL.addElement(new Integer(n25));
                                    bl2 = this.pktDec.readPktBody(n23, n15, n18, nArray2[n18][n15][n23], this.cbI[n18][n15], this.nBytes);
                                    int n26 = this.in.getPos() - n24;
                                    string = String.valueOf(string) + " Pkt l=" + n23 + ",r=" + n15 + ",c=" + n18 + ": " + n24 + ", " + n26 + ", " + n25 + "\n";
                                    if (bl2) {
                                        if (this.pl.getBooleanParameter("cdstr_info")) {
                                            FacilityManager.getMsgLogger().printmsg(1, string);
                                        }
                                        return true;
                                    }
                                    int[] nArray3 = nArray2[n18][n15];
                                    int n27 = n23++;
                                    nArray3[n27] = nArray3[n27] + 1;
                                }
                            }
                        }
                        ++n18;
                    }
                    n17 += n13;
                }
                n16 += n14;
            }
            ++n15;
        }
        if (this.pl.getBooleanParameter("cdstr_info")) {
            FacilityManager.getMsgLogger().printmsg(1, string);
        }
        return false;
    }

    private int readTilePartHeader() throws IOException {
        if (this.in.readShort() != -112) {
            throw new CorruptedCodestreamException("SOT tag not found in tile-part start");
        }
        int n = this.in.readUnsignedShort();
        if (n != 10) {
            throw new CorruptedCodestreamException("Wrong length for SOT marker segment: " + n);
        }
        int n2 = this.in.readUnsignedShort();
        if (n2 > 65534) {
            throw new CorruptedCodestreamException("Tile index too high in tile-part.");
        }
        int n3 = this.in.readInt();
        if (n3 < 0) {
            throw new NotImplementedError("Tile length larger than maximum supported");
        }
        int n4 = this.in.read();
        if (n4 != this.tilePartsRead[n2] || n4 < 0 || n4 > 254) {
            throw new CorruptedCodestreamException("Out of order tile-part");
        }
        int n5 = this.in.read();
        if (n4 == 0) {
            this.remainingTileParts += n5 - 1;
            this.tileParts[n2] = n5;
            this.tilePartLen[n2] = new int[n5];
            this.tilePartNum[n2] = new int[n5];
            this.firstPackOff[n2] = new int[n5];
            this.tilePartHeadLen[n2] = new int[n5];
        }
        this.hd.resetHeaderMarkers();
        this.hd.nTileParts[n2] = n5;
        do {
            this.hd.extractTilePartMarkSeg(this.in.readShort(), this.in, n2);
        } while ((this.hd.markersFound & 0x2000) == 0);
        this.hd.readFoundTilePartMarkSeg(n2);
        this.tilePartLen[n2][n4] = n3;
        this.tilePartNum[n2][n4] = this.totTilePartsRead++;
        this.hd.setTileOfTileParts(n2);
        return n2;
    }

    public void setTile(int n, int n2) {
        if (n < 0 || n2 < 0 || n >= this.ntX || n2 >= this.ntY) {
            throw new IllegalArgumentException();
        }
        int n3 = n2 * this.ntX + n;
        this.ctX = n;
        this.ctY = n2;
        int n4 = n == 0 ? this.ax : this.px + n * this.ntW;
        int n5 = n2 == 0 ? this.ay : this.py + n2 * this.ntH;
        int n6 = this.nc - 1;
        while (n6 >= 0) {
            this.culx[n6] = (n4 + this.hd.getCompSubsX(n6) - 1) / this.hd.getCompSubsX(n6);
            this.culy[n6] = (n5 + this.hd.getCompSubsY(n6) - 1) / this.hd.getCompSubsY(n6);
            this.offX[n6] = (this.px + n * this.ntW + this.hd.getCompSubsX(n6) - 1) / this.hd.getCompSubsX(n6);
            this.offY[n6] = (this.py + n2 * this.ntH + this.hd.getCompSubsY(n6) - 1) / this.hd.getCompSubsY(n6);
            --n6;
        }
        this.subbTrees = new SubbandSyn[this.nc];
        this.mdl = new int[this.nc];
        this.derived = new boolean[this.nc];
        this.params = new StdDequantizerParams[this.nc];
        this.gb = new int[this.nc];
        int n7 = 0;
        while (n7 < this.nc) {
            this.derived[n7] = this.decSpec.qts.isDerived(n3, n7);
            this.params[n7] = (StdDequantizerParams)this.decSpec.qsss.getTileCompVal(n3, n7);
            this.gb[n7] = (Integer)this.decSpec.gbs.getTileCompVal(n3, n7);
            this.mdl[n7] = (Integer)this.decSpec.dls.getTileCompVal(n3, n7);
            this.subbTrees[n7] = new SubbandSyn(this.getCompWidth(n7, this.mdl[n7]), this.getCompHeight(n7, this.mdl[n7]), this.getULX(n7, this.mdl[n7]), this.getULY(n7, this.mdl[n7]), this.mdl[n7], this.decSpec.wfs.getHFilters(n3, n7), this.decSpec.wfs.getVFilters(n3, n7));
            this.initSubbandsFields(n7, this.subbTrees[n7]);
            ++n7;
        }
        try {
            this.initTile(n3);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new Error("IO Error when reading tile " + n + " x " + n2);
        }
    }
}

