/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.codestream.reader;

import java.io.IOException;
import jj2000.j2k.codestream.reader.FileBitstreamReaderAgent;
import jj2000.j2k.codestream.reader.HeaderDecoder;
import jj2000.j2k.decoder.DecoderSpecs;
import jj2000.j2k.entropy.decoder.CodedCBlkDataSrcDec;
import jj2000.j2k.entropy.decoder.DecLyrdCBlk;
import jj2000.j2k.image.Coord;
import jj2000.j2k.io.RandomAccessIO;
import jj2000.j2k.quantization.dequantizer.StdDequantizerParams;
import jj2000.j2k.util.MathUtil;
import jj2000.j2k.util.ParameterList;
import jj2000.j2k.wavelet.Subband;
import jj2000.j2k.wavelet.synthesis.SubbandSyn;

public abstract class BitstreamReaderAgent
implements CodedCBlkDataSrcDec {
    protected DecoderSpecs decSpec;
    protected boolean[] derived = null;
    protected int[] gb = null;
    protected StdDequantizerParams[] params = null;
    public static final char OPT_PREFIX = 'B';
    private static final String[][] pinfo = null;
    protected int[] mdl;
    protected final int nc;
    protected int res;
    protected SubbandSyn[] subbTrees;
    protected final int imgW;
    protected final int imgH;
    protected final int ax;
    protected final int ay;
    protected final int px;
    protected final int py;
    protected final int[] offX;
    protected final int[] offY;
    protected final int[] culx;
    protected final int[] culy;
    protected final int ntW;
    protected final int ntH;
    protected final int ntX;
    protected final int ntY;
    protected int ctX;
    protected int ctY;
    protected final HeaderDecoder hd;
    protected int tnbytes;
    protected int anbytes;
    protected float trate;
    protected float arate;

    protected BitstreamReaderAgent(HeaderDecoder headerDecoder, DecoderSpecs decoderSpecs) {
        this.decSpec = decoderSpecs;
        this.hd = headerDecoder;
        this.nc = headerDecoder.getNumComps();
        this.offX = new int[this.nc];
        this.offY = new int[this.nc];
        this.culx = new int[this.nc];
        this.culy = new int[this.nc];
        this.imgW = headerDecoder.getImgWidth();
        this.imgH = headerDecoder.getImgHeight();
        this.ax = headerDecoder.getImgULX();
        this.ay = headerDecoder.getImgULY();
        Coord coord = headerDecoder.getTilingOrigin(null);
        this.px = coord.x;
        this.py = coord.y;
        this.ntW = headerDecoder.getNomTileWidth();
        this.ntH = headerDecoder.getNomTileHeight();
        this.ntX = (this.ax + this.imgW - this.px + this.ntW - 1) / this.ntW;
        this.ntY = (this.ay + this.imgH - this.py + this.ntH - 1) / this.ntH;
    }

    public static BitstreamReaderAgent createInstance(RandomAccessIO randomAccessIO, HeaderDecoder headerDecoder, ParameterList parameterList, DecoderSpecs decoderSpecs) throws IOException {
        parameterList.checkList('B', ParameterList.toNameArray(BitstreamReaderAgent.getParameterInfo()));
        if (randomAccessIO.getPos() != headerDecoder.getTotalHeaderLength() + headerDecoder.initPos) {
            throw new IllegalArgumentException("Invalid header length");
        }
        return new FileBitstreamReaderAgent(headerDecoder, randomAccessIO, decoderSpecs, parameterList);
    }

    public int getActualNbytes() {
        return this.anbytes;
    }

    public float getActualRate() {
        this.arate = (float)this.anbytes * 8.0f / (float)this.hd.getImgWidth() / (float)this.hd.getImgHeight();
        return this.arate;
    }

    public abstract DecLyrdCBlk getCodeBlock(int var1, int var2, int var3, SubbandSyn var4, int var5, int var6, DecLyrdCBlk var7);

    public final int getCompHeight(int n, int n2) {
        int n3 = this.mdl[n] - n2;
        int n4 = this.ctY < this.ntY - 1 ? this.py + (this.ctY + 1) * this.ntH : this.ay + this.imgH;
        n4 = (n4 + this.hd.getCompSubsY(n) - 1) / this.hd.getCompSubsY(n);
        return (n4 + (1 << n3) - 1) / (1 << n3) - (this.culy[n] + (1 << n3) - 1) / (1 << n3);
    }

    public final int getCompImgHeight(int n, int n2) {
        int n3 = this.decSpec.dls.getMinInComp(n) - n2;
        int n4 = (this.ay + this.hd.getCompSubsY(n) - 1) / this.hd.getCompSubsY(n);
        int n5 = (this.ay + this.imgH + this.hd.getCompSubsY(n) - 1) / this.hd.getCompSubsY(n);
        return (n5 + (1 << n3) - 1) / (1 << n3) - (n4 + (1 << n3) - 1) / (1 << n3);
    }

    public final int getCompImgWidth(int n, int n2) {
        int n3 = this.decSpec.dls.getMinInComp(n) - n2;
        int n4 = (this.ax + this.hd.getCompSubsX(n) - 1) / this.hd.getCompSubsX(n);
        int n5 = (this.ax + this.imgW + this.hd.getCompSubsX(n) - 1) / this.hd.getCompSubsX(n);
        return (n5 + (1 << n3) - 1) / (1 << n3) - (n4 + (1 << n3) - 1) / (1 << n3);
    }

    public final int getCompSubsX(int n) {
        return this.hd.getCompSubsX(n);
    }

    public int getCompSubsY(int n) {
        return this.hd.getCompSubsY(n);
    }

    public final int getCompWidth(int n, int n2) {
        int n3 = this.mdl[n] - n2;
        int n4 = this.ctX < this.ntX - 1 ? this.px + (this.ctX + 1) * this.ntW : this.ax + this.imgW;
        n4 = (n4 + this.hd.getCompSubsX(n) - 1) / this.hd.getCompSubsX(n);
        return (n4 + (1 << n3) - 1) / (1 << n3) - (this.culx[n] + (1 << n3) - 1) / (1 << n3);
    }

    public int getHeight(int n) {
        int n2 = this.decSpec.dls.getMinInTile(this.getTileIdx());
        if (n > n2) {
            throw new IllegalArgumentException("Requested resolution level is not available for, at least, one component in tile: " + this.ctX + "x" + this.ctY);
        }
        int n3 = n2 - n;
        int n4 = this.ctY == 0 ? this.ay : this.py + this.ctY * this.ntH;
        int n5 = this.ctY < this.ntY - 1 ? this.py + (this.ctY + 1) * this.ntH : this.ay + this.imgH;
        return (n5 + (1 << n3) - 1) / (1 << n3) - (n4 + (1 << n3) - 1) / (1 << n3);
    }

    public int getImgHeight(int n) {
        int n2 = this.decSpec.dls.getMin();
        if (n > n2) {
            throw new IllegalArgumentException("Requested resolution level is not available for, at least, one tile-component");
        }
        int n3 = n2 - n;
        return (this.ay + this.imgH + (1 << n3) - 1) / (1 << n3) - (this.ay + (1 << n3) - 1) / (1 << n3);
    }

    public int getImgRes() {
        return this.res;
    }

    public int getImgULX(int n) {
        int n2 = this.decSpec.dls.getMin();
        if (n > n2) {
            throw new IllegalArgumentException("Requested resolution level is not available for, at least, one tile-component");
        }
        int n3 = n2 - n;
        return (this.ax + (1 << n3) - 1) / (1 << n3);
    }

    public int getImgULY(int n) {
        int n2 = this.decSpec.dls.getMin();
        if (n > n2) {
            throw new IllegalArgumentException("Requested resolution level is not available for, at least, one tile-component");
        }
        int n3 = n2 - n;
        return (this.ay + (1 << n3) - 1) / (1 << n3);
    }

    public int getImgWidth(int n) {
        int n2 = this.decSpec.dls.getMin();
        if (n > n2) {
            throw new IllegalArgumentException("Requested resolution level is not available for, at least, one tile-component");
        }
        int n3 = n2 - n;
        return (this.ax + this.imgW + (1 << n3) - 1) / (1 << n3) - (this.ax + (1 << n3) - 1) / (1 << n3);
    }

    public final Coord getNumCodeBlocks(SubbandSyn subbandSyn, int n, Coord coord) {
        int n2 = this.getPartitionULX();
        int n3 = this.getPartitionULY();
        if (coord == null) {
            coord = new Coord();
        }
        if (subbandSyn.w == 0 || subbandSyn.h == 0) {
            coord.x = 0;
            coord.y = 0;
        } else {
            int n4 = n2;
            int n5 = n3;
            block0 : switch (subbandSyn.gOrient) {
                case 1: {
                    n4 = 0;
                    Subband subband = subbandSyn;
                    do {
                        if (subband.orientation != 3 && subband.orientation != 2) continue;
                        n5 = 0;
                        break block0;
                    } while (subband.gOrient != 0 && (subband = ((Subband)subband).getParent()) != null);
                    break;
                }
                case 2: {
                    Subband subband = subbandSyn;
                    do {
                        if (subband.orientation != 3 && subband.orientation != 1) continue;
                        n4 = 0;
                        break;
                    } while (subband.gOrient != 0 && (subband = ((Subband)subband).getParent()) != null);
                    n5 = 0;
                    break;
                }
                case 3: {
                    n4 = 0;
                    n5 = 0;
                    break;
                }
                default: {
                    throw new Error("Internal JJ2000 error");
                }
                case 0: 
            }
            int n6 = subbandSyn.ulcx - n4 + subbandSyn.nomCBlkW;
            coord.x = (n6 + subbandSyn.w - 1) / subbandSyn.nomCBlkW - (n6 / subbandSyn.nomCBlkW - 1);
            n6 = subbandSyn.ulcy - n5 + subbandSyn.nomCBlkH;
            coord.y = (n6 + subbandSyn.h - 1) / subbandSyn.nomCBlkH - (n6 / subbandSyn.nomCBlkH - 1);
        }
        return coord;
    }

    public final int getNumComps() {
        return this.nc;
    }

    public final int getNumTiles() {
        return this.ntX * this.ntY;
    }

    public final Coord getNumTiles(Coord coord) {
        if (coord != null) {
            coord.x = this.ntX;
            coord.y = this.ntY;
            return coord;
        }
        return new Coord(this.ntX, this.ntY);
    }

    public final int getPPX(int n, int n2, int n3) {
        return this.decSpec.pss.getPPX(n, n2, n3);
    }

    public final int getPPY(int n, int n2, int n3) {
        return this.decSpec.pss.getPPY(n, n2, n3);
    }

    public static String[][] getParameterInfo() {
        return null;
    }

    public final int getPartitionULX() {
        return this.hd.getPartitionULX();
    }

    public int getPartitionULY() {
        return this.hd.getPartitionULY();
    }

    public final SubbandSyn getSubbandTree(int n, int n2) {
        if (n != this.getTileIdx()) {
            throw new IllegalArgumentException("Can not request subband tree of a different tile than the current one");
        }
        if (n2 < 0 || n2 >= this.nc) {
            throw new IllegalArgumentException("Component index out of range");
        }
        return this.subbTrees[n2];
    }

    public int getTargetNbytes() {
        return this.tnbytes;
    }

    public float getTargetRate() {
        return this.trate;
    }

    public final Coord getTile(Coord coord) {
        if (coord != null) {
            coord.x = this.ctX;
            coord.y = this.ctY;
            return coord;
        }
        return new Coord(this.ctX, this.ctY);
    }

    public final int getTileIdx() {
        return this.ctY * this.ntX + this.ctX;
    }

    public final Coord getTileOff(Coord coord, int n, int n2) {
        int n3 = this.mdl[n] - n2;
        if (n3 < 0) {
            throw new IllegalArgumentException("Requested resolution level is not available for, at least, one component in tile: " + this.ctX + "x" + this.ctY);
        }
        int n4 = (this.offX[n] + (1 << n3) - 1) / (1 << n3);
        int n5 = (this.offY[n] + (1 << n3) - 1) / (1 << n3);
        if (coord != null) {
            coord.x = n4;
            coord.y = n5;
            return coord;
        }
        return new Coord(n4, n5);
    }

    public final int getULX(int n, int n2) {
        int n3 = this.mdl[n] - n2;
        if (n3 < 0) {
            throw new IllegalArgumentException("Requested resolution level is not available for, at least, one component in tile: " + this.ctX + "x" + this.ctY);
        }
        return (this.culx[n] + (1 << n3) - 1) / (1 << n3);
    }

    public final int getULY(int n, int n2) {
        int n3 = this.mdl[n] - n2;
        if (n3 < 0) {
            throw new IllegalArgumentException("Requested resolution level is not available for, at least, one component in tile: " + this.ctX + "x" + this.ctY);
        }
        return (this.culy[n] + (1 << n3) - 1) / (1 << n3);
    }

    public int getWidth(int n) {
        int n2 = this.decSpec.dls.getMinInTile(this.getTileIdx());
        if (n > n2) {
            throw new IllegalArgumentException("Requested resolution level is not available for, at least, one component in tile: " + this.ctX + "x" + this.ctY);
        }
        int n3 = n2 - n;
        int n4 = this.ctX == 0 ? this.ax : this.px + this.ctX * this.ntW;
        int n5 = this.ctX < this.ntX - 1 ? this.px + (this.ctX + 1) * this.ntW : this.ax + this.imgW;
        return (n5 + (1 << n3) - 1) / (1 << n3) - (n4 + (1 << n3) - 1) / (1 << n3);
    }

    protected void initSubbandsFields(int n, SubbandSyn subbandSyn) {
        int n2 = this.getTileIdx();
        int n3 = subbandSyn.resLvl;
        int n4 = this.decSpec.cblks.getCBlkWidth((byte)3, n2, n);
        int n5 = this.decSpec.cblks.getCBlkHeight((byte)3, n2, n);
        if (!subbandSyn.isNode) {
            if (this.hd.precinctPartitionUsed()) {
                int n6 = MathUtil.log2(this.getPPX(n2, n, n3));
                int n7 = MathUtil.log2(this.getPPY(n2, n, n3));
                int n8 = MathUtil.log2(n4);
                int n9 = MathUtil.log2(n5);
                switch (subbandSyn.resLvl) {
                    case 0: {
                        subbandSyn.nomCBlkW = n8 < n6 ? 1 << n8 : 1 << n6;
                        subbandSyn.nomCBlkH = n9 < n7 ? 1 << n9 : 1 << n7;
                        break;
                    }
                    default: {
                        subbandSyn.nomCBlkW = n8 < n6 - 1 ? 1 << n8 : 1 << n6 - 1;
                        subbandSyn.nomCBlkH = n9 < n7 - 1 ? 1 << n9 : 1 << n7 - 1;
                        break;
                    }
                }
            } else {
                subbandSyn.nomCBlkW = n4;
                subbandSyn.nomCBlkH = n5;
            }
            subbandSyn.magbits = this.derived[n] ? this.gb[n] + (this.params[n].exp[0][0] - (this.mdl[n] - subbandSyn.level)) - 1 : this.gb[n] + this.params[n].exp[subbandSyn.resLvl][subbandSyn.sbandIdx] - 1;
        } else {
            this.initSubbandsFields(n, (SubbandSyn)subbandSyn.getLL());
            this.initSubbandsFields(n, (SubbandSyn)subbandSyn.getHL());
            this.initSubbandsFields(n, (SubbandSyn)subbandSyn.getLH());
            this.initSubbandsFields(n, (SubbandSyn)subbandSyn.getHH());
        }
    }

    public abstract void nextTile();

    public abstract void setTile(int var1, int var2);
}

