/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k;

import java.util.Hashtable;

public class ModuleSpec {
    public static final byte SPEC_TYPE_COMP = 0;
    public static final byte SPEC_TYPE_TILE = 1;
    public static final byte SPEC_TYPE_TILE_COMP = 2;
    public static final byte SPEC_DEF = 0;
    public static final byte SPEC_COMP_DEF = 1;
    public static final byte SPEC_TILE_DEF = 2;
    public static final byte SPEC_TILE_COMP = 3;
    protected int specType;
    protected int nTiles = 0;
    protected int nComp = 0;
    protected byte[][] specValType;
    protected Object def = null;
    protected Object[] compDef = null;
    protected Object[] tileDef = null;
    protected Hashtable tileCompVal;

    public ModuleSpec(int n, int n2, byte by) {
        this.nTiles = n;
        this.nComp = n2;
        this.specValType = new byte[n][n2];
        switch (by) {
            case 1: {
                this.specType = 1;
                break;
            }
            case 0: {
                this.specType = 0;
                break;
            }
            case 2: {
                this.specType = 2;
                break;
            }
        }
    }

    public Object getCompDef(int n) {
        if (this.specType == 1) {
            throw new Error("Illegal use of ModuleSpec class");
        }
        if (this.compDef == null || this.compDef[n] == null) {
            return this.getDefault();
        }
        return this.compDef[n];
    }

    public int getCompDefRep(int n) {
        int n2 = this.nTiles - 1;
        while (n2 >= 0) {
            if (this.specValType[n2][n] == 1) {
                return n2;
            }
            --n2;
        }
        throw new IllegalArgumentException("No representative for component default value, c=" + n);
    }

    public int[] getDefRep() {
        int[] nArray = new int[2];
        int n = this.nTiles - 1;
        while (n >= 0) {
            int n2 = this.nComp - 1;
            while (n2 >= 0) {
                if (this.specValType[n][n2] == 0) {
                    nArray[0] = n;
                    nArray[1] = n2;
                    return nArray;
                }
                --n2;
            }
            --n;
        }
        throw new IllegalArgumentException("No representative for default value");
    }

    public Object getDefault() {
        return this.def;
    }

    protected Object getSpec(int n, int n2) {
        switch (this.specValType[n][n2]) {
            case 0: {
                return this.getDefault();
            }
            case 1: {
                return this.getCompDef(n2);
            }
            case 2: {
                return this.getTileDef(n);
            }
            case 3: {
                return this.tileCompVal.get("t" + n + "c" + n2);
            }
        }
        throw new IllegalArgumentException("Not recognized spec type");
    }

    public byte getSpecValType(int n, int n2) {
        return this.specValType[n][n2];
    }

    public Object getTileCompVal(int n, int n2) {
        if (this.specType != 2) {
            throw new Error("Illegal use of ModuleSpec class");
        }
        return this.getSpec(n, n2);
    }

    public Object getTileDef(int n) {
        if (this.specType == 0) {
            throw new Error("Illegal use of ModuleSpec class");
        }
        if (this.tileDef == null || this.tileDef[n] == null) {
            return this.getDefault();
        }
        return this.tileDef[n];
    }

    public int getTileDefRep(int n) {
        int n2 = this.nComp - 1;
        while (n2 >= 0) {
            if (this.specValType[n][n2] == 2) {
                return n2;
            }
            --n2;
        }
        throw new IllegalArgumentException("No representative for tile default value");
    }

    public boolean isCompSpecified(int n) {
        return this.compDef != null && this.compDef[n] != null;
    }

    public boolean isTileCompSpecified(int n, int n2) {
        return this.tileCompVal != null && this.tileCompVal.get("t" + n + "c" + n2) != null;
    }

    public boolean isTileSpecified(int n) {
        return this.tileDef != null && this.tileDef[n] != null;
    }

    public static final boolean[] parseIdx(String string, int n) {
        int n2;
        int n3 = string.length();
        char c = string.charAt(0);
        int n4 = -1;
        int n5 = -1;
        boolean bl = false;
        boolean[] blArray = new boolean[n];
        int n6 = 1;
        while (n6 < n3) {
            c = string.charAt(n6);
            if (Character.isDigit(c)) {
                if (n4 == -1) {
                    n4 = 0;
                }
                n4 = n4 * 10 + (c - 48);
            } else {
                if (n4 == -1 || c != ',' && c != '-') {
                    throw new IllegalArgumentException("Bad construction for parameter: " + string);
                }
                if (n4 < 0 || n4 >= n) {
                    throw new IllegalArgumentException("Out of range index in parameter `" + string + "' : " + n4);
                }
                if (c == ',') {
                    if (bl) {
                        n2 = n5 + 1;
                        while (n2 < n4) {
                            blArray[n2] = true;
                            ++n2;
                        }
                    }
                    bl = false;
                } else {
                    bl = true;
                }
                blArray[n4] = true;
                n5 = n4;
                n4 = -1;
            }
            ++n6;
        }
        if (n4 < 0 || n4 >= n) {
            throw new IllegalArgumentException("Out of range index in parameter `" + string + "' : " + n4);
        }
        if (bl) {
            n2 = n5 + 1;
            while (n2 < n4) {
                blArray[n2] = true;
                ++n2;
            }
        }
        blArray[n4] = true;
        return blArray;
    }

    public void setCompDef(int n, Object object) {
        if (this.specType == 1) {
            String string = "Option whose value is '" + object + "' cannot be " + "specified for components as it is a 'tile only' specific " + "option";
            throw new Error(string);
        }
        if (this.compDef == null) {
            this.compDef = new Object[this.nComp];
        }
        int n2 = 0;
        while (n2 < this.nTiles) {
            if (this.specValType[n2][n] < 1) {
                this.specValType[n2][n] = 1;
            }
            ++n2;
        }
        this.compDef[n] = object;
    }

    public void setDefault(Object object) {
        this.def = object;
    }

    public void setTileCompVal(int n, int n2, Object object) {
        if (this.specType != 2) {
            String string = "Option whose value is '" + object + "' cannot be " + "specified for ";
            switch (this.specType) {
                case 1: {
                    string = String.valueOf(string) + "components as it is a 'tile only' specific option";
                    break;
                }
                case 0: {
                    string = String.valueOf(string) + "tiles as it is a 'component only' specific option";
                    break;
                }
            }
            throw new Error(string);
        }
        if (this.tileCompVal == null) {
            this.tileCompVal = new Hashtable();
        }
        this.specValType[n][n2] = 3;
        this.tileCompVal.put("t" + n + "c" + n2, object);
    }

    public void setTileDef(int n, Object object) {
        if (this.specType == 0) {
            String string = "Option whose value is '" + object + "' cannot be " + "specified for tiles as it is a 'component only' specific " + "option";
            throw new Error(string);
        }
        if (this.tileDef == null) {
            this.tileDef = new Object[this.nTiles];
        }
        int n2 = 0;
        while (n2 < this.nComp) {
            if (this.specValType[n][n2] < 2) {
                this.specValType[n][n2] = 2;
            }
            ++n2;
        }
        this.tileDef[n] = object;
    }
}

