/*
 * Decompiled with CFR 0.152.
 */
package jj2000.disp;

import java.awt.Adjustable;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.FocusListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class ImgScrollPane
extends Container {
    public static final int SCROLLBARS_ALWAYS = 1;
    public static final int SCROLLBARS_AS_NEEDED = 0;
    public static final int SCROLLBARS_NEVER = 2;
    public static final float MAX_ZOOM = 32.0f;
    static final int SCROLLBAR_THICKNESS = 16;
    static final int INTERNAL_GAP = 0;
    static final float BLOCK_INCREMENT_PROPORTION = 0.8f;
    ISPScrollbar hsbar;
    ISPScrollbar vsbar;
    private ImageScrollDisplay imgDisplay;
    private int sbType;
    private float zoom = 1.0f;
    private float lastZoom;
    private Dimension lastSize;
    private boolean copyScroll = true;

    public ImgScrollPane() {
        this(0);
    }

    public ImgScrollPane(int n) {
        super.setLayout(new BorderLayout(0, 0));
        this.sbType = n;
        this.hsbar = new ISPScrollbar(0, 0, 1, 0, 1);
        this.vsbar = new ISPScrollbar(1, 0, 1, 0, 1);
        this.imgDisplay = new ImageScrollDisplay();
        super.add((Component)this.hsbar, "South");
        super.add((Component)this.vsbar, "East");
        super.add((Component)this.imgDisplay, "Center");
        switch (n) {
            case 0: 
            case 2: {
                this.hsbar.setVisible(false);
                this.vsbar.setVisible(false);
                break;
            }
            case 1: {
                this.hsbar.setVisible(true);
                this.vsbar.setVisible(true);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    static /* synthetic */ Dimension access$0(ImgScrollPane imgScrollPane) {
        return imgScrollPane.lastSize;
    }

    static /* synthetic */ float access$2(ImgScrollPane imgScrollPane) {
        return imgScrollPane.lastZoom;
    }

    public Component add(Component component) {
        throw new IllegalArgumentException();
    }

    public Component add(Component component, int n) {
        throw new IllegalArgumentException();
    }

    public void add(Component component, Object object) {
        throw new IllegalArgumentException();
    }

    public void add(Component component, Object object, int n) {
        throw new IllegalArgumentException();
    }

    public Component add(String string, Component component) {
        throw new IllegalArgumentException();
    }

    public synchronized void addFocusListener(FocusListener focusListener) {
        super.addFocusListener(focusListener);
        this.imgDisplay.addFocusListener(focusListener);
        this.hsbar.addFocusListener(focusListener);
        this.vsbar.addFocusListener(focusListener);
    }

    public synchronized void addKeyListener(KeyListener keyListener) {
        super.addKeyListener(keyListener);
        this.imgDisplay.addKeyListener(keyListener);
        this.hsbar.addKeyListener(keyListener);
        this.vsbar.addKeyListener(keyListener);
    }

    public synchronized void addMouseListener(MouseListener mouseListener) {
        super.addMouseListener(mouseListener);
        this.imgDisplay.addMouseListener(mouseListener);
    }

    public synchronized void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        super.addMouseMotionListener(mouseMotionListener);
        this.imgDisplay.addMouseMotionListener(mouseMotionListener);
    }

    public synchronized void doLayout() {
        Cloneable cloneable;
        if (this.sbType == 0 && this.imgDisplay.calcDim()) {
            cloneable = this.getSize();
            Dimension dimension = this.imgDisplay.getPreferredSize();
            if (cloneable.width >= dimension.width) {
                if (cloneable.height >= dimension.height) {
                    this.hsbar.setVisible(false);
                    this.vsbar.setVisible(false);
                } else {
                    this.vsbar.setVisible(true);
                    if (cloneable.width >= dimension.width + 16) {
                        this.hsbar.setVisible(false);
                    } else {
                        this.hsbar.setVisible(true);
                    }
                }
            } else {
                this.hsbar.setVisible(true);
                if (cloneable.height >= dimension.height + 16) {
                    this.vsbar.setVisible(false);
                } else {
                    this.vsbar.setVisible(true);
                }
            }
        }
        this.imgDisplay.erase = true;
        super.doLayout();
        if (this.hsbar.isVisible() && this.vsbar.isVisible()) {
            cloneable = this.hsbar.getBounds();
            if (((Rectangle)cloneable).width > 16) {
                ((Rectangle)cloneable).width -= 16;
            }
            this.hsbar.setBounds((Rectangle)cloneable);
        }
        this.setScrollbars();
    }

    public synchronized boolean getCopyScroll() {
        return this.copyScroll;
    }

    public Adjustable getHAdjustable() {
        return this.hsbar;
    }

    public synchronized Image getImage() {
        return this.imgDisplay.img;
    }

    public Point getScrollPosition() {
        return new Point(this.hsbar.getValue(), this.vsbar.getValue());
    }

    public int getScrollbarDisplayPolicy() {
        return this.sbType;
    }

    public Adjustable getVAdjustable() {
        return this.vsbar;
    }

    public Dimension getViewportSize() {
        return this.imgDisplay.getSize();
    }

    public synchronized float getZoom() {
        return this.zoom;
    }

    public void remove(int n) {
        throw new IllegalArgumentException();
    }

    public void remove(Component component) {
        throw new IllegalArgumentException();
    }

    public void removeAll() {
        throw new IllegalArgumentException();
    }

    public synchronized void removeFocusListener(FocusListener focusListener) {
        super.removeFocusListener(focusListener);
        this.imgDisplay.removeFocusListener(focusListener);
        this.hsbar.removeFocusListener(focusListener);
        this.vsbar.removeFocusListener(focusListener);
    }

    public synchronized void removeKeyListener(KeyListener keyListener) {
        super.removeKeyListener(keyListener);
        this.imgDisplay.removeKeyListener(keyListener);
        this.hsbar.removeKeyListener(keyListener);
        this.vsbar.removeKeyListener(keyListener);
    }

    public synchronized void removeMouseListener(MouseListener mouseListener) {
        super.removeMouseListener(mouseListener);
        this.imgDisplay.removeMouseListener(mouseListener);
    }

    public synchronized void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        super.removeMouseMotionListener(mouseMotionListener);
        this.imgDisplay.removeMouseMotionListener(mouseMotionListener);
    }

    public synchronized void setBackground(Color color) {
        super.setBackground(color);
        this.imgDisplay.setBackground(color);
        this.hsbar.setBackground(color);
        this.vsbar.setBackground(color);
    }

    public synchronized void setCopyScroll(boolean bl) {
        this.copyScroll = bl;
    }

    public synchronized void setCursor(Cursor cursor) {
        super.setCursor(cursor);
        this.imgDisplay.setCursor(cursor);
    }

    public synchronized void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.imgDisplay.setEnabled(bl);
        this.hsbar.setEnabled(bl);
        this.vsbar.setEnabled(bl);
    }

    public synchronized void setForeground(Color color) {
        super.setForeground(color);
        this.imgDisplay.setForeground(color);
        this.hsbar.setForeground(color);
        this.vsbar.setForeground(color);
    }

    public void setImage(Image image) {
        this.imgDisplay.setImage(image);
    }

    public void setLayout(LayoutManager layoutManager) {
        throw new IllegalArgumentException();
    }

    public synchronized void setScrollPosition(int n, int n2) {
        this.hsbar.setValueI(n);
        this.vsbar.setValueI(n2);
        n = this.hsbar.getValue();
        n2 = this.vsbar.getValue();
        if (this.imgDisplay.lastUpdateOffset != null && this.imgDisplay.lastUpdateOffset.x == n && this.imgDisplay.lastUpdateOffset.y == n2) {
            return;
        }
        this.imgDisplay.repaint();
    }

    public synchronized void setScrollPosition(Point point) {
        this.setScrollPosition(point.x, point.y);
    }

    public void setScrollbarDisplayPolicy(int n) {
        if (n == this.sbType) {
            return;
        }
        switch (this.sbType) {
            case 0: 
            case 2: {
                this.hsbar.setVisible(false);
                this.vsbar.setVisible(false);
                break;
            }
            case 1: {
                this.hsbar.setVisible(true);
                this.vsbar.setVisible(true);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.doLayout();
    }

    private void setScrollbars() {
        if (!this.imgDisplay.calcDim()) {
            return;
        }
        Dimension dimension = this.imgDisplay.getSize();
        Dimension dimension2 = this.imgDisplay.getPreferredSize();
        if (this.lastZoom == 0.0f) {
            this.lastZoom = this.zoom;
        }
        if (this.lastSize == null) {
            this.lastSize = new Dimension(dimension.width, dimension.height);
        }
        int n = dimension.width < dimension2.width ? dimension.width : dimension2.width;
        int n2 = dimension.height < dimension2.height ? dimension.height : dimension2.height;
        int n3 = (int)(((float)this.hsbar.getValue() + (float)this.lastSize.width / 2.0f) / this.lastZoom * this.zoom - (float)n / 2.0f);
        if (n3 > dimension2.width - dimension.width) {
            n3 = dimension2.width - dimension.width;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (dimension.width <= 0) {
            dimension.width = 1;
        }
        if (dimension2.width <= 0) {
            dimension2.width = 1;
        }
        this.hsbar.setValues(n3, dimension.width, 0, dimension2.width);
        dimension.width = (int)((float)dimension.width * 0.8f);
        if (dimension.width <= 0) {
            dimension.width = 1;
        }
        this.hsbar.setBlockIncrementI(dimension.width);
        n3 = (int)(((float)this.vsbar.getValue() + (float)this.lastSize.height / 2.0f) / this.lastZoom * this.zoom - (float)n2 / 2.0f);
        if (n3 > dimension2.height - dimension.height) {
            n3 = dimension2.height - dimension.height;
        }
        if (n3 < 0) {
            n3 = 0;
        }
        if (dimension.height <= 0) {
            dimension.height = 1;
        }
        if (dimension2.height <= 0) {
            dimension2.height = 1;
        }
        this.vsbar.setValues(n3, dimension.height, 0, dimension2.height);
        dimension.height = (int)((float)dimension.height * 0.8f);
        if (dimension.height <= 0) {
            dimension.height = 1;
        }
        this.vsbar.setBlockIncrementI(dimension.height);
        this.lastZoom = this.zoom;
        this.lastSize.width = n;
        this.lastSize.height = n2;
    }

    public synchronized void setZoom(float f) {
        if (f == this.zoom || f > 32.0f && this.zoom == 32.0f) {
            return;
        }
        this.zoom = f;
        if (this.zoom > 32.0f) {
            this.zoom = 32.0f;
        }
        this.setScrollbars();
        if (this.sbType == 0) {
            this.doLayout();
        }
        this.imgDisplay.erase = true;
        this.imgDisplay.repaint();
    }

    public synchronized void zoom(float f) {
        this.setZoom(this.zoom * f);
    }

    private class ImageScrollDisplay
    extends Canvas {
        Image img;
        Dimension dim = new Dimension();
        boolean erase;
        Dimension imgDim = new Dimension();
        int dimFlags;
        Point lastUpdateOffset;

        ImageScrollDisplay() {
        }

        boolean calcDim() {
            if (this.dimFlags != 3) {
                return false;
            }
            if (ImgScrollPane.this.zoom == 1.0f) {
                this.dim.width = this.imgDim.width;
                this.dim.height = this.imgDim.height;
            } else {
                this.dim.width = (int)(ImgScrollPane.this.zoom * (float)this.imgDim.width);
                this.dim.height = (int)(ImgScrollPane.this.zoom * (float)this.imgDim.height);
            }
            return true;
        }

        public Dimension getMaximumSize() {
            return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }

        public Dimension getMinimumSize() {
            return new Dimension(0, 0);
        }

        public Dimension getPreferredSize() {
            return this.dim;
        }

        public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
            if (this.img != image) {
                return false;
            }
            if ((n & 3) != 0) {
                ImgScrollPane imgScrollPane = ImgScrollPane.this;
                synchronized (imgScrollPane) {
                    if ((n & 1) != 0) {
                        this.imgDim.width = n4;
                        this.dimFlags |= 1;
                    }
                    if ((n & 2) != 0) {
                        this.imgDim.height = n5;
                        this.dimFlags |= 2;
                    }
                    if (this.dimFlags == 3) {
                        ImgScrollPane.this.doLayout();
                    }
                }
            }
            return super.imageUpdate(image, n, n2, n3, n4, n5);
        }

        public void paint(Graphics graphics) {
            this.update(graphics);
        }

        void setImage(Image image) {
            ImgScrollPane imgScrollPane = ImgScrollPane.this;
            synchronized (imgScrollPane) {
                if (image == null) {
                    throw new IllegalArgumentException();
                }
                if (this.img == image) {
                    Object var3_3 = null;
                    return;
                }
                this.dimFlags = 0;
                this.img = image;
                ImgScrollPane.this.lastSize = null;
                ImgScrollPane.this.lastZoom = 0.0f;
                ImgScrollPane.this.setScrollbars();
                this.erase = true;
            }
            ImgScrollPane.this.prepareImage(image, this);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void update(Graphics graphics) {
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8;
            int n9;
            int n10;
            int n11;
            int n12;
            int n13;
            int n14;
            Rectangle rectangle;
            int n15;
            int n16;
            Rectangle rectangle2;
            int n17;
            boolean bl;
            boolean bl2;
            float f;
            Image image;
            ImgScrollPane imgScrollPane = ImgScrollPane.this;
            synchronized (imgScrollPane) {
                image = this.img;
                f = ImgScrollPane.this.zoom;
                bl2 = this.erase;
                bl = ImgScrollPane.this.copyScroll;
                this.erase = false;
                if (image == null) return;
                n17 = this.checkImage(image, null);
                if (n17 == 0) {
                    return;
                }
                rectangle2 = this.getBounds();
                n16 = rectangle2.width > this.dim.width ? (rectangle2.width - this.dim.width) / 2 : 0;
                n15 = rectangle2.height > this.dim.height ? (rectangle2.height - this.dim.height) / 2 : 0;
                rectangle = graphics.getClipBounds();
                if (this.lastUpdateOffset != null && (rectangle.width < rectangle2.width || rectangle.height < rectangle2.height)) {
                    n14 = this.lastUpdateOffset.x;
                    n13 = this.lastUpdateOffset.y;
                } else {
                    n14 = ImgScrollPane.this.hsbar.getValue();
                    n13 = ImgScrollPane.this.vsbar.getValue();
                }
                if (this.lastUpdateOffset == null) {
                    this.lastUpdateOffset = new Point();
                }
                n12 = this.lastUpdateOffset.x;
                n11 = this.lastUpdateOffset.y;
                this.lastUpdateOffset.x = n14;
                this.lastUpdateOffset.y = n13;
                if (f == 1.0f) {
                    n16 -= n14;
                    n15 -= n13;
                    n10 = 0;
                    n9 = 0;
                    n8 = 0;
                    n7 = 0;
                    n6 = 0;
                    n5 = 0;
                    n4 = 0;
                    n3 = 0;
                } else {
                    if (this.dimFlags != 3) {
                        return;
                    }
                    n10 = 0;
                    n9 = 0;
                    n7 = this.imgDim.width;
                    n8 = this.imgDim.height;
                    n6 = 0;
                    n5 = 0;
                    n3 = this.dim.width;
                    n4 = this.dim.height;
                    n2 = 0;
                    n = 0;
                    if (n3 > rectangle2.width) {
                        n3 = rectangle2.width + (f > 1.0f ? (int)Math.ceil(f) : 0);
                        if ((float)((int)f) == f) {
                            n3 = (int)(Math.ceil((float)n3 / f) * (double)f);
                        }
                        n9 = (int)((float)n14 / f);
                        n7 = n9 + (int)((float)n3 / f);
                        n = (int)((float)n9 * f - (float)n14);
                    }
                    if (n4 > rectangle2.height) {
                        n4 = rectangle2.height + (f > 1.0f ? (int)Math.ceil(f) : 0);
                        if ((float)((int)f) == f) {
                            n4 = (int)(Math.ceil((float)n4 / f) * (double)f);
                        }
                        n10 = (int)((float)n13 / f);
                        n8 = n10 + (int)((float)n4 / f);
                        n2 = (int)((float)n10 * f - (float)n13);
                    }
                    n5 += n16 + n;
                    n6 += n15 + n2;
                    n3 += n16 + n;
                    n4 += n15 + n2;
                }
            }
            if ((n17 & 0x20) == 0 && (n12 != n14 || n11 != n13)) {
                bl2 = true;
            }
            if (bl2) {
                graphics.setClip(0, 0, rectangle2.width, rectangle2.height);
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, rectangle2.width, rectangle2.height);
            }
            if (bl && !bl2 && (n12 != n14 || n11 != n13) && (n17 & 0x20) != 0) {
                int n18 = rectangle.x;
                int n19 = rectangle.y;
                n = rectangle.x + rectangle.width;
                n2 = rectangle.y + rectangle.height;
                int n20 = n12 - n14;
                int n21 = n11 - n13;
                int n22 = n20 + rectangle2.width;
                int n23 = n21 + rectangle2.height;
                if (n18 > n20) {
                    n20 = n18;
                }
                if (n19 > n21) {
                    n21 = n19;
                }
                if (n < n22) {
                    n22 = n;
                }
                if (n2 < n23) {
                    n23 = n2;
                }
                if (n20 < n22 && n21 < n23) {
                    graphics.copyArea(n20 + n14 - n12, n21 + n13 - n11, n22 - n20, n23 - n21, n12 - n14, n11 - n13);
                    if (n18 < n20) {
                        graphics.setClip(n18, n19, n20 - n18, n2 - n19);
                        if (f == 1.0f) {
                            graphics.drawImage(image, n16, n15, this);
                        } else {
                            graphics.drawImage(image, n5, n6, n3, n4, n9, n10, n7, n8, this);
                        }
                    }
                    if (n22 < n) {
                        graphics.setClip(n22, n19, n - n22, n2 - n19);
                        if (f == 1.0f) {
                            graphics.drawImage(image, n16, n15, this);
                        } else {
                            graphics.drawImage(image, n5, n6, n3, n4, n9, n10, n7, n8, this);
                        }
                    }
                    if (n19 < n21) {
                        graphics.setClip(n20, n19, n22 - n20, n21 - n19);
                        if (f == 1.0f) {
                            graphics.drawImage(image, n16, n15, this);
                        } else {
                            graphics.drawImage(image, n5, n6, n3, n4, n9, n10, n7, n8, this);
                        }
                    }
                    if (n23 >= n2) return;
                    graphics.setClip(n20, n23, n22 - n20, n2 - n23);
                    if (f == 1.0f) {
                        graphics.drawImage(image, n16, n15, this);
                        return;
                    }
                    graphics.drawImage(image, n5, n6, n3, n4, n9, n10, n7, n8, this);
                    return;
                }
                if (f == 1.0f) {
                    graphics.drawImage(image, n16, n15, this);
                    return;
                }
                graphics.drawImage(image, n5, n6, n3, n4, n9, n10, n7, n8, this);
                return;
            }
            if (f == 1.0f) {
                graphics.drawImage(image, n16, n15, this);
                return;
            }
            graphics.drawImage(image, n5, n6, n3, n4, n9, n10, n7, n8, this);
        }
    }

    class ISPScrollbar
    extends Scrollbar {
        ISPScrollbar(int n, int n2, int n3, int n4, int n5) {
            super(n, n2, n3, n4, n5);
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            if (this.getOrientation() == 0) {
                dimension.height = 16;
            } else {
                dimension.width = 16;
            }
            return dimension;
        }

        public void setBlockIncrement(int n) {
            throw new IllegalArgumentException();
        }

        void setBlockIncrementI(int n) {
            super.setBlockIncrement(n);
        }

        public void setMaximum(int n) {
            throw new IllegalArgumentException();
        }

        public void setMinimum(int n) {
            throw new IllegalArgumentException();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void setValue(int n) {
            ImgScrollPane imgScrollPane = ImgScrollPane.this;
            synchronized (imgScrollPane) {
                super.setValue(n);
                n = this.getValue();
                if (((ImgScrollPane)ImgScrollPane.this).imgDisplay.lastUpdateOffset != null && (this.getOrientation() == 0 ? ((ImgScrollPane)ImgScrollPane.this).imgDisplay.lastUpdateOffset.x == n : ((ImgScrollPane)ImgScrollPane.this).imgDisplay.lastUpdateOffset.y == n)) {
                    return;
                }
            }
            ImgScrollPane.this.imgDisplay.repaint();
        }

        void setValueI(int n) {
            super.setValue(n);
        }

        public void setVisibleAmount(int n) {
            throw new IllegalArgumentException();
        }
    }
}

