/*
 * Decompiled with CFR 0.152.
 */
package jj2000.disp;

import java.awt.Adjustable;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.TextArea;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import jj2000.disp.ImgScrollPane;
import jj2000.j2k.decoder.Decoder;

public class ImgKeyListener
extends KeyAdapter {
    Frame helpFrame = null;
    ImgScrollPane isp;
    Decoder dec;
    public static final int ACCEL_FACTOR = 10;

    public ImgKeyListener(ImgScrollPane imgScrollPane, Decoder decoder) {
        this.isp = imgScrollPane;
        this.dec = decoder;
    }

    private int calcIncrement(KeyEvent keyEvent, Adjustable adjustable) {
        int n = keyEvent.isControlDown() ? adjustable.getBlockIncrement() : adjustable.getUnitIncrement();
        if (keyEvent.isShiftDown()) {
            n *= 10;
        }
        return n;
    }

    private static TextArea getHelp() {
        TextArea textArea = new TextArea("", 17, 61, 3);
        textArea.setEditable(false);
        textArea.setFont(new Font("Monospaced", 0, 10));
        textArea.append("The following key sequences are recognized in the \nimage display window:\n\n");
        textArea.append("'-'           : zoom out by a factor of 2.\n");
        textArea.append("'+' or '='    : zoom in by a factor of 2.\n");
        textArea.append("'1'           : set the zoom factor to 1 (i.e. no zoom).\n");
        textArea.append("<up arrow>    : scroll the image up by one pixel.\n");
        textArea.append("<down arrow>  : scroll the image down by one pixel.\n");
        textArea.append("<left arrow>  : scroll the image left by one pixel.\n");
        textArea.append("<right arrow> : scroll the image right by one pixel.\n");
        textArea.append("<page up>     : scroll the image up by a whole page.\n");
        textArea.append("<page down>   : scroll the image down by a whole page.\n");
        textArea.append("Ctrl+<arrow>  : scroll in the direction of the arrow a \n                page at a time instead of a pixel at a time.\n");
        textArea.append("Shift+<arrow> : accelerate the scroll speed by 10.\n");
        textArea.append("'Q' or 'q'    : exit the application.\n");
        textArea.append("'Ctrl-C'      : exit the application.\n");
        return textArea;
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.isConsumed()) {
            return;
        }
        switch (keyEvent.getKeyCode()) {
            case 37: {
                Adjustable adjustable = this.isp.getHAdjustable();
                adjustable.setValue(adjustable.getValue() - this.calcIncrement(keyEvent, adjustable));
                break;
            }
            case 39: {
                Adjustable adjustable = this.isp.getHAdjustable();
                adjustable.setValue(adjustable.getValue() + this.calcIncrement(keyEvent, adjustable));
                break;
            }
            case 38: {
                Adjustable adjustable = this.isp.getVAdjustable();
                adjustable.setValue(adjustable.getValue() - this.calcIncrement(keyEvent, adjustable));
                break;
            }
            case 40: {
                Adjustable adjustable = this.isp.getVAdjustable();
                adjustable.setValue(adjustable.getValue() + this.calcIncrement(keyEvent, adjustable));
                break;
            }
            case 33: {
                Adjustable adjustable = this.isp.getVAdjustable();
                adjustable.setValue(adjustable.getValue() - adjustable.getBlockIncrement());
                break;
            }
            case 34: {
                Adjustable adjustable = this.isp.getVAdjustable();
                adjustable.setValue(adjustable.getValue() + adjustable.getBlockIncrement());
                break;
            }
            case 67: {
                if (!keyEvent.isControlDown()) break;
                this.dec.exit();
                break;
            }
            default: {
                return;
            }
        }
        keyEvent.consume();
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.isConsumed()) {
            return;
        }
        switch (keyEvent.getKeyChar()) {
            case '+': 
            case '=': {
                this.isp.zoom(2.0f);
                break;
            }
            case '-': {
                this.isp.zoom(0.5f);
                break;
            }
            case '1': {
                this.isp.setZoom(1.0f);
                break;
            }
            case 'Q': 
            case 'q': {
                this.dec.exit();
                break;
            }
            case 'H': 
            case 'h': {
                if (this.helpFrame == null) {
                    this.helpFrame = new Frame("Tools");
                    this.helpFrame.add(ImgKeyListener.getHelp());
                    this.helpFrame.pack();
                    this.helpFrame.setResizable(false);
                    this.helpFrame.addWindowListener(new WindowAdapter(){

                        public void windowClosing(WindowEvent windowEvent) {
                            ((Component)ImgKeyListener.this.helpFrame).setVisible(false);
                        }
                    });
                }
                if (this.helpFrame.isVisible()) {
                    ((Component)this.helpFrame).setVisible(false);
                    break;
                }
                ((Component)this.helpFrame).setVisible(true);
                break;
            }
            default: {
                return;
            }
        }
        keyEvent.consume();
    }
}

