/*
 * Decompiled with CFR 0.152.
 */
package jj2000.disp;

import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Vector;
import jj2000.j2k.image.BlkImgDataSrc;
import jj2000.j2k.image.Coord;
import jj2000.j2k.image.DataBlkInt;

public class BlkImgDataSrcImageProducer
implements ImageProducer {
    private volatile Vector consumers;
    private BlkImgDataSrc src;
    private int type;
    private static final int GRAY = 0;
    private static final int RGB = 1;
    private static final int RGBA = 2;
    private static final ColorModel cm = ColorModel.getRGBdefault();

    public BlkImgDataSrcImageProducer(BlkImgDataSrc blkImgDataSrc) {
        switch (blkImgDataSrc.getNumComps()) {
            case 1: {
                this.type = 0;
                break;
            }
            case 3: {
                this.type = 1;
                break;
            }
            case 4: {
                this.type = 2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Only 1, 3, and 4 components supported");
            }
        }
        int n = blkImgDataSrc.getNumComps() - 1;
        while (n >= 0) {
            if (blkImgDataSrc.getCompImgHeight(n) != blkImgDataSrc.getImgHeight() || blkImgDataSrc.getCompImgWidth(n) != blkImgDataSrc.getImgWidth()) {
                throw new IllegalArgumentException("All components must have the same dimensions and nosubsampling");
            }
            if (blkImgDataSrc.getNomRangeBits(n) > 8) {
                throw new IllegalArgumentException("Depths greater than 8 bits per component is not supported");
            }
            --n;
        }
        this.src = blkImgDataSrc;
        this.consumers = new Vector();
    }

    public final synchronized void addConsumer(ImageConsumer imageConsumer) {
        if (imageConsumer != null && !this.consumers.contains(imageConsumer)) {
            this.consumers.addElement(imageConsumer);
        }
    }

    public static Image createImage(BlkImgDataSrc blkImgDataSrc) {
        return Toolkit.getDefaultToolkit().createImage(new BlkImgDataSrcImageProducer(blkImgDataSrc));
    }

    public static Image createImage(BlkImgDataSrc blkImgDataSrc, Component component) {
        return component.getToolkit().createImage(new BlkImgDataSrcImageProducer(blkImgDataSrc));
    }

    public boolean isConsumer(ImageConsumer imageConsumer) {
        return this.consumers.contains(imageConsumer);
    }

    public synchronized void removeConsumer(ImageConsumer imageConsumer) {
        this.consumers.removeElement(imageConsumer);
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
    }

    public void startProduction(ImageConsumer imageConsumer) {
        int n;
        int n2;
        int n3;
        Object[] objectArray;
        Coord coord = this.src.getNumTiles(null);
        int n4 = 0;
        if (imageConsumer != null) {
            this.addConsumer(imageConsumer);
        }
        BlkImgDataSrcImageProducer blkImgDataSrcImageProducer = this;
        synchronized (blkImgDataSrcImageProducer) {
            objectArray = new ImageConsumer[this.consumers.size()];
            this.consumers.copyInto(objectArray);
        }
        if (this.src == null) {
            int n5 = objectArray.length - 1;
            while (n5 >= 0) {
                objectArray[n5].imageComplete(1);
                --n5;
            }
            return;
        }
        int[] nArray = null;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        DataBlkInt dataBlkInt = null;
        DataBlkInt dataBlkInt2 = null;
        DataBlkInt dataBlkInt3 = null;
        DataBlkInt dataBlkInt4 = null;
        switch (this.type) {
            case 2: {
                dataBlkInt = new DataBlkInt();
                n14 = 1 << this.src.getNomRangeBits(3) - 1;
                n12 = (1 << this.src.getNomRangeBits(3)) - 1;
                n13 = this.src.getFixedPoint(3);
            }
            case 1: {
                dataBlkInt2 = new DataBlkInt();
                n11 = 1 << this.src.getNomRangeBits(2) - 1;
                n9 = (1 << this.src.getNomRangeBits(2)) - 1;
                n10 = this.src.getFixedPoint(2);
                dataBlkInt3 = new DataBlkInt();
                n8 = 1 << this.src.getNomRangeBits(1) - 1;
                n6 = (1 << this.src.getNomRangeBits(1)) - 1;
                n7 = this.src.getFixedPoint(1);
            }
            case 0: {
                dataBlkInt4 = new DataBlkInt();
                n3 = 1 << this.src.getNomRangeBits(0) - 1;
                n2 = (1 << this.src.getNomRangeBits(0)) - 1;
                n = this.src.getFixedPoint(0);
                break;
            }
            default: {
                throw new Error("Internal JJ2000 error");
            }
        }
        coord = this.src.getNumTiles(null);
        int n15 = 24;
        n15 = coord.x == 1 ? (n15 |= 6) : (n15 |= 1);
        int n16 = objectArray.length - 1;
        while (n16 >= 0) {
            objectArray[n16].setColorModel(cm);
            objectArray[n16].setDimensions(this.src.getImgWidth(), this.src.getImgHeight());
            objectArray[n16].setHints(n15);
            --n16;
        }
        int n17 = 0;
        while (n17 < coord.y) {
            int n18 = 0;
            while (n18 < coord.x) {
                this.src.setTile(n18, n17);
                int n19 = this.src.getHeight();
                int n20 = this.src.getWidth();
                if (nArray == null || nArray.length < n20) {
                    nArray = new int[n20];
                }
                int n21 = this.src.getULX(0) - (this.src.getImgULX() + this.src.getCompSubsX(0) - 1) / this.src.getCompSubsX(0);
                int n22 = this.src.getULY(0) - (this.src.getImgULY() + this.src.getCompSubsY(0) - 1) / this.src.getCompSubsY(0);
                int n23 = 0;
                while (n23 < n19) {
                    boolean bl = false;
                    switch (this.type) {
                        case 2: {
                            dataBlkInt.ulx = 0;
                            dataBlkInt.uly = n23;
                            dataBlkInt.w = n20;
                            dataBlkInt.h = 1;
                            this.src.getInternCompData(dataBlkInt, 3);
                            bl = bl || dataBlkInt.progressive;
                        }
                        case 1: {
                            dataBlkInt2.ulx = 0;
                            dataBlkInt3.ulx = 0;
                            dataBlkInt3.uly = dataBlkInt2.uly = n23;
                            dataBlkInt3.w = dataBlkInt2.w = n20;
                            dataBlkInt2.h = 1;
                            dataBlkInt3.h = 1;
                            this.src.getInternCompData(dataBlkInt2, 2);
                            bl = bl || dataBlkInt2.progressive;
                            this.src.getInternCompData(dataBlkInt3, 1);
                            bl = bl || dataBlkInt3.progressive;
                        }
                        case 0: {
                            dataBlkInt4.ulx = 0;
                            dataBlkInt4.uly = n23;
                            dataBlkInt4.w = n20;
                            dataBlkInt4.h = 1;
                            this.src.getInternCompData(dataBlkInt4, 0);
                            bl = bl || dataBlkInt4.progressive;
                            break;
                        }
                    }
                    if (bl) {
                        n16 = objectArray.length - 1;
                        while (n16 >= 0) {
                            objectArray[n16].imageComplete(4);
                            --n16;
                        }
                        return;
                    }
                    switch (this.type) {
                        case 0: {
                            int n24;
                            int[] nArray2 = dataBlkInt4.data;
                            int n25 = dataBlkInt4.offset + n20 - 1;
                            n16 = n20 - 1;
                            while (n16 >= 0) {
                                n24 = (n24 = (nArray2[n25--] >> n) + n3) < 0 ? 0 : (n24 > n2 ? n2 : n24);
                                nArray[n16] = 0xFF000000 | n24 << 16 | n24 << 8 | n24;
                                --n16;
                            }
                            break;
                        }
                        case 1: {
                            int n26;
                            int n27;
                            int n24;
                            int[] nArray2 = dataBlkInt4.data;
                            int[] nArray3 = dataBlkInt3.data;
                            int[] nArray4 = dataBlkInt2.data;
                            int n25 = dataBlkInt4.offset + n20 - 1;
                            int n28 = dataBlkInt3.offset + n20 - 1;
                            int n29 = dataBlkInt2.offset + n20 - 1;
                            n16 = n20 - 1;
                            while (n16 >= 0) {
                                n24 = (n24 = (nArray2[n25--] >> n) + n3) < 0 ? 0 : (n24 > n2 ? n2 : n24);
                                n27 = (nArray3[n28--] >> n7) + n8;
                                n27 = n27 < 0 ? 0 : (n27 > n6 ? n6 : n27);
                                n26 = (nArray4[n29--] >> n10) + n11;
                                n26 = n26 < 0 ? 0 : (n26 > n9 ? n9 : n26);
                                nArray[n16] = 0xFF000000 | n24 << 16 | n27 << 8 | n26;
                                --n16;
                            }
                            break;
                        }
                        case 2: {
                            int n26;
                            int n27;
                            int n24;
                            int[] nArray2 = dataBlkInt4.data;
                            int[] nArray3 = dataBlkInt3.data;
                            int[] nArray4 = dataBlkInt2.data;
                            int[] nArray5 = dataBlkInt.data;
                            int n25 = dataBlkInt4.offset + n20 - 1;
                            int n28 = dataBlkInt3.offset + n20 - 1;
                            int n29 = dataBlkInt2.offset + n20 - 1;
                            int n30 = dataBlkInt.offset + n20 - 1;
                            n16 = n20 - 1;
                            while (n16 >= 0) {
                                n24 = (n24 = (nArray2[n25--] >> n) + n3) < 0 ? 0 : (n24 > n2 ? n2 : n24);
                                n27 = (nArray3[n28--] >> n7) + n8;
                                n27 = n27 < 0 ? 0 : (n27 > n6 ? n6 : n27);
                                n26 = (nArray4[n29--] >> n10) + n11;
                                n26 = n26 < 0 ? 0 : (n26 > n9 ? n9 : n26);
                                int n31 = (nArray5[n30--] >> n13) + n14;
                                n31 = n31 < 0 ? 0 : (n31 > n12 ? n12 : n31);
                                nArray[n16] = n31 << 24 | n24 << 16 | n27 << 8 | n26;
                                --n16;
                            }
                            break;
                        }
                    }
                    n16 = objectArray.length - 1;
                    while (n16 >= 0) {
                        objectArray[n16].setPixels(n21, n22 + n23, n20, 1, cm, nArray, 0, n20);
                        --n16;
                    }
                    ++n23;
                }
                ++n18;
                ++n4;
            }
            ++n17;
        }
        n16 = objectArray.length - 1;
        while (n16 >= 0) {
            objectArray[n16].imageComplete(2);
            --n16;
        }
        n16 = objectArray.length - 1;
        while (n16 >= 0) {
            objectArray[n16].imageComplete(3);
            --n16;
        }
        BlkImgDataSrcImageProducer blkImgDataSrcImageProducer2 = this;
        synchronized (blkImgDataSrcImageProducer2) {
            n16 = objectArray.length - 1;
            while (n16 >= 0) {
                this.consumers.removeElement(objectArray[n16]);
                --n16;
            }
        }
    }
}

