/*
 * Decompiled with CFR 0.152.
 */
package org.alov.viewer;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import org.alov.map.CarteHost;
import org.alov.map.CarteHostListener;
import org.alov.map.MapUtils;
import org.alov.util.Strings;
import org.alov.util.XmlElement;
import org.alov.util.XmlUtils;

public class LinkLabel
extends Component
implements CarteHostListener,
MouseListener {
    private static int _num = 0;
    private String linkmask = null;
    private String target = "";
    private CarteHost host = null;
    private boolean isTransparent = true;
    private boolean isCaptionAsURL = false;
    private String text = "";
    private float m_nHAlign = 0.0f;
    private float m_nVAlign = 0.5f;
    private int baseline;
    private FontMetrics fm;
    static final String TRANSPARENT = "transparent";

    public LinkLabel() {
        this("");
    }

    public LinkLabel(String text) {
        this.text = text;
        this.setName("linklabel" + _num);
        ++_num;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        if (this.isCaptionAsURL) {
            this.linkmask = text;
        }
        this.text = text;
    }

    public void paint(Graphics g) {
        if (g == null || this.text == null) {
            return;
        }
        int currentY = 0;
        this.fm = this.getFontMetrics(this.getFont());
        this.baseline = this.fm.getMaxAscent();
        Dimension d = this.getSize();
        if (!this.isTransparent) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, d.width, d.height);
        }
        Vector lines = MapUtils.wrapString(g, this.text, d.width);
        if (this.m_nVAlign == 0.5f) {
            int center = d.height / 2;
            currentY = center - lines.size() * this.fm.getHeight() / 2;
        } else if (this.m_nVAlign == 1.0f) {
            currentY = d.height - lines.size() * this.fm.getHeight();
        }
        g.setColor(this.getForeground());
        int count = lines.size();
        for (int i = 0; i < count; ++i) {
            String line = (String)lines.elementAt(i);
            this.drawAlignedString(g, line, 0, currentY, d.width);
            currentY += this.fm.getHeight();
            line = null;
        }
        lines.removeAllElements();
        this.fm = null;
    }

    protected void drawAlignedString(Graphics g, String s, int x, int y, int width) {
        int drawx = x;
        int drawy = y + this.baseline;
        int sw = this.fm.stringWidth(s);
        if (this.m_nHAlign != 0.0f) {
            if (this.m_nHAlign == 0.5f) {
                drawx += (width - sw) / 2;
            } else if (this.m_nHAlign == 1.0f) {
                drawx = drawx + width - sw;
            }
        }
        g.drawString(s, drawx, drawy);
        if (!Strings.isNullOrBlank(this.linkmask)) {
            g.drawLine(drawx, drawy + 1, sw, drawy + 1);
        }
    }

    public void setParameters(CarteHost host, XmlElement layout) {
        this.linkmask = XmlUtils.getString("linkmask", layout, null);
        this.target = XmlUtils.getString("target", layout, "");
        this.isTransparent = XmlUtils.getBoolean(TRANSPARENT, layout, true);
        this.isCaptionAsURL = XmlUtils.getBoolean("direct", layout, false);
        this.setText(XmlUtils.getString("caption", layout, ""));
        this.host = host;
        if (!Strings.isNullOrBlank(this.linkmask)) {
            this.linkmask = MapUtils.parameterArgument(host, this.linkmask);
            this.addMouseListener(this);
        }
    }

    public void stop() {
    }

    public void mouseClicked(MouseEvent e) {
        this.host.showURL(this.linkmask, this.target);
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    public void mouseExited(MouseEvent e) {
        this.setCursor(Cursor.getPredefinedCursor(0));
    }
}

