/*
 * Decompiled with CFR 0.152.
 */
package org.alov.viewer;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.SystemColor;

public class LightForm
extends ScrollPane {
    public static final String LIGHTFORM = "lightform";
    private static final byte HEADER = 0;
    private static final byte SELECTED = 1;
    private static final byte NORMAL = 2;
    private static final int EPS = 5;
    protected String[][] cells = null;
    protected int[] colType = null;
    private boolean dontRefresh = false;
    private boolean needUpdate;
    public int colCount = 0;
    public int rowCount = 0;
    public int currRow = 1;
    private Panel panel = null;
    private int defHeight = 23;

    public LightForm() {
        super(1);
        this.setName(LIGHTFORM);
        this.setBackground(SystemColor.window);
        this.panel = new Panel();
        this.panel.setLayout(null);
        this.panel.setSize(1000, 1000);
        this.add(this.panel);
    }

    public void firstRecord() {
        this.currRow = 1;
        this.updateView();
    }

    public void lastRecord() {
        this.currRow = this.rowCount - 1;
        this.updateView();
    }

    public void next() {
        if (this.currRow < this.rowCount - 1) {
            ++this.currRow;
            this.updateView();
        }
    }

    public void previous() {
        if (this.currRow > 1) {
            --this.currRow;
            this.updateView();
        }
    }

    protected void loadLabels() {
        this.panel.removeAll();
        Graphics g = this.getGraphics();
        Font fd = g.getFont();
        Font fc = new Font(fd.getName(), 1, fd.getSize() + 1);
        this.panel.setFont(fc);
        FontMetrics fm = g.getFontMetrics();
        this.defHeight = fm.getHeight() + 2;
        int x = 2;
        int y = 2;
        Label l = null;
        for (int i = 0; i < this.colCount - 1; ++i) {
            l = new Label(this.getCell(i, 0));
            l.setFont(fd);
            this.panel.add(l);
            l.setBounds(x, y, 100, this.defHeight);
            l = new Label();
            this.panel.add(l);
            l.setBounds(x + 102, y, 100, this.defHeight);
            y = y + this.defHeight + 2;
        }
    }

    protected void updateView() {
        Label l = null;
        Graphics g = this.panel.getGraphics();
        FontMetrics fm = g.getFontMetrics();
        int maxw = 0;
        int i = 0;
        int k = 1;
        while (i < this.colCount - 1) {
            l = (Label)this.panel.getComponent(k);
            String s = this.getCell(i, this.currRow);
            int w = fm.stringWidth(s + "W") + 10;
            l.setText(s);
            l.setSize(w, this.defHeight);
            if (w > maxw) {
                maxw = w;
            }
            ++i;
            k += 2;
        }
        this.panel.setSize(104 + maxw, (this.defHeight + 2) * this.colCount);
        this.doLayout();
        this.repaint();
    }

    public String getCell(int col, int row) {
        if (col >= this.colCount || row >= this.rowCount || col < 0 || row < 0) {
            return null;
        }
        return this.cells[row][col];
    }

    public void setCell(int col, int row, String value) {
        if (col < this.colCount && row < this.rowCount && col >= 0 && row >= 0) {
            this.cells[row][col] = value;
        }
    }

    public int getCurrRow() {
        return this.currRow;
    }

    public void setCurrRow(int r) {
        if (this.currRow != r) {
            this.currRow = r;
        }
    }

    public boolean setDimension(int w, int h) {
        if (w < 0) {
            w = 0;
        }
        if (h < 0) {
            h = 0;
        }
        if (this.colCount == w && this.rowCount == h) {
            return false;
        }
        String[][] newCells = new String[h][w];
        int toCopyW = w < this.colCount ? w : this.colCount;
        for (int i = 0; i < toCopyW; ++i) {
            newCells[0][i] = this.cells[0][i];
        }
        this.colCount = w;
        this.rowCount = h;
        this.cells = newCells;
        this.currRow = 1;
        return true;
    }
}

