/*
 * Decompiled with CFR 0.152.
 */
package org.alov.viewer;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.Vector;
import org.alov.map.Carte;
import org.alov.map.DisplayContext;
import org.alov.map.DisplayContextImpl;
import org.alov.map.Layer;
import org.alov.map.LayerGroup;
import org.alov.map.MapUtils;
import org.alov.map.Renderer;
import org.alov.tm.MultiAnimation;
import org.alov.viewer.LayerControlItem;
import org.alov.viewer.LayerCtl;
import org.alov.viewer.MyDisplayContext;

class LayerCtlImpl
extends Canvas
implements MouseListener,
ComponentListener {
    Color selectionColor = Color.white;
    Color networkColor = new Color(208, 208, 238);
    Color disabledColor = Color.gray;
    Color failureColor = Color.gray;
    boolean drawSeparator = false;
    boolean drawSelection = true;
    boolean compactSingleRend = false;
    Font fontBold = MapUtils.defaultBoldFont;
    Font fontPlain = MapUtils.defaultPlainFont;
    Image imageClock = null;
    Image imageZoomIn = null;
    Image imageZoomOut = null;
    Image imageNetwork = null;
    Image imageOutExt = null;
    Image imageKey = null;
    Image imageChecked = null;
    Image imageUncheck = null;
    private Image backImage = null;
    private boolean repaintNeeded = false;
    Vector sync_with = new Vector();
    int legendWidth = 120;
    private static final int minItemHeight = 16;
    private int itemWidth = 24;
    private int selection = -1;
    Dimension minSize = null;
    LayerCtl parentCtl;
    LayerControlItem[] items = null;
    Carte map = null;

    LayerCtlImpl(LayerCtl parent) {
        this.parentCtl = parent;
        this.minSize = new Dimension(this.legendWidth, 10);
        this.setSize(this.minSize);
        this.addMouseListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void repaint() {
        Graphics g = this.getGraphics();
        if (g != null) {
            try {
                this.paint(g);
            }
            finally {
                g.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void paint(Graphics g) {
        if (g != null) {
            boolean isRepaint = this.repaintNeeded;
            this.repaintNeeded = false;
            if ((this.backImage == null || isRepaint) && this.items != null) {
                Dimension d = this.getSize();
                if (d == null || d.width <= 0 || d.height <= 0) {
                    return;
                }
                this.backImage = this.createImage(d.width, d.height);
                if (this.backImage == null) {
                    return;
                }
                Graphics drawTo = this.backImage.getGraphics();
                try {
                    DisplayContextImpl dc = new DisplayContextImpl(this.map, drawTo, this.map.getProjection(), this.map.getLastExtent());
                    LayerCtlImpl.paintItems(this.items, dc, this.selection, true);
                }
                finally {
                    drawTo.dispose();
                }
            }
            if (this.backImage != null) {
                g.drawImage(this.backImage, 0, 0, null);
            }
        }
    }

    private static void paintItems(LayerControlItem[] items, DisplayContext dc, int selection, boolean hasControls) {
        int itemCount = items.length;
        for (int i = 0; i < itemCount; ++i) {
            LayerControlItem item = items[i];
            int height = item.getHeight();
            if (height <= 0) continue;
            item.paint(i == selection, hasControls, dc);
        }
    }

    void synchronyzeLegends(String layerId) {
        Layer l;
        if (this.map != null && (l = this.map.getProject().getLayerById(layerId)) != null) {
            Object[] obj = new Object[]{l.datasetId, new Boolean(l.isVisible())};
            int c = this.sync_with.size();
            for (int i = 0; i < c; ++i) {
                LayerCtl ctl = (LayerCtl)this.sync_with.elementAt(i);
                ctl.notifyStatus(118, obj);
            }
        }
    }

    void changeLayerVisibility(Object[] obj) {
        Layer l;
        if (this.map != null && (l = this.map.getProject().getLayerByDsId((String)obj[0])) != null) {
            l.setVisible((Boolean)obj[1]);
        }
    }

    void setMap(Carte map) {
        this.map = map;
    }

    void clear() {
        this.items = null;
    }

    void setLayers(Vector layers) {
        if (this.items != null) {
            int count = this.items.length;
            for (int i = 0; i < count; ++i) {
                LayerControlItem lci = this.items[i];
                if (lci.animation == null) continue;
                MultiAnimation.stopAnimation(lci.animation);
                lci.animation = null;
            }
        }
        this.items = LayerCtlImpl.refreshItemList(layers, this);
        this.mapUpdated();
    }

    public int getWidth() {
        Dimension dim = this.getSize();
        return dim.width;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static BufferedImage paintLayers(Vector layers, DisplayContext dc, Color bgColor, int width, int height) {
        if (width <= 0) {
            width = 200;
        }
        LayerControlItem[] items = LayerCtlImpl.refreshItemList(layers, null);
        int ic = items.length;
        for (int i = 0; i < ic; ++i) {
            items[i].cwidth = width;
        }
        BufferedImage img2 = new BufferedImage(1, 1, 2);
        Graphics g2 = img2.getGraphics();
        if (g2 != null) {
            try {
                MyDisplayContext dc2 = new MyDisplayContext(g2, dc);
                LayerCtlImpl.updateItemBounds(items, dc2);
            }
            finally {
                g2.dispose();
            }
        }
        Dimension size = LayerCtlImpl.updateItemLocations(items, width, height);
        size.width += 10;
        size.height = height > 0 ? height : (size.height += 20);
        BufferedImage img = new BufferedImage(size.width, size.height, 2);
        Graphics g = img.getGraphics();
        if (g != null) {
            try {
                for (int i = 0; i < items.length; ++i) {
                    items[i].backColor = bgColor;
                }
                g.setColor(bgColor);
                g.fillRect(0, 0, size.width, size.height);
                DisplayContextImpl dc2 = new DisplayContextImpl(dc, g, dc.getProjection(), dc.getLastExtent());
                LayerCtlImpl.paintItems(items, dc2, -1, false);
            }
            finally {
                g.dispose();
            }
        }
        return img;
    }

    void selectItem(String layerId) {
        if (this.items != null && layerId != null) {
            String sName = this.parentCtl.getName();
            for (int i = 0; i < this.items.length; ++i) {
                Layer lyr = this.items[i].getLayer();
                if (!lyr.id.equals(layerId) || !lyr.isBelongToLegend(sName) || !lyr.legendVisible) continue;
                this.selection = i;
                return;
            }
        }
        this.selection = -1;
    }

    public Layer getSelected() {
        if (this.selection >= 0 && this.selection < this.items.length) {
            return this.items[this.selection].getLayer();
        }
        return null;
    }

    public void mapUpdated() {
        if (this.items == null) {
            return;
        }
        this.updateItemBounds();
        this.updateItemLocations();
        Layer lyr = this.map.getActiveLayer();
        if (lyr != null) {
            this.selectItem(lyr.id);
        }
        this.repaintNeeded = true;
        this.repaint();
    }

    private static void updateItemBounds(LayerControlItem[] items, DisplayContext dc) {
        int count = items.length;
        for (int i = 0; i < count; ++i) {
            items[i].updateBounds(dc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateItemBounds() {
        Graphics g = this.getGraphics();
        if (g != null) {
            try {
                MyDisplayContext dc = new MyDisplayContext(g, this.map);
                LayerCtlImpl.updateItemBounds(this.items, dc);
            }
            finally {
                g.dispose();
            }
        }
    }

    private static LayerControlItem[] refreshItemList(Vector layers, LayerCtlImpl instance) {
        int count = layers.size();
        LayerControlItem[] items2 = new LayerControlItem[count];
        int added = 0;
        String sName = instance == null ? null : instance.parentCtl.getName();
        for (int i = 0; i < count; ++i) {
            Layer lyr = (Layer)layers.elementAt(i);
            if (sName != null && !lyr.isBelongToLegend(sName)) continue;
            LayerControlItem lci = new LayerControlItem(lyr, instance);
            lci.layerCtl = instance;
            items2[added++] = lci;
        }
        LayerControlItem[] items = new LayerControlItem[added];
        System.arraycopy(items2, 0, items, 0, added);
        return items;
    }

    private static Dimension updateItemLocations(LayerControlItem[] items, int controlWidth, int controlHeight) {
        int count = items.length;
        int curY = 0;
        for (int i = 0; i < count; ++i) {
            LayerControlItem item = items[i];
            item.setLocation(0, curY);
            int h = item.getHeight();
            curY += h;
            item.setSize(controlWidth, h);
        }
        return new Dimension(controlWidth, curY);
    }

    void updateItemLocations() {
        Dimension d = this.parentCtl.getSize();
        Insets insets = this.parentCtl.getInsets();
        int w = d.width - insets.left - insets.left;
        Dimension resultSize = LayerCtlImpl.updateItemLocations(this.items, w, d.height);
        if (d.height - insets.top - insets.top < resultSize.height) {
            LayerCtlImpl.updateItemLocations(this.items, w -= this.parentCtl.getVScrollbarWidth(), d.height);
        }
        this.minSize = new Dimension(w, resultSize.height);
        this.setSize(w, resultSize.height);
        this.parentCtl.doLayout();
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mousePressed(MouseEvent e) {
        if (this.items == null || this.items.length == 0) {
            return;
        }
        Point pt = e.getPoint();
        int oldSelection = this.selection;
        int clickedAt = -1;
        LayerControlItem clicked = null;
        int ptY = pt.y;
        if (ptY >= 0) {
            int count = this.items.length;
            int y = 0;
            for (int i = 0; i < count; ++i) {
                int h = this.items[i].getHeight();
                if (ptY >= (y += h) || h <= 0) continue;
                clickedAt = i;
                clicked = this.items[i];
                break;
            }
        }
        boolean paintNew = false;
        boolean paintAll = false;
        boolean visibilityChanged = false;
        this.selection = clickedAt;
        Layer lyr = null;
        if (clickedAt >= 0) {
            paintNew = clickedAt != oldSelection;
            Point clickPt = new Point(pt.x, pt.y - clicked.getBounds().y);
            boolean layoutChanged = clicked.isExpandButton(clickPt);
            Object obj = clicked.getCheckboxObject(clickPt);
            boolean bl = visibilityChanged = obj != null;
            if (visibilityChanged) {
                lyr = clicked.getLayer();
                paintAll = lyr.controlledLayers != null && lyr.controlledLayers.size() > 0;
                paintNew = true;
                if (obj instanceof Layer) {
                    lyr.setVisible(!lyr.isVisible());
                } else if (obj instanceof Renderer) {
                    Renderer rend = (Renderer)obj;
                    boolean bl2 = rend.enabled = !rend.enabled;
                    if (clicked.isNotPaintedRenderer(rend)) {
                        this.map.updateMap();
                        this.updateItemBounds();
                        this.updateItemLocations();
                        paintAll = true;
                        paintNew = false;
                    }
                }
            } else if (layoutChanged) {
                clicked.expandClicked();
                this.updateItemBounds();
                this.updateItemLocations();
                paintAll = true;
            }
        }
        if (this.map != null) {
            boolean isRepaint = false;
            if (clickedAt >= 0 && oldSelection != clickedAt) {
                isRepaint = MapUtils.isNotEmptyRecs(this.map.getActiveLayer().getSelection());
            }
            Layer l = null;
            if (this.selection >= 0 && this.selection < this.items.length && (l = this.items[this.selection].getLayer()) instanceof LayerGroup) {
                l = null;
                this.selection = oldSelection;
            }
            if (this.drawSelection) {
                this.map.setActiveLayer(l);
            } else {
                this.map.broadcastMessage(123, lyr == null ? l.getName() : lyr.getName());
            }
            if (isRepaint || visibilityChanged) {
                this.map.updateMap();
            }
        }
        if (paintAll) {
            this.repaintNeeded = true;
            this.repaint();
        } else {
            Graphics g = this.getGraphics();
            if (g != null) {
                try {
                    DisplayContextImpl dc = new DisplayContextImpl(this.map, g, this.map.getProjection(), this.map.getLastExtent());
                    if (paintNew && this.selection >= 0) {
                        this.items[this.selection].paint(true, true, dc);
                    }
                    if (oldSelection != this.selection && oldSelection >= 0) {
                        this.items[oldSelection].paint(false, true, dc);
                    }
                }
                finally {
                    g.dispose();
                }
            }
        }
    }

    public void mouseReleased(MouseEvent e) {
    }

    public void componentResized(ComponentEvent e) {
        this.repaintNeeded = true;
        this.setBounds(0, 0, this.minSize.width, this.minSize.height);
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }
}

