/*
 * Decompiled with CFR 0.152.
 */
package org.alov.viewer;

import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Label;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.InputEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;
import java.util.Vector;
import org.alov.map.Carte;
import org.alov.map.CarteAttribute;
import org.alov.map.CarteHost;
import org.alov.map.CarteHostListener;
import org.alov.map.FieldDef;
import org.alov.map.LayerVector;
import org.alov.map.MapUtils;
import org.alov.map.Record;
import org.alov.map.RecordsArray;
import org.alov.map.StatusListener;
import org.alov.util.Strings;
import org.alov.util.XmlElement;
import org.alov.util.XmlUtils;
import org.alov.viewer.EditListener;
import org.alov.viewer.FrameAlign;
import org.alov.viewer.GridCellEventListener;
import org.alov.viewer.LightForm;
import org.alov.viewer.LightGrid;

public class FrameRes
extends FrameAlign
implements ActionListener,
GridCellEventListener,
CarteHostListener,
CarteAttribute,
ItemListener,
StatusListener {
    private static final String PAR_SHOWONMAP = "showonmap";
    private static final String PAR_CLOSEONEXTENTCHANGE = "close_on_extentchange";
    private static final String BTN_WEBLINK = "btn_weblink";
    private static final String BTN_SHOWWEBLINK = "btn_showweblink";
    private static final String BTN_ONMAP = "btn_onmap";
    private static final String BTN_CLOSE = "btn_close";
    private static final String LBL_WEBLINK = "lbl_weblink";
    private static final String LBL_RECNO = "lbl_recno";
    private static final String BTN_NEXT = "btn_next";
    private static final String BTN_PREVIOUS = "btn_previous";
    private static final String BTN_FIRSTRECORD = "btn_firstrecord";
    private static final String BTN_LASTRECORD = "btn_lastrecord";
    private static final String BTN_APPLY = "btn_apply";
    private static final String BTN_APPLYALLRECORDS = "btn_applyallrecords";
    private static final String EDITFORM = "editform";
    private static final String LST_ZOOMTO = "lst_zoomto";
    private String currWebLink = null;
    private int fi_description = 0;
    private int fi_description_original = 0;
    private boolean showOnClick = false;
    private boolean closeOnExtentChange = false;
    private float[] zoomto_values = null;
    private Choice chZoomTo = null;
    protected Carte map = null;
    protected CarteHost host = null;
    protected LayerVector layer;
    protected LightGrid sg = null;
    protected LightForm lf = null;
    protected EditListener ef = null;
    private int minWidth = 330;
    private int xPos;
    private int yPos;
    private int wPos;
    private int hPos = -1;

    public FrameRes() {
        this.enableEvents(1L);
    }

    protected void processComponentEvent(ComponentEvent e) {
        int id = e.getID();
        switch (id) {
            case 101: {
                Rectangle rect = this.getBounds();
                if (rect.width < this.minWidth) {
                    rect.width = this.minWidth;
                }
                if (rect.height < 300) {
                    rect.height = 300;
                }
                super.setBounds(rect);
                if (null == this.layer || null == this.sg) {
                    return;
                }
                int fieldsWidth = 0;
                for (int j = 0; j < this.sg.colCount; ++j) {
                    fieldsWidth += this.sg.getColWidth(j);
                }
                int fieldWidth = this.sg.getViewportSize().width - fieldsWidth;
                this.sg.setColumnWidth(this.fi_description, this.sg.getColWidth(this.fi_description) + fieldWidth >= this.fi_description_original ? this.sg.getColWidth(this.fi_description) + fieldWidth : this.fi_description_original);
                this.sg.endUpdate();
            }
        }
    }

    public void actionPerformed(ActionEvent evt) {
        Object o = evt.getSource();
        if (o instanceof Component) {
            String sName = ((Component)o).getName();
            if (sName.equalsIgnoreCase(BTN_WEBLINK) || sName.equalsIgnoreCase(BTN_SHOWWEBLINK)) {
                this.map.showURL(this.currWebLink);
            } else if (sName.equalsIgnoreCase(BTN_ONMAP)) {
                float zoomto_value;
                float keepvalue = this.layer.zoom_for_select;
                if (this.chZoomTo != null && (zoomto_value = this.zoomto_values[this.chZoomTo.getSelectedIndex()]) >= 0.0f) {
                    this.layer.zoom_for_select = zoomto_value;
                }
                System.out.println(">>> " + this.layer.zoom_for_select);
                this.showOnMap();
                this.layer.zoom_for_select = keepvalue;
            } else if (sName.equalsIgnoreCase(BTN_CLOSE)) {
                ((Component)this).setVisible(false);
            } else if (this.lf != null) {
                if (sName.equalsIgnoreCase(BTN_NEXT)) {
                    this.lf.next();
                } else if (sName.equalsIgnoreCase(BTN_PREVIOUS)) {
                    this.lf.previous();
                } else if (sName.equalsIgnoreCase(BTN_FIRSTRECORD)) {
                    this.lf.firstRecord();
                } else if (sName.equalsIgnoreCase(BTN_LASTRECORD)) {
                    this.lf.lastRecord();
                }
                this.setLabels(this.lf.getCell(this.lf.colCount - 1, this.lf.currRow), this.lf.currRow + ":" + (this.lf.rowCount - 1));
            } else if (this.sg != null) {
                if (sName.equalsIgnoreCase(BTN_NEXT)) {
                    this.sg.next();
                } else if (sName.equalsIgnoreCase(BTN_PREVIOUS)) {
                    this.sg.previous();
                } else if (sName.equalsIgnoreCase(BTN_FIRSTRECORD)) {
                    this.sg.firstRecord();
                } else if (sName.equalsIgnoreCase(BTN_LASTRECORD)) {
                    this.sg.lastRecord();
                } else if (sName.equalsIgnoreCase(BTN_APPLYALLRECORDS)) {
                    if (this.ef != null && this.ef.isEdited()) {
                        this.ef.saveFields();
                        this.sg.setGridColumn(this.ef.getFields());
                        this.sg.updateAll();
                    }
                } else if (sName.equalsIgnoreCase(BTN_APPLY)) {
                    if (this.ef != null && this.ef.isEdited()) {
                        this.sg.lastCurrRow = this.sg.currRow;
                        this.ef.saveFields();
                        this.sg.setGridRow(this.ef.getFields());
                        this.sg.updateAll();
                    }
                    if (this.sg.wasEdited) {
                        this.saveChangesToLayer();
                        this.map.updateMap();
                    }
                }
            }
        }
    }

    public void itemStateChanged(ItemEvent e) {
    }

    private void setLabels(String sId, String sCounter) {
        Component c = MapUtils.findComp(this, LBL_RECNO);
        if (c instanceof Label) {
            ((Label)c).setText(sCounter);
        }
        if (Strings.isNullOrBlank(sId)) {
            return;
        }
        Record rec = this.layer.findById(sId);
        this.currWebLink = this.map.getProject().getWebLink(this.layer, rec);
        if (this.currWebLink == null) {
            this.currWebLink = "";
        }
        if ((c = MapUtils.findComp(this, BTN_SHOWWEBLINK)) != null) {
            c.setEnabled(!Strings.isNullOrBlank(this.currWebLink));
        }
        if ((c = MapUtils.findComp(this, BTN_WEBLINK)) != null) {
            c.setEnabled(!Strings.isNullOrBlank(this.currWebLink));
        }
        if ((c = MapUtils.findComp(this, LBL_WEBLINK)) instanceof Label) {
            ((Label)c).setText(this.currWebLink);
        }
    }

    private void showOnMap() {
        String s = null;
        if (this.sg != null) {
            s = this.sg.getCell(this.sg.colCount - 1, this.sg.currRow);
        } else if (this.lf != null) {
            s = this.lf.getCell(this.lf.colCount - 1, this.lf.currRow);
        }
        if (!Strings.isNullOrBlank(s)) {
            this.map.selectObjectsById(this.layer.id, s);
        }
    }

    private void saveChangesToLayer() {
        Record curRecord = null;
        int index = 0;
        for (int i = 1; i < this.sg.rowCount; ++i) {
            if (!this.sg.rowWasEdited[i]) continue;
            String sID = this.sg.getCell(this.sg.colCount - 1, i);
            curRecord = this.layer.findById(sID);
            for (int j = 0; j < this.sg.colCount - 1; ++j) {
                index = this.sg.getColDefIndex(j);
                curRecord.setField(index, this.sg.getCell(j, i));
            }
            if (this.ef != null) {
                this.ef.applyChanges(sID, curRecord);
            }
            this.map.broadcastMessage(122, this.layer.getName() + " " + curRecord.index);
        }
    }

    public void gridCellClicked(Point p, InputEvent cause) {
        this.setLabels(this.sg.getCell(this.sg.colCount - 1, this.sg.currRow), this.sg.currRow + ":" + (this.sg.rowCount - 1));
        if (this.sg.lastCurrRow != this.sg.currRow) {
            if (this.ef != null) {
                if (this.ef.isEdited()) {
                    this.ef.saveFields();
                    this.sg.setGridRow(this.ef.getFields());
                    this.sg.updateAll();
                }
                String[] row = this.sg.getGridRow(this.sg.currRow);
                this.ef.setFields(row);
            }
            this.sg.lastCurrRow = this.sg.currRow;
        }
        if (this.showOnClick && p != null && cause != null) {
            this.showOnMap();
        }
    }

    private void loadToGrid(LayerVector lyr, RecordsArray records) {
        String s;
        int j;
        if (this.sg == null && this.lf == null) {
            return;
        }
        int fieldCount = lyr.getFieldCount();
        int recCount = records.size();
        this.layer = lyr;
        boolean isGrid = this.sg != null;
        FontMetrics fm = null;
        int defHeight = 0;
        if (isGrid) {
            this.sg.beginUpdate();
            Graphics g = this.sg.getGraphics();
            fm = g.getFontMetrics();
            defHeight = fm.getHeight() + 2;
            g.dispose();
            this.sg.colType = new int[fieldCount];
            this.sg.setDimension(fieldCount + 1, 1, defHeight);
        } else {
            this.lf.colType = new int[fieldCount];
            this.lf.setDimension(fieldCount + 1, recCount + 1);
        }
        int fieldCountVis = 0;
        String wa = "W";
        for (j = 0; j < fieldCount; ++j) {
            FieldDef fd = lyr.getFieldDef(j);
            if (fd == null || !fd.visible) continue;
            if (j == this.layer.fi_description) {
                this.fi_description = j;
            }
            s = fd.label;
            if (isGrid) {
                this.sg.colType[fieldCountVis] = fd.type;
                int w = fm.stringWidth(s + "W");
                this.sg.setColumnWidth(fieldCountVis, w);
                this.sg.setCell(fieldCountVis, 0, s);
                this.sg.addColDef(s, fd.type, fd.editable, fd.index);
            } else {
                this.lf.colType[fieldCountVis] = fd.type;
                this.lf.setCell(fieldCountVis, 0, s);
            }
            ++fieldCountVis;
        }
        if (isGrid) {
            this.sg.setRowHeight(0, defHeight);
            this.sg.setDimension(fieldCountVis + 1, recCount + 1, defHeight);
            this.sg.setCell(fieldCountVis, 0, "");
            if (fieldCountVis > 0) {
                this.sg.setColumnWidth(fieldCountVis, 0);
            }
        } else {
            this.lf.setDimension(fieldCountVis + 1, recCount + 1);
            this.lf.setCell(fieldCountVis, 0, "");
        }
        for (int i = 0; i < recCount; ++i) {
            Record rec = records.getRecord(i, 1);
            int k = 0;
            if (fieldCountVis > 0) {
                for (int j2 = 0; j2 < fieldCount; ++j2) {
                    if (!lyr.getFieldDef((int)j2).visible) continue;
                    s = lyr.getFieldString(rec, j2);
                    if (isGrid) {
                        int w = fm.stringWidth(s + "W");
                        if (w > this.sg.getColWidth(k)) {
                            this.sg.setColumnWidth(k, w);
                        }
                        this.sg.setCell(k, i + 1, s);
                    } else {
                        this.lf.setCell(k, i + 1, s);
                    }
                    ++k;
                }
            }
            if (isGrid) {
                this.fi_description_original = this.sg.getColWidth(this.fi_description);
                this.sg.setCell(fieldCountVis, i + 1, String.valueOf(lyr.getId(rec)));
                continue;
            }
            this.lf.setCell(fieldCountVis, i + 1, String.valueOf(lyr.getId(rec)));
        }
        if (isGrid) {
            this.sg.endUpdate();
            int w = 0;
            for (j = 0; j < fieldCountVis; ++j) {
                w += this.sg.getColWidth(j) + 1;
            }
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            this.setBounds(10, 10, (w += this.sg.getVScrollbarWidth()) + 10 > d.width ? d.width - 10 : (w < this.minWidth ? this.minWidth : w), 300);
            this.processComponentEvent(new ComponentEvent(this, 101));
            this.sg.setUnEdited();
            if (this.ef != null) {
                int colDefCount = this.sg.cols.size();
                boolean[] editableFields = new boolean[colDefCount];
                boolean canEdit = this.ef.isEditableLayer(lyr);
                for (int i = 0; i < colDefCount; ++i) {
                    editableFields[i] = canEdit && this.sg.getColDefEditable(i);
                }
                this.ef.setEditable(editableFields);
                String[] hdr = this.sg.getGridRow(0);
                this.ef.loadLabels(hdr);
                this.sg.lastCurrRow = 0;
            }
            this.gridCellClicked(null, null);
        } else {
            this.lf.loadLabels();
            this.lf.updateView();
            this.setLabels(this.lf.getCell(this.lf.colCount - 1, this.lf.currRow), this.lf.currRow + ":" + (this.lf.rowCount - 1));
            if (this.hPos > 0) {
                this.setBounds(this.xPos, this.yPos, this.wPos, this.hPos);
            }
        }
    }

    private void setBtn(String sName) {
        MapUtils.addActionListener(this, this, sName);
        Component b = MapUtils.findComp(this, sName);
        if (b != null && b instanceof Button) {
            ((Button)b).setLabel(this.map.getResource(((Button)b).getLabel()));
        }
    }

    public void setParameters(CarteHost host, XmlElement layout) {
        Vector items;
        int count;
        XmlElement el;
        this.host = host;
        this.map = host.getMapByName(layout);
        this.map.statusListeners.addElement(this);
        this.showOnClick = XmlUtils.getBoolean(PAR_SHOWONMAP, layout, false);
        this.closeOnExtentChange = XmlUtils.getBoolean(PAR_CLOSEONEXTENTCHANGE, layout, false);
        String s = XmlUtils.getString("bounds", layout, null);
        if (s != null) {
            try {
                StringTokenizer tok = new StringTokenizer(s, ",");
                this.xPos = Integer.valueOf(tok.nextToken());
                this.yPos = Integer.valueOf(tok.nextToken());
                this.wPos = Integer.valueOf(tok.nextToken());
                this.hPos = Integer.valueOf(tok.nextToken());
            }
            catch (Exception e) {
                this.hPos = -1;
            }
        }
        if ((el = layout.findElementByAttrib("object", "name", LST_ZOOMTO, true)) != null && (count = (items = el.getElementsByTagName("item")).size()) > 0) {
            this.zoomto_values = new float[count];
            for (int i = 0; i < count; ++i) {
                el = (XmlElement)items.elementAt(i);
                this.zoomto_values[i] = XmlUtils.getFloat("id", el, -1.0f);
            }
        }
    }

    public void stop() {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void showAttributes(LayerVector lyr, RecordsArray records) {
        if (lyr != null && lyr.getMap() == this.map && MapUtils.isNotEmptyRecs(records)) {
            this.loadToGrid(lyr, records);
            this.show();
            this.requestFocus();
        }
    }

    public void afterProjectLoaded(boolean bSuccess) {
        if (bSuccess) {
            this.setTitle(this.map.getResource("Attribute Data"));
            this.setBtn(BTN_SHOWWEBLINK);
            this.setBtn(BTN_WEBLINK);
            this.setBtn(BTN_ONMAP);
            this.setBtn(BTN_CLOSE);
            this.setBtn(BTN_NEXT);
            this.setBtn(BTN_PREVIOUS);
            this.setBtn(BTN_FIRSTRECORD);
            this.setBtn(BTN_LASTRECORD);
            this.setBtn(BTN_APPLY);
            this.setBtn(BTN_APPLYALLRECORDS);
            this.chZoomTo = (Choice)MapUtils.findComp(this, LST_ZOOMTO);
            this.sg = (LightGrid)MapUtils.findComp(this, "lightgrid");
            if (this.sg != null) {
                this.sg.setGridCellEventListener(this);
                this.sg.colSizing = true;
                this.ef = (EditListener)((Object)MapUtils.findComp(this, EDITFORM));
                if (this.ef != null) {
                    if (this.ef instanceof Component) {
                        Dimension dim = ((Component)((Object)this.ef)).getSize();
                        this.minWidth += dim.width;
                    }
                    this.ef.setEditObject(this.host.findByClass("org.alov.edit.EditObject"));
                }
            } else {
                this.lf = (LightForm)MapUtils.findComp(this, "lightform");
            }
            this.addWindowListener(new WindowEventHandler());
            this.pack();
        }
    }

    public void notifyStatus(int code, Object obj) {
        if (this.closeOnExtentChange && code == 109) {
            ((Component)this).setVisible(false);
        }
    }

    private class WindowEventHandler
    extends WindowAdapter {
        private WindowEventHandler() {
        }

        public void windowClosing(WindowEvent evt) {
            ((Component)FrameRes.this).setVisible(false);
        }
    }
}

