/*
 * Decompiled with CFR 0.152.
 */
package org.alov.util;

import java.awt.Color;
import java.awt.Font;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.alov.map.FloatRectangle;
import org.alov.util.AlovMapException;
import org.alov.util.Log;
import org.alov.util.Strings;
import org.alov.util.XmlElement;
import org.alov.util.XmlParser;

public class XmlUtils {
    private static String COLON = ":";
    private static String WRONG_OBJECT = "WRONG OBJECT: ";
    public static boolean hasErrors = false;
    public static boolean caseSensitive = false;
    private static final String EQUAL_SPACE = "= ";
    private static final String SPACE_EQUAL = " =";

    public static boolean getElBoolean(String name, XmlElement el, boolean def) {
        return (Boolean)XmlUtils.elementValue(name, el, new Boolean(def), 1005);
    }

    public static int getElInt(String name, XmlElement el, int def) {
        return (Integer)XmlUtils.elementValue(name, el, new Integer(def), 1001);
    }

    public static float getElFloat(String name, XmlElement el, float def) {
        return ((Float)XmlUtils.elementValue(name, el, new Float(def), 1002)).floatValue();
    }

    public static String getElString(String name, XmlElement el, String def) {
        return (String)XmlUtils.elementValue(name, el, def, 1003);
    }

    public static Color getElColor(String name, XmlElement el, Color def) {
        return (Color)XmlUtils.elementValue(name, el, def, 1004);
    }

    public static Font getElFont(String name, XmlElement el, Font def) {
        return (Font)XmlUtils.elementValue(name, el, def, 1006);
    }

    public static FloatRectangle getElRect(XmlElement el) {
        FloatRectangle rect = new FloatRectangle(XmlUtils.getElFloat("xmin", el, 0.0f), XmlUtils.getElFloat("ymin", el, 0.0f), XmlUtils.getElFloat("xmax", el, 0.0f), XmlUtils.getElFloat("ymax", el, 0.0f));
        if (rect.x == 0.0 && rect.y == 0.0 && rect.x2 == 0.0 && rect.y2 == 0.0) {
            return null;
        }
        return rect;
    }

    public static boolean getBoolean(String name, XmlElement el, boolean def) {
        return (Boolean)XmlUtils.attrValue(name, el, new Boolean(def), 1005);
    }

    public static int getInt(String name, XmlElement el, int def) {
        return (Integer)XmlUtils.attrValue(name, el, new Integer(def), 1001);
    }

    public static float getFloat(String name, XmlElement el, float def) {
        return ((Float)XmlUtils.attrValue(name, el, new Float(def), 1002)).floatValue();
    }

    public static String getString(String name, XmlElement el, String def) {
        return (String)XmlUtils.attrValue(name, el, def, 1003);
    }

    public static Color getColor(String name, XmlElement el, Color def) {
        return (Color)XmlUtils.attrValue(name, el, def, 1004);
    }

    public static Font getFont(String name, XmlElement el, Font def) {
        return (Font)XmlUtils.attrValue(name, el, def, 1006);
    }

    public static FloatRectangle getRect(XmlElement el) {
        FloatRectangle rect = new FloatRectangle(XmlUtils.getFloat("xmin", el, 0.0f), XmlUtils.getFloat("ymin", el, 0.0f), XmlUtils.getFloat("xmax", el, 0.0f), XmlUtils.getFloat("ymax", el, 0.0f));
        return rect.isZero() ? null : rect;
    }

    public static String getLangString(String name, XmlElement el, String def, String language) {
        if (language != null && language.length() > 0) {
            XmlElement el2 = el.getLangElementByName(name, language, caseSensitive);
            if (el2 == null && (name.equals("name") || name.equals("label"))) {
                el2 = el.getLangElementByName("title", language, caseSensitive);
            }
            if (el2 != null && !Strings.isNullOrBlank(el2.value)) {
                return el2.value;
            }
        }
        return XmlUtils.getString(name, el, def);
    }

    private static Object getValueUsingScheme(String s, Object def, int scheme) {
        if (Strings.isNullOrBlank(s)) {
            return def;
        }
        try {
            Object val = Strings.strToObject(s, scheme);
            if (val != null) {
                return val;
            }
        }
        catch (Exception e) {
            String sMsg = "Parameter par=" + s + ". " + e.getMessage();
            Log.addMessage(114, null, null, sMsg);
            Log.addMessage(0, null, null, "Assign to default value \"" + def + "\"");
        }
        return def;
    }

    private static Object attrValue(String name, XmlElement el, Object def, int scheme) {
        String s = el.getAttributeValue(name);
        return XmlUtils.getValueUsingScheme(s, def, scheme);
    }

    private static Object elementValue(String name, XmlElement el, Object def, int scheme) {
        String s = el.getElValue(name, null, caseSensitive);
        return XmlUtils.getValueUsingScheme(s, def, scheme);
    }

    public static Properties getText(String elemName, XmlElement el) {
        XmlElement textElem = el.getFirstElementByName(elemName, caseSensitive);
        return textElem == null ? null : XmlUtils.makeProperties(textElem.value, " \n\r");
    }

    public static XmlElement parseStream(InputStream is, String rootNodeName) throws AlovMapException {
        return XmlParser.parseXml(is);
    }

    public static String removeObjs(StringBuffer val) {
        int iBeg = -1;
        StringBuffer buf = new StringBuffer();
        int len = val.length();
        for (int i = 0; i < len; ++i) {
            char cc = val.charAt(i);
            if (iBeg < 0) {
                if (cc == '&') {
                    iBeg = i;
                    continue;
                }
                buf.append(cc);
                continue;
            }
            if (cc != ';') continue;
            if (val.charAt(iBeg + 1) == 'a' && val.charAt(iBeg + 2) == 'm' && val.charAt(iBeg + 3) == 'p') {
                buf.append('&');
            } else if (val.charAt(iBeg + 1) == 'l' && val.charAt(iBeg + 2) == 't') {
                buf.append('<');
            } else if (val.charAt(iBeg + 1) == 'g' && val.charAt(iBeg + 2) == 't') {
                buf.append('>');
            } else if (val.charAt(iBeg + 1) == 'q' && val.charAt(iBeg + 2) == 'u' && val.charAt(iBeg + 3) == 'o' && val.charAt(iBeg + 4) == 't') {
                buf.append('\"');
            } else if (val.charAt(iBeg + 1) == 'a' && val.charAt(iBeg + 2) == 'p' && val.charAt(iBeg + 3) == 'o' && val.charAt(iBeg + 4) == 's') {
                buf.append('\'');
            } else {
                String s2 = XmlUtils.subBuffer(val, iBeg + 2, i).toString();
                cc = '\u0000';
                try {
                    int b_code = Integer.parseInt(s2);
                    buf.append((char)b_code);
                }
                catch (NumberFormatException e) {
                    Log.addMessage(114, null, null, WRONG_OBJECT + XmlUtils.subBuffer(val, iBeg, i + 1).toString() + ". ");
                }
            }
            iBeg = -1;
        }
        return buf.toString();
    }

    static StringBuffer subBuffer(StringBuffer buf, int iBeg, int iEnd) {
        int len;
        int len2;
        if (iBeg < 0) {
            iBeg = 0;
        }
        if (iEnd > (len2 = buf.length())) {
            iEnd = len2 - 1;
        }
        if ((len = iEnd - iBeg) <= 0) {
            return new StringBuffer();
        }
        char[] data = new char[len];
        buf.getChars(iBeg, iEnd, data, 0);
        StringBuffer buf2 = new StringBuffer(len);
        return buf2.append(data);
    }

    static StringBuffer subBuffer(StringBuffer buf, int iBeg) {
        return XmlUtils.subBuffer(buf, iBeg, buf.length());
    }

    public static String setObjs(String val) {
        val = Strings.setObj(val, '&', "amp");
        val = Strings.setObj(val, '<', "lt");
        val = Strings.setObj(val, '>', "gt");
        val = Strings.setObj(val, '\"', "quot");
        return Strings.setObj(val, '\'', "apos");
    }

    public static String getEncoding(XmlElement el) {
        char c;
        int c_limit = 127;
        if (el.value != null) {
            for (int i = 0; i < el.value.length(); ++i) {
                c = el.value.charAt(i);
                if (c <= '\u007f') continue;
                return "UTF-8";
            }
        }
        Enumeration e = el.attributes.keys();
        while (e.hasMoreElements()) {
            String k = el.getAttributeValue((String)e.nextElement());
            for (int i = 0; i < k.length(); ++i) {
                c = k.charAt(i);
                if (c <= '\u007f') continue;
                return "UTF-8";
            }
        }
        for (int i = 0; i < el.children.size(); ++i) {
            if (!XmlUtils.getEncoding((XmlElement)el.children.elementAt(i)).equalsIgnoreCase("UTF-8")) continue;
            return "UTF-8";
        }
        return "ISO-8859-1";
    }

    public static void writeElement(XmlElement me, OutputStreamWriter os, int ident) throws Exception {
        if (me == null) {
            return;
        }
        String sident = new String();
        for (int i = 0; i < ident; ++i) {
            sident = sident + ' ';
        }
        XmlUtils.writeBytes(os, sident + "<" + me.tagName);
        Enumeration e = me.attributes.keys();
        while (e.hasMoreElements()) {
            String k = (String)e.nextElement();
            XmlUtils.writeBytes(os, " " + k + "=\"" + XmlUtils.setObjs(me.getAttributeValue(k)) + "\"");
        }
        int count = me.children.size();
        if (count == 0 && me.value == null) {
            XmlUtils.writeBytes(os, "/>\n");
        } else if (count != 0) {
            XmlUtils.writeBytes(os, ">\n");
            for (int i = 0; i < count; ++i) {
                XmlUtils.writeElement((XmlElement)me.children.elementAt(i), os, ident + 3);
            }
            XmlUtils.writeBytes(os, sident + "</" + me.tagName + ">\n");
        } else {
            XmlUtils.writeBytes(os, '>' + XmlUtils.setObjs(me.value) + "</" + me.tagName + ">\n");
        }
    }

    private static void writeBytes(OutputStreamWriter osw, String s) throws Exception {
        osw.write(s, 0, s.length());
    }

    public static void writeStream(XmlElement me, DataOutputStream os, String sEnc) throws Exception {
        XmlUtils.writeStream(me, os, sEnc, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStream(XmlElement me, DataOutputStream os, String sEnc, String addon) throws Exception {
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)os, sEnc);
        try {
            if (sEnc.equalsIgnoreCase("UTF-8")) {
                os.writeBytes("\u00ef\u00bb\u00bf");
            }
            XmlUtils.writeBytes(osw, "<?xml version=\"1.0\" encoding=\"" + sEnc + "\"?>\n");
            if (addon != null) {
                XmlUtils.writeBytes(osw, addon + "\n");
            }
            XmlUtils.writeElement(me, osw, 0);
        }
        finally {
            osw.close();
        }
    }

    public static void writeStream(XmlElement me, DataOutputStream os) throws Exception {
        XmlUtils.writeStream(me, os, XmlUtils.getEncoding(me));
    }

    public static String convertColor(Color c) {
        return String.valueOf(c.getRed()) + COLON + String.valueOf(c.getGreen()) + COLON + String.valueOf(c.getBlue());
    }

    public static Properties makeProperties(String s, String tokSep) {
        int k;
        if (Strings.isNullOrBlank(s)) {
            return null;
        }
        while ((k = s.indexOf(EQUAL_SPACE)) > 0) {
            s = s.substring(0, k) + '=' + s.substring(k + 2);
        }
        while ((k = s.indexOf(SPACE_EQUAL)) > 0) {
            s = s.substring(0, k) + '=' + s.substring(k + 2);
        }
        StringTokenizer st = new StringTokenizer(s, tokSep);
        Properties props = new Properties();
        String prop = "";
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            int n = tok.indexOf(61);
            if (n < 0) {
                prop = prop + tok;
                continue;
            }
            prop = prop + tok.substring(0, n).trim();
            String val = tok.substring(n + 1, tok.length()).trim();
            if (!prop.equals("")) {
                ((Hashtable)props).put(prop.toLowerCase().trim(), val);
            }
            prop = "";
        }
        return props;
    }

    public static void addAll(Vector v1, Vector v2) {
        if (v1 != null && v2 != null) {
            int count = v2.size();
            for (int i = 0; i < count; ++i) {
                if (v1.indexOf(v2.elementAt(i)) >= 0) continue;
                v1.addElement(v2.elementAt(i));
            }
        }
    }

    public static void xorAddAll(Vector v1, Vector v2) {
        if (v1 != null && v2 != null) {
            int count = v2.size();
            for (int i = 0; i < count; ++i) {
                int index = v1.indexOf(v2.elementAt(i));
                if (index < 0) {
                    v1.addElement(v2.elementAt(i));
                    continue;
                }
                v1.remove(index);
            }
        }
    }
}

