/*
 * Decompiled with CFR 0.152.
 */
package org.alov.util;

import java.awt.Color;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import org.alov.map.FloatRectangle;

public class Writers {
    private static final String EMPTY = "";

    private Writers() {
    }

    public static void writeUTFCond(DataOutputStream os, String s) throws IOException {
        if (s != null) {
            os.write(1);
            os.writeUTF(s);
        } else {
            os.write(0);
        }
    }

    public static void writeString(DataOutputStream os, String str, String def) throws IOException {
        os.writeUTF(str == null ? def : str);
    }

    public static void writeColor(OutputStream os, Color c) throws IOException {
        os.write(c.getRed());
        os.write(c.getGreen());
        os.write(c.getBlue());
    }

    public static void writeFloat(OutputStream os, float f) throws IOException {
        int n = Float.floatToIntBits(f);
        os.write(n & 0xFF);
        os.write((n & 0xFF00) >> 8);
        os.write((n & 0xFF0000) >> 16);
        os.write((n & 0xFF000000) >> 24);
    }

    public static void writeDouble(OutputStream os, double f) throws IOException {
        long n = Double.doubleToLongBits(f);
        os.write((int)n & 0xFF);
        os.write((int)(n & 0xFFL) >> 8);
        os.write((int)(n & 0xFFL) >> 16);
        os.write((int)(n & 0xFFL) >> 24);
        os.write((int)(n & 0xFFL) >> 32);
        os.write((int)(n & 0xFFL) >> 40);
        os.write((int)(n & 0xFFL) >> 48);
        os.write((int)(n & 0xFFL) >> 56);
    }

    public static void writeInt4(OutputStream os, int n) throws IOException {
        os.write(n & 0xFF);
        os.write((n & 0xFF00) >> 8);
        os.write((n & 0xFF0000) >> 16);
        os.write((n & 0xFF000000) >> 24);
    }

    public static void writeRect(OutputStream os, FloatRectangle rect) throws IOException {
        Writers.writeFloat(os, (float)rect.x);
        Writers.writeFloat(os, (float)rect.y);
        Writers.writeFloat(os, (float)rect.x2);
        Writers.writeFloat(os, (float)rect.y2);
    }

    public static void writeObject(DataOutputStream os, Object o, int t) throws IOException {
        try {
            switch (t) {
                case -7: 
                case -6: {
                    os.write(o == null ? 0 : (int)((Byte)o).byteValue());
                    break;
                }
                case 5: {
                    os.writeShort(o == null ? 0 : (int)((Short)o).shortValue());
                    break;
                }
                case 4: {
                    os.writeInt(o == null ? 0 : (Integer)o);
                    break;
                }
                case -5: {
                    os.writeLong(o == null ? 0L : (Long)o);
                    break;
                }
                case 2: 
                case 3: {
                    os.writeFloat(o == null ? 0.0f : ((BigDecimal)o).floatValue());
                    break;
                }
                case 6: 
                case 7: {
                    if (o instanceof Double) {
                        os.writeFloat(o == null ? 0.0f : ((Double)o).floatValue());
                        break;
                    }
                    os.writeFloat(o == null ? 0.0f : ((Float)o).floatValue());
                    break;
                }
                case 8: {
                    os.writeDouble(o == null ? 0.0 : (Double)o);
                    break;
                }
                case 1: {
                    os.writeUTF(o == null ? EMPTY : o.toString());
                    break;
                }
                case -1: 
                case 12: {
                    String s = o == null ? EMPTY : (String)o;
                    os.writeUTF(s);
                    break;
                }
                case 91: 
                case 92: {
                    os.writeDouble(o == null ? 0.0 : (Double)o);
                }
            }
        }
        catch (ClassCastException e) {
            String s = o.toString();
            switch (t) {
                case -7: 
                case -6: {
                    os.write(Byte.parseByte(s));
                    break;
                }
                case 5: {
                    os.writeShort(Short.parseShort(s));
                    break;
                }
                case 4: {
                    os.writeInt(Integer.parseInt(s));
                    break;
                }
                case -5: {
                    os.writeLong(Long.parseLong(s));
                    break;
                }
                case 2: 
                case 3: 
                case 6: 
                case 7: {
                    os.writeFloat(Float.parseFloat(s));
                }
                case 8: {
                    os.writeDouble(Double.parseDouble(s));
                    break;
                }
                case -1: 
                case 12: {
                    os.writeUTF(s);
                }
            }
        }
    }
}

