/*
 * Decompiled with CFR 0.152.
 */
package org.alov.util;

import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.StringTokenizer;
import org.alov.data.SQLConst;
import org.alov.map.MapUtils;

public class Strings {
    private static String TRUE = "true";
    private static String COLON = ":";
    private static byte[] alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".getBytes();

    private Strings() {
    }

    public static int arrayContains(String s, String[] arr) {
        if (s != null && arr != null) {
            for (int i = 0; i < arr.length; ++i) {
                if (!s.equalsIgnoreCase(arr[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean checkSuffix(String str, String suffix) {
        if (Strings.isNullOrBlank(suffix)) {
            int k = str.lastIndexOf(".");
            return k < 0 || k < str.length() - 4;
        }
        int k1 = str.toUpperCase().lastIndexOf(suffix.toUpperCase());
        int k2 = str.length() - suffix.length();
        return k1 > 0 && k1 == k2;
    }

    public static String changeSuffix(String str, String newSuffix) {
        if (Strings.checkSuffix(str, newSuffix)) {
            return str;
        }
        int slash = str.lastIndexOf("/");
        int bslash = str.lastIndexOf("\\");
        int dot = str.lastIndexOf(".");
        if (dot > slash && dot > bslash) {
            str = str.substring(0, dot);
        }
        return str + newSuffix;
    }

    public static boolean isNullOrBlank(String str) {
        return str == null || str.trim().length() < 1;
    }

    public static String doubleToStr(double val, int rnd) {
        String s = (double)rnd > 1000000.0 || rnd == 0 ? String.valueOf(val) : (rnd == 1 ? String.valueOf(Math.round(val)) : (rnd > 0 ? String.valueOf((double)Math.round(val * (double)rnd) / (1.0 * (double)rnd)) : String.valueOf(Math.round(val / (double)rnd) * (long)rnd)));
        return s;
    }

    public static int strToInt(String str, int def) {
        try {
            return str == null ? def : Integer.parseInt(str.trim());
        }
        catch (Exception e) {
            return def;
        }
    }

    public static int objToInt(Object obj, int def) {
        try {
            if (obj == null) {
                return def;
            }
            if (obj instanceof Number) {
                return ((Number)obj).intValue();
            }
            return Double.valueOf((String)obj).intValue();
        }
        catch (Exception e) {
            return def;
        }
    }

    public static boolean isNumeric(String str) {
        try {
            if (Strings.isNullOrBlank(str)) {
                return false;
            }
            Double.valueOf(str);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Object strToObject(String val, int type) throws Exception {
        if (Strings.isNullOrBlank(val) && (SQLConst.isNumber(type) || type == 1002 || type == 1001)) {
            val = "0";
        }
        switch (type) {
            case -7: 
            case -6: {
                return new Byte(val);
            }
            case 5: {
                return new Short(val);
            }
            case 4: 
            case 1001: {
                return new Integer(val);
            }
            case -5: {
                return new Long(val);
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 1002: {
                return new Float(val);
            }
            case 8: {
                return new Double(val);
            }
            case 1: 
            case 12: 
            case 1003: {
                return val == null ? "" : val;
            }
            case 1005: {
                int _yes = 89;
                int _true = 84;
                int _one = 49;
                char fChar = Character.toUpperCase(val.charAt(0));
                return new Boolean(fChar == 'Y' || fChar == 'T' || fChar == '1');
            }
            case 91: 
            case 92: {
                DateFormat df = DateFormat.getInstance();
                try {
                    return df.parse(val);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            case 1004: {
                int a = 0;
                StringTokenizer tok = new StringTokenizer(val, COLON);
                int r = tok.hasMoreTokens() ? Integer.parseInt(tok.nextToken()) : 0;
                int g = tok.hasMoreTokens() ? Integer.parseInt(tok.nextToken()) : 0;
                int b = tok.hasMoreTokens() ? Integer.parseInt(tok.nextToken()) : 0;
                int n = a = tok.hasMoreTokens() ? Integer.parseInt(tok.nextToken()) : 255;
                if (r < 0 || g < 0 || b < 0 || a < 0 || r > 255 || g > 255 || b > 255 || a > 255) {
                    throw new Exception("Color parameter outside of expected range. ");
                }
                try {
                    return new Color(r, g, b, a);
                }
                catch (Throwable e) {
                    return new Color(r, g, b);
                }
            }
            case 1006: {
                int style = 0;
                int size = 11;
                StringTokenizer tok = new StringTokenizer(val, ",");
                val = tok.nextToken();
                if (tok.hasMoreTokens()) {
                    style = Integer.valueOf(tok.nextToken());
                }
                if (tok.hasMoreTokens()) {
                    size = Integer.valueOf(tok.nextToken());
                }
                return MapUtils.createAndVerifyFont(val, style, size, null);
            }
        }
        return null;
    }

    public static String setObj(String val, char ch, String cod) {
        int i;
        int k = 0;
        StringBuffer s4 = new StringBuffer();
        while ((i = val.indexOf(ch, k)) >= 0) {
            s4.append(val.substring(k, i)).append(cod);
            k = i + 1;
        }
        if (k < val.length()) {
            s4.append(val.substring(k));
        }
        return s4.toString();
    }

    public static String decode(String s) throws UnsupportedEncodingException {
        int i;
        StringBuffer result = new StringBuffer();
        String str = s.replace('+', ' ');
        int start = 0;
        byte[] bytes = null;
        while ((i = str.indexOf(37, start)) >= 0) {
            result.append(str.substring(start, i));
            start = i;
            int length = str.length();
            while (i + 2 < length && str.charAt(i) == '%') {
                i += 3;
            }
            if (bytes == null || bytes.length < (i - start) / 3) {
                bytes = new byte[(i - start) / 3];
            }
            int index = 0;
            while (start < i) {
                String sub = str.substring(start + 1, start + 3);
                try {
                    bytes[index] = (byte)Integer.parseInt(sub, 16);
                    ++index;
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
                start += 3;
            }
            result.append(new String(bytes, 0, index));
            start = i;
        }
        if (start < str.length()) {
            result.append(str.substring(start));
        }
        return result.toString();
    }

    public static String encodeBASE64(byte[] bytes) throws IOException {
        int b1;
        boolean n = false;
        ByteArrayInputStream bin = new ByteArrayInputStream(bytes);
        StringBuffer out = new StringBuffer(bytes.length * 4 / 3);
        while ((b1 = bin.read()) != -1) {
            int b2 = bin.read();
            if (b2 == -1) {
                Strings.writeChars(b1, 0, 0, 2, out);
                continue;
            }
            int b3 = bin.read();
            if (b3 == -1) {
                Strings.writeChars(b1, b2, 0, 1, out);
                continue;
            }
            Strings.writeChars(b1, b2, b3, 0, out);
        }
        return out.toString();
    }

    private static final void writeChars(int b1, int b2, int b3, int padding, StringBuffer out) throws IOException {
        out.append((char)alphabet[b1 >> 2]);
        out.append((char)alphabet[(b1 & 3) << 4 | b2 >> 4]);
        if (padding != 2) {
            if (padding == 1) {
                out.append((char)alphabet[(b2 & 0xF) << 2 | b3 >> 6]);
            } else {
                out.append((char)alphabet[(b2 & 0xF) << 2 | b3 >> 6]);
                out.append((char)alphabet[b3 & 0x3F]);
            }
        }
    }

    public static double time2DeltaExtDate(String delta) {
        int TIME_UNIT_COUNT = 6;
        char[] TIME_UNIT = new char[]{'y', 'm', 'd', 'h', 'M', 's'};
        double[] TIME_LENGHT = new double[]{365.25, 31.0, 1.0, 0.041666666666666664, 6.944444444444444E-4, 1.1574074074074073E-5};
        double result = 0.0;
        if (!Strings.isNullOrBlank(delta)) {
            double dCoeff = 365.25;
            String sLenght = delta;
            int index = -1;
            for (int id = 0; id < 6; ++id) {
                index = sLenght.indexOf(TIME_UNIT[id]);
                if (0 > index) continue;
                sLenght = sLenght.substring(0, index).trim();
                dCoeff = TIME_LENGHT[id];
                break;
            }
            try {
                result = Double.valueOf(sLenght) * dCoeff;
            }
            catch (NumberFormatException e) {
                System.out.println("Error: " + e.getMessage() + "\tString: " + delta);
            }
        }
        return result;
    }

    public static String includeLastSymbol(String val, char sym) {
        if (val.charAt(val.length() - 1) != sym) {
            return val + sym;
        }
        return val;
    }

    public static String excludeLastSymbol(String val, char sym) {
        if (val.charAt(val.length() - 1) == sym) {
            return val.substring(0, val.length() - 1);
        }
        return val;
    }

    public static String extractFileName(String url) {
        return url.substring(Math.max(url.lastIndexOf(47), url.lastIndexOf(92)) + 1);
    }

    public static String extractDir(String fileName) {
        int k = (fileName = fileName.replace('\\', '/')).lastIndexOf(47);
        return k > 0 ? fileName.substring(0, k + 1) : fileName;
    }

    public static String getAbsPath(String absPath, String relPath) {
        if (relPath != null && relPath.indexOf("://") < 0 && relPath.indexOf("file:/") < 0) {
            if (relPath.indexOf(":\\") == 1 || relPath.indexOf(":/") == 1) {
                return "file:/" + relPath;
            }
            String upDir1 = "../";
            String upDir2 = "..\\";
            while ((relPath.startsWith("../") || relPath.startsWith("..\\")) && absPath.length() > 0) {
                absPath = absPath.substring(0, absPath.length() - 1);
                absPath = absPath.substring(0, absPath.lastIndexOf(47) + 1);
                relPath = relPath.substring(3);
            }
            return absPath + relPath;
        }
        return relPath;
    }

    public static void deleteSpaces(StringBuffer sb) {
        int len = sb.length();
        int s = 0;
        int d = 0;
        char pc = ' ';
        while (s < len) {
            char sc;
            if (Character.isWhitespace(sc = sb.charAt(s++)) && Character.isWhitespace(pc)) continue;
            sb.setCharAt(d++, sc);
            pc = sc;
        }
        if (d > 0 && Character.isWhitespace(pc)) {
            --d;
        }
        sb.setLength(d);
    }
}

