/*
 * Decompiled with CFR 0.152.
 */
package org.alov.util;

import org.alov.map.ClientLog;
import org.alov.map.Layer;
import org.alov.util.Logger;

public class Log {
    public static int debugLevel = 0;
    private static Logger logInstance = null;

    public static void init(Logger logger, boolean bSilent) throws Exception {
        if (logInstance == null) {
            logger.init();
            logInstance = logger;
        } else if (!bSilent) {
            throw new Exception("You must finalize current logger before assigning a new logger");
        }
    }

    public static void kill() {
        if (logInstance != null) {
            logInstance.kill();
        }
        logInstance = null;
    }

    public static Logger getInstance() {
        return logInstance;
    }

    public static void log(int level, String msg) {
        if (logInstance != null) {
            logInstance.log(level, msg);
        }
    }

    public static void log(int level, Exception ex) {
        if (logInstance != null) {
            logInstance.log(level, ex);
        }
    }

    public static void addMessage(int messageCode, String mapName, Layer lyr, String obj) {
        if (logInstance instanceof ClientLog) {
            ((ClientLog)logInstance).addStatusInfo(messageCode, mapName, lyr, obj);
        }
    }
}

